/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.io.XmlWriter;

public class NoteWriter
extends XmlWriter {
    public NoteWriter(PrintWriter out) {
        super(out);
    }

    public NoteWriter(OutputStream out) {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8))));
    }

    public void write(NoteData data) {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("<osm-notes>");
        for (Note note : data.getNotes()) {
            LatLon ll = note.getLatLon();
            this.out.print("  <note ");
            this.out.print("id=\"" + note.getId() + "\" ");
            this.out.print("lat=\"" + LatLon.cDdHighPrecisionFormatter.format(ll.lat()) + "\" ");
            this.out.print("lon=\"" + LatLon.cDdHighPrecisionFormatter.format(ll.lon()) + "\" ");
            this.out.print("created_at=\"" + note.getCreatedAt() + "\" ");
            if (note.getClosedAt() != null) {
                this.out.print("closed_at=\"" + note.getClosedAt() + "\" ");
            }
            this.out.println(">");
            for (NoteComment comment : note.getComments()) {
                this.writeComment(comment);
            }
            this.out.println("  </note>");
        }
        this.out.println("</osm-notes>");
        this.out.flush();
    }

    private void writeComment(NoteComment comment) {
        this.out.print("    <comment");
        this.out.print(" action=\"" + (Object)((Object)comment.getNoteAction()) + "\" ");
        this.out.print("timestamp=\"" + comment.getCommentTimestamp() + "\" ");
        if (comment.getUser() != null && !comment.getUser().equals(User.getAnonymous())) {
            this.out.print("uid=\"" + comment.getUser().getId() + "\" ");
            this.out.print("user=\"" + NoteWriter.encode(comment.getUser().getName()) + "\" ");
        }
        this.out.print("is_new=\"" + comment.isNew() + "\" ");
        this.out.print(">");
        this.out.print(NoteWriter.encode(comment.getText(), false));
        this.out.println("</comment>");
    }
}

