/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "maybeComputeTrimIndent", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "maybeComputeTrimMargin", "visitCall", "expression", "Companion", "ir.backend.common"})
public final class StringTrimLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final FqName TRIM_MARGIN_FQ_NAME = new FqName("kotlin.text.trimMargin");
    @NotNull
    private static final FqName TRIM_INDENT_FQ_NAME = new FqName("kotlin.text.trimIndent");

    public StringTrimLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return StringTrimLowering.Companion.matchTrimIndent(expression2) ? this.maybeComputeTrimIndent(expression2) : (StringTrimLowering.Companion.matchTrimMargin(expression2) ? this.maybeComputeTrimMargin(expression2) : super.visitCall(expression2));
    }

    private final IrExpression maybeComputeTrimIndent(IrCall call2) {
        IrExpression irExpression = call2.getExtensionReceiver();
        Intrinsics.checkNotNull(irExpression);
        String string2 = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string2 == null) {
            return call2;
        }
        String receiverString = string2;
        String newString = StringsKt.trimIndent(receiverString);
        return IrConstImpl.Companion.string(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), newString);
    }

    private final IrExpression maybeComputeTrimMargin(IrCall call2) {
        String string2;
        IrExpression irExpression = call2.getExtensionReceiver();
        Intrinsics.checkNotNull(irExpression);
        String string3 = StringTrimLowering.Companion.getConstantString(irExpression);
        if (string3 == null) {
            return call2;
        }
        String receiverString = string3;
        IrExpression prefixArgument = call2.getValueArgument(0);
        if (prefixArgument != null) {
            String string4;
            String string5 = StringTrimLowering.Companion.getConstantString(prefixArgument);
            if (string5 == null) {
                return call2;
            }
            String prefixString = string5;
            try {
                string4 = StringsKt.trimMargin(receiverString, prefixString);
            }
            catch (IllegalArgumentException e) {
                return call2;
            }
            string2 = string4;
        } else {
            string2 = StringsKt.trimMargin$default(receiverString, null, 1, null);
        }
        String newString = string2;
        return IrConstImpl.Companion.string(call2.getStartOffset(), call2.getEndOffset(), call2.getType(), newString);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/StringTrimLowering$Companion;", "", "()V", "TRIM_INDENT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "TRIM_MARGIN_FQ_NAME", "matchTrimIndent", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "matchTrimMargin", "getConstantString", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        private final String getConstantString(IrExpression $this$getConstantString) {
            if ($this$getConstantString instanceof IrConst && Intrinsics.areEqual(((IrConst)$this$getConstantString).getKind(), IrConstKind.String.INSTANCE)) {
                return (String)IrConstKind.String.INSTANCE.valueOf((IrConst)$this$getConstantString);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean matchTrimIndent(IrCall expression2) {
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            if (!callee.getValueParameters().isEmpty()) return false;
            IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer)) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), TRIM_INDENT_FQ_NAME)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean matchTrimMargin(IrCall expression2) {
            IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
            IrValueParameter irValueParameter = CollectionsKt.singleOrNull(callee.getValueParameters());
            IrAnnotationContainer irAnnotationContainer = irValueParameter;
            if (irValueParameter == null) return false;
            IrType irType = irAnnotationContainer.getType();
            irAnnotationContainer = irType;
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer)) return false;
            boolean bl = true;
            if (!bl) return false;
            IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
            IrAnnotationContainer irAnnotationContainer2 = irValueParameter2;
            if (irValueParameter2 == null) return false;
            IrType irType2 = irAnnotationContainer2.getType();
            irAnnotationContainer2 = irType2;
            if (irType2 == null) return false;
            if (!IrTypePredicatesKt.isString((IrType)irAnnotationContainer2)) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), TRIM_MARGIN_FQ_NAME)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

