info = {
    "name": "ru",
    "date_order": "DMY",
    "january": [
        "янв",
        "январь",
        "января"
    ],
    "february": [
        "февр",
        "февраль",
        "февраля",
        "Фев"
    ],
    "march": [
        "мар",
        "март",
        "марта"
    ],
    "april": [
        "апр",
        "апрель",
        "апреля"
    ],
    "may": [
        "май",
        "мая"
    ],
    "june": [
        "июн",
        "июнь",
        "июня"
    ],
    "july": [
        "июл",
        "июль",
        "июля"
    ],
    "august": [
        "авг",
        "август",
        "августа"
    ],
    "september": [
        "сент",
        "сентябрь",
        "сентября",
        "Сен"
    ],
    "october": [
        "окт",
        "октябрь",
        "октября"
    ],
    "november": [
        "нояб",
        "ноябрь",
        "ноября",
        "Ноя"
    ],
    "december": [
        "дек",
        "декабрь",
        "декабря"
    ],
    "monday": [
        "пн",
        "понедельник"
    ],
    "tuesday": [
        "вт",
        "вторник"
    ],
    "wednesday": [
        "ср",
        "среда",
        "Среду"
    ],
    "thursday": [
        "четверг",
        "чт"
    ],
    "friday": [
        "пт",
        "пятница",
        "Пятницу"
    ],
    "saturday": [
        "сб",
        "суббота",
        "Субботу"
    ],
    "sunday": [
        "воскресенье",
        "вс",
        "Воскресение"
    ],
    "am": [
        "дп"
    ],
    "pm": [
        "пп"
    ],
    "year": [
        "г",
        "год",
        "года",
        "лет"
    ],
    "month": [
        "мес",
        "месяц",
        "месяца",
        "месяцев"
    ],
    "week": [
        "нед",
        "неделя",
        "недели",
        "недель",
        "неделю"
    ],
    "day": [
        "день",
        "дн",
        "дня",
        "дней",
        "сутки",
        "суток"
    ],
    "hour": [
        "ч",
        "час",
        "часа",
        "часов"
    ],
    "minute": [
        "мин",
        "минута",
        "минуты",
        "минут",
        "минуту"
    ],
    "second": [
        "с",
        "сек",
        "секунда",
        "секунды",
        "секунд",
        "секунду"
    ],
    "relative-type": {
        "0 day ago": [
            "сегодня"
        ],
        "0 hour ago": [
            "в этом часе"
        ],
        "0 minute ago": [
            "в эту минуту"
        ],
        "0 month ago": [
            "в этом месяце"
        ],
        "0 second ago": [
            "сейчас"
        ],
        "0 week ago": [
            "на этой неделе"
        ],
        "0 year ago": [
            "в этом году"
        ],
        "1 day ago": [
            "вчера"
        ],
        "1 month ago": [
            "в прошлом месяце"
        ],
        "1 week ago": [
            "на прошлой неделе"
        ],
        "1 year ago": [
            "в прошлом году"
        ],
        "in 1 day": [
            "завтра"
        ],
        "in 1 month": [
            "в следующем месяце"
        ],
        "in 1 week": [
            "на следующей неделе"
        ],
        "in 1 year": [
            "в следующем году"
        ],
        "2 day ago": [
            "позавчера"
        ],
        "in 2 day": [
            "послезавтра"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) д назад",
            "(\\d+) день назад",
            "(\\d+) дн назад",
            "(\\d+) дня назад"
        ],
        "\\1 hour ago": [
            "(\\d+) ч назад",
            "(\\d+) час назад",
            "(\\d+) часа назад"
        ],
        "\\1 minute ago": [
            "(\\d+) мин назад",
            "(\\d+) минуту назад",
            "(\\d+) минуты назад"
        ],
        "\\1 month ago": [
            "(\\d+) мес назад",
            "(\\d+) месяц назад",
            "(\\d+) месяца назад"
        ],
        "\\1 second ago": [
            "(\\d+) сек назад",
            "(\\d+) секунду назад",
            "(\\d+) секунды назад"
        ],
        "\\1 week ago": [
            "(\\d+) нед назад",
            "(\\d+) недели назад",
            "(\\d+) неделю назад"
        ],
        "\\1 year ago": [
            "(\\d+) г назад",
            "(\\d+) год назад",
            "(\\d+) года назад"
        ],
        "in \\1 day": [
            "через (\\d+) д",
            "через (\\d+) день",
            "через (\\d+) дн",
            "через (\\d+) дня"
        ],
        "in \\1 hour": [
            "через (\\d+) ч",
            "через (\\d+) час",
            "через (\\d+) часа"
        ],
        "in \\1 minute": [
            "через (\\d+) мин",
            "через (\\d+) минуту",
            "через (\\d+) минуты"
        ],
        "in \\1 month": [
            "через (\\d+) мес",
            "через (\\d+) месяц",
            "через (\\d+) месяца"
        ],
        "in \\1 second": [
            "через (\\d+) сек",
            "через (\\d+) секунду",
            "через (\\d+) секунды"
        ],
        "in \\1 week": [
            "через (\\d+) нед",
            "через (\\d+) недели",
            "через (\\d+) неделю"
        ],
        "in \\1 year": [
            "через (\\d+) г",
            "через (\\d+) год",
            "через (\\d+) года"
        ]
    },
    "locale_specific": {
        "ru-BY": {
            "name": "ru-BY"
        },
        "ru-KG": {
            "name": "ru-KG"
        },
        "ru-KZ": {
            "name": "ru-KZ"
        },
        "ru-MD": {
            "name": "ru-MD"
        },
        "ru-UA": {
            "name": "ru-UA",
            "am": [
                "am"
            ],
            "pm": [
                "pm"
            ]
        }
    },
    "skip": [
        "в",
        "во",
        "и",
        "около",
        "примерно",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "назад"
    ],
    "in": [
        "в течение",
        "спустя",
        "через"
    ],
    "simplifications": [
        {
            "од(на|ну|ни|ной|ин)": "1"
        },
        {
            "дв(а|е|ое|ух)": "2"
        },
        {
            "пар[ауы]": "2"
        },
        {
            "три": "3"
        },
        {
            "четыре": "4"
        },
        {
            "пять": "5"
        },
        {
            "шесть": "6"
        },
        {
            "семь": "7"
        },
        {
            "восемь": "8"
        },
        {
            "девять": "9"
        },
        {
            "десять": "10"
        },
        {
            "одиннадцать": "11"
        },
        {
            "двенадцать": "12"
        },
        {
            "пятнадцать": "15"
        },
        {
            "двадцать": "20"
        },
        {
            "тридцать": "30"
        },
        {
            "сорок": "40"
        },
        {
            "пятьдесят": "50"
        },
        {
            "несколько секунд": "44 секунды"
        },
        {
            "полчаса": "30 минут"
        },
        {
            "полгода": "6 месяцев"
        },
        {
            "полтора часа": "90 минут"
        },
        {
            "полтора года": "18 месяцев"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)секунд[уы]|(?<=[^\\d]\\s+|^)секунду(?=(\\s+назад)))": "1 секунду"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)минут[уы]|(?<=[^\\d]\\s+|^)минуту(?=(\\s+назад)))": "1 минуту"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)часа?|(?<=[^\\d]\\s+|^)час(?=(\\s+назад)))": "1 час"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)(день|дня)|(?<=[^\\d]\\s+|^)день(?=(\\s+назад)))": "1 день"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)сут(ки|ок)|(?<=[^\\d]\\s+|^)сутки(?=(\\s+назад)))": "1 сутки"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)недел[юи]|(?<=[^\\d]\\s+|^)неделю(?=(\\s+назад)))": "1 неделю"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)месяца?|(?<=[^\\d]\\s+|^)месяц(?=(\\s+назад)))": "1 месяц"
        },
        {
            "((?<=(через|спустя|в течение)\\s+)года?|(?<=[^\\d]\\s+|^)год(?=(\\s+назад)))": "1 год"
        }
    ]
}
