"use strict";var e,t=require("@csstools/css-parser-algorithms"),i=require("@csstools/css-tokenizer");exports.NodeType=void 0,(e=exports.NodeType||(exports.NodeType={})).CustomMedia="custom-media",e.GeneralEnclosed="general-enclosed",e.MediaAnd="media-and",e.MediaCondition="media-condition",e.MediaConditionListWithAnd="media-condition-list-and",e.MediaConditionListWithOr="media-condition-list-or",e.MediaFeature="media-feature",e.MediaFeatureBoolean="mf-boolean",e.MediaFeatureName="mf-name",e.MediaFeaturePlain="mf-plain",e.MediaFeatureRangeNameValue="mf-range-name-value",e.MediaFeatureRangeValueName="mf-range-value-name",e.MediaFeatureRangeValueNameValue="mf-range-value-name-value",e.MediaFeatureValue="mf-value",e.MediaInParens="media-in-parens",e.MediaNot="media-not",e.MediaOr="media-or",e.MediaQueryWithType="media-query-with-type",e.MediaQueryWithoutType="media-query-without-type",e.MediaQueryInvalid="media-query-invalid";const a=/[A-Z]/g;function toLowerCaseAZ(e){return e.replace(a,(e=>String.fromCharCode(e.charCodeAt(0)+32)))}class MediaCondition{type=exports.NodeType.MediaCondition;media;constructor(e){this.media=e}tokens(){return this.media.tokens()}toString(){return this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,media:this.media.toJSON()}}isMediaCondition(){return MediaCondition.isMediaCondition(this)}static isMediaCondition(e){return!!e&&(e instanceof MediaCondition&&e.type===exports.NodeType.MediaCondition)}}class MediaInParens{type=exports.NodeType.MediaInParens;media;before;after;constructor(e,t=[],i=[]){this.media=e,this.before=t,this.after=i}tokens(){return[...this.before,...this.media.tokens(),...this.after]}toString(){return i.stringify(...this.before)+this.media.toString()+i.stringify(...this.after)}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&("walk"in this.media?this.media.walk(e,i):void 0)}toJSON(){return{type:this.type,media:this.media.toJSON(),before:this.before,after:this.after}}isMediaInParens(){return MediaInParens.isMediaInParens(this)}static isMediaInParens(e){return!!e&&(e instanceof MediaInParens&&e.type===exports.NodeType.MediaInParens)}}class MediaQueryWithType{type=exports.NodeType.MediaQueryWithType;modifier;mediaType;and=void 0;media=void 0;constructor(e,t,i,a){this.modifier=e,this.mediaType=t,i&&a&&(this.and=i,this.media=a)}getModifier(){if(!this.modifier.length)return"";for(let e=0;e<this.modifier.length;e++){const t=this.modifier[e];if(t[0]===i.TokenType.Ident)return t[4].value}return""}negateQuery(){const e=new MediaQueryWithType([...this.modifier],[...this.mediaType],this.and,this.media);if(0===e.modifier.length)return e.modifier=[[i.TokenType.Ident,"not",-1,-1,{value:"not"}],[i.TokenType.Whitespace," ",-1,-1,void 0]],e;for(let t=0;t<e.modifier.length;t++){const a=e.modifier[t];if(a[0]===i.TokenType.Ident&&"not"===toLowerCaseAZ(a[4].value)){e.modifier.splice(t,1);break}if(a[0]===i.TokenType.Ident&&"only"===toLowerCaseAZ(a[4].value)){a[1]="not",a[4].value="not";break}}return e}getMediaType(){if(!this.mediaType.length)return"";for(let e=0;e<this.mediaType.length;e++){const t=this.mediaType[e];if(t[0]===i.TokenType.Ident)return t[4].value}return""}tokens(){return this.and&&this.media?[...this.modifier,...this.mediaType,...this.and,...this.media.tokens()]:[...this.modifier,...this.mediaType]}toString(){return this.and&&this.media?i.stringify(...this.modifier)+i.stringify(...this.mediaType)+i.stringify(...this.and)+this.media.toString():i.stringify(...this.modifier)+i.stringify(...this.mediaType)}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;if(t&&(i={...t}),this.media)return!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,string:this.toString(),modifier:this.modifier,mediaType:this.mediaType,and:this.and,media:this.media}}isMediaQueryWithType(){return MediaQueryWithType.isMediaQueryWithType(this)}static isMediaQueryWithType(e){return!!e&&(e instanceof MediaQueryWithType&&e.type===exports.NodeType.MediaQueryWithType)}}class MediaQueryWithoutType{type=exports.NodeType.MediaQueryWithoutType;media;constructor(e){this.media=e}negateQuery(){let e=this.media;if(e.media.type===exports.NodeType.MediaNot)return new MediaQueryWithoutType(new MediaCondition(e.media.media));e.media.type===exports.NodeType.MediaConditionListWithOr&&(e=new MediaCondition(new MediaInParens(e,[[i.TokenType.Whitespace," ",0,0,void 0],[i.TokenType.OpenParen,"(",0,0,void 0]],[[i.TokenType.CloseParen,")",0,0,void 0]])));return new MediaQueryWithType([[i.TokenType.Ident,"not",0,0,{value:"not"}],[i.TokenType.Whitespace," ",0,0,void 0]],[[i.TokenType.Ident,"all",0,0,{value:"all"}],[i.TokenType.Whitespace," ",0,0,void 0]],[[i.TokenType.Ident,"and",0,0,{value:"and"}]],e)}tokens(){return this.media.tokens()}toString(){return this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,string:this.toString(),media:this.media}}isMediaQueryWithoutType(){return MediaQueryWithoutType.isMediaQueryWithoutType(this)}static isMediaQueryWithoutType(e){return!!e&&(e instanceof MediaQueryWithoutType&&e.type===exports.NodeType.MediaQueryWithoutType)}}class MediaQueryInvalid{type=exports.NodeType.MediaQueryInvalid;media;constructor(e){this.media=e}negateQuery(){return new MediaQueryInvalid(this.media)}tokens(){return this.media.flatMap((e=>e.tokens()))}toString(){return this.media.map((e=>e.toString())).join("")}walk(e,t){let i=!1;if(this.media.forEach(((a,r)=>{if(i)return;let n;t&&(n={...t}),!1!==e({node:a,parent:this,state:n},r)?"walk"in a&&!1===a.walk(e,n)&&(i=!0):i=!0})),i)return!1}toJSON(){return{type:this.type,string:this.toString(),media:this.media}}isMediaQueryInvalid(){return MediaQueryInvalid.isMediaQueryInvalid(this)}static isMediaQueryInvalid(e){return!!e&&(e instanceof MediaQueryInvalid&&e.type===exports.NodeType.MediaQueryInvalid)}}class GeneralEnclosed{type=exports.NodeType.GeneralEnclosed;value;constructor(e){this.value=e}tokens(){return this.value.tokens()}toString(){return this.value.toString()}indexOf(e){return e===this.value?"value":-1}at(e){if("value"===e)return this.value}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.value,parent:this,state:i},"value")&&("walk"in this.value?this.value.walk(e,i):void 0)}toJSON(){return{type:this.type,tokens:this.tokens()}}isGeneralEnclosed(){return GeneralEnclosed.isGeneralEnclosed(this)}static isGeneralEnclosed(e){return!!e&&(e instanceof GeneralEnclosed&&e.type===exports.NodeType.GeneralEnclosed)}}class MediaAnd{type=exports.NodeType.MediaAnd;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return i.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){return"media"===e?this.media:null}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaAnd(){return MediaAnd.isMediaAnd(this)}static isMediaAnd(e){return!!e&&(e instanceof MediaAnd&&e.type===exports.NodeType.MediaAnd)}}class MediaConditionListWithAnd{type=exports.NodeType.MediaConditionListWithAnd;leading;list;before;after;constructor(e,t,i=[],a=[]){this.leading=e,this.list=t,this.before=i,this.after=a}tokens(){return[...this.before,...this.leading.tokens(),...this.list.flatMap((e=>e.tokens())),...this.after]}toString(){return i.stringify(...this.before)+this.leading.toString()+this.list.map((e=>e.toString())).join("")+i.stringify(...this.after)}indexOf(e){return e===this.leading?"leading":"media-and"===e.type?this.list.indexOf(e):-1}at(e){return"leading"===e?this.leading:"number"==typeof e?(e<0&&(e=this.list.length+e),this.list[e]):void 0}walk(e,t){let i;if(t&&(i={...t}),!1===e({node:this.leading,parent:this,state:i},"leading"))return!1;if("walk"in this.leading&&!1===this.leading.walk(e,i))return!1;let a=!1;return this.list.forEach(((r,n)=>{a||(t&&(i={...t}),!1!==e({node:r,parent:this,state:i},n)?"walk"in r&&!1===r.walk(e,i)&&(a=!0):a=!0)})),!a&&void 0}toJSON(){return{type:this.type,leading:this.leading.toJSON(),list:this.list.map((e=>e.toJSON())),before:this.before,after:this.after}}isMediaConditionListWithAnd(){return MediaConditionListWithAnd.isMediaConditionListWithAnd(this)}static isMediaConditionListWithAnd(e){return!!e&&(e instanceof MediaConditionListWithAnd&&e.type===exports.NodeType.MediaConditionListWithAnd)}}class MediaConditionListWithOr{type=exports.NodeType.MediaConditionListWithOr;leading;list;before;after;constructor(e,t,i=[],a=[]){this.leading=e,this.list=t,this.before=i,this.after=a}tokens(){return[...this.before,...this.leading.tokens(),...this.list.flatMap((e=>e.tokens())),...this.after]}toString(){return i.stringify(...this.before)+this.leading.toString()+this.list.map((e=>e.toString())).join("")+i.stringify(...this.after)}indexOf(e){return e===this.leading?"leading":"media-or"===e.type?this.list.indexOf(e):-1}at(e){return"leading"===e?this.leading:"number"==typeof e?(e<0&&(e=this.list.length+e),this.list[e]):void 0}walk(e,t){let i;if(t&&(i={...t}),!1===e({node:this.leading,parent:this,state:i},"leading"))return!1;if("walk"in this.leading&&!1===this.leading.walk(e,i))return!1;let a=!1;return this.list.forEach(((r,n)=>{a||(t&&(i={...t}),!1!==e({node:r,parent:this,state:i},n)?"walk"in r&&!1===r.walk(e,i)&&(a=!0):a=!0)})),!a&&void 0}toJSON(){return{type:this.type,leading:this.leading.toJSON(),list:this.list.map((e=>e.toJSON())),before:this.before,after:this.after}}isMediaConditionListWithOr(){return MediaConditionListWithOr.isMediaConditionListWithOr(this)}static isMediaConditionListWithOr(e){return!!e&&(e instanceof MediaConditionListWithOr&&e.type===exports.NodeType.MediaConditionListWithOr)}}function isNumber(e){return!!(e.type===t.ComponentValueType.Token&&e.value[0]===i.TokenType.Number||e.type===t.ComponentValueType.Function&&r.has(toLowerCaseAZ(e.name[4].value)))}const r=new Set(["abs","acos","asin","atan","atan2","calc","clamp","cos","exp","hypot","log","max","min","mod","pow","rem","round","sign","sin","sqrt","tan"]);function isDimension(e){return e.type===t.ComponentValueType.Token&&e.value[0]===i.TokenType.Dimension}function isIdent(e){return e.type===t.ComponentValueType.Token&&e.value[0]===i.TokenType.Ident}function isEnvironmentVariable(e){return e.type===t.ComponentValueType.Function&&"env"===toLowerCaseAZ(e.name[4].value)}class MediaFeatureName{type=exports.NodeType.MediaFeatureName;name;before;after;constructor(e,t=[],i=[]){this.name=e,this.before=t,this.after=i}getName(){return this.name.value[4].value}getNameToken(){return this.name.value}tokens(){return[...this.before,...this.name.tokens(),...this.after]}toString(){return i.stringify(...this.before)+this.name.toString()+i.stringify(...this.after)}indexOf(e){return e===this.name?"name":-1}at(e){if("name"===e)return this.name}toJSON(){return{type:this.type,name:this.getName(),tokens:this.tokens()}}isMediaFeatureName(){return MediaFeatureName.isMediaFeatureName(this)}static isMediaFeatureName(e){return!!e&&(e instanceof MediaFeatureName&&e.type===exports.NodeType.MediaFeatureName)}}function parseMediaFeatureName(e){let i=-1;for(let a=0;a<e.length;a++){const r=e[a];if(r.type!==t.ComponentValueType.Whitespace&&r.type!==t.ComponentValueType.Comment){if(!isIdent(r))return!1;if(-1!==i)return!1;i=a}}return-1!==i&&new MediaFeatureName(e[i],e.slice(0,i).flatMap((e=>e.tokens())),e.slice(i+1).flatMap((e=>e.tokens())))}class MediaFeatureBoolean{type=exports.NodeType.MediaFeatureBoolean;name;constructor(e){this.name=e}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return this.name.tokens()}toString(){return this.name.toString()}indexOf(e){return e===this.name?"name":-1}at(e){if("name"===e)return this.name}toJSON(){return{type:this.type,name:this.name.toJSON(),tokens:this.tokens()}}isMediaFeatureBoolean(){return MediaFeatureBoolean.isMediaFeatureBoolean(this)}static isMediaFeatureBoolean(e){return!!e&&(e instanceof MediaFeatureBoolean&&e.type===exports.NodeType.MediaFeatureBoolean)}}function parseMediaFeatureBoolean(e){const t=parseMediaFeatureName(e);return!1===t?t:new MediaFeatureBoolean(t)}class MediaFeatureValue{type=exports.NodeType.MediaFeatureValue;value;before;after;constructor(e,t=[],i=[]){Array.isArray(e)&&1===e.length?this.value=e[0]:this.value=e,this.before=t,this.after=i}tokens(){return Array.isArray(this.value)?[...this.before,...this.value.flatMap((e=>e.tokens())),...this.after]:[...this.before,...this.value.tokens(),...this.after]}toString(){return Array.isArray(this.value)?i.stringify(...this.before)+this.value.map((e=>e.toString())).join("")+i.stringify(...this.after):i.stringify(...this.before)+this.value.toString()+i.stringify(...this.after)}indexOf(e){return e===this.value?"value":-1}at(e){return"value"===e?this.value:Array.isArray(this.value)&&"number"==typeof e?(e<0&&(e=this.value.length+e),this.value[e]):void 0}walk(e,t){if(Array.isArray(this.value)){let i=!1;if(this.value.forEach(((a,r)=>{if(i)return;let n;t&&(n={...t}),!1!==e({node:a,parent:this,state:n},r)?"walk"in a&&!1===a.walk(e,n)&&(i=!0):i=!0})),i)return!1}else{let i;if(t&&(i={...t}),!1===e({node:this.value,parent:this,state:i},"value"))return!1;if("walk"in this.value)return this.value.walk(e,i)}}toJSON(){return Array.isArray(this.value)?{type:this.type,value:this.value.map((e=>e.toJSON())),tokens:this.tokens()}:{type:this.type,value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureValue(){return MediaFeatureValue.isMediaFeatureValue(this)}static isMediaFeatureValue(e){return!!e&&(e instanceof MediaFeatureValue&&e.type===exports.NodeType.MediaFeatureValue)}}function parseMediaFeatureValue(e){let i=-1,a=-1;for(let r=0;r<e.length;r++){const n=e[r];if(n.type!==t.ComponentValueType.Whitespace&&n.type!==t.ComponentValueType.Comment){if(-1!==i)return!1;if(isNumber(n)){const t=matchesRatioExactly(e.slice(r));if(-1!==t){i=t[0]+r,a=t[1]+r,r+=t[1]-t[0];continue}i=r,a=r}else if(isEnvironmentVariable(n))i=r,a=r;else if(isDimension(n))i=r,a=r;else{if(!isIdent(n))return!1;i=r,a=r}}}return-1!==i&&new MediaFeatureValue(e.slice(i,a+1),e.slice(0,i).flatMap((e=>e.tokens())),e.slice(a+1).flatMap((e=>e.tokens())))}function matchesRatioExactly(e){let t=-1,i=-1;const a=matchesRatio(e);if(-1===a)return-1;t=a[0],i=a[1];for(let t=i+1;t<e.length;t++){const i=e[t];if("whitespace"!==i.type&&"comment"!==i.type)return-1}return[t,i]}function matchesRatio(e){let t=-1,a=-1;for(let r=0;r<e.length;r++){const n=e[r];if("whitespace"!==n.type&&"comment"!==n.type){if("token"===n.type){const e=n.value;if(e[0]===i.TokenType.Delim&&"/"===e[4].value){if(-1===t)return-1;if(-1!==a)return-1;a=r;continue}}if(!isNumber(n))return-1;if(-1!==a)return[t,r];if(-1!==t)return-1;t=r}}return-1}class MediaFeaturePlain{type=exports.NodeType.MediaFeaturePlain;name;colon;value;constructor(e,t,i){this.name=e,this.colon=t,this.value=i}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.name.tokens(),this.colon,...this.value.tokens()]}toString(){return this.name.toString()+i.stringify(this.colon)+this.value.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.value,parent:this,state:i},"value")&&this.value.walk(e,i)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeaturePlain(){return MediaFeaturePlain.isMediaFeaturePlain(this)}static isMediaFeaturePlain(e){return!!e&&(e instanceof MediaFeaturePlain&&e.type===exports.NodeType.MediaFeaturePlain)}}function parseMediaFeaturePlain(e){let a=[],r=[],n=null;for(let o=0;o<e.length;o++){const s=e[o];if(s.type===t.ComponentValueType.Token){const t=s.value;if(t[0]===i.TokenType.Colon){a=e.slice(0,o),r=e.slice(o+1),n=t;break}}}if(!a.length||!r.length||!n)return!1;const o=parseMediaFeatureName(a);if(!1===o)return!1;const s=parseMediaFeatureValue(r);return!1!==s&&new MediaFeaturePlain(o,n,s)}var n,o;function matchesComparison(e){let a=-1;for(let r=0;r<e.length;r++){const n=e[r];if(n.type===t.ComponentValueType.Token){const e=n.value;if(e[0]===i.TokenType.Delim){if(e[4].value===exports.MediaFeatureEQ.EQ)return-1!==a?[a,r]:[r,r];if(e[4].value===exports.MediaFeatureLT.LT){a=r;continue}if(e[4].value===exports.MediaFeatureGT.GT){a=r;continue}}}break}return-1!==a&&[a,a]}function comparisonFromTokens(e){if(0===e.length||e.length>2)return!1;if(e[0][0]!==i.TokenType.Delim)return!1;if(1===e.length)switch(e[0][4].value){case exports.MediaFeatureEQ.EQ:return exports.MediaFeatureEQ.EQ;case exports.MediaFeatureLT.LT:return exports.MediaFeatureLT.LT;case exports.MediaFeatureGT.GT:return exports.MediaFeatureGT.GT;default:return!1}if(e[1][0]!==i.TokenType.Delim)return!1;if(e[1][4].value!==exports.MediaFeatureEQ.EQ)return!1;switch(e[0][4].value){case exports.MediaFeatureLT.LT:return exports.MediaFeatureLT.LT_OR_EQ;case exports.MediaFeatureGT.GT:return exports.MediaFeatureGT.GT_OR_EQ;default:return!1}}exports.MediaFeatureLT=void 0,(n=exports.MediaFeatureLT||(exports.MediaFeatureLT={})).LT="<",n.LT_OR_EQ="<=",exports.MediaFeatureGT=void 0,(o=exports.MediaFeatureGT||(exports.MediaFeatureGT={})).GT=">",o.GT_OR_EQ=">=",exports.MediaFeatureEQ=void 0,(exports.MediaFeatureEQ||(exports.MediaFeatureEQ={})).EQ="=";class MediaFeatureRangeNameValue{type=exports.NodeType.MediaFeatureRangeNameValue;name;operator;value;constructor(e,t,i){this.name=e,this.operator=t,this.value=i}operatorKind(){return comparisonFromTokens(this.operator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.name.tokens(),...this.operator,...this.value.tokens()]}toString(){return this.name.toString()+i.stringify(...this.operator)+this.value.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.value,parent:this,state:i},"value")&&("walk"in this.value?this.value.walk(e,i):void 0)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeNameValue(){return MediaFeatureRangeNameValue.isMediaFeatureRangeNameValue(this)}static isMediaFeatureRangeNameValue(e){return!!e&&(e instanceof MediaFeatureRangeNameValue&&e.type===exports.NodeType.MediaFeatureRangeNameValue)}}class MediaFeatureRangeValueName{type=exports.NodeType.MediaFeatureRangeValueName;name;operator;value;constructor(e,t,i){this.name=e,this.operator=t,this.value=i}operatorKind(){return comparisonFromTokens(this.operator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.value.tokens(),...this.operator,...this.name.tokens()]}toString(){return this.value.toString()+i.stringify(...this.operator)+this.name.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.value,parent:this,state:i},"value")&&("walk"in this.value?this.value.walk(e,i):void 0)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeValueName(){return MediaFeatureRangeValueName.isMediaFeatureRangeValueName(this)}static isMediaFeatureRangeValueName(e){return!!e&&(e instanceof MediaFeatureRangeValueName&&e.type===exports.NodeType.MediaFeatureRangeValueName)}}class MediaFeatureRangeValueNameValue{type=exports.NodeType.MediaFeatureRangeValueNameValue;name;valueOne;valueOneOperator;valueTwo;valueTwoOperator;constructor(e,t,i,a,r){this.name=e,this.valueOne=t,this.valueOneOperator=i,this.valueTwo=a,this.valueTwoOperator=r}valueOneOperatorKind(){return comparisonFromTokens(this.valueOneOperator)}valueTwoOperatorKind(){return comparisonFromTokens(this.valueTwoOperator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.valueOne.tokens(),...this.valueOneOperator,...this.name.tokens(),...this.valueTwoOperator,...this.valueTwo.tokens()]}toString(){return this.valueOne.toString()+i.stringify(...this.valueOneOperator)+this.name.toString()+i.stringify(...this.valueTwoOperator)+this.valueTwo.toString()}indexOf(e){return e===this.name?"name":e===this.valueOne?"valueOne":e===this.valueTwo?"valueTwo":-1}at(e){return"name"===e?this.name:"valueOne"===e?this.valueOne:"valueTwo"===e?this.valueTwo:void 0}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.valueOne,parent:this,state:i},"valueOne")&&((!("walk"in this.valueOne)||!1!==this.valueOne.walk(e,i))&&(t&&(i={...t}),!1!==e({node:this.valueTwo,parent:this,state:i},"valueTwo")&&((!("walk"in this.valueTwo)||!1!==this.valueTwo.walk(e,i))&&void 0)))}toJSON(){return{type:this.type,name:this.name.toJSON(),valueOne:this.valueOne.toJSON(),valueTwo:this.valueTwo.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeValueNameValue(){return MediaFeatureRangeValueNameValue.isMediaFeatureRangeValueNameValue(this)}static isMediaFeatureRangeValueNameValue(e){return!!e&&(e instanceof MediaFeatureRangeValueNameValue&&e.type===exports.NodeType.MediaFeatureRangeValueNameValue)}}function parseMediaFeatureRange(e){let a=!1,r=!1;for(let n=0;n<e.length;n++){const o=e[n];if(o.type===t.ComponentValueType.Token){if(o.value[0]===i.TokenType.Delim){const t=matchesComparison(e.slice(n));if(!1!==t){if(!1!==a){r=[t[0]+n,t[1]+n];break}a=[t[0]+n,t[1]+n],n+=t[1]}}}}if(!1===a)return!1;const n=[e[a[0]].value];if(a[0]!==a[1]&&n.push(e[a[1]].value),!1===r){const t=e.slice(0,a[0]),i=e.slice(a[1]+1),r=parseMediaFeatureName(t),o=parseMediaFeatureName(i);if(!r&&!o)return!1;if(r&&!o||r&&s.has(toLowerCaseAZ(r.getName()))){const e=parseMediaFeatureValue(i);return!!e&&new MediaFeatureRangeNameValue(r,n,e)}if(!r&&o||o&&s.has(toLowerCaseAZ(o.getName()))){const e=parseMediaFeatureValue(t);return!!e&&new MediaFeatureRangeValueName(o,n,e)}return!1}const o=[e[r[0]].value];r[0]!==r[1]&&o.push(e[r[1]].value);const u=e.slice(0,a[0]),d=e.slice(a[1]+1,r[0]),l=e.slice(r[1]+1),p=parseMediaFeatureValue(u),h=parseMediaFeatureName(d),m=parseMediaFeatureValue(l);if(!p||!h||!m)return!1;{const e=comparisonFromTokens(n);if(!1===e||e===exports.MediaFeatureEQ.EQ)return!1;const t=comparisonFromTokens(o);if(!1===t||t===exports.MediaFeatureEQ.EQ)return!1;if(!(e!==exports.MediaFeatureLT.LT&&e!==exports.MediaFeatureLT.LT_OR_EQ||t!==exports.MediaFeatureGT.GT&&t!==exports.MediaFeatureGT.GT_OR_EQ))return!1;if(!(e!==exports.MediaFeatureGT.GT&&e!==exports.MediaFeatureGT.GT_OR_EQ||t!==exports.MediaFeatureLT.LT&&t!==exports.MediaFeatureLT.LT_OR_EQ))return!1}return new MediaFeatureRangeValueNameValue(h,p,n,m,o)}const s=new Set(["any-hover","any-pointer","aspect-ratio","color","color-gamut","color-index","device-aspect-ratio","device-height","device-width","display-mode","dynamic-range","environment-blending","forced-colors","grid","height","horizontal-viewport-segments","hover","inverted-colors","monochrome","nav-controls","orientation","overflow-block","overflow-inline","pointer","prefers-color-scheme","prefers-contrast","prefers-reduced-data","prefers-reduced-motion","prefers-reduced-transparency","resolution","scan","scripting","update","vertical-viewport-segments","video-color-gamut","video-dynamic-range","width"]);class MediaFeature{type=exports.NodeType.MediaFeature;feature;before;after;constructor(e,t=[],i=[]){this.feature=e,this.before=t,this.after=i}getName(){return this.feature.getName()}getNameToken(){return this.feature.getNameToken()}tokens(){return[...this.before,...this.feature.tokens(),...this.after]}toString(){return i.stringify(...this.before)+this.feature.toString()+i.stringify(...this.after)}indexOf(e){return e===this.feature?"feature":-1}at(e){if("feature"===e)return this.feature}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.feature,parent:this,state:i},"feature")&&("walk"in this.feature?this.feature.walk(e,i):void 0)}toJSON(){return{type:this.type,feature:this.feature.toJSON(),before:this.before,after:this.after}}isMediaFeature(){return MediaFeature.isMediaFeature(this)}static isMediaFeature(e){return!!e&&(e instanceof MediaFeature&&e.type===exports.NodeType.MediaFeature)}}function parseMediaFeature(e,t=[],a=[]){if(e.startToken[0]!==i.TokenType.OpenParen)return!1;const r=parseMediaFeatureBoolean(e.value);if(!1!==r)return new MediaFeature(r,t,a);const n=parseMediaFeaturePlain(e.value);if(!1!==n)return new MediaFeature(n,t,a);const o=parseMediaFeatureRange(e.value);return!1!==o&&new MediaFeature(o,t,a)}class MediaNot{type=exports.NodeType.MediaNot;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return i.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaNot(){return MediaNot.isMediaNot(this)}static isMediaNot(e){return!!e&&(e instanceof MediaNot&&e.type===exports.NodeType.MediaNot)}}class MediaOr{type=exports.NodeType.MediaOr;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return i.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e,t){let i;return t&&(i={...t}),!1!==e({node:this.media,parent:this,state:i},"media")&&this.media.walk(e,i)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaOr(){return MediaOr.isMediaOr(this)}static isMediaOr(e){return!!e&&(e instanceof MediaOr&&e.type===exports.NodeType.MediaOr)}}var u,d;function modifierFromToken(e){if(e[0]!==i.TokenType.Ident)return!1;switch(toLowerCaseAZ(e[4].value)){case exports.MediaQueryModifier.Not:return exports.MediaQueryModifier.Not;case exports.MediaQueryModifier.Only:return exports.MediaQueryModifier.Only;default:return!1}}function parseMediaQuery(e){{const t=parseMediaCondition(e);if(!1!==t)return new MediaQueryWithoutType(t)}{let a=-1,r=-1,n=-1;for(let o=0;o<e.length;o++){const s=e[o];if(!t.isWhitespaceNode(s)&&!t.isCommentNode(s)){if(t.isTokenNode(s)){const t=s.value;if(-1===a&&t[0]===i.TokenType.Ident&&modifierFromToken(t)){a=o;continue}if(-1===r&&t[0]===i.TokenType.Ident&&!modifierFromToken(t)){r=o;continue}if(-1===n&&t[0]===i.TokenType.Ident&&"and"===toLowerCaseAZ(t[4].value)){n=o;if(!1===parseMediaConditionWithoutOr(e.slice(o+1)))return!1;break}return!1}return!1}}let o=[],s=[];-1!==a?(o=e.slice(0,a+1).flatMap((e=>e.tokens())),-1!==r&&(s=e.slice(a+1,r+1).flatMap((e=>e.tokens())))):-1!==r&&(s=e.slice(0,r+1).flatMap((e=>e.tokens())));const u=parseMediaConditionWithoutOr(e.slice(Math.max(a,r,n)+1));return!1===u?new MediaQueryWithType(o,[...s,...e.slice(r+1).flatMap((e=>e.tokens()))]):new MediaQueryWithType(o,s,e.slice(r+1,n+1).flatMap((e=>e.tokens())),u)}}function parseMediaConditionListWithOr(e){let i=!1;const a=[];let r=-1,n=-1;for(let o=0;o<e.length;o++){if(i){const t=parseMediaOr(e.slice(o));if(!1!==t){o+=t.advance,a.push(t.node),n=o;continue}}const s=e[o];if(s.type!==t.ComponentValueType.Whitespace&&s.type!==t.ComponentValueType.Comment){if(i)return!1;if(!1!==i||!t.isSimpleBlockNode(s))return!1;if(s.normalize(),i=parseMediaInParensFromSimpleBlock(s),!1===i)return!1;r=o}}return!(!i||!a.length)&&new MediaConditionListWithOr(i,a,e.slice(0,r).flatMap((e=>e.tokens())),e.slice(n+1).flatMap((e=>e.tokens())))}function parseMediaConditionListWithAnd(e){let i=!1;const a=[];let r=-1,n=-1;for(let o=0;o<e.length;o++){if(i){const t=parseMediaAnd(e.slice(o));if(!1!==t){o+=t.advance,a.push(t.node),n=o;continue}}const s=e[o];if(s.type!==t.ComponentValueType.Whitespace&&s.type!==t.ComponentValueType.Comment){if(i)return!1;if(!1!==i||!t.isSimpleBlockNode(s))return!1;if(s.normalize(),i=parseMediaInParensFromSimpleBlock(s),!1===i)return!1;r=o}}return!(!i||!a.length)&&new MediaConditionListWithAnd(i,a,e.slice(0,r).flatMap((e=>e.tokens())),e.slice(n+1).flatMap((e=>e.tokens())))}function parseMediaCondition(e){const t=parseMediaNot(e);if(!1!==t)return new MediaCondition(t);const i=parseMediaConditionListWithAnd(e);if(!1!==i)return new MediaCondition(i);const a=parseMediaConditionListWithOr(e);if(!1!==a)return new MediaCondition(a);const r=parseMediaInParens(e);return!1!==r&&new MediaCondition(r)}function parseMediaConditionWithoutOr(e){const t=parseMediaNot(e);if(!1!==t)return new MediaCondition(t);const i=parseMediaConditionListWithAnd(e);if(!1!==i)return new MediaCondition(i);const a=parseMediaInParens(e);return!1!==a&&new MediaCondition(a)}function parseMediaInParens(e){let a=-1;for(let i=0;i<e.length;i++){const r=e[i];if(r.type!==t.ComponentValueType.Whitespace&&r.type!==t.ComponentValueType.Comment){if(!t.isSimpleBlockNode(r))return!1;if(-1!==a)return!1;a=i}}if(-1===a)return!1;const r=e[a];if(r.startToken[0]!==i.TokenType.OpenParen)return!1;r.normalize();const n=[...e.slice(0,a).flatMap((e=>e.tokens())),r.startToken],o=[r.endToken,...e.slice(a+1).flatMap((e=>e.tokens()))],s=parseMediaFeature(r,n,o);if(!1!==s)return new MediaInParens(s);const u=parseMediaCondition(r.value);return!1!==u?new MediaInParens(u,n,o):new MediaInParens(new GeneralEnclosed(r),e.slice(0,a).flatMap((e=>e.tokens())),e.slice(a+1).flatMap((e=>e.tokens())))}function parseMediaInParensFromSimpleBlock(e){if(e.startToken[0]!==i.TokenType.OpenParen)return!1;const t=parseMediaFeature(e,[e.startToken],[e.endToken]);if(!1!==t)return new MediaInParens(t);const a=parseMediaCondition(e.value);return!1!==a?new MediaInParens(a,[e.startToken],[e.endToken]):new MediaInParens(new GeneralEnclosed(e))}function parseMediaNot(e){let i=!1,a=null;for(let r=0;r<e.length;r++){const n=e[r];if(n.type!==t.ComponentValueType.Whitespace&&n.type!==t.ComponentValueType.Comment){if(isIdent(n)){if("not"===toLowerCaseAZ(n.value[4].value)){if(i)return!1;i=!0;continue}return!1}if(!i||!t.isSimpleBlockNode(n))return!1;{n.normalize();const t=parseMediaInParensFromSimpleBlock(n);if(!1===t)return!1;a=new MediaNot(e.slice(0,r).flatMap((e=>e.tokens())),t)}}}return a||!1}function parseMediaOr(e){let i=!1;for(let a=0;a<e.length;a++){const r=e[a];if(r.type!==t.ComponentValueType.Whitespace&&r.type!==t.ComponentValueType.Comment){if(isIdent(r)){if("or"===toLowerCaseAZ(r.value[4].value)){if(i)return!1;i=!0;continue}return!1}if(i&&t.isSimpleBlockNode(r)){r.normalize();const t=parseMediaInParensFromSimpleBlock(r);return!1!==t&&{advance:a,node:new MediaOr(e.slice(0,a).flatMap((e=>e.tokens())),t)}}return!1}}return!1}function parseMediaAnd(e){let i=!1;for(let a=0;a<e.length;a++){const r=e[a];if(r.type!==t.ComponentValueType.Whitespace&&r.type!==t.ComponentValueType.Comment){if(isIdent(r)){if("and"===toLowerCaseAZ(r.value[4].value)){if(i)return!1;i=!0;continue}return!1}if(i&&t.isSimpleBlockNode(r)){r.normalize();const t=parseMediaInParensFromSimpleBlock(r);return!1!==t&&{advance:a,node:new MediaAnd(e.slice(0,a).flatMap((e=>e.tokens())),t)}}return!1}}return!1}function parseFromTokens(e,i){const a=t.parseCommaSeparatedListOfComponentValues(e,{onParseError:null==i?void 0:i.onParseError});return a.map(((e,t)=>{const r=parseMediaQuery(e);return 0==r&&!0===(null==i?void 0:i.preserveInvalidMediaQueries)?new MediaQueryInvalid(a[t]):r})).filter((e=>!!e))}exports.MediaQueryModifier=void 0,(u=exports.MediaQueryModifier||(exports.MediaQueryModifier={})).Not="not",u.Only="only";class CustomMedia{type=exports.NodeType.CustomMedia;name;mediaQueryList=null;trueOrFalseKeyword=null;constructor(e,t,i){this.name=e,this.mediaQueryList=t,this.trueOrFalseKeyword=i??null}getName(){for(let e=0;e<this.name.length;e++){const t=this.name[e];if(t[0]===i.TokenType.Ident)return t[4].value}return""}getNameToken(){for(let e=0;e<this.name.length;e++){const t=this.name[e];if(t[0]===i.TokenType.Ident)return t}return null}hasMediaQueryList(){return!!this.mediaQueryList}hasTrueKeyword(){if(!this.trueOrFalseKeyword)return!1;for(let e=0;e<this.trueOrFalseKeyword.length;e++){const t=this.trueOrFalseKeyword[e];if(t[0]!==i.TokenType.Comment&&t[0]!==i.TokenType.Whitespace)return t[0]===i.TokenType.Ident&&"true"===toLowerCaseAZ(t[4].value)}return!1}hasFalseKeyword(){if(!this.trueOrFalseKeyword)return!1;for(let e=0;e<this.trueOrFalseKeyword.length;e++){const t=this.trueOrFalseKeyword[e];if(t[0]!==i.TokenType.Comment&&t[0]!==i.TokenType.Whitespace)return t[0]===i.TokenType.Ident&&"false"===toLowerCaseAZ(t[4].value)}return!1}tokens(){if(this.trueOrFalseKeyword)return[...this.name,...this.trueOrFalseKeyword];if(!this.mediaQueryList)return[...this.name];const e=[];for(let t=0;t<this.mediaQueryList.length;t++){const a=this.mediaQueryList[t];0!==t&&e.push([i.TokenType.Comma,",",-1,-1,void 0]),e.push(...a.tokens())}return[...this.name,...e]}toString(){return i.stringify(...this.tokens())}toJSON(){var e;return{type:this.type,string:this.toString(),nameValue:this.getName(),name:this.name,hasFalseKeyword:this.hasFalseKeyword(),hasTrueKeyword:this.hasTrueKeyword(),trueOrFalseKeyword:this.trueOrFalseKeyword,mediaQueryList:null==(e=this.mediaQueryList)?void 0:e.map((e=>e.toJSON()))}}isCustomMedia(){return CustomMedia.isCustomMedia(this)}static isCustomMedia(e){return!!e&&(e instanceof CustomMedia&&e.type===exports.NodeType.CustomMedia)}}function parseCustomMediaFromTokens(e,t){let a=[],r=e;for(let t=0;t<e.length;t++)if(e[t][0]!==i.TokenType.Comment&&e[t][0]!==i.TokenType.Whitespace){if(e[t][0]===i.TokenType.Ident){if(e[t][4].value.startsWith("--")){a=e.slice(0,t+1),r=e.slice(t+1);break}}return!1}let n=!0;for(let e=0;e<r.length;e++)if(r[e][0]!==i.TokenType.Comment&&r[e][0]!==i.TokenType.Whitespace){if(r[e][0]===i.TokenType.Ident){const t=toLowerCaseAZ(r[e][4].value);if("false"===t)continue;if("true"===t)continue}if(r[e][0]===i.TokenType.EOF)break;n=!1}return n?new CustomMedia(a,null,r):new CustomMedia(a,parseFromTokens(i.cloneTokens(r),t))}function isMediaConditionListWithAnd(e){return MediaConditionListWithAnd.isMediaConditionListWithAnd(e)}function isMediaConditionListWithOr(e){return MediaConditionListWithOr.isMediaConditionListWithOr(e)}function isMediaFeatureRangeNameValue(e){return MediaFeatureRangeNameValue.isMediaFeatureRangeNameValue(e)}function isMediaFeatureRangeValueName(e){return MediaFeatureRangeValueName.isMediaFeatureRangeValueName(e)}function isMediaFeatureRangeValueNameValue(e){return MediaFeatureRangeValueNameValue.isMediaFeatureRangeValueNameValue(e)}function isMediaQueryWithType(e){return MediaQueryWithType.isMediaQueryWithType(e)}function isMediaQueryWithoutType(e){return MediaQueryWithoutType.isMediaQueryWithoutType(e)}function isMediaQueryInvalid(e){return MediaQueryInvalid.isMediaQueryInvalid(e)}exports.MediaType=void 0,(d=exports.MediaType||(exports.MediaType={})).All="all",d.Print="print",d.Screen="screen",d.Tty="tty",d.Tv="tv",d.Projection="projection",d.Handheld="handheld",d.Braille="braille",d.Embossed="embossed",d.Aural="aural",d.Speech="speech",exports.CustomMedia=CustomMedia,exports.GeneralEnclosed=GeneralEnclosed,exports.MediaAnd=MediaAnd,exports.MediaCondition=MediaCondition,exports.MediaConditionListWithAnd=MediaConditionListWithAnd,exports.MediaConditionListWithOr=MediaConditionListWithOr,exports.MediaFeature=MediaFeature,exports.MediaFeatureBoolean=MediaFeatureBoolean,exports.MediaFeatureName=MediaFeatureName,exports.MediaFeaturePlain=MediaFeaturePlain,exports.MediaFeatureRangeNameValue=MediaFeatureRangeNameValue,exports.MediaFeatureRangeValueName=MediaFeatureRangeValueName,exports.MediaFeatureRangeValueNameValue=MediaFeatureRangeValueNameValue,exports.MediaFeatureValue=MediaFeatureValue,exports.MediaInParens=MediaInParens,exports.MediaNot=MediaNot,exports.MediaOr=MediaOr,exports.MediaQueryInvalid=MediaQueryInvalid,exports.MediaQueryWithType=MediaQueryWithType,exports.MediaQueryWithoutType=MediaQueryWithoutType,exports.cloneMediaQuery=function cloneMediaQuery(e){const t=i.cloneTokens(e.tokens()),a=parseFromTokens(t,{preserveInvalidMediaQueries:!0})[0];if(!a)throw new Error(`Failed to clone media query for : "${i.stringify(...t)}"`);if(isMediaQueryInvalid(e)&&isMediaQueryInvalid(a))return a;if(isMediaQueryWithType(e)&&isMediaQueryWithType(a))return a;if(isMediaQueryWithoutType(e)&&isMediaQueryWithoutType(a))return a;throw new Error(`Failed to clone media query for : "${i.stringify(...t)}"`)},exports.comparisonFromTokens=comparisonFromTokens,exports.invertComparison=function invertComparison(e){switch(e){case exports.MediaFeatureEQ.EQ:return exports.MediaFeatureEQ.EQ;case exports.MediaFeatureLT.LT:return exports.MediaFeatureGT.GT;case exports.MediaFeatureLT.LT_OR_EQ:return exports.MediaFeatureGT.GT_OR_EQ;case exports.MediaFeatureGT.GT:return exports.MediaFeatureLT.LT;case exports.MediaFeatureGT.GT_OR_EQ:return exports.MediaFeatureLT.LT_OR_EQ;default:return!1}},exports.isCustomMedia=function isCustomMedia(e){return CustomMedia.isCustomMedia(e)},exports.isGeneralEnclosed=function isGeneralEnclosed(e){return GeneralEnclosed.isGeneralEnclosed(e)},exports.isMediaAnd=function isMediaAnd(e){return MediaAnd.isMediaAnd(e)},exports.isMediaCondition=function isMediaCondition(e){return MediaCondition.isMediaCondition(e)},exports.isMediaConditionList=function isMediaConditionList(e){return isMediaConditionListWithAnd(e)||isMediaConditionListWithOr(e)},exports.isMediaConditionListWithAnd=isMediaConditionListWithAnd,exports.isMediaConditionListWithOr=isMediaConditionListWithOr,exports.isMediaFeature=function isMediaFeature(e){return MediaFeature.isMediaFeature(e)},exports.isMediaFeatureBoolean=function isMediaFeatureBoolean(e){return MediaFeatureBoolean.isMediaFeatureBoolean(e)},exports.isMediaFeatureName=function isMediaFeatureName(e){return MediaFeatureName.isMediaFeatureName(e)},exports.isMediaFeaturePlain=function isMediaFeaturePlain(e){return MediaFeaturePlain.isMediaFeaturePlain(e)},exports.isMediaFeatureRange=function isMediaFeatureRange(e){return isMediaFeatureRangeNameValue(e)||isMediaFeatureRangeValueName(e)||isMediaFeatureRangeValueNameValue(e)},exports.isMediaFeatureRangeNameValue=isMediaFeatureRangeNameValue,exports.isMediaFeatureRangeValueName=isMediaFeatureRangeValueName,exports.isMediaFeatureRangeValueNameValue=isMediaFeatureRangeValueNameValue,exports.isMediaFeatureValue=function isMediaFeatureValue(e){return MediaFeatureValue.isMediaFeatureValue(e)},exports.isMediaInParens=function isMediaInParens(e){return MediaInParens.isMediaInParens(e)},exports.isMediaNot=function isMediaNot(e){return MediaNot.isMediaNot(e)},exports.isMediaOr=function isMediaOr(e){return MediaOr.isMediaOr(e)},exports.isMediaQuery=function isMediaQuery(e){return isMediaQueryWithType(e)||isMediaQueryWithoutType(e)||isMediaQueryInvalid(e)},exports.isMediaQueryInvalid=isMediaQueryInvalid,exports.isMediaQueryWithType=isMediaQueryWithType,exports.isMediaQueryWithoutType=isMediaQueryWithoutType,exports.matchesComparison=matchesComparison,exports.matchesRatio=matchesRatio,exports.matchesRatioExactly=matchesRatioExactly,exports.modifierFromToken=modifierFromToken,exports.newMediaFeatureBoolean=function newMediaFeatureBoolean(e){const a=[i.TokenType.Ident,"",-1,-1,{value:""}];return i.mutateIdent(a,e),new MediaFeature(new MediaFeatureBoolean(new MediaFeatureName(new t.TokenNode(a))),[[i.TokenType.OpenParen,"(",-1,-1,void 0]],[[i.TokenType.CloseParen,")",-1,-1,void 0]])},exports.newMediaFeaturePlain=function newMediaFeaturePlain(e,...a){const r=[i.TokenType.Ident,"",-1,-1,{value:""}];i.mutateIdent(r,e);const n=t.parseListOfComponentValues(a);return new MediaFeature(new MediaFeaturePlain(new MediaFeatureName(new t.TokenNode(r)),[i.TokenType.Colon,":",-1,-1,void 0],new MediaFeatureValue(1===n.length?n[0]:n)),[[i.TokenType.OpenParen,"(",-1,-1,void 0]],[[i.TokenType.CloseParen,")",-1,-1,void 0]])},exports.parse=function parse(e,t){const a=i.tokenizer({css:e},{onParseError:null==t?void 0:t.onParseError}),r=[];for(;!a.endOfFile();)r.push(a.nextToken());return r.push(a.nextToken()),parseFromTokens(r,t)},exports.parseCustomMedia=function parseCustomMedia(e,t){const a=i.tokenizer({css:e},{onParseError:null==t?void 0:t.onParseError}),r=[];for(;!a.endOfFile();)r.push(a.nextToken());return r.push(a.nextToken()),parseCustomMediaFromTokens(r,t)},exports.parseCustomMediaFromTokens=parseCustomMediaFromTokens,exports.parseFromTokens=parseFromTokens,exports.typeFromToken=function typeFromToken(e){if(e[0]!==i.TokenType.Ident)return!1;switch(toLowerCaseAZ(e[4].value)){case exports.MediaType.All:return exports.MediaType.All;case exports.MediaType.Print:return exports.MediaType.Print;case exports.MediaType.Screen:return exports.MediaType.Screen;case exports.MediaType.Tty:return exports.MediaType.Tty;case exports.MediaType.Tv:return exports.MediaType.Tv;case exports.MediaType.Projection:return exports.MediaType.Projection;case exports.MediaType.Handheld:return exports.MediaType.Handheld;case exports.MediaType.Braille:return exports.MediaType.Braille;case exports.MediaType.Embossed:return exports.MediaType.Embossed;case exports.MediaType.Aural:return exports.MediaType.Aural;case exports.MediaType.Speech:return exports.MediaType.Speech;default:return!1}};
