/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.res.StringManager;

public class SSLHostConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SSLHostConfig.class);
    private static final StringManager sm = StringManager.getManager(SSLHostConfig.class);
    protected static final String DEFAULT_SSL_HOST_NAME = "_default_";
    protected static final Set<String> SSL_PROTO_ALL_SET = new HashSet<String>();
    public static final String DEFAULT_TLS_CIPHERS = "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA";
    private Type configType = null;
    private String hostName = "_default_";
    private transient Long openSslConfContext = 0L;
    private transient Long openSslContext = 0L;
    private boolean tls13RenegotiationAvailable = false;
    private String[] enabledCiphers;
    private String[] enabledProtocols;
    private ObjectName oname;
    private Set<String> explicitlyRequestedProtocols = new HashSet<String>();
    private SSLHostConfigCertificate defaultCertificate = null;
    private Set<SSLHostConfigCertificate> certificates = new LinkedHashSet<SSLHostConfigCertificate>(4);
    private String certificateRevocationListFile;
    private CertificateVerification certificateVerification = CertificateVerification.NONE;
    private int certificateVerificationDepth = 10;
    private boolean certificateVerificationDepthConfigured = false;
    private String ciphers = "HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5:!kRSA";
    private LinkedHashSet<Cipher> cipherList = null;
    private List<String> jsseCipherNames = null;
    private boolean honorCipherOrder = false;
    private Set<String> protocols = new HashSet<String>();
    private int sessionCacheSize = -1;
    private int sessionTimeout = 86400;
    private String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private boolean revocationEnabled = false;
    private String sslProtocol = "TLS";
    private String trustManagerClassName;
    private String truststoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
    private String truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String truststoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private String truststoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private transient KeyStore truststore = null;
    private String certificateRevocationListPath;
    private String caCertificateFile;
    private String caCertificatePath;
    private boolean disableCompression = true;
    private boolean disableSessionTickets = false;
    private boolean insecureRenegotiation = false;
    private OpenSSLConf openSslConf = null;

    public SSLHostConfig() {
        this.setProtocols("all");
    }

    public boolean isTls13RenegotiationAvailable() {
        return this.tls13RenegotiationAvailable;
    }

    public void setTls13RenegotiationAvailable(boolean bl) {
        this.tls13RenegotiationAvailable = bl;
    }

    public Long getOpenSslConfContext() {
        return this.openSslConfContext;
    }

    public void setOpenSslConfContext(Long l) {
        this.openSslConfContext = l;
    }

    public Long getOpenSslContext() {
        return this.openSslContext;
    }

    public void setOpenSslContext(Long l) {
        this.openSslContext = l;
    }

    public String getConfigType() {
        return this.configType.name();
    }

    boolean setProperty(String string, Type type) {
        if (this.configType == null) {
            this.configType = type;
        } else if (type != this.configType) {
            log.warn((Object)sm.getString("sslHostConfig.mismatch", new Object[]{string, this.getHostName(), type, this.configType}));
            return false;
        }
        return true;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = stringArray;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] stringArray) {
        this.enabledCiphers = stringArray;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName objectName) {
        this.oname = objectName;
    }

    private void registerDefaultCertificate() {
        if (this.defaultCertificate == null) {
            SSLHostConfigCertificate sSLHostConfigCertificate = new SSLHostConfigCertificate(this, SSLHostConfigCertificate.Type.UNDEFINED);
            this.addCertificate(sSLHostConfigCertificate);
            this.defaultCertificate = sSLHostConfigCertificate;
        }
    }

    public void addCertificate(SSLHostConfigCertificate sSLHostConfigCertificate) {
        if (this.certificates.size() == 0) {
            this.certificates.add(sSLHostConfigCertificate);
            return;
        }
        if (this.certificates.size() == 1 && this.certificates.iterator().next().getType() == SSLHostConfigCertificate.Type.UNDEFINED || sSLHostConfigCertificate.getType() == SSLHostConfigCertificate.Type.UNDEFINED) {
            throw new IllegalArgumentException(sm.getString("sslHostConfig.certificate.notype"));
        }
        this.certificates.add(sSLHostConfigCertificate);
    }

    public OpenSSLConf getOpenSslConf() {
        return this.openSslConf;
    }

    public void setOpenSslConf(OpenSSLConf openSSLConf) {
        if (openSSLConf == null) {
            throw new IllegalArgumentException(sm.getString("sslHostConfig.opensslconf.null"));
        }
        if (this.openSslConf != null) {
            throw new IllegalArgumentException(sm.getString("sslHostConfig.opensslconf.alreadySet"));
        }
        this.setProperty("<OpenSSLConf>", Type.OPENSSL);
        this.openSslConf = openSSLConf;
    }

    public Set<SSLHostConfigCertificate> getCertificates() {
        return this.getCertificates(false);
    }

    public Set<SSLHostConfigCertificate> getCertificates(boolean bl) {
        if (this.certificates.size() == 0 && bl) {
            this.registerDefaultCertificate();
        }
        return this.certificates;
    }

    public void setCertificateRevocationListFile(String string) {
        this.certificateRevocationListFile = string;
    }

    public String getCertificateRevocationListFile() {
        return this.certificateRevocationListFile;
    }

    public void setCertificateVerification(String string) {
        try {
            this.certificateVerification = CertificateVerification.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.certificateVerification = CertificateVerification.REQUIRED;
            throw illegalArgumentException;
        }
    }

    public CertificateVerification getCertificateVerification() {
        return this.certificateVerification;
    }

    public void setCertificateVerificationAsString(String string) {
        this.setCertificateVerification(string);
    }

    public String getCertificateVerificationAsString() {
        return this.certificateVerification.toString();
    }

    public void setCertificateVerificationDepth(int n) {
        this.certificateVerificationDepth = n;
        this.certificateVerificationDepthConfigured = true;
    }

    public int getCertificateVerificationDepth() {
        return this.certificateVerificationDepth;
    }

    public boolean isCertificateVerificationDepthConfigured() {
        return this.certificateVerificationDepthConfigured;
    }

    public void setCiphers(String string) {
        if (string != null && !string.contains(":")) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim();
                if (string3.length() <= 0) continue;
                String string4 = OpenSSLCipherConfigurationParser.jsseToOpenSSL(string3);
                if (string4 == null) {
                    string4 = string3;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(':');
                }
                stringBuilder.append(string4);
            }
            this.ciphers = stringBuilder.toString();
        } else {
            this.ciphers = string;
        }
        this.cipherList = null;
        this.jsseCipherNames = null;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public LinkedHashSet<Cipher> getCipherList() {
        if (this.cipherList == null) {
            this.cipherList = OpenSSLCipherConfigurationParser.parse(this.getCiphers());
        }
        return this.cipherList;
    }

    public List<String> getJsseCipherNames() {
        if (this.jsseCipherNames == null) {
            this.jsseCipherNames = OpenSSLCipherConfigurationParser.convertForJSSE(this.getCipherList());
        }
        return this.jsseCipherNames;
    }

    public void setHonorCipherOrder(boolean bl) {
        this.honorCipherOrder = bl;
    }

    public boolean getHonorCipherOrder() {
        return this.honorCipherOrder;
    }

    public void setHostName(String string) {
        this.hostName = string.toLowerCase(Locale.ENGLISH);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setProtocols(String string) {
        this.protocols.clear();
        this.explicitlyRequestedProtocols.clear();
        for (String string2 : string.split("(?=[-+,])")) {
            String string3 = string2.trim();
            if (string3.length() <= 1) continue;
            if (string3.charAt(0) == '+') {
                if ((string3 = string3.substring(1).trim()).equalsIgnoreCase("all")) {
                    this.protocols.addAll(SSL_PROTO_ALL_SET);
                    continue;
                }
                this.protocols.add(string3);
                this.explicitlyRequestedProtocols.add(string3);
                continue;
            }
            if (string3.charAt(0) == '-') {
                if ((string3 = string3.substring(1).trim()).equalsIgnoreCase("all")) {
                    this.protocols.removeAll(SSL_PROTO_ALL_SET);
                    continue;
                }
                this.protocols.remove(string3);
                this.explicitlyRequestedProtocols.remove(string3);
                continue;
            }
            if (string3.charAt(0) == ',') {
                string3 = string3.substring(1).trim();
            }
            if (!this.protocols.isEmpty()) {
                log.warn((Object)sm.getString("sslHostConfig.prefix_missing", new Object[]{string3, this.getHostName()}));
            }
            if (string3.equalsIgnoreCase("all")) {
                this.protocols.addAll(SSL_PROTO_ALL_SET);
                continue;
            }
            this.protocols.add(string3);
            this.explicitlyRequestedProtocols.add(string3);
        }
    }

    public Set<String> getProtocols() {
        return this.protocols;
    }

    boolean isExplicitlyRequestedProtocol(String string) {
        return this.explicitlyRequestedProtocols.contains(string);
    }

    public void setSessionCacheSize(int n) {
        this.sessionCacheSize = n;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionTimeout(int n) {
        this.sessionTimeout = n;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setKeyManagerAlgorithm(String string) {
        this.setProperty("keyManagerAlgorithm", Type.JSSE);
        this.keyManagerAlgorithm = string;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setRevocationEnabled(boolean bl) {
        this.setProperty("revocationEnabled", Type.JSSE);
        this.revocationEnabled = bl;
    }

    public boolean getRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setSslProtocol(String string) {
        this.setProperty("sslProtocol", Type.JSSE);
        this.sslProtocol = string;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setTrustManagerClassName(String string) {
        this.setProperty("trustManagerClassName", Type.JSSE);
        this.trustManagerClassName = string;
    }

    public String getTrustManagerClassName() {
        return this.trustManagerClassName;
    }

    public void setTruststoreAlgorithm(String string) {
        this.setProperty("truststoreAlgorithm", Type.JSSE);
        this.truststoreAlgorithm = string;
    }

    public String getTruststoreAlgorithm() {
        return this.truststoreAlgorithm;
    }

    public void setTruststoreFile(String string) {
        this.setProperty("truststoreFile", Type.JSSE);
        this.truststoreFile = string;
    }

    public String getTruststoreFile() {
        return this.truststoreFile;
    }

    public void setTruststorePassword(String string) {
        this.setProperty("truststorePassword", Type.JSSE);
        this.truststorePassword = string;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststoreProvider(String string) {
        this.setProperty("truststoreProvider", Type.JSSE);
        this.truststoreProvider = string;
    }

    public String getTruststoreProvider() {
        if (this.truststoreProvider == null) {
            Set<SSLHostConfigCertificate> set = this.getCertificates();
            if (set.size() == 1) {
                return set.iterator().next().getCertificateKeystoreProvider();
            }
            return SSLHostConfigCertificate.DEFAULT_KEYSTORE_PROVIDER;
        }
        return this.truststoreProvider;
    }

    public void setTruststoreType(String string) {
        this.setProperty("truststoreType", Type.JSSE);
        this.truststoreType = string;
    }

    public String getTruststoreType() {
        if (this.truststoreType == null) {
            String string;
            Set<SSLHostConfigCertificate> set = this.getCertificates();
            if (set.size() == 1 && !"PKCS12".equalsIgnoreCase(string = set.iterator().next().getCertificateKeystoreType())) {
                return string;
            }
            return SSLHostConfigCertificate.DEFAULT_KEYSTORE_TYPE;
        }
        return this.truststoreType;
    }

    public void setTrustStore(KeyStore keyStore) {
        this.truststore = keyStore;
    }

    public KeyStore getTruststore() throws IOException {
        KeyStore keyStore = this.truststore;
        if (keyStore == null && this.truststoreFile != null) {
            try {
                keyStore = SSLUtilBase.getStore(this.getTruststoreType(), this.getTruststoreProvider(), this.getTruststoreFile(), this.getTruststorePassword());
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.getCause();
                if (throwable instanceof UnrecoverableKeyException) {
                    log.warn((Object)sm.getString("sslHostConfig.invalid_truststore_password"), throwable);
                    keyStore = SSLUtilBase.getStore(this.getTruststoreType(), this.getTruststoreProvider(), this.getTruststoreFile(), null);
                }
                throw iOException;
            }
        }
        return keyStore;
    }

    public void setCertificateRevocationListPath(String string) {
        this.setProperty("certificateRevocationListPath", Type.OPENSSL);
        this.certificateRevocationListPath = string;
    }

    public String getCertificateRevocationListPath() {
        return this.certificateRevocationListPath;
    }

    public void setCaCertificateFile(String string) {
        if (this.setProperty("caCertificateFile", Type.OPENSSL) && this.truststoreFile != null) {
            this.truststoreFile = null;
        }
        this.caCertificateFile = string;
    }

    public String getCaCertificateFile() {
        return this.caCertificateFile;
    }

    public void setCaCertificatePath(String string) {
        if (this.setProperty("caCertificatePath", Type.OPENSSL) && this.truststoreFile != null) {
            this.truststoreFile = null;
        }
        this.caCertificatePath = string;
    }

    public String getCaCertificatePath() {
        return this.caCertificatePath;
    }

    public void setDisableCompression(boolean bl) {
        this.setProperty("disableCompression", Type.OPENSSL);
        this.disableCompression = bl;
    }

    public boolean getDisableCompression() {
        return this.disableCompression;
    }

    public void setDisableSessionTickets(boolean bl) {
        this.setProperty("disableSessionTickets", Type.OPENSSL);
        this.disableSessionTickets = bl;
    }

    public boolean getDisableSessionTickets() {
        return this.disableSessionTickets;
    }

    public void setInsecureRenegotiation(boolean bl) {
        this.setProperty("insecureRenegotiation", Type.OPENSSL);
        this.insecureRenegotiation = bl;
    }

    public boolean getInsecureRenegotiation() {
        return this.insecureRenegotiation;
    }

    public static String adjustRelativePath(String string) throws FileNotFoundException {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = string;
        File file = new File((String)object);
        if (!file.isAbsolute()) {
            object = System.getProperty("catalina.base") + File.separator + (String)object;
            file = new File((String)object);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(sm.getString("sslHostConfig.fileNotFound", new Object[]{object}));
        }
        return object;
    }

    static {
        SSL_PROTO_ALL_SET.add("SSLv2Hello");
        SSL_PROTO_ALL_SET.add("TLSv1");
        SSL_PROTO_ALL_SET.add("TLSv1.1");
        SSL_PROTO_ALL_SET.add("TLSv1.2");
        SSL_PROTO_ALL_SET.add("TLSv1.3");
    }

    public static enum CertificateVerification {
        NONE(false),
        OPTIONAL_NO_CA(true),
        OPTIONAL(true),
        REQUIRED(false);

        private final boolean optional;

        private CertificateVerification(boolean bl) {
            this.optional = bl;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public static CertificateVerification fromString(String string) {
            if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "require".equalsIgnoreCase(string) || "required".equalsIgnoreCase(string)) {
                return REQUIRED;
            }
            if ("optional".equalsIgnoreCase(string) || "want".equalsIgnoreCase(string)) {
                return OPTIONAL;
            }
            if ("optionalNoCA".equalsIgnoreCase(string) || "optional_no_ca".equalsIgnoreCase(string)) {
                return OPTIONAL_NO_CA;
            }
            if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "none".equalsIgnoreCase(string)) {
                return NONE;
            }
            throw new IllegalArgumentException(sm.getString("sslHostConfig.certificateVerificationInvalid", new Object[]{string}));
        }
    }

    public static enum Type {
        JSSE,
        OPENSSL;

    }
}

