/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.http.MimeHeaders;

public class FormAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(FormAuthenticator.class);
    protected String characterEncoding = null;
    protected String landingPage = null;
    protected int authenticationSessionTimeout = 120;

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public void setLandingPage(String string) {
        this.landingPage = string;
    }

    public int getAuthenticationSessionTimeout() {
        return this.authenticationSessionTimeout;
    }

    public void setAuthenticationSessionTimeout(int n) {
        this.authenticationSessionTimeout = n;
    }

    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        String string;
        String string2;
        Session session = null;
        Principal principal = null;
        if (!this.cache) {
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Checking for reauthenticate in session " + session));
            }
            string2 = (String)session.getNote("org.apache.catalina.session.USERNAME");
            string = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (string2 != null && string != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reauthenticating username '" + string2 + "'"));
                }
                if ((principal = this.context.getRealm().authenticate(string2, string)) != null) {
                    this.register(request, httpServletResponse, principal, "FORM", string2, string);
                    if (!this.matchRequest(request)) {
                        return true;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Restore request from session '" + session.getIdInternal() + "'"));
            }
            if (this.restoreRequest(request, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Proceed to restored request");
                }
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Restore of original request failed");
            }
            httpServletResponse.sendError(400);
            return false;
        }
        if (this.checkForCachedAuthentication(request, httpServletResponse, true)) {
            return true;
        }
        string2 = request.getContextPath();
        string = request.getDecodedRequestURI();
        boolean bl = string.startsWith(string2) && string.endsWith("/j_security_check");
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (!bl) {
            if (request.getServletPath().length() == 0 && request.getPathInfo() == null) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append('/');
                if (request.getQueryString() != null) {
                    stringBuilder.append('?');
                    stringBuilder.append(request.getQueryString());
                }
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuilder.toString()));
                return false;
            }
            session = request.getSessionInternal(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Save request in session '" + session.getIdInternal() + "'"));
            }
            try {
                this.saveRequest(request, session);
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Request body too big to save during authentication");
                httpServletResponse.sendError(403, sm.getString("authenticator.requestBodyTooBig"));
                return false;
            }
            this.forwardToLoginPage(request, httpServletResponse, loginConfig);
            return false;
        }
        request.getResponse().sendAcknowledgement(ContinueResponseTiming.ALWAYS);
        Realm realm = this.context.getRealm();
        if (this.characterEncoding != null) {
            request.setCharacterEncoding(this.characterEncoding);
        }
        String string3 = request.getParameter("j_username");
        String string4 = request.getParameter("j_password");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authenticating username '" + string3 + "'"));
        }
        if ((principal = realm.authenticate(string3, string4)) == null) {
            this.forwardToErrorPage(request, httpServletResponse, loginConfig);
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication of '" + string3 + "' was successful"));
        }
        if (session == null) {
            session = request.getSessionInternal(false);
        }
        if (session != null && this.getChangeSessionIdOnAuthentication() && ((object = (String)session.getNote("org.apache.catalina.authenticator.SESSION_ID")) == null || !((String)object).equals(request.getRequestedSessionId()))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("formAuthenticator.sessionIdMismatch", new Object[]{session.getId(), object}));
            }
            session.expire();
            session = null;
        }
        if (session == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"User took so long to log on the session expired");
            }
            if (this.landingPage == null) {
                httpServletResponse.sendError(408, sm.getString("authenticator.sessionExpired"));
            } else {
                object = request.getContextPath() + this.landingPage;
                SavedRequest savedRequest = new SavedRequest();
                savedRequest.setMethod("GET");
                savedRequest.setRequestURI((String)object);
                savedRequest.setDecodedRequestURI((String)object);
                request.getSessionInternal(true).setNote("org.apache.catalina.authenticator.REQUEST", savedRequest);
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL((String)object));
            }
            return false;
        }
        this.register(request, httpServletResponse, principal, "FORM", string3, string4);
        string = this.savedRequestURL(session);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirecting to original '" + string + "'"));
        }
        if (string == null) {
            if (this.landingPage == null) {
                httpServletResponse.sendError(400, sm.getString("authenticator.formlogin"));
            } else {
                object = request.getContextPath() + this.landingPage;
                SavedRequest savedRequest = new SavedRequest();
                savedRequest.setMethod("GET");
                savedRequest.setRequestURI((String)object);
                savedRequest.setDecodedRequestURI((String)object);
                session.setNote("org.apache.catalina.authenticator.REQUEST", savedRequest);
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL((String)object));
            }
        } else {
            object = request.getResponse();
            String string5 = httpServletResponse.encodeRedirectURL(string);
            if ("HTTP/1.1".equals(request.getProtocol())) {
                ((Response)object).sendRedirect(string5, 303);
            } else {
                ((Response)object).sendRedirect(string5, 302);
            }
        }
        return false;
    }

    @Override
    protected boolean isContinuationRequired(Request request) {
        SavedRequest savedRequest;
        String string = this.context.getPath();
        String string2 = request.getDecodedRequestURI();
        if (string2.startsWith(string) && string2.endsWith("/j_security_check")) {
            return true;
        }
        Session session = request.getSessionInternal(false);
        return session != null && (savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST")) != null && string2.equals(savedRequest.getDecodedRequestURI());
    }

    @Override
    protected String getAuthMethod() {
        return "FORM";
    }

    @Override
    protected void register(Request request, HttpServletResponse httpServletResponse, Principal principal, String string, String string2, String string3, boolean bl, boolean bl2) {
        Session session;
        super.register(request, httpServletResponse, principal, string, string2, string3, bl, bl2);
        if (!bl2 && (session = request.getSessionInternal(false)) != null) {
            if (string2 != null) {
                session.setNote("org.apache.catalina.session.USERNAME", string2);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (string3 != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", string3);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardToLoginPage(Request request, HttpServletResponse httpServletResponse, LoginConfig loginConfig) throws IOException {
        String string;
        Object object;
        String string2;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("formAuthenticator.forwardLogin", new Object[]{request.getRequestURI(), request.getMethod(), loginConfig.getLoginPage(), this.context.getName()}));
        }
        if ((string2 = loginConfig.getLoginPage()) == null || string2.length() == 0) {
            String string3 = sm.getString("formAuthenticator.noLoginPage", new Object[]{this.context.getName()});
            this.log.warn((Object)string3);
            httpServletResponse.sendError(500, string3);
            return;
        }
        if (this.getChangeSessionIdOnAuthentication() && (object = request.getSessionInternal(false)) != null) {
            string = object.getId();
            String string4 = this.changeSessionID(request, (Session)object);
            object.setNote("org.apache.catalina.authenticator.SESSION_ID", string4);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("formAuthenticator.changeSessionIdLogin", new Object[]{string, string4}));
            }
        }
        object = request.getMethod();
        request.getCoyoteRequest().method().setString("GET");
        string = this.context.getServletContext().getRequestDispatcher(string2);
        try {
            if (this.context.fireRequestInitEvent((ServletRequest)request.getRequest())) {
                string.forward((ServletRequest)request.getRequest(), (ServletResponse)httpServletResponse);
                this.context.fireRequestDestroyEvent((ServletRequest)request.getRequest());
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            String string5 = sm.getString("formAuthenticator.forwardLoginFail");
            this.log.warn((Object)string5, throwable);
            request.setAttribute("jakarta.servlet.error.exception", throwable);
            httpServletResponse.sendError(500, string5);
        }
        finally {
            request.getCoyoteRequest().method().setString((String)object);
        }
    }

    protected void forwardToErrorPage(Request request, HttpServletResponse httpServletResponse, LoginConfig loginConfig) throws IOException {
        String string = loginConfig.getErrorPage();
        if (string == null || string.length() == 0) {
            String string2 = sm.getString("formAuthenticator.noErrorPage", new Object[]{this.context.getName()});
            this.log.warn((Object)string2);
            httpServletResponse.sendError(500, string2);
            return;
        }
        RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(loginConfig.getErrorPage());
        try {
            if (this.context.fireRequestInitEvent((ServletRequest)request.getRequest())) {
                requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)httpServletResponse);
                this.context.fireRequestDestroyEvent((ServletRequest)request.getRequest());
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            String string3 = sm.getString("formAuthenticator.forwardErrorFail");
            this.log.warn((Object)string3, throwable);
            request.setAttribute("jakarta.servlet.error.exception", throwable);
            httpServletResponse.sendError(500, string3);
        }
    }

    protected boolean matchRequest(Request request) {
        String string;
        Session session = request.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (savedRequest == null) {
            return false;
        }
        if (this.cache && session.getPrincipal() == null || !this.cache && request.getPrincipal() == null) {
            return false;
        }
        if (this.getChangeSessionIdOnAuthentication() && ((string = (String)session.getNote("org.apache.catalina.authenticator.SESSION_ID")) == null || !string.equals(request.getRequestedSessionId()))) {
            return false;
        }
        string = request.getDecodedRequestURI();
        if (string == null) {
            return false;
        }
        return string.equals(savedRequest.getDecodedRequestURI());
    }

    protected boolean restoreRequest(Request request, Session session) throws IOException {
        ByteChunk byteChunk;
        Object object;
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.SESSION_ID");
        if (savedRequest == null) {
            return false;
        }
        byte[] byArray = new byte[4096];
        ServletInputStream servletInputStream = request.createInputStream();
        while (servletInputStream.read(byArray) >= 0) {
        }
        request.clearCookies();
        Iterator<Cookie> iterator = savedRequest.getCookies();
        while (iterator.hasNext()) {
            request.addCookie(iterator.next());
        }
        String string = savedRequest.getMethod();
        MimeHeaders mimeHeaders = request.getCoyoteRequest().getMimeHeaders();
        mimeHeaders.recycle();
        boolean bl = "GET".equalsIgnoreCase(string) || "HEAD".equalsIgnoreCase(string);
        Iterator<String> iterator2 = savedRequest.getHeaderNames();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if ("If-Modified-Since".equalsIgnoreCase((String)object) || bl && "If-None-Match".equalsIgnoreCase((String)object)) continue;
            byteChunk = savedRequest.getHeaderValues((String)object);
            while (byteChunk.hasNext()) {
                mimeHeaders.addValue((String)object).setString((String)byteChunk.next());
            }
        }
        request.clearLocales();
        object = savedRequest.getLocales();
        while (object.hasNext()) {
            request.addLocale((Locale)object.next());
        }
        request.getCoyoteRequest().getParameters().recycle();
        byteChunk = savedRequest.getBody();
        if (byteChunk != null) {
            request.getCoyoteRequest().action(ActionCode.REQ_SET_BODY_REPLAY, (Object)byteChunk);
            MessageBytes messageBytes = MessageBytes.newInstance();
            String string2 = savedRequest.getContentType();
            if (string2 == null && "POST".equalsIgnoreCase(string)) {
                string2 = "application/x-www-form-urlencoded";
            }
            messageBytes.setString(string2);
            request.getCoyoteRequest().setContentType(messageBytes);
        }
        request.getCoyoteRequest().method().setString(string);
        request.getRequestURI();
        request.getQueryString();
        request.getProtocol();
        if (savedRequest.getOriginalMaxInactiveInterval() > 0) {
            session.setMaxInactiveInterval(savedRequest.getOriginalMaxInactiveInterval());
        }
        return true;
    }

    protected void saveRequest(Request request, Session session) throws IOException {
        int n;
        SavedRequest savedRequest = new SavedRequest();
        Cookie[] cookieArray = request.getCookies();
        if (cookieArray != null) {
            for (Cookie object2 : cookieArray) {
                savedRequest.addCookie(object2);
            }
        }
        Enumeration<String> enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration<String> enumeration2 = request.getHeaders(string);
            while (enumeration2.hasMoreElements()) {
                String string2 = enumeration2.nextElement();
                savedRequest.addHeader(string, string2);
            }
        }
        Enumeration<Locale> enumeration3 = request.getLocales();
        while (enumeration3.hasMoreElements()) {
            Locale locale = enumeration3.nextElement();
            savedRequest.addLocale(locale);
        }
        request.getResponse().sendAcknowledgement(ContinueResponseTiming.ALWAYS);
        int n2 = request.getConnector().getMaxSavePostSize();
        if (n2 != 0) {
            int n3;
            ByteChunk byteChunk = new ByteChunk();
            byteChunk.setLimit(n2);
            byte[] byArray = new byte[4096];
            ServletInputStream servletInputStream = request.getInputStream();
            while ((n3 = servletInputStream.read(byArray)) >= 0) {
                byteChunk.append(byArray, 0, n3);
            }
            if (byteChunk.getLength() > 0) {
                savedRequest.setContentType(request.getContentType());
                savedRequest.setBody(byteChunk);
            }
        }
        savedRequest.setMethod(request.getMethod());
        savedRequest.setQueryString(request.getQueryString());
        savedRequest.setRequestURI(request.getRequestURI());
        savedRequest.setDecodedRequestURI(request.getDecodedRequestURI());
        if (session instanceof HttpSession && ((HttpSession)session).isNew() && (n = session.getMaxInactiveInterval()) > this.getAuthenticationSessionTimeout()) {
            savedRequest.setOriginalMaxInactiveInterval(n);
            session.setMaxInactiveInterval(this.getAuthenticationSessionTimeout());
        }
        session.setNote("org.apache.catalina.authenticator.REQUEST", savedRequest);
    }

    protected String savedRequestURL(Session session) {
        SavedRequest savedRequest = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (savedRequest == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(savedRequest.getRequestURI());
        if (savedRequest.getQueryString() != null) {
            stringBuilder.append('?');
            stringBuilder.append(savedRequest.getQueryString());
        }
        return stringBuilder.toString();
    }
}

