/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimePartDataSource;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SendMailFactory
implements ObjectFactory {
    protected static final String DataSourceClassName = "jakarta.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Reference reference = (Reference)object;
        if (reference.getClassName().equals(DataSourceClassName)) {
            return AccessController.doPrivileged(() -> {
                RefAddr refAddr;
                Properties properties = new Properties();
                Enumeration<RefAddr> enumeration = reference.getAll();
                properties.put("mail.transport.protocol", "smtp");
                while (enumeration.hasMoreElements()) {
                    RefAddr refAddr2 = enumeration.nextElement();
                    properties.put(refAddr2.getType(), refAddr2.getContent());
                }
                MimeMessage mimeMessage = new MimeMessage(Session.getInstance((Properties)properties));
                try {
                    refAddr = reference.get("mail.from");
                    String string = null;
                    if (refAddr != null) {
                        string = (String)reference.get("mail.from").getContent();
                    }
                    if (string != null) {
                        mimeMessage.setFrom(new InternetAddress(string));
                    }
                    mimeMessage.setSubject("");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                refAddr = new MimePartDataSource((MimePart)mimeMessage);
                return refAddr;
            });
        }
        return null;
    }
}

