/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericStackFrame;
import org.graalvm.visualvm.jfr.model.JFRStackFrame;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;

final class JFRGenericStackTrace
extends JFRStackTrace {
    private final IMCStackTrace stackTrace;

    JFRGenericStackTrace(IMCStackTrace stackTrace) {
        this.stackTrace = stackTrace;
    }

    public List<JFRStackFrame> getFrames() {
        List<? extends IMCFrame> imcFrames = this.stackTrace.getFrames();
        ArrayList<JFRStackFrame> frames = new ArrayList<JFRStackFrame>(imcFrames.size());
        for (IMCFrame iMCFrame : imcFrames) {
            frames.add(new JFRGenericStackFrame(iMCFrame));
        }
        return frames;
    }

    public boolean isTruncated() {
        return this.stackTrace.getTruncationState().isTruncated();
    }

    public int hashCode() {
        return this.stackTrace.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRGenericStackTrace ? this.stackTrace.equals(((JFRGenericStackTrace)((Object)o)).stackTrace) : false;
    }
}

