/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.exceptions;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsNode;
import org.graalvm.visualvm.jfr.views.exceptions.ExceptionsViewSupport;
import org.graalvm.visualvm.jfr.views.exceptions.JFRSnapshotExceptionsViewProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotExceptionsView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/exception.png";
    private DataViewComponent dvc;
    private ExceptionsViewSupport.MasterViewSupport masterView;
    private ExceptionsViewSupport.DataViewSupport dataView;

    JFRSnapshotExceptionsView(JFRSnapshot jfrSnapshot) {
        super(jfrSnapshot, "Exceptions", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 50);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        this.masterView = new ExceptionsViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                this.changeAggregation(0, ExceptionsViewSupport.Aggregation.CLASS, ExceptionsViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(int mode, ExceptionsViewSupport.Aggregation primary, ExceptionsViewSupport.Aggregation secondary) {
                JFRSnapshotExceptionsView.this.setAggregation(mode, primary, secondary);
            }
        };
        boolean hasEvents = model != null && model.containsEvent(JFRSnapshotExceptionsViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new ExceptionsViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final int mode, final ExceptionsViewSupport.Aggregation primary, final ExceptionsViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new ExceptionsNode.Root(), false);
        new RequestProcessor("JFR Exceptions Initializer").post(new Runnable(){

            @Override
            public void run() {
                final ExceptionsNode.Root root = new ExceptionsNode.Root(mode, primary, secondary);
                JFRSnapshotExceptionsView.this.getModel().visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (root.getNChildren() == 0) {
                            root.addChild(ExceptionsNode.Label.createNoData(root));
                        }
                        JFRSnapshotExceptionsView.this.dataView.setData(root, !ExceptionsViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotExceptionsView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

