/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.repository;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.single.shard.TransportSingleShardAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.IndicesService;
import org.opensearch.replication.action.repository.GetFileChunkRequest;
import org.opensearch.replication.action.repository.GetFileChunkResponse;
import org.opensearch.replication.action.repository.RemoteClusterRepositoryRequest;
import org.opensearch.replication.repository.RemoteClusterRestoreLeaderService;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportActionProxy;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0014J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J*\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u0017\u001a\u00120\u001fR\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/replication/action/repository/TransportGetFileChunkAction;", "Lorg/opensearch/action/support/single/shard/TransportSingleShardAction;", "Lorg/opensearch/replication/action/repository/GetFileChunkRequest;", "Lorg/opensearch/replication/action/repository/GetFileChunkResponse;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "restoreLeaderService", "Lorg/opensearch/replication/repository/RemoteClusterRestoreLeaderService;", "(Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/indices/IndicesService;Lorg/opensearch/replication/repository/RemoteClusterRestoreLeaderService;)V", "getResponseReader", "Lorg/opensearch/common/io/stream/Writeable$Reader;", "resolveIndex", "", "request", "shardOperation", "shardId", "Lorg/opensearch/index/shard/ShardId;", "shards", "Lorg/opensearch/cluster/routing/ShardsIterator;", "state", "Lorg/opensearch/cluster/ClusterState;", "Lorg/opensearch/action/support/single/shard/TransportSingleShardAction$InternalRequest;", "Companion", "opensearch-cross-cluster-replication"})
public final class TransportGetFileChunkAction
extends TransportSingleShardAction<GetFileChunkRequest, GetFileChunkResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final RemoteClusterRestoreLeaderService restoreLeaderService;
    private static final Logger log = LogManager.getLogger(TransportGetFileChunkAction.class);

    @Inject
    public TransportGetFileChunkAction(@NotNull ThreadPool threadPool, @NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull IndicesService indicesService, @NotNull RemoteClusterRestoreLeaderService restoreLeaderService) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)((Object)restoreLeaderService), (String)"restoreLeaderService");
        super("indices:data/read/plugins/replication/file_chunk", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFileChunkRequest::new, "get");
        this.indicesService = indicesService;
        this.restoreLeaderService = restoreLeaderService;
        TransportActionProxy.registerProxyAction((TransportService)transportService, (String)"indices:data/read/plugins/replication/file_chunk", GetFileChunkResponse::new);
    }

    @NotNull
    protected GetFileChunkResponse shardOperation(@NotNull GetFileChunkRequest request, @NotNull ShardId shardId) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        log.debug(request.toString());
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.getId());
        Store store = indexShard.store();
        byte[] buffer = new byte[request.getLength()];
        Ref.IntRef bytesRead = new Ref.IntRef();
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        ExtensionsKt.performOp$default(store, (Function0)new Function0<Unit>(request, this, bytesRead, buffer){
            final /* synthetic */ GetFileChunkRequest $request;
            final /* synthetic */ TransportGetFileChunkAction this$0;
            final /* synthetic */ Ref.IntRef $bytesRead;
            final /* synthetic */ byte[] $buffer;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$bytesRead = $bytesRead;
                this.$buffer = $buffer;
                super(0);
            }

            public final void invoke() {
                StoreFileMetadata fileMetaData = this.$request.getStoreFileMetadata();
                RemoteClusterRestoreLeaderService remoteClusterRestoreLeaderService = TransportGetFileChunkAction.access$getRestoreLeaderService$p(this.this$0);
                String string = this.$request.getRestoreUUID();
                RemoteClusterRepositoryRequest remoteClusterRepositoryRequest = this.$request;
                String string2 = fileMetaData.name();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileMetaData.name()");
                InputStreamIndexInput currentInput = remoteClusterRestoreLeaderService.openInputStream(string, remoteClusterRepositoryRequest, string2, fileMetaData.length());
                long offset = this.$request.getOffset();
                if (offset < fileMetaData.length()) {
                    currentInput.skip(offset);
                    this.$bytesRead.element = currentInput.read(this.$buffer);
                }
            }
        }, null, 2, null);
        return new GetFileChunkResponse(request.getStoreFileMetadata(), request.getOffset(), (BytesReference)new BytesArray(buffer, 0, bytesRead.element));
    }

    protected boolean resolveIndex(@NotNull GetFileChunkRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return true;
    }

    @NotNull
    protected Writeable.Reader<GetFileChunkResponse> getResponseReader() {
        return TransportGetFileChunkAction::getResponseReader$lambda-0;
    }

    @Nullable
    protected ShardsIterator shards(@NotNull ClusterState state, @NotNull TransportSingleShardAction.InternalRequest request) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (ShardsIterator)state.routingTable().shardRoutingTable(((GetFileChunkRequest)request.request()).getLeaderShardId()).primaryShardIt();
    }

    private static final GetFileChunkResponse getResponseReader$lambda-0(StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        return new GetFileChunkResponse(inp);
    }

    public static final /* synthetic */ RemoteClusterRestoreLeaderService access$getRestoreLeaderService$p(TransportGetFileChunkAction $this) {
        return $this.restoreLeaderService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/replication/action/repository/TransportGetFileChunkAction$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

