/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.type;

import java.util.Arrays;
import java.util.List;
import org.opensearch.sql.data.type.ExprCoreType;

public interface ExprType {
    default public boolean isCompatible(ExprType other) {
        if (this.equals(other)) {
            return true;
        }
        if (other.equals(ExprCoreType.UNKNOWN)) {
            return false;
        }
        for (ExprType parentTypeOfOther : other.getParent()) {
            if (!this.isCompatible(parentTypeOfOther)) continue;
            return true;
        }
        return false;
    }

    default public boolean shouldCast(ExprType other) {
        return !this.equals(other);
    }

    default public List<ExprType> getParent() {
        return Arrays.asList(ExprCoreType.UNKNOWN);
    }

    public String typeName();

    default public String legacyTypeName() {
        return this.typeName();
    }
}

