from typing import Union, Optional, Dict

from github.Installation import Installation
from github.InstallationAuthorization import InstallationAuthorization
from github.PaginatedList import PaginatedList
from github.Requester import Requester

class GithubIntegration:
    integration_id: Union[int, str] = ...
    private_key: str = ...
    base_url: str = ...
    jwt_expiry: int = ...
    jwt_issued_at: int = ...
    __requester: Requester = ...
    def __init__(
        self,
        integration_id: Union[int, str],
        private_key: str,
        base_url: str = ...,
        jwt_expiry: int = ...,
        jwt_issued_at: int = ...,
    ) -> None: ...
    def _get_installed_app(self, url: str) -> Installation: ...
    def _get_headers(self) -> Dict[str, str]: ...
    def create_jwt(self, expiration: Optional[int] = ...) -> str: ...
    def get_access_token(
        self, installation_id: int, permissions: Optional[Dict[str, str]] = ...
    ) -> InstallationAuthorization: ...
    def get_app_installation(self, installation_id: int) -> Installation: ...
    def get_installation(self, owner: str, repo: str) -> Installation: ...
    def get_installations(self) -> PaginatedList[Installation]: ...
    def get_org_installation(self, org: str) -> Installation: ...
    def get_repo_installation(self, owner: str, repo: str) -> Installation: ...
    def get_user_installation(self, username: str) -> Installation: ...
