#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_security_zones
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: junos_security_zones
version_added: 2.9.0
short_description: Manage security zones on Juniper JUNOS devices
description: This module provides declarative management of security zones on Juniper JUNOS devices
author: Pranav Bhatt (@pranav-bhatt)
requirements:
  - ncclient (>=v0.6.4)
  - xmltodict (>=0.12.0)
notes:
- This module requires the netconf system service be enabled on the device being managed.
- This module works with connection C(netconf).
- See L(the Junos OS Platform Options,https://docs.ansible.com/ansible/latest/network/user_guide/platform_junos.html).
- Tested against JunOS v18.4R1
options:
  config:
    description: Dictionary of security zone parameters
    type: dict
    suboptions:
      functional_zone_management:
        description:
          - Functional zone to configure host for out of band management interfaces
        type: dict
        suboptions:
          description:
            description:
              - Text description of zone
            type: str
          host_inbound_traffic: &host_inbound_traffic
            description:
              - Allowed system services & protocols
            type: dict
            suboptions:
              protocols:
                description:
                  - Protocol type of incoming traffic to accept
                type: list
                elements: dict
                suboptions:
                  name:
                    description:
                      - Type of incoming protocol to accept
                    type: str
                  except:
                    description:
                      - Disallow the specified protocol traffic
                    type: bool
              system_services:
                description:
                  - Type of incoming system-service traffic to accept
                type: list
                elements: dict
                suboptions:
                  name:
                    description:
                      - Type of incoming system-service traffic to accept
                    type: str
                  except:
                    description:
                      - Disallow the specified incoming system-service traffic
                    type: bool
          interfaces: &interfaces
            description:
              - Interfaces that are part of this zone
            type: list
            elements: str
          screen: &screen
            description:
              - Name of ids option object applied to the zone
            type: str
      zones:
        description:
          - Security zones
        type: list
        elements: dict
        suboptions:
          name:
            description:
              - Name of the security zone
            type: str
          address_book:
            description:
              - Address book entries
            type: dict
            suboptions:
              addresses:
                description:
                  - Define security addresses
                type: list
                elements: dict
                suboptions:
                  name:
                    description:
                      - Name of address
                    type: str
                  ip_prefix:
                    description:
                      - Numeric IPv4 or IPv6 address with prefix
                    type: str
                  description:
                    description:
                      - Text description of address
                    type: str
                  dns_name:
                    description:
                      - DNS address name
                    type: dict
                    suboptions:
                      name:
                        description:
                          - Fully qualified hostname
                        type: str
                      ipv4_only:
                        description:
                          - IPv4 dns address
                        type: bool
                      ipv6_only:
                        description:
                          - IPv6 dns address
                        type: bool
                  range_address:
                    description:
                      - Address range
                    type: dict
                    suboptions:
                      from:
                        description:
                          - Start of address range
                        type: str
                      to:
                        description:
                          - End of address range
                        type: str
                  wildcard_address:
                    description:
                      - Numeric IPv4 wildcard address with in the form of a.d.d.r/netmask
                    type: str
              address_sets:
                description:
                  - Define security address sets
                type: list
                elements: dict
                suboptions:
                  name:
                    description:
                      - Name of address set
                    type: str
                  addresses:
                    description:
                      - Addresses to be included in this set
                    type: list
                    elements: str
                  address_sets:
                    description:
                      - Define an address-set name
                    type: list
                    elements: str
                  description:
                    description:
                      - Text description of address set
                    type: str
          advance_policy_based_routing_profile:
            description:
              - Enable Advance Policy Based Routing on this zone
            type: str
          advanced_connection_tracking:
            description:
              - Enable Advance Policy Based Routing on this zone
            type: dict
            suboptions:
              mode:
                description:
                  - Set connection tracking mode
                type: str
                choices:
                  - allow-any-host
                  - allow-target-host
                  - allow-target-host-port
              timeout:
                description:
                  - Timeout value in seconds for advanced-connection-tracking table for this zone
                type: int
              track_all_policies_to_this_zone:
                description:
                  - Mandate all policies with to-zone set to this zone to do connection track table lookup
                type: bool
          application_tracking:
            description:
              - Enable Application tracking support for this zone
            type: bool
          description:
            description:
              - Text description of zone
            type: str
          enable_reverse_reroute:
            description:
              - Enable Reverse route lookup when there is change in ingress interface
            type: bool
          host_inbound_traffic: *host_inbound_traffic
          interfaces: *interfaces
          screen: *screen
          source_identity_log:
            description:
              - Show user and group info in session log for this zone
            type: bool
          tcp_rst:
            description:
              - Send RST for NON-SYN packet not matching TCP session
            type: bool
          unidirectional_session_refreshing:
            description:
              - Enable unidirectional session refreshing on this zone
            type: bool

  running_config:
    description:
      - This option is used only with state I(parsed).
      - The value of this option should be the output received from the JunOS device
        by executing the command B(show security policies).
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into Ansible structured data as per the resource module's argspec
        and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - rendered
    - gathered
    - parsed
    default: merged
    description:
      - The state the configuration should be left in
      - The states I(rendered), I(gathered) and I(parsed) does not perform any change
        on the device.
      - The state I(rendered) will transform the configuration in C(config) option to
        platform specific CLI commands which will be returned in the I(rendered) key
        within the result. For state I(rendered) active connection to remote host is
        not required.
        behaviour for this module.
      - The state I(gathered) will fetch the running configuration from device and transform
        it into structured data in the format as per the resource module argspec and
        the value is returned in the I(gathered) key within the result.
      - The state I(parsed) reads the configuration from C(running_config) option and
        transforms it into JSON format as per the resource module parameters and the
        value is returned in the I(parsed) key within the result. The value of C(running_config)
        option should be the same format as the output of command
        I(show security policies detail) executed on device. For state I(parsed) active
        connection to remote host is not required.
    type: str
"""
EXAMPLES = """# Using merged
#
# Before state
# ------------
#
# vagrant@vsrx# show security zones
#
# [edit]
# vagrant@vsrx# show security zones
#
- name: Merge the provided configuration with the exisiting running configuration
  junipernetworks.junos.junos_security_zones: &merged
    config:
      functional_zone_management:
        description: test description
        host_inbound_traffic:
          protocols:
          - name: all
          - name: bgp
            except: true
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
          - ge-0/0/1.0
          - ge-0/0/2.0
        screen: test_screen
      security_zones:
      - address_book:
          address_sets:
          - addresses:
            - test_adr1
            - test_adr2
            name: test_adrset1
          - addresses:
            - test_adr3
            - test_adr4
            name: test_adrset2
          - address_sets:
            - test_adrset1
            - test_adrset2
            addresses:
            - test_adr5
            description: test description
            name: test_adrset3
          addresses:
          - description: test desc
            ip_prefix: 10.0.0.0/24
            name: test_adr1
          - dns_name:
              ipv6_only: true
              name: 1.1.1.1
            name: test_adr2
          - name: test_adr3
            range_address:
              from: 10.2.0.1
              to: 10.2.0.2
          - name: test_adr4
            wildcard_address: 10.3.0.1/24
          - description: test desc
            ip_prefix: 10.1.0.0/24
            name: test_adr5
        advance_policy_based_routing_profile: test_profile
        application_tracking: true
        description: test description
        enable_reverse_reroute: true
        host_inbound_traffic:
          protocols:
          - name: all
          - except: true
            name: bgp
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
        - ge-0/0/3.0
        - ge-0/0/4.0
        name: test_sec_zone1
        screen: test_screen
        source_identity_log: true
        tcp_rst: true
    state: merged
#
# -------------------------
# Module Execution Result
# -------------------------
#   "after": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     },
#     "security_zones": [
#         {
#             "address_book": {
#                 "address_sets": [
#                     {
#                         "addresses": [
#                             "test_adr1",
#                             "test_adr2"
#                         ],
#                         "name": "test_adrset1"
#                     },
#                     {
#                         "addresses": [
#                             "test_adr3",
#                             "test_adr4"
#                         ],
#                         "name": "test_adrset2"
#                     },
#                     {
#                         "address_sets": [
#                             "test_adrset1",
#                             "test_adrset2"
#                         ],
#                         "addresses": [
#                             "test_adr5"
#                         ],
#                         "description": "test description",
#                         "name": "test_adrset3"
#                     }
#                 ],
#                 "addresses": [
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.0.0.0/24",
#                         "name": "test_adr1"
#                     },
#                     {
#                         "dns_name": {
#                             "ipv6_only": true,
#                             "name": "1.1.1.1"
#                         },
#                         "name": "test_adr2"
#                     },
#                     {
#                         "name": "test_adr3",
#                         "range_address": {
#                             "from": "10.2.0.1",
#                             "to": "10.2.0.2"
#                         }
#                     },
#                     {
#                         "name": "test_adr4",
#                         "wildcard_address": "10.3.0.1/24"
#                     },
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.1.0.0/24",
#                         "name": "test_adr5"
#                     }
#                 ]
#             },
#             "advance_policy_based_routing_profile": "test_profile",
#             "application_tracking": true,
#             "description": "test description",
#             "enable_reverse_reroute": true,
#             "host_inbound_traffic": {
#                 "protocols": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "bgp"
#                     }
#                 ],
#                 "system_services": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "dhcp"
#                     }
#                 ]
#             },
#             "interfaces": [
#                 "ge-0/0/3.0",
#                 "ge-0/0/4.0"
#             ],
#             "name": "test_sec_zone1",
#             "screen": "test_screen",
#             "source_identity_log": true,
#             "tcp_rst": true
#         }
#     ]
# },
# "before": {},
# "changed": true,
# "commands":
# '<nc:security xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><nc:zones><nc:functional-zone><nc:management><nc:description>t'
# 'est description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:na'
# 'me>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><n'
# 'c:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/1.0</nc:name></nc'
# ':interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></nc:management></nc:f'
# 'unctional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test_adr1</nc:name><nc:i'
# 'p-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:name>test_adr2</nc:nam'
# 'e><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test_adr3</nc:name><nc:r'
# 'ange-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-address></nc:address><n'
# 'c:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-address></nc:address><nc:'
# 'address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:addre'
# 'ss><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:address><nc:name>test'
# '_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:name>test_adr3</nc:n'
# 'ame></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset3</nc'
# ':name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></nc:address-set><nc:a'
# 'ddress-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description></nc:address-set></n'
# 'c:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-policy-based-routing-p'
# 'rofile><nc:application-tracking/><nc:description>test description</nc:description><nc:enable-reverse-reroute/><nc:host-inbound-t'
# 'raffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></nc:protocols><nc:sys'
# 'tem-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</nc:name><nc:except/></nc:system-servi'
# 'ces></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/4.0</nc'
# ':name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst/></nc:security-zone></nc:zones></nc'
# ':security>'

# After state
# -----------
#
# vagrant@vsrx# show system ntp
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
# security-zone test_sec_zone1 {
#     description "test description";
#     tcp-rst;
#     address-book {
#         address test_adr1 {
#             description "test desc";
#             10.0.0.0/24;
#         }
#         address test_adr2 {
#             dns-name 1.1.1.1 {
#                 ipv6-only;
#             }
#         }
#         address test_adr3 {
#             range-address 10.2.0.1 {
#                 to {
#                     10.2.0.2;
#                 }
#             }
#         }
#         address test_adr4 {
#             wildcard-address 10.3.0.1/24;
#         }
#         address test_adr5 {
#             description "test desc";
#             10.1.0.0/24;
#         }
#         address-set test_adrset1 {
#             address test_adr1;
#             address test_adr2;
#         }
#         address-set test_adrset2 {
#             address test_adr3;
#             address test_adr4;
#         }
#         address-set test_adrset3 {
#             description "test description";
#             address test_adr5;
#             address-set test_adrset1;
#             address-set test_adrset2;
#         }
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     interfaces {
#         ge-0/0/3.0;
#         ge-0/0/4.0;
#     }
#     application-tracking;
#     source-identity-log;
#     advance-policy-based-routing-profile {
#         test_profile;
#     }
#     enable-reverse-reroute;
# }
#
#
# Using Replaced
# Before state
# ------------
#
# vagrant@vsrx# show security zones
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
# security-zone test_sec_zone1 {
#     description "test description";
#     tcp-rst;
#     address-book {
#         address test_adr1 {
#             description "test desc";
#             10.0.0.0/24;
#         }
#         address test_adr2 {
#             dns-name 1.1.1.1 {
#                 ipv6-only;
#             }
#         }
#         address test_adr3 {
#             range-address 10.2.0.1 {
#                 to {
#                     10.2.0.2;
#                 }
#             }
#         }
#         address test_adr4 {
#             wildcard-address 10.3.0.1/24;
#         }
#         address test_adr5 {
#             description "test desc";
#             10.1.0.0/24;
#         }
#         address-set test_adrset1 {
#             address test_adr1;
#             address test_adr2;
#         }
#         address-set test_adrset2 {
#             address test_adr3;
#             address test_adr4;
#         }
#         address-set test_adrset3 {
#             description "test description";
#             address test_adr5;
#             address-set test_adrset1;
#             address-set test_adrset2;
#         }
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     interfaces {
#         ge-0/0/3.0;
#         ge-0/0/4.0;
#     }
#     application-tracking;
#     source-identity-log;
#     advance-policy-based-routing-profile {
#         test_profile;
#     }
#     enable-reverse-reroute;
# }
#
#

- name: Replaced running security zones configuration with provided configuration
  junipernetworks.junos.junos_security_zones:
    config:
      functional_zone_management:
        description: test description
        host_inbound_traffic:
          protocols:
          - name: all
          - name: bgp
            except: true
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
          - ge-0/0/1.0
          - ge-0/0/2.0
        screen: test_screen
    state: replaced
#
# -------------------------
# Module Execution Result
# -------------------------
# "after": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     }
# },
# "before": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     },
#     "security_zones": [
#         {
#             "address_book": {
#                 "address_sets": [
#                     {
#                         "addresses": [
#                             "test_adr1",
#                             "test_adr2"
#                         ],
#                         "name": "test_adrset1"
#                     },
#                     {
#                         "addresses": [
#                             "test_adr3",
#                             "test_adr4"
#                         ],
#                         "name": "test_adrset2"
#                     },
#                     {
#                         "address_sets": [
#                             "test_adrset1",
#                             "test_adrset2"
#                         ],
#                         "addresses": [
#                             "test_adr5"
#                         ],
#                         "description": "test description",
#                         "name": "test_adrset3"
#                     }
#                 ],
#                 "addresses": [
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.0.0.0/24",
#                         "name": "test_adr1"
#                     },
#                     {
#                         "dns_name": {
#                             "ipv6_only": true,
#                             "name": "1.1.1.1"
#                         },
#                         "name": "test_adr2"
#                     },
#                     {
#                         "name": "test_adr3",
#                         "range_address": {
#                             "from": "10.2.0.1",
#                             "to": "10.2.0.2"
#                         }
#                     },
#                     {
#                         "name": "test_adr4",
#                         "wildcard_address": "10.3.0.1/24"
#                     },
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.1.0.0/24",
#                         "name": "test_adr5"
#                     }
#                 ]
#             },
#             "advance_policy_based_routing_profile": "test_profile",
#             "application_tracking": true,
#             "description": "test description",
#             "enable_reverse_reroute": true,
#             "host_inbound_traffic": {
#                 "protocols": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "bgp"
#                     }
#                 ],
#                 "system_services": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "dhcp"
#                     }
#                 ]
#             },
#             "interfaces": [
#                 "ge-0/0/3.0",
#                 "ge-0/0/4.0"
#             ],
#             "name": "test_sec_zone1",
#             "screen": "test_screen",
#             "source_identity_log": true,
#             "tcp_rst": true
#         }
#     ]
# },
# "changed": true,
# "commands":
# '<nc:security xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><nc:zones delete=\"delete\"/><nc:zones><nc:functional-zone><nc'
# ':management><nc:description>test description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:p'
# 'rotocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-se'
# 'rvices><nc:system-services><nc:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:'
# 'name>ge-0/0/1.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:'
# 'screen></nc:management></nc:functional-zone></nc:zones></nc:security>'
#
#
# After state
# -----------
#
# vagrant@vsrx# show system ntp
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
#
#
# Using overridden
#
# Before state
# ------------
#
# vagrant@vsrx# show security zones
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
# security-zone test_sec_zone1 {
#     description "test description";
#     tcp-rst;
#     address-book {
#         address test_adr1 {
#             description "test desc";
#             10.0.0.0/24;
#         }
#         address test_adr2 {
#             dns-name 1.1.1.1 {
#                 ipv6-only;
#             }
#         }
#         address test_adr3 {
#             range-address 10.2.0.1 {
#                 to {
#                     10.2.0.2;
#                 }
#             }
#         }
#         address test_adr4 {
#             wildcard-address 10.3.0.1/24;
#         }
#         address test_adr5 {
#             description "test desc";
#             10.1.0.0/24;
#         }
#         address-set test_adrset1 {
#             address test_adr1;
#             address test_adr2;
#         }
#         address-set test_adrset2 {
#             address test_adr3;
#             address test_adr4;
#         }
#         address-set test_adrset3 {
#             description "test description";
#             address test_adr5;
#             address-set test_adrset1;
#             address-set test_adrset2;
#         }
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     interfaces {
#         ge-0/0/3.0;
#         ge-0/0/4.0;
#     }
#     application-tracking;
#     source-identity-log;
#     advance-policy-based-routing-profile {
#         test_profile;
#     }
#     enable-reverse-reroute;
# }
#
#

- name: Override running security zones configuration with provided configuration
  junipernetworks.junos.junos_security_zones:
    config:
      functional_zone_management:
        description: test description
        host_inbound_traffic:
          protocols:
          - name: all
          - name: bgp
            except: true
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
          - ge-0/0/1.0
          - ge-0/0/2.0
        screen: test_screen
    state: overridden
#
# -------------------------
# Module Execution Result
# -------------------------
# "after": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     }
# },
# "before": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     },
#     "security_zones": [
#         {
#             "address_book": {
#                 "address_sets": [
#                     {
#                         "addresses": [
#                             "test_adr1",
#                             "test_adr2"
#                         ],
#                         "name": "test_adrset1"
#                     },
#                     {
#                         "addresses": [
#                             "test_adr3",
#                             "test_adr4"
#                         ],
#                         "name": "test_adrset2"
#                     },
#                     {
#                         "address_sets": [
#                             "test_adrset1",
#                             "test_adrset2"
#                         ],
#                         "addresses": [
#                             "test_adr5"
#                         ],
#                         "description": "test description",
#                         "name": "test_adrset3"
#                     }
#                 ],
#                 "addresses": [
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.0.0.0/24",
#                         "name": "test_adr1"
#                     },
#                     {
#                         "dns_name": {
#                             "ipv6_only": true,
#                             "name": "1.1.1.1"
#                         },
#                         "name": "test_adr2"
#                     },
#                     {
#                         "name": "test_adr3",
#                         "range_address": {
#                             "from": "10.2.0.1",
#                             "to": "10.2.0.2"
#                         }
#                     },
#                     {
#                         "name": "test_adr4",
#                         "wildcard_address": "10.3.0.1/24"
#                     },
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.1.0.0/24",
#                         "name": "test_adr5"
#                     }
#                 ]
#             },
#             "advance_policy_based_routing_profile": "test_profile",
#             "application_tracking": true,
#             "description": "test description",
#             "enable_reverse_reroute": true,
#             "host_inbound_traffic": {
#                 "protocols": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "bgp"
#                     }
#                 ],
#                 "system_services": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "dhcp"
#                     }
#                 ]
#             },
#             "interfaces": [
#                 "ge-0/0/3.0",
#                 "ge-0/0/4.0"
#             ],
#             "name": "test_sec_zone1",
#             "screen": "test_screen",
#             "source_identity_log": true,
#             "tcp_rst": true
#         }
#     ]
# },
# "changed": true,
# "commands":
# '<nc:security xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><nc:zones delete=\"delete\"/><nc:zones><nc:functional-zone><nc'
# ':management><nc:description>test description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:p'
# 'rotocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-se'
# 'rvices><nc:system-services><nc:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:'
# 'name>ge-0/0/1.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:'
# 'screen></nc:management></nc:functional-zone></nc:zones></nc:security>'
#
#
# After state
# -----------
#
# vagrant@vsrx# show system ntp
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
#
#
# Using deleted
#
# Before state
# ------------
#
# vagrant@vsrx# show security zones
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
#
#
- name: Delete running security zones configuration
  junipernetworks.junos.junos_security_zones:
    config:
    state: deleted
#
# -------------------------
# Module Execution Result
# -------------------------
#     "after": {},
#     "before": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     }
# },
# "changed": true,
# "commands":
#   "<nc:security xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\">"
#   "<nc:zones delete=\"delete\"/></nc:security>"
#
#
# After state
# -----------
#
# vagrant@vsrx# show security zones
#
# [edit]
# Using gathered
#
# Before state
# ------------
#
# vagrant@vsrx# show system ntp
# functional-zone management {
#     interfaces {
#         ge-0/0/1.0;
#         ge-0/0/2.0;
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     description "test description";
# }
# security-zone test_sec_zone1 {
#     description "test description";
#     tcp-rst;
#     address-book {
#         address test_adr1 {
#             description "test desc";
#             10.0.0.0/24;
#         }
#         address test_adr2 {
#             dns-name 1.1.1.1 {
#                 ipv6-only;
#             }
#         }
#         address test_adr3 {
#             range-address 10.2.0.1 {
#                 to {
#                     10.2.0.2;
#                 }
#             }
#         }
#         address test_adr4 {
#             wildcard-address 10.3.0.1/24;
#         }
#         address test_adr5 {
#             description "test desc";
#             10.1.0.0/24;
#         }
#         address-set test_adrset1 {
#             address test_adr1;
#             address test_adr2;
#         }
#         address-set test_adrset2 {
#             address test_adr3;
#             address test_adr4;
#         }
#         address-set test_adrset3 {
#             description "test description";
#             address test_adr5;
#             address-set test_adrset1;
#             address-set test_adrset2;
#         }
#     }
#     screen test_screen;
#     host-inbound-traffic {
#         system-services {
#             all;
#             dhcp {
#                 except;
#             }
#         }
#         protocols {
#             all;
#             bgp {
#                 except;
#             }
#         }
#     }
#     interfaces {
#         ge-0/0/3.0;
#         ge-0/0/4.0;
#     }
#     application-tracking;
#     source-identity-log;
#     advance-policy-based-routing-profile {
#         test_profile;
#     }
#     enable-reverse-reroute;
# }
- name: Gather running security zones configuration
  junipernetworks.junos.junos_security_zones:
    state: gathered
#
# -------------------------
# Module Execution Result
# -------------------------
# "gathered": {
#     "functional_zone_management": {
#         "description": "test description",
#         "host_inbound_traffic": {
#             "protocols": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "bgp"
#                 }
#             ],
#             "system_services": [
#                 {
#                     "name": "all"
#                 },
#                 {
#                     "except": true,
#                     "name": "dhcp"
#                 }
#             ]
#         },
#         "interfaces": [
#             "ge-0/0/1.0",
#             "ge-0/0/2.0"
#         ],
#         "screen": "test_screen"
#     },
#     "security_zones": [
#         {
#             "address_book": {
#                 "address_sets": [
#                     {
#                         "addresses": [
#                             "test_adr1",
#                             "test_adr2"
#                         ],
#                         "name": "test_adrset1"
#                     },
#                     {
#                         "addresses": [
#                             "test_adr3",
#                             "test_adr4"
#                         ],
#                         "name": "test_adrset2"
#                     },
#                     {
#                         "address_sets": [
#                             "test_adrset1",
#                             "test_adrset2"
#                         ],
#                         "addresses": [
#                             "test_adr5"
#                         ],
#                         "description": "test description",
#                         "name": "test_adrset3"
#                     }
#                 ],
#                 "addresses": [
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.0.0.0/24",
#                         "name": "test_adr1"
#                     },
#                     {
#                         "dns_name": {
#                             "ipv6_only": true,
#                             "name": "1.1.1.1"
#                         },
#                         "name": "test_adr2"
#                     },
#                     {
#                         "name": "test_adr3",
#                         "range_address": {
#                             "from": "10.2.0.1",
#                             "to": "10.2.0.2"
#                         }
#                     },
#                     {
#                         "name": "test_adr4",
#                         "wildcard_address": "10.3.0.1/24"
#                     },
#                     {
#                         "description": "test desc",
#                         "ip_prefix": "10.1.0.0/24",
#                         "name": "test_adr5"
#                     }
#                 ]
#             },
#             "advance_policy_based_routing_profile": "test_profile",
#             "application_tracking": true,
#             "description": "test description",
#             "enable_reverse_reroute": true,
#             "host_inbound_traffic": {
#                 "protocols": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "bgp"
#                     }
#                 ],
#                 "system_services": [
#                     {
#                         "name": "all"
#                     },
#                     {
#                         "except": true,
#                         "name": "dhcp"
#                     }
#                 ]
#             },
#             "interfaces": [
#                 "ge-0/0/3.0",
#                 "ge-0/0/4.0"
#             ],
#             "name": "test_sec_zone1",
#             "screen": "test_screen",
#             "source_identity_log": true,
#             "tcp_rst": true
#         }
#     ]
# }
# "changed": false,
#
#
# Using rendered
#
# Before state
# ------------
#
- name: Render xml for provided facts.
  junipernetworks.junos.junos_security_zones:
    config:
      functional_zone_management:
        description: test description
        host_inbound_traffic:
          protocols:
          - name: all
          - name: bgp
            except: true
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
          - ge-0/0/1.0
          - ge-0/0/2.0
        screen: test_screen
      security_zones:
      - address_book:
          address_sets:
          - addresses:
            - test_adr1
            - test_adr2
            name: test_adrset1
          - addresses:
            - test_adr3
            - test_adr4
            name: test_adrset2
          - address_sets:
            - test_adrset1
            - test_adrset2
            addresses:
            - test_adr5
            description: test description
            name: test_adrset3
          addresses:
          - description: test desc
            ip_prefix: 10.0.0.0/24
            name: test_adr1
          - dns_name:
              ipv6_only: true
              name: 1.1.1.1
            name: test_adr2
          - name: test_adr3
            range_address:
              from: 10.2.0.1
              to: 10.2.0.2
          - name: test_adr4
            wildcard_address: 10.3.0.1/24
          - description: test desc
            ip_prefix: 10.1.0.0/24
            name: test_adr5
        advance_policy_based_routing_profile: test_profile
        application_tracking: true
        description: test description
        enable_reverse_reroute: true
        host_inbound_traffic:
          protocols:
          - name: all
          - except: true
            name: bgp
          system_services:
          - name: all
          - except: true
            name: dhcp
        interfaces:
        - ge-0/0/3.0
        - ge-0/0/4.0
        name: test_sec_zone1
        screen: test_screen
        source_identity_log: true
        tcp_rst: true
    state: rendered
#
# -------------------------
# Module Execution Result
# -------------------------
# "rendered":
# '<nc:security xmlns:nc=\"urn:ietf:params:xml:ns:netconf:base:1.0\"><nc:zones><nc:functional-zone><nc:management><nc:description>t'
# 'est description</nc:description><nc:host-inbound-traffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:na'
# 'me>bgp</nc:name><nc:except/></nc:protocols><nc:system-services><nc:name>all</nc:name></nc:system-services><nc:system-services><n'
# 'c:name>dhcp</nc:name><nc:except/></nc:system-services></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/1.0</nc:name></nc'
# ':interfaces><nc:interfaces><nc:name>ge-0/0/2.0</nc:name></nc:interfaces><nc:screen>test_screen</nc:screen></nc:management></nc:f'
# 'unctional-zone><nc:security-zone><nc:name>test_sec_zone1</nc:name><nc:address-book><nc:address><nc:name>test_adr1</nc:name><nc:i'
# 'p-prefix>10.0.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:address><nc:address><nc:name>test_adr2</nc:nam'
# 'e><nc:dns-name><nc:name>1.1.1.1</nc:name><nc:ipv6-only/></nc:dns-name></nc:address><nc:address><nc:name>test_adr3</nc:name><nc:r'
# 'ange-address><nc:name>10.2.0.1</nc:name><nc:to><nc:range-high>10.2.0.2</nc:range-high></nc:to></nc:range-address></nc:address><n'
# 'c:address><nc:name>test_adr4</nc:name><nc:wildcard-address><nc:name>10.3.0.1/24</nc:name></nc:wildcard-address></nc:address><nc:'
# 'address><nc:name>test_adr5</nc:name><nc:ip-prefix>10.1.0.0/24</nc:ip-prefix><nc:description>test desc</nc:description></nc:addre'
# 'ss><nc:address-set><nc:name>test_adrset1</nc:name><nc:address><nc:name>test_adr1</nc:name></nc:address><nc:address><nc:name>test'
# '_adr2</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset2</nc:name><nc:address><nc:name>test_adr3</nc:n'
# 'ame></nc:address><nc:address><nc:name>test_adr4</nc:name></nc:address></nc:address-set><nc:address-set><nc:name>test_adrset3</nc'
# ':name><nc:address><nc:name>test_adr5</nc:name></nc:address><nc:address-set><nc:name>test_adrset1</nc:name></nc:address-set><nc:a'
# 'ddress-set><nc:name>test_adrset2</nc:name></nc:address-set><nc:description>test description</nc:description></nc:address-set></n'
# 'c:address-book><nc:advance-policy-based-routing-profile><nc:profile>test_profile</nc:profile></nc:advance-policy-based-routing-p'
# 'rofile><nc:application-tracking/><nc:description>test description</nc:description><nc:enable-reverse-reroute/><nc:host-inbound-t'
# 'raffic><nc:protocols><nc:name>all</nc:name></nc:protocols><nc:protocols><nc:name>bgp</nc:name><nc:except/></nc:protocols><nc:sys'
# 'tem-services><nc:name>all</nc:name></nc:system-services><nc:system-services><nc:name>dhcp</nc:name><nc:except/></nc:system-servi'
# 'ces></nc:host-inbound-traffic><nc:interfaces><nc:name>ge-0/0/3.0</nc:name></nc:interfaces><nc:interfaces><nc:name>ge-0/0/4.0</nc'
# ':name></nc:interfaces><nc:screen>test_screen</nc:screen><nc:source-identity-log/><nc:tcp-rst/></nc:security-zone></nc:zones></nc'
# ':security>'
#
# Using parsed
# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <security>
#             <zones>
#                 <functional-zone>
#                     <management>
#                         <description>test description</description>
#                         <host-inbound-traffic>
#                             <protocols>
#                                 <name>all</name>
#                             </protocols>
#                             <protocols>
#                                 <name>bgp</name>
#                                 <except />
#                             </protocols>
#                             <system-services>
#                                 <name>all</name>
#                             </system-services>
#                             <system-services>
#                                 <name>dhcp</name>
#                                 <except />
#                             </system-services>
#                         </host-inbound-traffic>
#                         <interfaces>
#                             <name>ge-0/0/1.0</name>
#                         </interfaces>
#                         <interfaces>
#                             <name>ge-0/0/2.0</name>
#                         </interfaces>
#                         <screen>test_screen</screen>
#                     </management>
#                 </functional-zone>
#                 <security-zone>
#                     <name>test_sec_zone1</name>
#                     <address-book>
#                         <address>
#                             <name>test_adr1</name>
#                             <ip-prefix>10.0.0.0/24</ip-prefix>
#                             <description>test desc</description>
#                         </address>
#                         <address>
#                             <name>test_adr2</name>
#                             <dns-name>
#                                 <name>1.1.1.1</name>
#                                 <ipv6-only />
#                             </dns-name>
#                         </address>
#                         <address>
#                             <name>test_adr3</name>
#                             <range-address>
#                                 <name>10.2.0.1</name>
#                                 <to>
#                                     <range-high>10.2.0.2</range-high>
#                                 </to>
#                             </range-address>
#                         </address>
#                         <address>
#                             <name>test_adr4</name>
#                             <wildcard-address>
#                                 <name>10.3.0.1/24</name>
#                             </wildcard-address>
#                         </address>
#                         <address>
#                             <name>test_adr5</name>
#                             <ip-prefix>10.1.0.0/24</ip-prefix>
#                             <description>test desc</description>
#                         </address>
#                         <address-set>
#                             <name>test_adrset1</name>
#                             <address>
#                                 <name>test_adr1</name>
#                             </address>
#                             <address>
#                                 <name>test_adr2</name>
#                             </address>
#                         </address-set>
#                         <address-set>
#                             <name>test_adrset2</name>
#                             <address>
#                                 <name>test_adr3</name>
#                             </address>
#                             <address>
#                                 <name>test_adr4</name>
#                             </address>
#                         </address-set>
#                         <address-set>
#                             <name>test_adrset3</name>
#                             <address>
#                                 <name>test_adr5</name>
#                             </address>
#                             <address-set>
#                                 <name>test_adrset1</name>
#                             </address-set>
#                             <address-set>
#                                 <name>test_adrset2</name>
#                             </address-set>
#                             <description>test description</description>
#                         </address-set>
#                     </address-book>
#                     <advance-policy-based-routing-profile>
#                         <profile>test_profile</profile>
#                     </advance-policy-based-routing-profile>
#                     <application-tracking />
#                     <description>test description</description>
#                     <enable-reverse-reroute />
#                     <host-inbound-traffic>
#                         <protocols>
#                             <name>all</name>
#                         </protocols>
#                         <protocols>
#                             <name>bgp</name>
#                             <except />
#                         </protocols>
#                         <system-services>
#                             <name>all</name>
#                         </system-services>
#                         <system-services>
#                             <name>dhcp</name>
#                             <except />
#                         </system-services>
#                     </host-inbound-traffic>
#                     <interfaces>
#                         <name>ge-0/0/3.0</name>
#                     </interfaces>
#                     <interfaces>
#                         <name>ge-0/0/4.0</name>
#                     </interfaces>
#                     <screen>test_screen</screen>
#                     <source-identity-log />
#                     <tcp-rst />
#                 </security-zone>
#             </zones>
#         </security>
#     </configuration>
# </rpc-reply>
#
- name: Parse security zones running config
  junipernetworks.junos.junos_security_zones:
    running_config: "{{ lookup('file', './parsed.cfg') }}"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed":  {
#     "functional_zone_management": {
#         "description": "test description 2",
#         "host_inbound_traffic": {
#             "protocols": [{"name": "all"}, {"except": True, "name": "bgp"}, {"except": True, "name": "bfd"}],
#             "system_services": [{"name": "all"}, {"except": True, "name": "dhcp"}, {"except": True, "name": "dhcpv6"}],
#         },
#         "interfaces": ["ge-0/0/1.0", "ge-0/0/2.0"],
#         "screen": "test_screen",
#     },
#     "security_zones": [
#         {
#             "address_book": {
#                 "address_sets": [
#                     {"addresses": ["test_adr1", "test_adr2"], "name": "test_adrset1"},
#                     {"addresses": ["test_adr3", "test_adr4"], "name": "test_adrset2"},
#                     {
#                         "address_sets": ["test_adrset1", "test_adrset2"],
#                         "addresses": ["test_adr5"],
#                         "description": "test description",
#                         "name": "test_adrset3",
#                     },
#                 ],
#                 "addresses": [
#                     {"description": "test desc", "ip_prefix": "10.0.0.0/24", "name": "test_adr1"},
#                     {"dns_name": {"ipv6_only": True, "name": "1.1.1.1"}, "name": "test_adr2"},
#                     {"name": "test_adr3", "range_address": {"from": "10.2.0.1", "to": "10.2.0.2"}},
#                     {"name": "test_adr4", "wildcard_address": "10.3.0.1/24"},
#                     {"description": "test desc", "ip_prefix": "10.1.0.0/24", "name": "test_adr5"},
#                 ],
#             },
#             "advance_policy_based_routing_profile": "test_profile",
#             "application_tracking": True,
#             "description": "test description",
#             "enable_reverse_reroute": True,
#             "host_inbound_traffic": {
#                 "protocols": [{"name": "all"}, {"except": True, "name": "bgp"}],
#                 "system_services": [{"name": "all"}, {"except": True, "name": "dhcp"}],
#             },
#             "interfaces": ["ge-0/0/3.0", "ge-0/0/4.0"],
#             "name": "test_sec_zone1",
#             "screen": "test_screen",
#             "source_identity_log": True,
#             "tcp_rst": True,
#         },
#         {"name": "test_sec_zone2", "source_identity_log": True, "tcp_rst": True},
#     ],
# }
#
#
"""
RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when state is I(merged), I(replaced), I(overridden), I(deleted) or I(purged)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: when state is I(merged), I(replaced), I(overridden), I(deleted) or I(purged)
  type: list
  sample:
    - "<rpc-reply>
      <configuration>
        <security>
          <policies>
            <global>
              <policy>
                  <name>test_glob_1</name>
                  <match>
                      <source-address>any-ipv6</source-address>
                      <destination-address>any-ipv6</destination-address>
                      <application>any</application>
                  </match>
                  <then>
                      <deny />
                  </then>
              </policy>
            </global>
          </policies>
        </security>
      </configuration>
    </rpc-reply>"
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when state is I(rendered)
  type: dict
  sample:
    - "<rpc-reply>
      <configuration>
        <security>
          <policies>
            <global>
              <policy>
                  <name>test_glob_1</name>
                  <match>
                      <source-address>any-ipv6</source-address>
                      <destination-address>any-ipv6</destination-address>
                      <application>any</application>
                  </match>
                  <then>
                      <deny />
                  </then>
              </policy>
            </global>
          </policies>
        </security>
      </configuration>
    </rpc-reply>"
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when state is I(gathered)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when state is I(parsed)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.security_zones.security_zones import (
    Security_zonesArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.security_zones.security_zones import (
    Security_zones,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]

    module = AnsibleModule(
        argument_spec=Security_zonesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )

    result = Security_zones(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
