#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for junos_static_routes
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type


DOCUMENTATION = """
module: junos_static_routes
short_description: Static routes resource module
description: This module provides declarative management of static routes on Juniper
  JUNOS devices
version_added: 1.0.0
author: Daniel Mellado (@dmellado)
requirements:
- ncclient (>=v0.6.4)
- xmltodict (>=0.12)
notes:
- This module requires the netconf system service be enabled on the device being managed.
- This module works with connection C(netconf). See L(the Junos OS Platform Options,../network/user_guide/platform_junos.html).
- Tested against JunOS v18.4R1
options:
  config:
    description: A dictionary of static routes options
    type: list
    elements: dict
    suboptions:
      vrf:
        description:
        - Virtual Routing and Forwarding (VRF) name
        type: str
      address_families:
        description:
        - Address family to use for the static routes
        elements: dict
        type: list
        suboptions:
          afi:
            description:
            - afi to use for the static routes
            type: str
            required: true
            choices:
            - ipv4
            - ipv6
          routes:
            description:
            - Static route configuration
            elements: dict
            type: list
            suboptions:
              dest:
                description:
                - Static route destination including prefix
                type: str
              next_hop:
                elements: dict
                type: list
                description:
                - Next hop to destination
                suboptions:
                  forward_router_address:
                    description:
                    - List of next hops
                    type: str
              metric:
                description:
                - Metric value for the static route
                type: int
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the Junos device
      by executing the command B(show routing-options).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result
    type: str
  state:
    description:
    - The state the configuration should be left in
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged
"""

EXAMPLES = """
# Using deleted

# Before state
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
#     route 192.168.16.0/24 next-hop 172.16.1.2;
# }

- name: Delete provided configuration (default operation is merge)
  junipernetworks.junos.junos_static_routes:
    config:
    - address_families:
      - afi: ipv4
        routes:
        - dest: 192.168.16.0/24
          next_hop:
          - forward_router_address: 172.16.1.2
    state: deleted

# Task Output
# -----------
# before:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
# commands:
#   - '<nc:routing-options
#     xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:static><nc:route
#     delete="delete"><nc:name>192.168.16.0/24</nc:name></nc:route></nc:static></nc:routing-options>'
#   - '<nc:routing-instances xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>'
# after:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2

# After state:
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
# }

# Using merged

# Before state
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
# }

- name: Merge provided configuration with device configuration (default operation
    is merge)
  junipernetworks.junos.junos_static_routes:
    config:
    - address_families:
      - afi: ipv4
        routes:
        - dest: 192.168.16.0/24
          next_hop:
          - forward_router_address: 172.16.1.2
    state: merged

# Task Output
# -----------
# before:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
# commands:
#   - '<nc:routing-options
#     xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:static><nc:route><nc:name>192.168.16.0/24</nc:name>
#     <nc:next-hop>172.16.1.2</nc:next-hop></nc:route></nc:static></nc:routing-options>'
#   - '<nc:routing-instances xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>'
# after:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
# After state:
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
#     route 192.168.16.0/24 next-hop 172.16.1.2;
# }

# Using overridden

# Before state
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
#     route 192.168.16.0/24 next-hop 172.16.1.2;
# }

- name: Override running configuration with provided configuration (default operation
    is merge)
  junipernetworks.junos.junos_static_routes:
    config:
    - address_families:
      - afi: ipv4
        routes:
        - dest: 192.168.16.0/24
          next_hop:
          - forward_router_address: 172.16.0.1
    state: overridden
# Task Output:
# ------------
# before:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
# commands:
#   - >-
#     <nc:routing-options
#     xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:static><nc:route
#     delete="delete"><nc:name>192.168.47.0/24</nc:name></nc:route><nc:route
#     delete="delete"><nc:name>192.168.16.0/24</nc:name></nc:route></nc:static><nc:static><nc:route><nc:name>192.168.16.0/24</nc:name><nc:next-hop>172.16.0.1</nc:next-hop></nc:route></nc:static></nc:routing-options>
#   - '<nc:routing-instances xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>'
# after:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.0.1

# After state:
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.16.0/24 next-hop 172.16.0.1;
# }

# Using replaced

# Before state
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 172.16.1.2;
#     route 192.168.16.0/24 next-hop 172.16.1.2;
# }

- name: Replace provided configuration with device configuration (default operation
    is merge)
  junipernetworks.junos.junos_static_routes:
    config:
    - address_families:
      - afi: ipv4
        routes:
        - dest: 192.168.47.0/24
          next_hop:
          - forward_router_address: 10.200.16.2
    state: replaced

# Task Output:
# ------------
# before:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
# commands:
#   - >-
#     <nc:routing-options
#     xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:static><nc:route
#     delete="delete"><nc:name>192.168.47.0/24</nc:name></nc:route></nc:static><nc:static><nc:route><nc:name>192.168.47.0/24</nc:name><nc:next-hop>10.200.16.2</nc:next-hop></nc:route></nc:static></nc:routing-options>
#   - '<nc:routing-instances xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"/>'
# after:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 10.200.16.2

# After state:
# ------------
#
# admin# show routing-options
# static {
#     route 192.168.47.0/24 next-hop 10.200.16.2;
#     route 192.168.16.0/24 next-hop 172.16.1.2;
# }

# Using gathered to gather static route facts from the device
# Before state
# ------------
# admin# show routing-options
# static {
#     route 192.168.16.0/24 next-hop 172.16.1.2;
#     route 192.168.47.0/24 next-hop 10.200.16.2;
# }
- name: Gather static routes facts from the device using junos_static_routes module
  junipernetworks.junos.junos_static_routes:
    state: gathered

# Task output:
# ------------
# gathered:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: 172.16.1.2
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 10.200.16.2

# Using rendered

- name: Render platform specific commands (without connecting to the device)
  junipernetworks.junos.junos_static_routes:
        config:
        - address_families:
          - afi: ipv4
            routes:
            - dest: 192.168.16.0/24
              next_hop:
              - forward_router_address: 172.16.1.2
        state: rendered

# Task output:
# ------------
# rendered:
#   - '<nc:routing-options
#     xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:static><nc:route><nc:name>192.168.16.0/24</nc:name>
#     <nc:next-hop>172.16.1.2</nc:next-hop></nc:route></nc:static></nc:routing-options>'

# Using parsed

# parsed.cfg
# ------------
# <?xml version="1.0" encoding="UTF-8"?>
# <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
#     <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
#         <version>18.4R1-S2.4</version>
#         <routing-options>
#         <static>
#             <route>
#                 <name>192.168.16.0/24</name>
#                 <next-hop>172.16.1.2</next-hop>
#                 <next-hop>172.16.1.3</next-hop>
#             </route>
#             <route>
#                 <name>192.168.47.0/24</name>
#                 <next-hop>10.200.16.2</next-hop>
#             </route>
#         </static>
#     </routing-options>
#     </configuration>
# </rpc-reply>

- name: Parsed running config (without connecting to the device)
  junipernetworks.junos.junos_static_routes:
        running_config: "{{ lookup('file', 'parsed.cfg') }}"
        state: parsed

# Task output:
# ------------
# parsed:
#   - address_families:
#       - afi: ipv4
#         routes:
#           - dest: 192.168.16.0/24
#             next_hop:
#               - forward_router_address: '[''172.16.1.2'', ''172.16.1.3'']'
#           - dest: 192.168.47.0/24
#             next_hop:
#               - forward_router_address: 10.200.16.2

"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: str
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: str
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['command 1', 'command 2', 'command 3']
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - <nc:protocols xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.argspec.static_routes.static_routes import (
    Static_routesArgs,
)
from ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.static_routes.static_routes import (
    Static_routes,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    module = AnsibleModule(
        argument_spec=Static_routesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
    )
    result = Static_routes(module).execute_module()

    module.exit_json(**result)


if __name__ == "__main__":
    main()
