/* dconf-model.c generated by valac 0.56.3, the Vala compiler
 * generated from dconf-model.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#define G_SETTINGS_ENABLE_BACKEND

#include <glib-object.h>
#include <glib.h>
#include <dconf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gsettingsbackend.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_folder_context_id ((guint16) 1)
#define MODEL_UTILS_undefined_context_id ((guint16) 0)
#define MODEL_UTILS_dconf_context_id ((guint16) 2)
#define MODEL_UTILS_special_context_id_number ((guint16) 3)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;
typedef struct _SettingsModelCorePrivate SettingsModelCorePrivate;

#define TYPE_SOURCE_MANAGER (source_manager_get_type ())
#define SOURCE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_MANAGER, SourceManager))
#define SOURCE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_MANAGER, SourceManagerClass))
#define IS_SOURCE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_MANAGER))
#define IS_SOURCE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_MANAGER))
#define SOURCE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_MANAGER, SourceManagerClass))

typedef struct _SourceManager SourceManager;
typedef struct _SourceManagerClass SourceManagerClass;

#define TYPE_SETTING_OBJECT (setting_object_get_type ())
#define SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTING_OBJECT, SettingObject))
#define SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTING_OBJECT, SettingObjectClass))
#define IS_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTING_OBJECT))
#define IS_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTING_OBJECT))
#define SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTING_OBJECT, SettingObjectClass))

typedef struct _SettingObject SettingObject;
typedef struct _SettingObjectClass SettingObjectClass;

#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;
enum  {
	SETTINGS_MODEL_CORE_0_PROPERTY,
	SETTINGS_MODEL_CORE_REFRESH_SOURCE_PROPERTY,
	SETTINGS_MODEL_CORE_USE_SHORTPATHS_PROPERTY,
	SETTINGS_MODEL_CORE_NUM_PROPERTIES
};
static GParamSpec* settings_model_core_properties[SETTINGS_MODEL_CORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_SCHEMA_PATH_TREE (schema_path_tree_get_type ())
#define SCHEMA_PATH_TREE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_PATH_TREE, SchemaPathTree))
#define SCHEMA_PATH_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_PATH_TREE, SchemaPathTreeClass))
#define IS_SCHEMA_PATH_TREE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_PATH_TREE))
#define IS_SCHEMA_PATH_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_PATH_TREE))
#define SCHEMA_PATH_TREE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_PATH_TREE, SchemaPathTreeClass))

typedef struct _SchemaPathTree SchemaPathTree;
typedef struct _SchemaPathTreeClass SchemaPathTreeClass;

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TYPE_GSETTINGS_KEY (gsettings_key_get_type ())
#define GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_KEY, GSettingsKey))
#define GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_KEY, GSettingsKeyClass))
#define IS_GSETTINGS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_KEY))
#define IS_GSETTINGS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_KEY))
#define GSETTINGS_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_KEY, GSettingsKeyClass))

typedef struct _GSettingsKey GSettingsKey;
typedef struct _GSettingsKeyClass GSettingsKeyClass;

#define TYPE_DCONF_KEY (dconf_key_get_type ())
#define DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DCONF_KEY, DConfKey))
#define DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DCONF_KEY, DConfKeyClass))
#define IS_DCONF_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DCONF_KEY))
#define IS_DCONF_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DCONF_KEY))
#define DCONF_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DCONF_KEY, DConfKeyClass))

typedef struct _DConfKey DConfKey;
typedef struct _DConfKeyClass DConfKeyClass;
typedef struct _Block7Data Block7Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef enum  {
	RANGE_TYPE_TYPE,
	RANGE_TYPE_ENUM,
	RANGE_TYPE_FLAGS,
	RANGE_TYPE_RANGE,
	RANGE_TYPE_OTHER
} RangeType;

#define TYPE_RANGE_TYPE (range_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _SettingObjectPrivate SettingObjectPrivate;
typedef struct _KeyPrivate KeyPrivate;
typedef struct _GSettingsKeyPrivate GSettingsKeyPrivate;
typedef enum  {
	KEY_CONFLICT_NONE,
	KEY_CONFLICT_SOFT,
	KEY_CONFLICT_HARD
} KeyConflict;

#define TYPE_KEY_CONFLICT (key_conflict_get_type ())
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _dconf_changeset_unref0(var) ((var == NULL) ? NULL : (var = (dconf_changeset_unref (var), NULL)))
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
enum  {
	SETTINGS_MODEL_CORE_PATHS_CHANGED_SIGNAL,
	SETTINGS_MODEL_CORE_GKEY_VALUE_PUSH_SIGNAL,
	SETTINGS_MODEL_CORE_DKEY_VALUE_PUSH_SIGNAL,
	SETTINGS_MODEL_CORE_NUM_SIGNALS
};
static guint settings_model_core_signals[SETTINGS_MODEL_CORE_NUM_SIGNALS] = {0};

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
typedef struct _SettingsModelPrivate SettingsModelPrivate;
enum  {
	SETTINGS_MODEL_0_PROPERTY,
	SETTINGS_MODEL_NUM_PROPERTIES
};
static GParamSpec* settings_model_properties[SETTINGS_MODEL_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SettingsModelCore {
	GObject parent_instance;
	SettingsModelCorePrivate * priv;
	gboolean copy_action;
};

struct _SettingsModelCoreClass {
	GObjectClass parent_class;
};

struct _SettingsModelCorePrivate {
	SourceManager* source_manager;
	gboolean _refresh_source;
	DConfClient* client;
	gchar* last_change_tag;
	gboolean gsettings_change;
	gboolean _use_shortpaths;
	gboolean paths_has_changed;
	GHashTable* saved_keys;
	guint16 context_index;
	GHashTable* contexts_hashtable_1;
	GHashTable* contexts_hashtable_2;
	gboolean _case_sensitive;
	GList* contexts_list;
	GListStore* watched_keys;
};

struct _Block7Data {
	int _ref_count_;
	SettingsModelCore* self;
	gboolean case_sensitive;
};

struct _SettingObject {
	GObject parent_instance;
	SettingObjectPrivate * priv;
};

struct _SettingObjectClass {
	GObjectClass parent_class;
};

struct _Key {
	SettingObject parent_instance;
	KeyPrivate * priv;
	gulong key_value_changed_handler;
};

struct _KeyClass {
	SettingObjectClass parent_class;
};

struct _GSettingsKey {
	Key parent_instance;
	GSettingsKeyPrivate * priv;
	KeyConflict key_conflict;
};

struct _GSettingsKeyClass {
	KeyClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	SettingsModelCore* self;
	GHashTable* delayed_settings_hashtable;
	DConfChangeset* dconf_changeset;
	gboolean dconf_changeset_has_change;
};

struct _SettingsModel {
	SettingsModelCore parent_instance;
	SettingsModelPrivate * priv;
};

struct _SettingsModelClass {
	SettingsModelCoreClass parent_class;
};

static gint SettingsModelCore_private_offset;
static gpointer settings_model_core_parent_class = NULL;
static gpointer settings_model_parent_class = NULL;

VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType source_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceManager, g_object_unref)
VALA_EXTERN GType setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingObject, g_object_unref)
VALA_EXTERN GType key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Key, g_object_unref)
VALA_EXTERN SourceManager* source_manager_new (void);
VALA_EXTERN SourceManager* source_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static guint _settings_model_core_contexts_hashtable_2_lambda35_ (guint16 a);
static guint __settings_model_core_contexts_hashtable_2_lambda35__ghash_func (gconstpointer key);
static gboolean _settings_model_core_contexts_hashtable_2_lambda36_ (guint16 a,
                                                              guint16 b);
static gboolean __settings_model_core_contexts_hashtable_2_lambda36__gequal_func (gconstpointer a,
                                                                           gconstpointer b);
VALA_EXTERN void _settings_model_core_refresh_relocatable_schema_paths (SettingsModelCore* self,
                                                            gboolean user_schemas,
                                                            gboolean built_in_schemas,
                                                            gboolean internal_schemas,
                                                            gboolean startup_schemas,
                                                            GVariant* user_paths_variant);
VALA_EXTERN void source_manager_refresh_relocatable_schema_paths (SourceManager* self,
                                                      gboolean user_schemas,
                                                      gboolean built_in_schemas,
                                                      gboolean internal_schemas,
                                                      gboolean startup_schemas,
                                                      GVariant* user_paths_variant);
VALA_EXTERN void _settings_model_core_add_mapping (SettingsModelCore* self,
                                       const gchar* schema,
                                       const gchar* folder_path);
VALA_EXTERN void source_manager_add_mapping (SourceManager* self,
                                 const gchar* schema,
                                 const gchar* folder_path);
VALA_EXTERN void _settings_model_core_finalize_model (SettingsModelCore* self);
static void __lambda96_ (SettingsModelCore* self,
                  GHashTable* modified_path_specs);
static void ___lambda96__source_manager_paths_changed (SourceManager* _sender,
                                                GHashTable* modified_path_specs,
                                                gpointer self);
VALA_EXTERN void source_manager_refresh_schema_source (SourceManager* self);
static gboolean __lambda97_ (SettingsModelCore* self);
static gboolean settings_model_core_get_refresh_source (SettingsModelCore* self);
static gboolean ___lambda97__gsource_func (gpointer self);
static void __lambda98_ (SettingsModelCore* self,
                  DConfClient* client,
                  const gchar* prefix,
                  gchar** changes,
                  const gchar* tag);
VALA_EXTERN gboolean model_utils_is_key_path (const gchar* path);
VALA_EXTERN gchar* model_utils_get_parent_path (const gchar* path);
VALA_EXTERN gpointer schema_path_tree_ref (gpointer instance);
VALA_EXTERN void schema_path_tree_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_schema_path_tree (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_schema_path_tree (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_schema_path_tree (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_schema_path_tree (const GValue* value);
VALA_EXTERN GType schema_path_tree_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SchemaPathTree, schema_path_tree_unref)
VALA_EXTERN SchemaPathTree* source_manager_get_cached_schemas (SourceManager* self);
VALA_EXTERN guint schema_path_tree_get_schema_count (SchemaPathTree* self,
                                         const gchar* path);
static void ___lambda98__dconf_client_changed (DConfClient* _sender,
                                        const gchar* prefix,
                                        gchar** changes,
                                        const gchar* tag,
                                        gpointer self);
VALA_EXTERN GType directory_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Directory, g_object_unref)
static Directory* settings_model_core_get_directory (SettingsModelCore* self,
                                              const gchar* path);
VALA_EXTERN Directory* directory_new (const gchar* _full_name,
                          const gchar* _name);
VALA_EXTERN Directory* directory_construct (GType object_type,
                                const gchar* _full_name,
                                const gchar* _name);
VALA_EXTERN void schema_path_tree_get_content_count (SchemaPathTree* self,
                                         const gchar* path,
                                         guint* schemas_count,
                                         guint* subpaths_count);
VALA_EXTERN gchar* model_utils_get_name (const gchar* path);
static GListStore* settings_model_core_get_children_as_liststore (SettingsModelCore* self,
                                                           const gchar* folder_path);
static void settings_model_core_lookup_gsettings (SettingsModelCore* self,
                                           const gchar* path,
                                           GListStore* key_model,
                                           gboolean* multiple_schemas);
static void settings_model_core_create_dconf_keys (SettingsModelCore* self,
                                            const gchar* parent_path,
                                            GListStore* key_model);
VALA_EXTERN GVariant* _settings_model_core_get_children (SettingsModelCore* self,
                                             const gchar* folder_path,
                                             gboolean watch,
                                             gboolean clean_watched);
VALA_EXTERN void _settings_model_core_clean_watched_keys (SettingsModelCore* self);
static void settings_model_core_add_watched_key (SettingsModelCore* self,
                                          Key* key);
static guint16 settings_model_core_get_context_id_from_key (SettingsModelCore* self,
                                                     Key* key);
VALA_EXTERN const gchar* setting_object_get_name (SettingObject* self);
static gboolean settings_model_core_get_use_shortpaths (SettingsModelCore* self);
VALA_EXTERN const gchar* setting_object_get_full_name (SettingObject* self);
VALA_EXTERN gboolean model_utils_is_folder_path (const gchar* path);
VALA_EXTERN gboolean _settings_model_core_get_object (SettingsModelCore* self,
                                          const gchar* path,
                                          guint16* context_id,
                                          gchar** name,
                                          gboolean watch);
static Key* settings_model_core_get_key (SettingsModelCore* self,
                                  const gchar* path,
                                  const gchar* context);
static guint16 settings_model_core_get_context_id_from_object (SettingsModelCore* self,
                                                        SettingObject* object);
VALA_EXTERN gboolean _settings_model_core_key_exists (SettingsModelCore* self,
                                          const gchar* key_path,
                                          guint16 key_context_id);
static gchar* settings_model_core_get_key_context_from_id (SettingsModelCore* self,
                                                    guint16 context_id);
VALA_EXTERN gboolean _settings_model_core_key_exists_2 (SettingsModelCore* self,
                                            const gchar* key_path);
VALA_EXTERN GType gsettings_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GSettingsKey, g_object_unref)
VALA_EXTERN gboolean _settings_model_core_is_key_ghost (SettingsModelCore* self,
                                            const gchar* key_path);
VALA_EXTERN GType dconf_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DConfKey, g_object_unref)
VALA_EXTERN const gchar* gsettings_key_get_schema_id (GSettingsKey* self);
static Key* settings_model_core_get_key_from_path_and_name (GListStore* key_model,
                                                     const gchar* key_name,
                                                     const gchar* context);
static Key* settings_model_core_get_specific_key (SettingsModelCore* self,
                                           const gchar* key_path,
                                           guint16 key_context_id);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
static GSettingsKey* settings_model_core_get_specific_gsettings_key (SettingsModelCore* self,
                                                              const gchar* key_path,
                                                              guint16 gkey_context_id);
static gchar* settings_model_core_get_schema_id_from_gkey_context_id (SettingsModelCore* self,
                                                               guint16 context_id);
static Directory* settings_model_core_get_folder_from_path_and_name (GListStore* key_model,
                                                              const gchar* folder_name);
static guint16 settings_model_core_get_context_id_from_gsettings_key (SettingsModelCore* self,
                                                               GSettingsKey* gkey,
                                                               gboolean create_context_if_needed);
VALA_EXTERN gboolean model_utils_is_undefined_context_id (guint16 context_id);
static gint __lambda54_ (SettingsModelCore* self,
                  guint16 a,
                  guint16 b);
static gint settings_model_core_sort_context_ids (const gchar* a_str,
                                           const gchar* b_str,
                                           gboolean case_sensitive);
static gint ___lambda54__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN guint16* _settings_model_core_get_sorted_context_id (SettingsModelCore* self,
                                                     gint* result_length1);
VALA_EXTERN void settings_model_core_sort_contexts_list (SettingsModelCore* self,
                                             gboolean case_sensitive);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gint __lambda84_ (Block7Data* _data7_,
                  guint16 a,
                  guint16 b);
static gint ___lambda84__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN gboolean source_manager_source_is_null (SourceManager* self);
VALA_EXTERN gboolean schema_path_tree_lookup (SchemaPathTree* self,
                                  const gchar* path,
                                  GHashTable** path_schemas,
                                  GHashTable** subpaths);
static void settings_model_core_create_gsettings_keys (SettingsModelCore* self,
                                                const gchar* parent_path,
                                                GSettingsSchema* settings_schema,
                                                GListStore* key_model);
static void settings_model_core_create_gsettings_key (SettingsModelCore* self,
                                               const gchar* parent_path,
                                               const gchar* key_id,
                                               GSettingsSchema* settings_schema,
                                               GSettings* settings,
                                               GListStore* key_model);
VALA_EXTERN GType range_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RangeType range_type_get_from_string (const gchar* str);
VALA_EXTERN GSettingsKey* gsettings_key_new (const gchar* parent_full_name,
                                 const gchar* name,
                                 GSettings* settings,
                                 const gchar* schema_id,
                                 const gchar* schema_path,
                                 const gchar* summary,
                                 const gchar* description,
                                 const gchar* type_string,
                                 GVariant* default_value,
                                 RangeType range_type,
                                 GVariant* range_content);
VALA_EXTERN GSettingsKey* gsettings_key_construct (GType object_type,
                                       const gchar* parent_full_name,
                                       const gchar* name,
                                       GSettings* settings,
                                       const gchar* schema_id,
                                       const gchar* schema_path,
                                       const gchar* summary,
                                       const gchar* description,
                                       const gchar* type_string,
                                       GVariant* default_value,
                                       RangeType range_type,
                                       GVariant* range_content);
VALA_EXTERN GType key_conflict_get_type (void) G_GNUC_CONST ;
VALA_EXTERN const gchar* key_get_type_string (Key* self);
VALA_EXTERN GVariant* gsettings_key_get_default_value (GSettingsKey* self);
VALA_EXTERN RangeType gsettings_key_get_range_type (GSettingsKey* self);
VALA_EXTERN GVariant* gsettings_key_get_range_content (GSettingsKey* self);
static void settings_model_core_create_dconf_key (SettingsModelCore* self,
                                           const gchar* full_name,
                                           const gchar* key_id,
                                           GListStore* key_model);
static GVariant* settings_model_core_get_dconf_key_value_or_null (const gchar* full_name,
                                                           DConfClient* client);
VALA_EXTERN DConfKey* dconf_key_new (const gchar* full_name,
                         const gchar* name,
                         const gchar* type_string);
VALA_EXTERN DConfKey* dconf_key_construct (GType object_type,
                               const gchar* full_name,
                               const gchar* name,
                               const gchar* type_string);
VALA_EXTERN void _settings_model_core_keys_value_push (SettingsModelCore* self);
static inline void settings_model_core_push_gsettings_key_value (SettingsModelCore* self,
                                                   GSettingsKey* gkey);
static inline void settings_model_core_push_dconf_key_value (SettingsModelCore* self,
                                               const gchar* key_path,
                                               DConfClient* client);
VALA_EXTERN void _settings_model_core_key_value_push (SettingsModelCore* self,
                                          const gchar* key_path,
                                          guint16 key_context_id);
VALA_EXTERN void gsettings_key_connect_settings (GSettingsKey* self);
static void settings_model_core_on_gkey_value_changed (SettingsModelCore* self,
                                                Key* key);
static void _settings_model_core_on_gkey_value_changed_key_value_changed (Key* _sender,
                                                                   gpointer self);
VALA_EXTERN void dconf_key_connect_client (DConfKey* self,
                               DConfClient* client);
static void settings_model_core_on_dkey_value_changed (SettingsModelCore* self,
                                                Key* key);
static void _settings_model_core_on_dkey_value_changed_key_value_changed (Key* _sender,
                                                                   gpointer self);
VALA_EXTERN void gsettings_key_disconnect_settings (GSettingsKey* self);
VALA_EXTERN void dconf_key_disconnect_client (DConfKey* self,
                                  DConfClient* client);
static GVariant* settings_model_core_get_gsettings_key_value (GSettingsKey* gkey);
static inline gboolean settings_model_core_is_key_default (GSettingsKey* gkey);
VALA_EXTERN gchar* _settings_model_core_get_folder_fallback_path (SettingsModelCore* self,
                                                      const gchar* folder_path);
VALA_EXTERN gchar* _settings_model_core_get_startup_path_fallback (SettingsModelCore* self,
                                                       const gchar* path);
VALA_EXTERN guint16 _settings_model_core_get_fallback_context (SettingsModelCore* self,
                                                   const gchar* key_path,
                                                   guint16 context_id,
                                                   const gchar* schema_id);
VALA_EXTERN GSettings* gsettings_key_get_settings (GSettingsKey* self);
static GVariant* settings_model_core_get_dconf_key_value (const gchar* full_name,
                                                   DConfClient* client);
VALA_EXTERN void _settings_model_core_set_gsettings_key_value (SettingsModelCore* self,
                                                   const gchar* key_path,
                                                   guint16 gkey_context_id,
                                                   GVariant* key_value);
static void settings_model_core_set_dconf_value (SettingsModelCore* self,
                                          const gchar* full_name,
                                          GVariant* key_value);
VALA_EXTERN void _settings_model_core_set_dconf_key_value (SettingsModelCore* self,
                                               const gchar* full_name,
                                               GVariant* key_value);
VALA_EXTERN void _settings_model_core_set_key_to_default (SettingsModelCore* self,
                                              const gchar* key_path,
                                              guint16 gkey_context_id);
VALA_EXTERN gboolean _settings_model_core_key_has_schema (SettingsModelCore* self,
                                              const gchar* key_path);
VALA_EXTERN void _settings_model_core_apply_key_value_changes (SettingsModelCore* self,
                                                   GHashTable* changes);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda26_ (Block8Data* _data8_,
                  const gchar* key_path,
                  GVariant* planned_value);
VALA_EXTERN gchar* gsettings_key_get_descriptor (GSettingsKey* self);
static void ___lambda26__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static gboolean __lambda32_ (SettingsModelCore* self,
                      const gchar* key_descriptor,
                      GSettings* schema_settings);
static gboolean ___lambda32__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
VALA_EXTERN GVariant* _settings_model_core_get_key_properties (SettingsModelCore* self,
                                                   const gchar* key_path,
                                                   guint16 key_context_id,
                                                   guint16 _query);
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GVariant* key_get_all_fixed_properties (Key* self);
VALA_EXTERN void key_generate_key_fixed_properties (Key* key);
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new_from_aqv (GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct_from_aqv (GType object_type,
                                                               GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new (void);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct (GType object_type);
VALA_EXTERN void key_get_key_fixed_properties (Key* key,
                                   PropertyQuery query,
                                   RegistryVariantDict** variantdict);
VALA_EXTERN void registry_variant_dict_insert_value (RegistryVariantDict* self,
                                         guint16 key,
                                         GVariant* variant);
VALA_EXTERN guint key_get_key_hash (Key* self);
VALA_EXTERN GVariant* registry_variant_dict_end (RegistryVariantDict* self);
VALA_EXTERN gchar* settings_model_core_get_suggested_gsettings_key_copy_text (SettingsModelCore* self,
                                                                  const gchar* key_path,
                                                                  guint16 gkey_context_id);
static inline gchar* _settings_model_core_get_suggested_gsettings_key_copy_text (GSettingsKey* gkey);
VALA_EXTERN gchar* settings_model_core_get_suggested_dconf_key_copy_text (SettingsModelCore* self,
                                                              const gchar* key_path);
static inline gchar* _settings_model_core_get_suggested_dconf_key_copy_text (const gchar* key_path,
                                                               DConfClient* client);
VALA_EXTERN SettingsModelCore* settings_model_core_construct (GType object_type);
VALA_EXTERN void settings_model_core_set_refresh_source (SettingsModelCore* self,
                                             gboolean value);
VALA_EXTERN void settings_model_core_set_use_shortpaths (SettingsModelCore* self,
                                             gboolean value);
static void g_cclosure_user_marshal_VOID__BOXED_BOOLEAN (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_UINT_VARIANT_BOOLEAN (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void settings_model_core_finalize (GObject * obj);
static GType settings_model_core_get_type_once (void);
static void _vala_settings_model_core_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_settings_model_core_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
VALA_EXTERN void settings_model_refresh_relocatable_schema_paths (SettingsModel* self,
                                                      gboolean user_schemas,
                                                      gboolean built_in_schemas,
                                                      gboolean internal_schemas,
                                                      gboolean startup_schemas,
                                                      GVariant* user_paths_variant);
VALA_EXTERN void settings_model_add_mapping (SettingsModel* self,
                                 const gchar* schema,
                                 const gchar* folder_path);
VALA_EXTERN void settings_model_finalize_model (SettingsModel* self);
VALA_EXTERN GVariant* _settings_model_get_folder_properties (SettingsModel* self,
                                                 const gchar* folder_path);
VALA_EXTERN GVariant* settings_model_get_children (SettingsModel* self,
                                       const gchar* folder_path,
                                       gboolean watch,
                                       gboolean clean_watched);
VALA_EXTERN guint16* settings_model_get_sorted_context_id (SettingsModel* self,
                                               gboolean case_sensitive,
                                               gint* result_length1);
VALA_EXTERN void settings_model_keys_value_push (SettingsModel* self);
VALA_EXTERN void settings_model_key_value_push (SettingsModel* self,
                                    const gchar* key_path,
                                    guint16 key_context_id);
VALA_EXTERN void settings_model_clean_watched_keys (SettingsModel* self);
VALA_EXTERN void settings_model_copy_action_called (SettingsModel* self);
VALA_EXTERN gboolean settings_model_get_object (SettingsModel* self,
                                    const gchar* path,
                                    guint16* context_id,
                                    gchar** name,
                                    gboolean watch);
VALA_EXTERN gchar* settings_model_get_fallback_path (SettingsModel* self,
                                         const gchar* path);
VALA_EXTERN gchar* settings_model_get_startup_path_fallback (SettingsModel* self,
                                                 const gchar* path);
VALA_EXTERN guint16 settings_model_get_fallback_context (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 context_id,
                                             const gchar* schema_id);
VALA_EXTERN void settings_model_set_gsettings_key_value (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 gkey_context_id,
                                             GVariant* key_value);
VALA_EXTERN void settings_model_set_key_to_default (SettingsModel* self,
                                        const gchar* key_path,
                                        guint16 gkey_context_id);
VALA_EXTERN void settings_model_set_dconf_key_value (SettingsModel* self,
                                         const gchar* key_path,
                                         GVariant* key_value);
VALA_EXTERN void settings_model_erase_key (SettingsModel* self,
                               const gchar* key_path);
VALA_EXTERN void settings_model_apply_key_value_changes (SettingsModel* self,
                                             GHashTable* changes);
VALA_EXTERN gboolean settings_model_key_exists (SettingsModel* self,
                                    const gchar* key_path,
                                    guint16 key_context_id);
VALA_EXTERN gboolean settings_model_key_has_schema (SettingsModel* self,
                                        const gchar* key_path);
VALA_EXTERN gboolean settings_model_is_key_ghost (SettingsModel* self,
                                      const gchar* key_path);
VALA_EXTERN GVariant* settings_model_get_folder_properties (SettingsModel* self,
                                                const gchar* folder_path);
VALA_EXTERN GVariant* settings_model_get_key_properties (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 key_context_id,
                                             guint16 query);
VALA_EXTERN gchar* settings_model_get_suggested_key_copy_text (SettingsModel* self,
                                                   const gchar* key_path,
                                                   guint16 key_context_id);
VALA_EXTERN SettingsModel* settings_model_new (void);
VALA_EXTERN SettingsModel* settings_model_construct (GType object_type);
static GType settings_model_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
settings_model_core_get_instance_private (SettingsModelCore* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsModelCore_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static guint
_settings_model_core_contexts_hashtable_2_lambda35_ (guint16 a)
{
	guint result;
	result = (guint) a;
	return result;
}

static guint
__settings_model_core_contexts_hashtable_2_lambda35__ghash_func (gconstpointer key)
{
	guint result;
	result = _settings_model_core_contexts_hashtable_2_lambda35_ ((guint16) ((guintptr) key));
	return result;
}

static gboolean
_settings_model_core_contexts_hashtable_2_lambda36_ (guint16 a,
                                                     guint16 b)
{
	gboolean result;
	result = a == b;
	return result;
}

static gboolean
__settings_model_core_contexts_hashtable_2_lambda36__gequal_func (gconstpointer a,
                                                                  gconstpointer b)
{
	gboolean result;
	result = _settings_model_core_contexts_hashtable_2_lambda36_ ((guint16) ((guintptr) a), (guint16) ((guintptr) b));
	return result;
}

void
_settings_model_core_refresh_relocatable_schema_paths (SettingsModelCore* self,
                                                       gboolean user_schemas,
                                                       gboolean built_in_schemas,
                                                       gboolean internal_schemas,
                                                       gboolean startup_schemas,
                                                       GVariant* user_paths_variant)
{
	SourceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_paths_variant != NULL);
	_tmp0_ = self->priv->source_manager;
	source_manager_refresh_relocatable_schema_paths (_tmp0_, user_schemas, built_in_schemas, internal_schemas, startup_schemas, user_paths_variant);
}

void
_settings_model_core_add_mapping (SettingsModelCore* self,
                                  const gchar* schema,
                                  const gchar* folder_path)
{
	SourceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (folder_path != NULL);
	_tmp0_ = self->priv->source_manager;
	source_manager_add_mapping (_tmp0_, schema, folder_path);
}

static void
__lambda96_ (SettingsModelCore* self,
             GHashTable* modified_path_specs)
{
	g_return_if_fail (modified_path_specs != NULL);
	self->priv->paths_has_changed = TRUE;
	g_signal_emit (self, settings_model_core_signals[SETTINGS_MODEL_CORE_PATHS_CHANGED_SIGNAL], 0, modified_path_specs, FALSE);
}

static void
___lambda96__source_manager_paths_changed (SourceManager* _sender,
                                           GHashTable* modified_path_specs,
                                           gpointer self)
{
	__lambda96_ ((SettingsModelCore*) self, modified_path_specs);
}

static gboolean
__lambda97_ (SettingsModelCore* self)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_refresh_source;
	if (_tmp0_) {
		SourceManager* _tmp1_;
		_tmp1_ = self->priv->source_manager;
		source_manager_refresh_schema_source (_tmp1_);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda97__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda97_ ((SettingsModelCore*) self);
	return result;
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
__lambda98_ (SettingsModelCore* self,
             DConfClient* client,
             const gchar* prefix,
             gchar** changes,
             const gchar* tag)
{
	gboolean _tmp0_ = FALSE;
	gboolean internal_changes = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GHashTable* modified_path_specs = NULL;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	GHashTableIter iter = {0};
	GHashTable* _tmp20_;
	GHashTableIter _tmp21_ = {0};
	gchar* path_spec = NULL;
	GHashTable* _tmp29_;
	g_return_if_fail (client != NULL);
	g_return_if_fail (prefix != NULL);
	if (self->copy_action) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->gsettings_change;
	}
	internal_changes = _tmp0_;
	if (self->copy_action) {
		self->copy_action = FALSE;
	}
	if (self->priv->gsettings_change) {
		self->priv->gsettings_change = FALSE;
	}
	_tmp3_ = self->priv->last_change_tag;
	if (_tmp3_ != NULL) {
		_tmp2_ = tag != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->last_change_tag;
		_tmp1_ = g_strcmp0 ((const gchar*) _tmp4_, (const gchar*) tag) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_g_free0 (self->priv->last_change_tag);
		self->priv->last_change_tag = NULL;
		internal_changes = TRUE;
	}
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, NULL, _g_free0_);
	modified_path_specs = _tmp7_;
	_tmp8_ = modified_path_specs;
	_tmp9_ = g_strdup (prefix);
	g_hash_table_add (_tmp8_, _tmp9_);
	{
		gchar** change_collection = NULL;
		gint change_collection_length1 = 0;
		gint _change_collection_size_ = 0;
		gint change_it = 0;
		change_collection = changes;
		change_collection_length1 = _vala_array_length (changes);
		for (change_it = 0; change_it < change_collection_length1; change_it = change_it + 1) {
			gchar* _tmp10_;
			gchar* change = NULL;
			_tmp10_ = g_strdup (change_collection[change_it]);
			change = _tmp10_;
			{
				gchar* item_path = NULL;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = change;
				_tmp12_ = g_strconcat (prefix, _tmp11_, NULL);
				item_path = _tmp12_;
				_tmp13_ = item_path;
				if (model_utils_is_key_path (_tmp13_)) {
					GHashTable* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = modified_path_specs;
					_tmp15_ = item_path;
					_tmp16_ = model_utils_get_parent_path (_tmp15_);
					g_hash_table_add (_tmp14_, _tmp16_);
				} else {
					GHashTable* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = modified_path_specs;
					_tmp18_ = item_path;
					_tmp19_ = g_strdup (_tmp18_);
					g_hash_table_add (_tmp17_, _tmp19_);
				}
				_g_free0 (item_path);
				_g_free0 (change);
			}
		}
	}
	_tmp20_ = modified_path_specs;
	g_hash_table_iter_init (&_tmp21_, _tmp20_);
	iter = _tmp21_;
	while (TRUE) {
		gconstpointer _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		SourceManager* _tmp25_;
		SchemaPathTree* _tmp26_;
		SchemaPathTree* _tmp27_;
		const gchar* _tmp28_;
		_tmp22_ = _vala_hash_set_next_value (&iter);
		_tmp23_ = g_strdup ((const gchar*) _tmp22_);
		_g_free0 (path_spec);
		path_spec = _tmp23_;
		_tmp24_ = path_spec;
		if (!(_tmp24_ != NULL)) {
			break;
		}
		_tmp25_ = self->priv->source_manager;
		_tmp26_ = source_manager_get_cached_schemas (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = path_spec;
		if (schema_path_tree_get_schema_count (_tmp27_, (const gchar*) _tmp28_) > ((guint) 0)) {
			g_hash_table_iter_remove (&iter);
		}
	}
	_tmp29_ = modified_path_specs;
	g_signal_emit (self, settings_model_core_signals[SETTINGS_MODEL_CORE_PATHS_CHANGED_SIGNAL], 0, _tmp29_, internal_changes);
	_g_free0 (path_spec);
	_g_hash_table_unref0 (modified_path_specs);
}

static void
___lambda98__dconf_client_changed (DConfClient* _sender,
                                   const gchar* prefix,
                                   gchar** changes,
                                   const gchar* tag,
                                   gpointer self)
{
	__lambda98_ ((SettingsModelCore*) self, _sender, prefix, changes, tag);
}

void
_settings_model_core_finalize_model (SettingsModelCore* self)
{
	SourceManager* _tmp0_;
	SourceManager* _tmp1_;
	DConfClient* _tmp2_;
	DConfClient* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_manager;
	g_signal_connect_object (_tmp0_, "paths-changed", (GCallback) ___lambda96__source_manager_paths_changed, self, 0);
	_tmp1_ = self->priv->source_manager;
	source_manager_refresh_schema_source (_tmp1_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3000, ___lambda97__gsource_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->client;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) ___lambda98__dconf_client_changed, self, 0);
	_tmp3_ = self->priv->client;
	dconf_client_watch_sync (_tmp3_, "/");
}

static Directory*
settings_model_core_get_directory (SettingsModelCore* self,
                                   const gchar* path)
{
	guint schemas_count = 0U;
	guint subpaths_count = 0U;
	SourceManager* _tmp1_;
	SchemaPathTree* _tmp2_;
	SchemaPathTree* _tmp3_;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	Directory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	if (g_strcmp0 (path, "/") == 0) {
		Directory* _tmp0_;
		_tmp0_ = directory_new ("/", "/");
		result = _tmp0_;
		return result;
	}
	schemas_count = (guint) 0;
	subpaths_count = (guint) 0;
	_tmp1_ = self->priv->source_manager;
	_tmp2_ = source_manager_get_cached_schemas (_tmp1_);
	_tmp3_ = _tmp2_;
	schema_path_tree_get_content_count (_tmp3_, path, &_tmp4_, &_tmp5_);
	schemas_count = _tmp4_;
	subpaths_count = _tmp5_;
	if ((schemas_count + subpaths_count) > ((guint) 0)) {
		_tmp6_ = TRUE;
	} else {
		DConfClient* _tmp7_;
		gint _tmp8_ = 0;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp7_ = self->priv->client;
		_tmp9_ = dconf_client_list (_tmp7_, path, &_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _tmp8_;
		_tmp6_ = _tmp8_ > 0;
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	}
	if (_tmp6_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		Directory* _tmp13_;
		Directory* _tmp14_;
		_tmp11_ = model_utils_get_name (path);
		_tmp12_ = _tmp11_;
		_tmp13_ = directory_new (path, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		result = _tmp14_;
		return result;
	}
	result = NULL;
	return result;
}

static GListStore*
settings_model_core_get_children_as_liststore (SettingsModelCore* self,
                                               const gchar* folder_path)
{
	GListStore* key_model = NULL;
	GListStore* _tmp0_;
	Directory* dir = NULL;
	Directory* _tmp1_;
	Directory* _tmp2_;
	gboolean multiple_schemas = FALSE;
	GListStore* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GListStore* _tmp5_;
	GListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_tmp0_ = g_list_store_new (TYPE_SETTING_OBJECT);
	key_model = _tmp0_;
	_tmp1_ = settings_model_core_get_directory (self, folder_path);
	dir = _tmp1_;
	_tmp2_ = dir;
	if (_tmp2_ == NULL) {
		result = key_model;
		_g_object_unref0 (dir);
		return result;
	}
	_tmp3_ = key_model;
	settings_model_core_lookup_gsettings (self, folder_path, _tmp3_, &_tmp4_);
	multiple_schemas = _tmp4_;
	_tmp5_ = key_model;
	settings_model_core_create_dconf_keys (self, folder_path, _tmp5_);
	result = key_model;
	_g_object_unref0 (dir);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GVariant*
_settings_model_core_get_children (SettingsModelCore* self,
                                   const gchar* folder_path,
                                   gboolean watch,
                                   gboolean clean_watched)
{
	GListStore* list_store = NULL;
	GListStore* _tmp0_;
	guint n_items = 0U;
	GListStore* _tmp1_;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp2_;
	GVariantType* _tmp3_;
	GVariantBuilder* _tmp4_;
	GVariantBuilder* _tmp5_;
	guint position = 0U;
	GObject* object = NULL;
	GListStore* _tmp6_;
	GObject* _tmp7_;
	GVariantBuilder* _tmp79_;
	GVariant* _tmp80_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	if (clean_watched) {
		_settings_model_core_clean_watched_keys (self);
	}
	_tmp0_ = settings_model_core_get_children_as_liststore (self, folder_path);
	list_store = _tmp0_;
	_tmp1_ = list_store;
	n_items = g_list_model_get_n_items ((GListModel*) _tmp1_);
	if (n_items == ((guint) 0)) {
		result = NULL;
		_g_object_unref0 (list_store);
		return result;
	}
	_tmp2_ = g_variant_type_new ("a(qs)");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_builder_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_type_free0 (_tmp3_);
	builder = _tmp5_;
	position = (guint) 0;
	_tmp6_ = list_store;
	_tmp7_ = g_list_model_get_item ((GListModel*) _tmp6_, (guint) 0);
	object = _tmp7_;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			SettingObject* base_object = NULL;
			GObject* _tmp10_;
			SettingObject* _tmp11_;
			SettingObject* _tmp12_;
			guint _tmp76_;
			GListStore* _tmp77_;
			GObject* _tmp78_;
			if (!_tmp8_) {
				GObject* _tmp9_;
				_tmp9_ = object;
				if (!(_tmp9_ != NULL)) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), TYPE_SETTING_OBJECT, SettingObject));
			base_object = _tmp11_;
			_tmp12_ = base_object;
			if (IS_KEY (_tmp12_)) {
				GVariantBuilder* _tmp14_;
				SettingObject* _tmp15_;
				SettingObject* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				if (watch) {
					SettingObject* _tmp13_;
					_tmp13_ = base_object;
					settings_model_core_add_watched_key (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_KEY, Key));
				}
				_tmp14_ = builder;
				_tmp15_ = base_object;
				_tmp16_ = base_object;
				_tmp17_ = setting_object_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				g_variant_builder_add (_tmp14_, "(qs)", settings_model_core_get_context_id_from_key (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_KEY, Key)), _tmp18_, NULL);
			} else {
				SettingObject* _tmp19_;
				_tmp19_ = base_object;
				if (IS_DIRECTORY (_tmp19_)) {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_use_shortpaths;
					if (!_tmp20_) {
						GVariantBuilder* _tmp21_;
						SettingObject* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						_tmp21_ = builder;
						_tmp22_ = base_object;
						_tmp23_ = setting_object_get_name (_tmp22_);
						_tmp24_ = _tmp23_;
						g_variant_builder_add (_tmp21_, "(qs)", MODEL_UTILS_folder_context_id, _tmp24_, NULL);
					} else {
						gchar* base_full_name = NULL;
						SettingObject* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						GListStore* child_list_store = NULL;
						const gchar* _tmp29_;
						GListStore* _tmp30_;
						GListStore* _tmp31_;
						_tmp25_ = base_object;
						_tmp26_ = setting_object_get_full_name (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = g_strdup (_tmp27_);
						base_full_name = _tmp28_;
						_tmp29_ = base_full_name;
						_tmp30_ = settings_model_core_get_children_as_liststore (self, _tmp29_);
						child_list_store = _tmp30_;
						_tmp31_ = child_list_store;
						if (g_list_model_get_n_items ((GListModel*) _tmp31_) != ((guint) 1)) {
							GVariantBuilder* _tmp32_;
							SettingObject* _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							_tmp32_ = builder;
							_tmp33_ = base_object;
							_tmp34_ = setting_object_get_name (_tmp33_);
							_tmp35_ = _tmp34_;
							g_variant_builder_add (_tmp32_, "(qs)", MODEL_UTILS_folder_context_id, _tmp35_, NULL);
						} else {
							SettingObject* test_object = NULL;
							GListStore* _tmp36_;
							GObject* _tmp37_;
							gchar* test_full_name = NULL;
							SettingObject* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							const gchar* _tmp42_;
							_tmp36_ = child_list_store;
							_tmp37_ = g_list_model_get_item ((GListModel*) _tmp36_, (guint) 0);
							test_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_SETTING_OBJECT, SettingObject);
							_tmp38_ = test_object;
							_tmp39_ = setting_object_get_full_name (_tmp38_);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup (_tmp40_);
							test_full_name = _tmp41_;
							_tmp42_ = test_full_name;
							if (model_utils_is_key_path (_tmp42_)) {
								GVariantBuilder* _tmp43_;
								SettingObject* _tmp44_;
								const gchar* _tmp45_;
								const gchar* _tmp46_;
								_tmp43_ = builder;
								_tmp44_ = base_object;
								_tmp45_ = setting_object_get_name (_tmp44_);
								_tmp46_ = _tmp45_;
								g_variant_builder_add (_tmp43_, "(qs)", MODEL_UTILS_folder_context_id, _tmp46_, NULL);
							} else {
								gchar* name = NULL;
								SettingObject* _tmp47_;
								const gchar* _tmp48_;
								const gchar* _tmp49_;
								gchar* _tmp50_;
								GVariantBuilder* _tmp74_;
								const gchar* _tmp75_;
								_tmp47_ = base_object;
								_tmp48_ = setting_object_get_name (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = g_strdup (_tmp49_);
								name = _tmp50_;
								{
									gboolean _tmp51_ = FALSE;
									_tmp51_ = TRUE;
									while (TRUE) {
										const gchar* _tmp55_;
										gchar* _tmp56_;
										const gchar* _tmp57_;
										SettingObject* _tmp58_;
										const gchar* _tmp59_;
										const gchar* _tmp60_;
										gchar* _tmp61_;
										gchar* _tmp62_;
										gchar* _tmp63_;
										SettingObject* _tmp64_;
										const gchar* _tmp65_;
										const gchar* _tmp66_;
										GListStore* _tmp67_;
										GListStore* _tmp68_;
										GObject* _tmp69_;
										SettingObject* _tmp70_;
										const gchar* _tmp71_;
										const gchar* _tmp72_;
										gchar* _tmp73_;
										if (!_tmp51_) {
											gboolean _tmp52_ = FALSE;
											const gchar* _tmp53_;
											_tmp53_ = test_full_name;
											if (model_utils_is_folder_path (_tmp53_)) {
												GListStore* _tmp54_;
												_tmp54_ = child_list_store;
												_tmp52_ = g_list_model_get_n_items ((GListModel*) _tmp54_) == ((guint) 1);
											} else {
												_tmp52_ = FALSE;
											}
											if (!_tmp52_) {
												break;
											}
										}
										_tmp51_ = FALSE;
										_tmp55_ = test_full_name;
										_tmp56_ = g_strdup (_tmp55_);
										_g_free0 (base_full_name);
										base_full_name = _tmp56_;
										_tmp57_ = name;
										_tmp58_ = test_object;
										_tmp59_ = setting_object_get_name (_tmp58_);
										_tmp60_ = _tmp59_;
										_tmp61_ = g_strconcat ("/", _tmp60_, NULL);
										_tmp62_ = _tmp61_;
										_tmp63_ = g_strconcat (_tmp57_, _tmp62_, NULL);
										_g_free0 (name);
										name = _tmp63_;
										_g_free0 (_tmp62_);
										_tmp64_ = test_object;
										_tmp65_ = setting_object_get_full_name (_tmp64_);
										_tmp66_ = _tmp65_;
										_tmp67_ = settings_model_core_get_children_as_liststore (self, _tmp66_);
										_g_object_unref0 (child_list_store);
										child_list_store = _tmp67_;
										_tmp68_ = child_list_store;
										_tmp69_ = g_list_model_get_item ((GListModel*) _tmp68_, (guint) 0);
										_g_object_unref0 (test_object);
										test_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, TYPE_SETTING_OBJECT, SettingObject);
										_tmp70_ = test_object;
										_tmp71_ = setting_object_get_full_name (_tmp70_);
										_tmp72_ = _tmp71_;
										_tmp73_ = g_strdup (_tmp72_);
										_g_free0 (test_full_name);
										test_full_name = _tmp73_;
									}
								}
								_tmp74_ = builder;
								_tmp75_ = name;
								g_variant_builder_add (_tmp74_, "(qs)", MODEL_UTILS_folder_context_id, _tmp75_, NULL);
								_g_free0 (name);
							}
							_g_free0 (test_full_name);
							_g_object_unref0 (test_object);
						}
						_g_object_unref0 (child_list_store);
						_g_free0 (base_full_name);
					}
				} else {
					g_assert_not_reached ();
				}
			}
			_tmp76_ = position;
			position = _tmp76_ + 1;
			_tmp77_ = list_store;
			_tmp78_ = g_list_model_get_item ((GListModel*) _tmp77_, position);
			_g_object_unref0 (object);
			object = _tmp78_;
			_g_object_unref0 (base_object);
		}
	}
	_tmp79_ = builder;
	_tmp80_ = g_variant_builder_end (_tmp79_);
	g_variant_ref_sink (_tmp80_);
	result = _tmp80_;
	_g_object_unref0 (object);
	_g_variant_builder_unref0 (builder);
	_g_object_unref0 (list_store);
	return result;
}

gboolean
_settings_model_core_get_object (SettingsModelCore* self,
                                 const gchar* path,
                                 guint16* context_id,
                                 gchar** name,
                                 gboolean watch)
{
	guint16 _vala_context_id = 0U;
	gchar* _vala_name = NULL;
	SettingObject* object = NULL;
	gboolean is_folder_path = FALSE;
	SettingObject* _tmp2_;
	gboolean _tmp4_ = FALSE;
	SettingObject* _tmp7_;
	SettingObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	is_folder_path = model_utils_is_folder_path (path);
	if (is_folder_path) {
		Directory* _tmp0_;
		_tmp0_ = settings_model_core_get_directory (self, path);
		_g_object_unref0 (object);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SETTING_OBJECT, SettingObject);
	} else {
		Key* _tmp1_;
		_tmp1_ = settings_model_core_get_key (self, path, "");
		_g_object_unref0 (object);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SETTING_OBJECT, SettingObject);
	}
	_tmp2_ = object;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		if (is_folder_path) {
			_vala_context_id = MODEL_UTILS_folder_context_id;
		} else {
			_vala_context_id = MODEL_UTILS_undefined_context_id;
		}
		_tmp3_ = g_strdup ("");
		_g_free0 (_vala_name);
		_vala_name = _tmp3_;
		result = FALSE;
		_g_object_unref0 (object);
		if (context_id) {
			*context_id = _vala_context_id;
		}
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	if (watch) {
		SettingObject* _tmp5_;
		_tmp5_ = object;
		_tmp4_ = IS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SETTING_OBJECT, SettingObject));
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		SettingObject* _tmp6_;
		_tmp6_ = object;
		settings_model_core_add_watched_key (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_SETTING_OBJECT, SettingObject), TYPE_KEY, Key));
	}
	_tmp7_ = object;
	_vala_context_id = settings_model_core_get_context_id_from_object (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SETTING_OBJECT, SettingObject));
	_tmp8_ = object;
	_tmp9_ = setting_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_SETTING_OBJECT, SettingObject));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala_name);
	_vala_name = _tmp11_;
	result = TRUE;
	_g_object_unref0 (object);
	if (context_id) {
		*context_id = _vala_context_id;
	}
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}

gboolean
_settings_model_core_key_exists (SettingsModelCore* self,
                                 const gchar* key_path,
                                 guint16 key_context_id)
{
	Key* key = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Key* _tmp2_;
	Key* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_tmp0_ = settings_model_core_get_key_context_from_id (self, key_context_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = settings_model_core_get_key (self, key_path, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	key = _tmp3_;
	result = key != NULL;
	_g_object_unref0 (key);
	return result;
}

gboolean
_settings_model_core_key_exists_2 (SettingsModelCore* self,
                                   const gchar* key_path)
{
	Key* key = NULL;
	Key* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_tmp0_ = settings_model_core_get_key (self, key_path, "");
	key = _tmp0_;
	result = key != NULL;
	_g_object_unref0 (key);
	return result;
}

static Key*
settings_model_core_get_key (SettingsModelCore* self,
                             const gchar* path,
                             const gchar* context)
{
	GListStore* key_model = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GListStore* _tmp18_;
	GListStore* _tmp19_;
	GListStore* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	Key* _tmp23_;
	Key* _tmp24_;
	Key* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	if (self->priv->paths_has_changed == FALSE) {
		Key* key = NULL;
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		Key* _tmp2_;
		Key* _tmp3_;
		_tmp0_ = self->priv->saved_keys;
		_tmp1_ = g_hash_table_lookup (_tmp0_, path);
		_tmp2_ = _g_object_ref0 ((Key*) _tmp1_);
		key = _tmp2_;
		_tmp3_ = key;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			GQuark _tmp6_ = 0U;
			static GQuark _tmp5_label0 = 0;
			static GQuark _tmp5_label1 = 0;
			_tmp4_ = context;
			_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
			if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("")))) {
				switch (0) {
					default:
					{
						gboolean _tmp7_ = FALSE;
						Key* _tmp8_;
						_tmp8_ = key;
						if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_KEY, Key))) {
							_tmp7_ = TRUE;
						} else {
							_tmp7_ = !_settings_model_core_is_key_ghost (self, path);
						}
						if (_tmp7_) {
							result = key;
							return result;
						} else {
							break;
						}
					}
				}
			} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string (".dconf")))) {
				switch (0) {
					default:
					{
						gboolean _tmp9_ = FALSE;
						Key* _tmp10_;
						_tmp10_ = key;
						if (IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_KEY, Key))) {
							_tmp9_ = !_settings_model_core_is_key_ghost (self, path);
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							result = key;
							return result;
						} else {
							break;
						}
					}
				}
			} else {
				switch (0) {
					default:
					{
						gboolean _tmp11_ = FALSE;
						Key* _tmp12_;
						_tmp12_ = key;
						if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_KEY, Key))) {
							Key* _tmp13_;
							const gchar* _tmp14_;
							const gchar* _tmp15_;
							_tmp13_ = key;
							_tmp14_ = gsettings_key_get_schema_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
							_tmp15_ = _tmp14_;
							_tmp11_ = g_strcmp0 (_tmp15_, context) == 0;
						} else {
							_tmp11_ = FALSE;
						}
						if (_tmp11_) {
							result = key;
							return result;
						} else {
							break;
						}
					}
				}
			}
		}
		_g_object_unref0 (key);
	}
	_tmp16_ = model_utils_get_parent_path (path);
	_tmp17_ = _tmp16_;
	_tmp18_ = settings_model_core_get_children_as_liststore (self, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	key_model = _tmp19_;
	_tmp20_ = key_model;
	_tmp21_ = model_utils_get_name (path);
	_tmp22_ = _tmp21_;
	_tmp23_ = settings_model_core_get_key_from_path_and_name (_tmp20_, _tmp22_, context);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	result = _tmp24_;
	_g_object_unref0 (key_model);
	return result;
}

static Key*
settings_model_core_get_specific_key (SettingsModelCore* self,
                                      const gchar* key_path,
                                      guint16 key_context_id)
{
	Key* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	if (model_utils_is_dconf_context_id (key_context_id)) {
		Key* nullable_key = NULL;
		Key* _tmp0_;
		gboolean _tmp1_ = FALSE;
		Key* _tmp2_;
		Key* _tmp4_;
		Key* _tmp5_;
		_tmp0_ = settings_model_core_get_key (self, key_path, ".dconf");
		nullable_key = _tmp0_;
		_tmp2_ = nullable_key;
		if (_tmp2_ == NULL) {
			_tmp1_ = TRUE;
		} else {
			Key* _tmp3_;
			_tmp3_ = nullable_key;
			_tmp1_ = !IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_KEY, Key));
		}
		if (_tmp1_) {
			g_assert_not_reached ();
		}
		_tmp4_ = nullable_key;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_KEY, Key));
		result = _tmp5_;
		_g_object_unref0 (nullable_key);
		return result;
	} else {
		GSettingsKey* _tmp6_;
		_tmp6_ = settings_model_core_get_specific_gsettings_key (self, key_path, key_context_id);
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_KEY, Key);
		return result;
	}
}

static GSettingsKey*
settings_model_core_get_specific_gsettings_key (SettingsModelCore* self,
                                                const gchar* key_path,
                                                guint16 gkey_context_id)
{
	gchar* schema_id = NULL;
	gchar* _tmp0_;
	Key* key = NULL;
	const gchar* _tmp1_;
	Key* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Key* _tmp5_;
	Key* _tmp11_;
	GSettingsKey* _tmp12_;
	GSettingsKey* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_tmp0_ = settings_model_core_get_schema_id_from_gkey_context_id (self, gkey_context_id);
	schema_id = _tmp0_;
	_tmp1_ = schema_id;
	_tmp2_ = settings_model_core_get_key (self, key_path, _tmp1_);
	key = _tmp2_;
	_tmp5_ = key;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Key* _tmp6_;
		_tmp6_ = key;
		_tmp4_ = !IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_KEY, Key));
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		Key* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = key;
		_tmp8_ = gsettings_key_get_schema_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
		_tmp9_ = _tmp8_;
		_tmp10_ = schema_id;
		_tmp3_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
	}
	if (_tmp3_) {
		g_assert_not_reached ();
	}
	_tmp11_ = key;
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
	result = _tmp12_;
	_g_object_unref0 (key);
	_g_free0 (schema_id);
	return result;
}

static Key*
settings_model_core_get_key_from_path_and_name (GListStore* key_model,
                                                const gchar* key_name,
                                                const gchar* context)
{
	guint n_items = 0U;
	guint position = 0U;
	Key* result;
	g_return_val_if_fail (key_model != NULL, NULL);
	g_return_val_if_fail (key_name != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	n_items = g_list_model_get_n_items ((GListModel*) key_model);
	if (n_items == ((guint) 0)) {
		result = NULL;
		return result;
	}
	position = (guint) 0;
	while (TRUE) {
		SettingObject* object = NULL;
		GObject* _tmp0_;
		SettingObject* _tmp1_;
		gboolean _tmp2_ = FALSE;
		SettingObject* _tmp3_;
		guint _tmp20_;
		if (!(position < n_items)) {
			break;
		}
		_tmp0_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (key_model, g_list_store_get_type (), GListStore), position);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp1_ = object;
		if (_tmp1_ == NULL) {
			g_assert_not_reached ();
		}
		_tmp3_ = object;
		if (IS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SETTING_OBJECT, SettingObject))) {
			SettingObject* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = object;
			_tmp5_ = setting_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SETTING_OBJECT, SettingObject));
			_tmp6_ = _tmp5_;
			_tmp2_ = g_strcmp0 (_tmp6_, key_name) == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp9_ = FALSE;
			SettingObject* _tmp10_;
			gboolean _tmp16_ = FALSE;
			SettingObject* _tmp17_;
			if (g_strcmp0 (context, "") == 0) {
				SettingObject* _tmp7_;
				Key* _tmp8_;
				_tmp7_ = object;
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SETTING_OBJECT, SettingObject), TYPE_KEY, Key));
				result = _tmp8_;
				_g_object_unref0 (object);
				return result;
			}
			_tmp10_ = object;
			if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_SETTING_OBJECT, SettingObject))) {
				SettingObject* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = object;
				_tmp12_ = gsettings_key_get_schema_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SETTING_OBJECT, SettingObject), TYPE_GSETTINGS_KEY, GSettingsKey));
				_tmp13_ = _tmp12_;
				_tmp9_ = g_strcmp0 (context, _tmp13_) == 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				SettingObject* _tmp14_;
				Key* _tmp15_;
				_tmp14_ = object;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_SETTING_OBJECT, SettingObject), TYPE_KEY, Key));
				result = _tmp15_;
				_g_object_unref0 (object);
				return result;
			}
			_tmp17_ = object;
			if (IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_SETTING_OBJECT, SettingObject))) {
				_tmp16_ = g_strcmp0 (context, ".dconf") == 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				SettingObject* _tmp18_;
				Key* _tmp19_;
				_tmp18_ = object;
				_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_SETTING_OBJECT, SettingObject), TYPE_KEY, Key));
				result = _tmp19_;
				_g_object_unref0 (object);
				return result;
			}
		}
		_tmp20_ = position;
		position = _tmp20_ + 1;
		_g_object_unref0 (object);
	}
	result = NULL;
	return result;
}

static Directory*
settings_model_core_get_folder_from_path_and_name (GListStore* key_model,
                                                   const gchar* folder_name)
{
	guint position = 0U;
	guint n_items = 0U;
	Directory* result;
	g_return_val_if_fail (folder_name != NULL, NULL);
	if (key_model == NULL) {
		result = NULL;
		return result;
	}
	position = (guint) 0;
	n_items = g_list_model_get_n_items ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (key_model, g_list_store_get_type (), GListStore));
	while (TRUE) {
		SettingObject* object = NULL;
		GObject* _tmp0_;
		SettingObject* _tmp1_;
		gboolean _tmp2_ = FALSE;
		SettingObject* _tmp3_;
		guint _tmp9_;
		if (!(position < n_items)) {
			break;
		}
		_tmp0_ = g_list_model_get_object ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (key_model, g_list_store_get_type (), GListStore), position);
		object = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SETTING_OBJECT, SettingObject);
		_tmp1_ = object;
		if (_tmp1_ == NULL) {
			g_assert_not_reached ();
		}
		_tmp3_ = object;
		if (IS_DIRECTORY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SETTING_OBJECT, SettingObject))) {
			SettingObject* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = object;
			_tmp5_ = setting_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SETTING_OBJECT, SettingObject));
			_tmp6_ = _tmp5_;
			_tmp2_ = g_strcmp0 (_tmp6_, folder_name) == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			SettingObject* _tmp7_;
			Directory* _tmp8_;
			_tmp7_ = object;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SETTING_OBJECT, SettingObject), TYPE_DIRECTORY, Directory));
			result = _tmp8_;
			_g_object_unref0 (object);
			return result;
		}
		_tmp9_ = position;
		position = _tmp9_ + 1;
		_g_object_unref0 (object);
	}
	result = NULL;
	return result;
}

static guint16
settings_model_core_get_context_id_from_object (SettingsModelCore* self,
                                                SettingObject* object)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (object != NULL, 0U);
	if (IS_DIRECTORY (object)) {
		result = MODEL_UTILS_folder_context_id;
		return result;
	}
	if (IS_KEY (object)) {
		result = settings_model_core_get_context_id_from_key (self, G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_KEY, Key));
		return result;
	}
	g_assert_not_reached ();
}

static guint16
settings_model_core_get_context_id_from_key (SettingsModelCore* self,
                                             Key* key)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (key != NULL, 0U);
	if (IS_GSETTINGS_KEY (key)) {
		result = settings_model_core_get_context_id_from_gsettings_key (self, G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_GSETTINGS_KEY, GSettingsKey), TRUE);
		return result;
	}
	if (IS_DCONF_KEY (key)) {
		result = MODEL_UTILS_dconf_context_id;
		return result;
	}
	g_assert_not_reached ();
}

static gint
__lambda54_ (SettingsModelCore* self,
             guint16 a,
             guint16 b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	_tmp0_ = settings_model_core_get_schema_id_from_gkey_context_id (self, a);
	_tmp1_ = _tmp0_;
	_tmp2_ = settings_model_core_get_schema_id_from_gkey_context_id (self, b);
	_tmp3_ = _tmp2_;
	_tmp4_ = settings_model_core_sort_context_ids (_tmp1_, _tmp3_, self->priv->_case_sensitive);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
___lambda54__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda54_ ((SettingsModelCore*) self, (guint16) ((guintptr) a), (guint16) ((guintptr) b));
	return result;
}

static guint16
settings_model_core_get_context_id_from_gsettings_key (SettingsModelCore* self,
                                                       GSettingsKey* gkey,
                                                       gboolean create_context_if_needed)
{
	gchar* schema_id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint16 context_id = 0U;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (gkey != NULL, 0U);
	_tmp0_ = gsettings_key_get_schema_id (gkey);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	schema_id = _tmp2_;
	_tmp3_ = self->priv->contexts_hashtable_1;
	_tmp4_ = schema_id;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	context_id = (guint16) ((guintptr) _tmp5_);
	if (!model_utils_is_undefined_context_id (context_id)) {
		result = context_id;
		_g_free0 (schema_id);
		return result;
	}
	if (!create_context_if_needed) {
		g_assert_not_reached ();
	}
	if (self->priv->context_index == G_MAXUINT16) {
		g_warning ("dconf-model.vala:366: max number of contexts reached");
		result = self->priv->context_index;
		_g_free0 (schema_id);
		return result;
	}
	self->priv->context_index = (guint16) (self->priv->context_index + 1);
	_tmp6_ = self->priv->contexts_hashtable_1;
	_tmp7_ = schema_id;
	_tmp8_ = g_strdup (_tmp7_);
	g_hash_table_insert (_tmp6_, _tmp8_, (gpointer) ((guintptr) self->priv->context_index));
	_tmp9_ = self->priv->contexts_hashtable_2;
	_tmp10_ = schema_id;
	_tmp11_ = g_strdup (_tmp10_);
	g_hash_table_insert (_tmp9_, (gpointer) ((guintptr) self->priv->context_index), _tmp11_);
	self->priv->contexts_list = g_list_insert_sorted_with_data (self->priv->contexts_list, (gpointer) ((guintptr) self->priv->context_index), ___lambda54__gcompare_data_func, self);
	result = self->priv->context_index;
	_g_free0 (schema_id);
	return result;
}

static gchar*
settings_model_core_get_key_context_from_id (SettingsModelCore* self,
                                             guint16 context_id)
{
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (!model_utils_is_undefined_context_id (context_id), "!ModelUtils.is_undefined_context_id (context_id)", NULL);
	_vala_return_val_if_fail (!model_utils_is_folder_context_id (context_id), "!ModelUtils.is_folder_context_id (context_id)", NULL);
	_vala_return_val_if_fail (context_id != G_MAXUINT16, "context_id != uint16.MAX", NULL);
	if (model_utils_is_dconf_context_id (context_id)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (".dconf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = settings_model_core_get_schema_id_from_gkey_context_id (self, context_id);
	result = _tmp1_;
	return result;
}

static gchar*
settings_model_core_get_schema_id_from_gkey_context_id (SettingsModelCore* self,
                                                        guint16 context_id)
{
	gchar* nullable_schema_id = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (!model_utils_is_undefined_context_id (context_id), "!ModelUtils.is_undefined_context_id (context_id)", NULL);
	_vala_return_val_if_fail (!model_utils_is_folder_context_id (context_id), "!ModelUtils.is_folder_context_id (context_id)", NULL);
	_vala_return_val_if_fail (!model_utils_is_dconf_context_id (context_id), "!ModelUtils.is_dconf_context_id (context_id)", NULL);
	_vala_return_val_if_fail (context_id != G_MAXUINT16, "context_id != uint16.MAX", NULL);
	_tmp0_ = self->priv->contexts_hashtable_2;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) context_id));
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	nullable_schema_id = _tmp2_;
	if (nullable_schema_id == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = g_strdup ((const gchar*) nullable_schema_id);
	result = _tmp3_;
	_g_free0 (nullable_schema_id);
	return result;
}

guint16*
_settings_model_core_get_sorted_context_id (SettingsModelCore* self,
                                            gint* result_length1)
{
	guint length = 0U;
	GList* _tmp0_;
	guint16* contexts_array = NULL;
	guint16* _tmp1_;
	gint contexts_array_length1;
	gint _contexts_array_size_;
	guint16* _tmp7_;
	gint _tmp7__length1;
	guint16* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contexts_list;
	length = g_list_length (_tmp0_);
	_tmp1_ = g_new0 (guint16, length);
	contexts_array = _tmp1_;
	contexts_array_length1 = length;
	_contexts_array_size_ = contexts_array_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint16* _tmp4_;
				gint _tmp4__length1;
				GList* _tmp5_;
				gconstpointer _tmp6_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp4_ = contexts_array;
				_tmp4__length1 = contexts_array_length1;
				_tmp5_ = self->priv->contexts_list;
				_tmp6_ = g_list_nth_data (_tmp5_, i);
				_tmp4_[((guint16) ((guintptr) _tmp6_)) - MODEL_UTILS_special_context_id_number] = (guint16) i;
			}
		}
	}
	_tmp7_ = contexts_array;
	_tmp7__length1 = contexts_array_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SettingsModelCore* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gint
__lambda84_ (Block7Data* _data7_,
             guint16 a,
             guint16 b)
{
	SettingsModelCore* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	self = _data7_->self;
	_tmp0_ = settings_model_core_get_schema_id_from_gkey_context_id (self, a);
	_tmp1_ = _tmp0_;
	_tmp2_ = settings_model_core_get_schema_id_from_gkey_context_id (self, b);
	_tmp3_ = _tmp2_;
	_tmp4_ = settings_model_core_sort_context_ids (_tmp1_, _tmp3_, _data7_->case_sensitive);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
___lambda84__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda84_ (self, (guint16) ((guintptr) a), (guint16) ((guintptr) b));
	return result;
}

void
settings_model_core_sort_contexts_list (SettingsModelCore* self,
                                        gboolean case_sensitive)
{
	Block7Data* _data7_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->case_sensitive = case_sensitive;
	if (_data7_->case_sensitive == self->priv->_case_sensitive) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	self->priv->_case_sensitive = _data7_->case_sensitive;
	self->priv->contexts_list = g_list_sort_with_data (self->priv->contexts_list, ___lambda84__gcompare_data_func, _data7_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gint
settings_model_core_sort_context_ids (const gchar* a_str,
                                      const gchar* b_str,
                                      gboolean case_sensitive)
{
	GCompareFunc _tmp5_;
	gint result;
	g_return_val_if_fail (a_str != NULL, 0);
	g_return_val_if_fail (b_str != NULL, 0);
	if (!case_sensitive) {
		gint insensitive_sort = 0;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gint _tmp4_;
		_tmp0_ = g_utf8_casefold (a_str, (gssize) -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_utf8_casefold (b_str, (gssize) -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_utf8_collate (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		insensitive_sort = _tmp4_;
		if (insensitive_sort != 0) {
			result = insensitive_sort;
			return result;
		}
	}
	_tmp5_ = ((GCompareFunc) g_strcmp0);
	result = _tmp5_ (a_str, b_str);
	return result;
}

static gpointer
_g_settings_schema_ref0 (gpointer self)
{
	return self ? g_settings_schema_ref (self) : NULL;
}

static void
settings_model_core_lookup_gsettings (SettingsModelCore* self,
                                      const gchar* path,
                                      GListStore* key_model,
                                      gboolean* multiple_schemas)
{
	gboolean _vala_multiple_schemas = FALSE;
	SourceManager* _tmp0_;
	GHashTable* schemas = NULL;
	GHashTable* folders = NULL;
	SourceManager* _tmp1_;
	SchemaPathTree* _tmp2_;
	SchemaPathTree* _tmp3_;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GHashTable* _tmp13_;
	GList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (key_model != NULL);
	_vala_multiple_schemas = FALSE;
	_tmp0_ = self->priv->source_manager;
	if (source_manager_source_is_null (_tmp0_)) {
		if (multiple_schemas) {
			*multiple_schemas = _vala_multiple_schemas;
		}
		return;
	}
	_tmp1_ = self->priv->source_manager;
	_tmp2_ = source_manager_get_cached_schemas (_tmp1_);
	_tmp3_ = _tmp2_;
	schema_path_tree_lookup (_tmp3_, path, &_tmp4_, &_tmp5_);
	_g_hash_table_unref0 (schemas);
	schemas = _tmp4_;
	_g_hash_table_unref0 (folders);
	folders = _tmp5_;
	_tmp6_ = schemas;
	_tmp7_ = g_hash_table_size (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > ((guint) 0)) {
		GHashTable* _tmp9_;
		GList* _tmp10_;
		_tmp9_ = schemas;
		_tmp10_ = g_hash_table_get_values (_tmp9_);
		{
			GList* schema_collection = NULL;
			GList* schema_it = NULL;
			schema_collection = _tmp10_;
			for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
				GSettingsSchema* _tmp11_;
				GSettingsSchema* schema = NULL;
				_tmp11_ = _g_settings_schema_ref0 ((GSettingsSchema*) schema_it->data);
				schema = _tmp11_;
				{
					GSettingsSchema* _tmp12_;
					_tmp12_ = schema;
					settings_model_core_create_gsettings_keys (self, path, (GSettingsSchema*) _tmp12_, key_model);
					_g_settings_schema_unref0 (schema);
				}
			}
			(schema_collection == NULL) ? NULL : (schema_collection = (g_list_free (schema_collection), NULL));
		}
	}
	_tmp13_ = folders;
	_tmp14_ = g_hash_table_get_values (_tmp13_);
	{
		GList* folder_collection = NULL;
		GList* folder_it = NULL;
		folder_collection = _tmp14_;
		for (folder_it = folder_collection; folder_it != NULL; folder_it = folder_it->next) {
			gchar* _tmp15_;
			gchar* folder = NULL;
			_tmp15_ = g_strdup ((const gchar*) folder_it->data);
			folder = _tmp15_;
			{
				const gchar* _tmp16_;
				Directory* _tmp17_;
				Directory* _tmp18_;
				gboolean _tmp19_;
				_tmp16_ = folder;
				_tmp17_ = settings_model_core_get_folder_from_path_and_name (key_model, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_ == NULL;
				_g_object_unref0 (_tmp18_);
				if (_tmp19_) {
					Directory* child = NULL;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
					Directory* _tmp26_;
					Directory* _tmp27_;
					Directory* _tmp28_;
					_tmp20_ = folder;
					_tmp21_ = g_strconcat (path, _tmp20_, NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = folder;
					_tmp26_ = directory_new (_tmp24_, _tmp25_);
					_tmp27_ = _tmp26_;
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					child = _tmp27_;
					_tmp28_ = child;
					g_list_store_append (key_model, (GObject*) _tmp28_);
					_g_object_unref0 (child);
				}
				_g_free0 (folder);
			}
		}
		(folder_collection == NULL) ? NULL : (folder_collection = (g_list_free (folder_collection), NULL));
	}
	_g_hash_table_unref0 (folders);
	_g_hash_table_unref0 (schemas);
	if (multiple_schemas) {
		*multiple_schemas = _vala_multiple_schemas;
	}
}

static void
settings_model_core_create_gsettings_keys (SettingsModelCore* self,
                                           const gchar* parent_path,
                                           GSettingsSchema* settings_schema,
                                           GListStore* key_model)
{
	gchar** gsettings_key_map = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint gsettings_key_map_length1;
	gint _gsettings_key_map_size_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* settings = NULL;
	const gchar* _tmp4_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent_path != NULL);
	g_return_if_fail (settings_schema != NULL);
	g_return_if_fail (key_model != NULL);
	_tmp1_ = _tmp0_ = g_settings_schema_list_keys (settings_schema);
	gsettings_key_map = _tmp1_;
	gsettings_key_map_length1 = _vala_array_length (_tmp0_);
	_gsettings_key_map_size_ = gsettings_key_map_length1;
	_tmp2_ = g_settings_schema_get_path (settings_schema);
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ == NULL) {
		GSettings* _tmp5_;
		_tmp5_ = g_settings_new_full (settings_schema, NULL, parent_path);
		_g_object_unref0 (settings);
		settings = _tmp5_;
	} else {
		GSettings* _tmp6_;
		_tmp6_ = g_settings_new_full (settings_schema, NULL, NULL);
		_g_object_unref0 (settings);
		settings = _tmp6_;
	}
	_tmp7_ = gsettings_key_map;
	_tmp7__length1 = gsettings_key_map_length1;
	{
		gchar** key_id_collection = NULL;
		gint key_id_collection_length1 = 0;
		gint _key_id_collection_size_ = 0;
		gint key_id_it = 0;
		key_id_collection = _tmp7_;
		key_id_collection_length1 = _tmp7__length1;
		for (key_id_it = 0; key_id_it < key_id_collection_length1; key_id_it = key_id_it + 1) {
			gchar* _tmp8_;
			gchar* key_id = NULL;
			_tmp8_ = g_strdup (key_id_collection[key_id_it]);
			key_id = _tmp8_;
			{
				const gchar* _tmp9_;
				GSettings* _tmp10_;
				_tmp9_ = key_id;
				_tmp10_ = settings;
				settings_model_core_create_gsettings_key (self, parent_path, _tmp9_, settings_schema, _tmp10_, key_model);
				_g_free0 (key_id);
			}
		}
	}
	_g_object_unref0 (settings);
	_g_free0 (path);
	gsettings_key_map = (_vala_array_free (gsettings_key_map, gsettings_key_map_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
settings_model_core_create_gsettings_key (SettingsModelCore* self,
                                          const gchar* parent_path,
                                          const gchar* key_id,
                                          GSettingsSchema* settings_schema,
                                          GSettings* settings,
                                          GListStore* key_model)
{
	GSettingsSchemaKey* settings_schema_key = NULL;
	GSettingsSchemaKey* _tmp0_;
	RangeType range_type = 0;
	GSettingsSchemaKey* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	const gchar* _tmp6_;
	RangeType _tmp7_;
	gchar* type_string = NULL;
	gchar* nullable_summary = NULL;
	GSettingsSchemaKey* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* nullable_description = NULL;
	GSettingsSchemaKey* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	GVariant* default_value = NULL;
	GVariant* _tmp19_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GSettingsKey* new_key = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	GSettingsSchemaKey* _tmp29_;
	GVariant* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GSettingsKey* _tmp36_;
	GSettingsKey* _tmp37_;
	GSettingsKey* conflicting_key = NULL;
	Key* _tmp38_;
	GSettingsKey* _tmp39_;
	GSettingsKey* _tmp73_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent_path != NULL);
	g_return_if_fail (key_id != NULL);
	g_return_if_fail (settings_schema != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key_model != NULL);
	_tmp0_ = g_settings_schema_get_key (settings_schema, key_id);
	settings_schema_key = _tmp0_;
	_tmp1_ = settings_schema_key;
	_tmp2_ = g_settings_schema_key_get_range (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_get_child_value (_tmp3_, (gsize) 0);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_get_string (_tmp5_, NULL);
	_tmp7_ = range_type_get_from_string (_tmp6_);
	_g_variant_unref0 (_tmp5_);
	_g_variant_unref0 (_tmp3_);
	range_type = _tmp7_;
	switch (range_type) {
		case RANGE_TYPE_ENUM:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("<enum>");
			_g_free0 (type_string);
			type_string = _tmp8_;
			break;
		}
		case RANGE_TYPE_FLAGS:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("<flags>");
			_g_free0 (type_string);
			type_string = _tmp9_;
			break;
		}
		default:
		case RANGE_TYPE_OTHER:
		case RANGE_TYPE_RANGE:
		case RANGE_TYPE_TYPE:
		{
			GSettingsSchemaKey* _tmp10_;
			const GVariantType* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = settings_schema_key;
			_tmp11_ = g_settings_schema_key_get_value_type (_tmp10_);
			_tmp12_ = g_variant_type_dup_string (_tmp11_);
			_g_free0 (type_string);
			type_string = _tmp12_;
			break;
		}
	}
	_tmp13_ = settings_schema_key;
	_tmp14_ = g_settings_schema_key_get_summary (_tmp13_);
	_tmp15_ = g_strdup (_tmp14_);
	nullable_summary = _tmp15_;
	_tmp16_ = settings_schema_key;
	_tmp17_ = g_settings_schema_key_get_description (_tmp16_);
	_tmp18_ = g_strdup (_tmp17_);
	nullable_description = _tmp18_;
	_tmp19_ = g_settings_get_default_value (settings, key_id);
	default_value = _tmp19_;
	if (default_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp20_ = nullable_summary;
	if (_tmp20_ == NULL) {
		_tmp20_ = "";
	}
	_tmp21_ = nullable_description;
	if (_tmp21_ == NULL) {
		_tmp21_ = "";
	}
	_tmp22_ = g_settings_schema_get_id (settings_schema);
	_tmp23_ = g_settings_schema_get_path (settings_schema);
	_tmp24_ = string_strip ((const gchar*) _tmp20_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_strip ((const gchar*) _tmp21_);
	_tmp27_ = _tmp26_;
	_tmp28_ = type_string;
	_tmp29_ = settings_schema_key;
	_tmp30_ = g_settings_schema_key_get_range (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_variant_get_child_value (_tmp31_, (gsize) 1);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_variant_get_child_value (_tmp33_, (gsize) 0);
	_tmp35_ = _tmp34_;
	_tmp36_ = gsettings_key_new (parent_path, key_id, settings, _tmp22_, _tmp23_, _tmp25_, _tmp27_, _tmp28_, (GVariant*) default_value, range_type, _tmp35_);
	_tmp37_ = _tmp36_;
	_g_variant_unref0 (_tmp35_);
	_g_variant_unref0 (_tmp33_);
	_g_variant_unref0 (_tmp31_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	new_key = _tmp37_;
	_tmp38_ = settings_model_core_get_key_from_path_and_name (key_model, key_id, "");
	conflicting_key = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_GSETTINGS_KEY, GSettingsKey);
	_tmp39_ = conflicting_key;
	if (_tmp39_ != NULL) {
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		GSettingsKey* _tmp44_;
		_tmp44_ = conflicting_key;
		if (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_GSETTINGS_KEY, GSettingsKey)->key_conflict == KEY_CONFLICT_HARD) {
			_tmp43_ = TRUE;
		} else {
			GSettingsKey* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			GSettingsKey* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp45_ = new_key;
			_tmp46_ = key_get_type_string ((Key*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = conflicting_key;
			_tmp49_ = key_get_type_string ((Key*) G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp50_ = _tmp49_;
			_tmp43_ = g_strcmp0 (_tmp47_, _tmp50_) != 0;
		}
		if (_tmp43_) {
			_tmp42_ = TRUE;
		} else {
			GSettingsKey* _tmp51_;
			GVariant* _tmp52_;
			GVariant* _tmp53_;
			GSettingsKey* _tmp54_;
			GVariant* _tmp55_;
			GVariant* _tmp56_;
			_tmp51_ = new_key;
			_tmp52_ = gsettings_key_get_default_value (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = conflicting_key;
			_tmp55_ = gsettings_key_get_default_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp56_ = _tmp55_;
			_tmp42_ = !g_variant_equal (_tmp53_, _tmp56_);
		}
		if (_tmp42_) {
			_tmp41_ = TRUE;
		} else {
			GSettingsKey* _tmp57_;
			RangeType _tmp58_;
			RangeType _tmp59_;
			GSettingsKey* _tmp60_;
			RangeType _tmp61_;
			RangeType _tmp62_;
			_tmp57_ = new_key;
			_tmp58_ = gsettings_key_get_range_type (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = conflicting_key;
			_tmp61_ = gsettings_key_get_range_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp62_ = _tmp61_;
			_tmp41_ = _tmp59_ != _tmp62_;
		}
		if (_tmp41_) {
			_tmp40_ = TRUE;
		} else {
			GSettingsKey* _tmp63_;
			GVariant* _tmp64_;
			GVariant* _tmp65_;
			GSettingsKey* _tmp66_;
			GVariant* _tmp67_;
			GVariant* _tmp68_;
			_tmp63_ = new_key;
			_tmp64_ = gsettings_key_get_range_content (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = conflicting_key;
			_tmp67_ = gsettings_key_get_range_content (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp68_ = _tmp67_;
			_tmp40_ = !g_variant_equal (_tmp65_, _tmp68_);
		}
		if (_tmp40_) {
			GSettingsKey* _tmp69_;
			GSettingsKey* _tmp70_;
			_tmp69_ = conflicting_key;
			G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, TYPE_GSETTINGS_KEY, GSettingsKey)->key_conflict = KEY_CONFLICT_HARD;
			_tmp70_ = new_key;
			_tmp70_->key_conflict = KEY_CONFLICT_HARD;
		} else {
			GSettingsKey* _tmp71_;
			GSettingsKey* _tmp72_;
			_tmp71_ = conflicting_key;
			G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, TYPE_GSETTINGS_KEY, GSettingsKey)->key_conflict = KEY_CONFLICT_SOFT;
			_tmp72_ = new_key;
			_tmp72_->key_conflict = KEY_CONFLICT_SOFT;
		}
	}
	_tmp73_ = new_key;
	g_list_store_append (key_model, (GObject*) _tmp73_);
	_g_object_unref0 (conflicting_key);
	_g_object_unref0 (new_key);
	_g_variant_unref0 (default_value);
	_g_free0 (nullable_description);
	_g_free0 (nullable_summary);
	_g_free0 (type_string);
	_g_settings_schema_key_unref0 (settings_schema_key);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
settings_model_core_create_dconf_keys (SettingsModelCore* self,
                                       const gchar* parent_path,
                                       GListStore* key_model)
{
	DConfClient* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent_path != NULL);
	g_return_if_fail (key_model != NULL);
	_tmp0_ = self->priv->client;
	_tmp2_ = dconf_client_list (_tmp0_, parent_path, &_tmp1_);
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp2_;
		item_collection_length1 = _tmp1_;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			gchar* _tmp3_;
			gchar* item = NULL;
			_tmp3_ = g_strdup (item_collection[item_it]);
			item = _tmp3_;
			{
				gchar* item_path = NULL;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp4_ = item;
				_tmp5_ = g_strconcat (parent_path, _tmp4_, NULL);
				item_path = _tmp5_;
				_tmp6_ = item_path;
				if (dconf_is_dir (_tmp6_, NULL)) {
					gchar* item_name = NULL;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					Directory* _tmp10_;
					Directory* _tmp11_;
					gboolean _tmp12_;
					_tmp7_ = item;
					_tmp8_ = string_slice (_tmp7_, (glong) 0, (glong) -1);
					item_name = _tmp8_;
					_tmp9_ = item_name;
					_tmp10_ = settings_model_core_get_folder_from_path_and_name (key_model, _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_ == NULL;
					_g_object_unref0 (_tmp11_);
					if (_tmp12_) {
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						Directory* _tmp15_;
						Directory* _tmp16_;
						_tmp13_ = item_path;
						_tmp14_ = item_name;
						_tmp15_ = directory_new (_tmp13_, _tmp14_);
						_tmp16_ = _tmp15_;
						g_list_store_append (key_model, (GObject*) _tmp16_);
						_g_object_unref0 (_tmp16_);
					}
					_g_free0 (item_name);
				} else {
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_;
					_tmp18_ = item_path;
					if (dconf_is_key (_tmp18_, NULL)) {
						const gchar* _tmp19_;
						Key* _tmp20_;
						Key* _tmp21_;
						_tmp19_ = item;
						_tmp20_ = settings_model_core_get_key_from_path_and_name (key_model, _tmp19_, "");
						_tmp21_ = _tmp20_;
						_tmp17_ = _tmp21_ == NULL;
						_g_object_unref0 (_tmp21_);
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp22_ = item;
						_tmp23_ = g_strconcat (parent_path, _tmp22_, NULL);
						_tmp24_ = _tmp23_;
						_tmp25_ = item;
						settings_model_core_create_dconf_key (self, _tmp24_, _tmp25_, key_model);
						_g_free0 (_tmp24_);
					}
				}
				_g_free0 (item_path);
				_g_free0 (item);
			}
		}
		item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
settings_model_core_create_dconf_key (SettingsModelCore* self,
                                      const gchar* full_name,
                                      const gchar* key_id,
                                      GListStore* key_model)
{
	GVariant* key_value = NULL;
	DConfClient* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	DConfKey* new_key = NULL;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	DConfKey* _tmp5_;
	DConfKey* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_id != NULL);
	g_return_if_fail (key_model != NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = settings_model_core_get_dconf_key_value_or_null (full_name, _tmp0_);
	key_value = _tmp1_;
	_tmp2_ = key_value;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (key_value);
		return;
	}
	_tmp3_ = key_value;
	_tmp4_ = g_variant_get_type_string ((GVariant*) _tmp3_);
	_tmp5_ = dconf_key_new (full_name, key_id, _tmp4_);
	new_key = _tmp5_;
	_tmp6_ = new_key;
	g_list_store_append (key_model, (GObject*) _tmp6_);
	_g_object_unref0 (new_key);
	_g_variant_unref0 (key_value);
}

void
_settings_model_core_keys_value_push (SettingsModelCore* self)
{
	guint position = 0U;
	GObject* object = NULL;
	GListStore* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (self != NULL);
	position = (guint) 0;
	_tmp0_ = self->priv->watched_keys;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
	object = _tmp1_;
	while (TRUE) {
		GObject* _tmp2_;
		GObject* _tmp3_;
		guint _tmp10_;
		GListStore* _tmp11_;
		GObject* _tmp12_;
		_tmp2_ = object;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = object;
		if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject))) {
			GObject* _tmp4_;
			_tmp4_ = object;
			settings_model_core_push_gsettings_key_value (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), TYPE_GSETTINGS_KEY, GSettingsKey));
		} else {
			GObject* _tmp5_;
			_tmp5_ = object;
			if (IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject))) {
				GObject* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				DConfClient* _tmp9_;
				_tmp6_ = object;
				_tmp7_ = setting_object_get_full_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, G_TYPE_OBJECT, GObject), TYPE_KEY, Key));
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->client;
				settings_model_core_push_dconf_key_value (self, _tmp8_, _tmp9_);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp10_ = position;
		position = _tmp10_ + 1;
		_tmp11_ = self->priv->watched_keys;
		_tmp12_ = g_list_model_get_item ((GListModel*) _tmp11_, position);
		_g_object_unref0 (object);
		object = _tmp12_;
	}
	_g_object_unref0 (object);
}

void
_settings_model_core_key_value_push (SettingsModelCore* self,
                                     const gchar* key_path,
                                     guint16 key_context_id)
{
	guint position = 0U;
	GObject* object = NULL;
	GListStore* _tmp0_;
	GObject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	position = (guint) 0;
	_tmp0_ = self->priv->watched_keys;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
	object = _tmp1_;
	while (TRUE) {
		GObject* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GObject* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		guint _tmp15_;
		GListStore* _tmp16_;
		GObject* _tmp17_;
		_tmp2_ = object;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp4_ = object;
		_tmp5_ = setting_object_get_full_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), TYPE_KEY, Key));
		_tmp6_ = _tmp5_;
		if (g_strcmp0 (_tmp6_, key_path) == 0) {
			GObject* _tmp7_;
			_tmp7_ = object;
			_tmp3_ = settings_model_core_get_context_id_from_key (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject), TYPE_KEY, Key)) == key_context_id;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GObject* _tmp8_;
			_tmp8_ = object;
			if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G_TYPE_OBJECT, GObject))) {
				GObject* _tmp9_;
				_tmp9_ = object;
				settings_model_core_push_gsettings_key_value (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), TYPE_GSETTINGS_KEY, GSettingsKey));
			} else {
				GObject* _tmp10_;
				_tmp10_ = object;
				if (IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject))) {
					GObject* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					DConfClient* _tmp14_;
					_tmp11_ = object;
					_tmp12_ = setting_object_get_full_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, G_TYPE_OBJECT, GObject), TYPE_KEY, Key));
					_tmp13_ = _tmp12_;
					_tmp14_ = self->priv->client;
					settings_model_core_push_dconf_key_value (self, _tmp13_, _tmp14_);
				} else {
					g_assert_not_reached ();
				}
			}
			_g_object_unref0 (object);
			return;
		}
		_tmp15_ = position;
		position = _tmp15_ + 1;
		_tmp16_ = self->priv->watched_keys;
		_tmp17_ = g_list_model_get_item ((GListModel*) _tmp16_, position);
		_g_object_unref0 (object);
		object = _tmp17_;
	}
	_g_object_unref0 (object);
}

static void
_settings_model_core_on_gkey_value_changed_key_value_changed (Key* _sender,
                                                              gpointer self)
{
	settings_model_core_on_gkey_value_changed ((SettingsModelCore*) self, _sender);
}

static void
_settings_model_core_on_dkey_value_changed_key_value_changed (Key* _sender,
                                                              gpointer self)
{
	settings_model_core_on_dkey_value_changed ((SettingsModelCore*) self, _sender);
}

static void
settings_model_core_add_watched_key (SettingsModelCore* self,
                                     Key* key)
{
	GListStore* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	Key* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (IS_GSETTINGS_KEY (key)) {
		gulong _tmp0_;
		gsettings_key_connect_settings (G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_GSETTINGS_KEY, GSettingsKey));
		_tmp0_ = g_signal_connect_object (key, "value-changed", (GCallback) _settings_model_core_on_gkey_value_changed_key_value_changed, self, 0);
		key->key_value_changed_handler = _tmp0_;
	} else {
		if (IS_DCONF_KEY (key)) {
			DConfClient* _tmp1_;
			gulong _tmp2_;
			_tmp1_ = self->priv->client;
			dconf_key_connect_client (G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_DCONF_KEY, DConfKey), _tmp1_);
			_tmp2_ = g_signal_connect_object (key, "value-changed", (GCallback) _settings_model_core_on_dkey_value_changed_key_value_changed, self, 0);
			key->key_value_changed_handler = _tmp2_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp3_ = self->priv->watched_keys;
	g_list_store_append (_tmp3_, (GObject*) key);
	_tmp4_ = self->priv->saved_keys;
	_tmp5_ = setting_object_get_full_name ((SettingObject*) key);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = _g_object_ref0 (key);
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
}

static void
settings_model_core_on_gkey_value_changed (SettingsModelCore* self,
                                           Key* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	settings_model_core_push_gsettings_key_value (self, G_TYPE_CHECK_INSTANCE_CAST (key, TYPE_GSETTINGS_KEY, GSettingsKey));
}

static void
settings_model_core_on_dkey_value_changed (SettingsModelCore* self,
                                           Key* key)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	DConfClient* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = setting_object_get_full_name ((SettingObject*) key);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->client;
	settings_model_core_push_dconf_key_value (self, _tmp1_, _tmp2_);
}

void
_settings_model_core_clean_watched_keys (SettingsModelCore* self)
{
	guint position = 0U;
	GObject* object = NULL;
	GListStore* _tmp0_;
	GObject* _tmp1_;
	Key* key = NULL;
	GListStore* _tmp17_;
	GHashTable* _tmp18_;
	g_return_if_fail (self != NULL);
	position = (guint) 0;
	_tmp0_ = self->priv->watched_keys;
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
	object = _tmp1_;
	while (TRUE) {
		GObject* _tmp2_;
		GObject* _tmp3_;
		Key* _tmp4_;
		Key* _tmp5_;
		Key* _tmp10_;
		Key* _tmp13_;
		guint _tmp14_;
		GListStore* _tmp15_;
		GObject* _tmp16_;
		_tmp2_ = object;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = object;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), TYPE_KEY, Key));
		_g_object_unref0 (key);
		key = _tmp4_;
		_tmp5_ = key;
		if (IS_GSETTINGS_KEY (_tmp5_)) {
			Key* _tmp6_;
			_tmp6_ = key;
			gsettings_key_disconnect_settings (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_GSETTINGS_KEY, GSettingsKey));
		} else {
			Key* _tmp7_;
			_tmp7_ = key;
			if (IS_DCONF_KEY (_tmp7_)) {
				Key* _tmp8_;
				DConfClient* _tmp9_;
				_tmp8_ = key;
				_tmp9_ = self->priv->client;
				dconf_key_disconnect_client (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DCONF_KEY, DConfKey), _tmp9_);
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp10_ = key;
		if (_tmp10_->key_value_changed_handler != ((gulong) 0)) {
			Key* _tmp11_;
			Key* _tmp12_;
			_tmp11_ = key;
			_tmp12_ = key;
			g_signal_handler_disconnect ((GObject*) _tmp11_, _tmp12_->key_value_changed_handler);
		}
		_tmp13_ = key;
		_tmp13_->key_value_changed_handler = (gulong) 0;
		_tmp14_ = position;
		position = _tmp14_ + 1;
		_tmp15_ = self->priv->watched_keys;
		_tmp16_ = g_list_model_get_item ((GListModel*) _tmp15_, position);
		_g_object_unref0 (object);
		object = _tmp16_;
	}
	_tmp17_ = self->priv->watched_keys;
	g_list_store_remove_all (_tmp17_);
	_tmp18_ = self->priv->saved_keys;
	g_hash_table_remove_all (_tmp18_);
	self->priv->paths_has_changed = FALSE;
	_g_object_unref0 (key);
	_g_object_unref0 (object);
}

static inline void
settings_model_core_push_gsettings_key_value (SettingsModelCore* self,
                                              GSettingsKey* gkey)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gkey != NULL);
	_tmp0_ = setting_object_get_full_name ((SettingObject*) gkey);
	_tmp1_ = _tmp0_;
	_tmp2_ = settings_model_core_get_gsettings_key_value (gkey);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, settings_model_core_signals[SETTINGS_MODEL_CORE_GKEY_VALUE_PUSH_SIGNAL], 0, _tmp1_, settings_model_core_get_context_id_from_gsettings_key (self, gkey, FALSE), _tmp3_, settings_model_core_is_key_default (gkey));
	_g_variant_unref0 (_tmp3_);
}

static inline void
settings_model_core_push_dconf_key_value (SettingsModelCore* self,
                                          const gchar* key_path,
                                          DConfClient* client)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = settings_model_core_get_dconf_key_value_or_null (key_path, client);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, settings_model_core_signals[SETTINGS_MODEL_CORE_DKEY_VALUE_PUSH_SIGNAL], 0, key_path, _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

gchar*
_settings_model_core_get_folder_fallback_path (SettingsModelCore* self,
                                               const gchar* folder_path)
{
	gchar* fallback_path = NULL;
	gchar* _tmp0_;
	Directory* dir = NULL;
	Directory* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_tmp0_ = g_strdup (folder_path);
	fallback_path = _tmp0_;
	_tmp1_ = settings_model_core_get_directory (self, folder_path);
	dir = _tmp1_;
	while (TRUE) {
		Directory* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		Directory* _tmp6_;
		_tmp2_ = dir;
		if (!(_tmp2_ == NULL)) {
			break;
		}
		_tmp3_ = fallback_path;
		_tmp4_ = model_utils_get_parent_path (_tmp3_);
		_g_free0 (fallback_path);
		fallback_path = _tmp4_;
		_tmp5_ = fallback_path;
		_tmp6_ = settings_model_core_get_directory (self, _tmp5_);
		_g_object_unref0 (dir);
		dir = _tmp6_;
	}
	result = fallback_path;
	_g_object_unref0 (dir);
	return result;
}

gchar*
_settings_model_core_get_startup_path_fallback (SettingsModelCore* self,
                                                const gchar* path)
{
	GListStore* key_model = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GListStore* _tmp3_;
	GListStore* _tmp4_;
	Key* key = NULL;
	GListStore* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Key* _tmp8_;
	Key* _tmp9_;
	Key* _tmp10_;
	gchar* new_path = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	Directory* _tmp14_;
	Directory* _tmp15_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	if (model_utils_is_folder_path (path)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (path);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = model_utils_get_parent_path (path);
	_tmp2_ = _tmp1_;
	_tmp3_ = settings_model_core_get_children_as_liststore (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	key_model = _tmp4_;
	_tmp5_ = key_model;
	_tmp6_ = model_utils_get_name (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = settings_model_core_get_key_from_path_and_name (_tmp5_, _tmp7_, "");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	key = _tmp9_;
	_tmp10_ = key;
	if (_tmp10_ != NULL) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (path);
		result = _tmp11_;
		_g_object_unref0 (key);
		_g_object_unref0 (key_model);
		return result;
	}
	_tmp12_ = g_strconcat (path, "/", NULL);
	new_path = _tmp12_;
	_tmp13_ = new_path;
	_tmp14_ = settings_model_core_get_directory (self, _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ != NULL;
	_g_object_unref0 (_tmp15_);
	if (_tmp16_) {
		result = new_path;
		_g_object_unref0 (key);
		_g_object_unref0 (key_model);
		return result;
	}
	_tmp17_ = g_strdup (path);
	result = _tmp17_;
	_g_free0 (new_path);
	_g_object_unref0 (key);
	_g_object_unref0 (key_model);
	return result;
}

guint16
_settings_model_core_get_fallback_context (SettingsModelCore* self,
                                           const gchar* key_path,
                                           guint16 context_id,
                                           const gchar* schema_id)
{
	gchar* context = NULL;
	Key* found_object = NULL;
	const gchar* _tmp3_;
	Key* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Key* _tmp6_;
	Key* _tmp9_;
	Key* _tmp10_;
	Key* _tmp11_;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (key_path != NULL, 0U);
	g_return_val_if_fail (schema_id != NULL, 0U);
	if (g_strcmp0 (schema_id, "") != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (schema_id);
		_g_free0 (context);
		context = _tmp0_;
	} else {
		if (model_utils_is_undefined_context_id (context_id)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("");
			_g_free0 (context);
			context = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = settings_model_core_get_key_context_from_id (self, context_id);
			_g_free0 (context);
			context = _tmp2_;
		}
	}
	_tmp3_ = context;
	_tmp4_ = settings_model_core_get_key (self, key_path, _tmp3_);
	found_object = _tmp4_;
	_tmp6_ = found_object;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = context;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Key* _tmp8_;
		_tmp8_ = settings_model_core_get_key (self, key_path, "");
		_g_object_unref0 (found_object);
		found_object = _tmp8_;
	}
	_tmp9_ = found_object;
	if (_tmp9_ == NULL) {
		result = MODEL_UTILS_undefined_context_id;
		_g_object_unref0 (found_object);
		_g_free0 (context);
		return result;
	}
	_settings_model_core_clean_watched_keys (self);
	_tmp10_ = found_object;
	settings_model_core_add_watched_key (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_KEY, Key));
	_tmp11_ = found_object;
	result = settings_model_core_get_context_id_from_object (self, (SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_KEY, Key));
	_g_object_unref0 (found_object);
	_g_free0 (context);
	return result;
}

static GVariant*
settings_model_core_get_gsettings_key_value (GSettingsKey* gkey)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* result;
	g_return_val_if_fail (gkey != NULL, NULL);
	_tmp0_ = gsettings_key_get_settings (gkey);
	_tmp1_ = _tmp0_;
	_tmp2_ = setting_object_get_name ((SettingObject*) gkey);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_get_value (_tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static GVariant*
settings_model_core_get_dconf_key_value (const gchar* full_name,
                                         DConfClient* client)
{
	GVariant* key_value = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* result;
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = settings_model_core_get_dconf_key_value_or_null (full_name, client);
	key_value = _tmp0_;
	if (key_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = _g_variant_ref0 ((GVariant*) key_value);
	result = _tmp1_;
	_g_variant_unref0 (key_value);
	return result;
}

static GVariant*
settings_model_core_get_dconf_key_value_or_null (const gchar* full_name,
                                                 DConfClient* client)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = dconf_client_read (client, full_name);
	result = _tmp0_;
	return result;
}

void
_settings_model_core_set_gsettings_key_value (SettingsModelCore* self,
                                              const gchar* key_path,
                                              guint16 gkey_context_id,
                                              GVariant* key_value)
{
	gchar* schema_id = NULL;
	gchar* _tmp0_;
	Key* key = NULL;
	const gchar* _tmp1_;
	Key* _tmp2_;
	Key* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = settings_model_core_get_schema_id_from_gkey_context_id (self, gkey_context_id);
	schema_id = _tmp0_;
	_tmp1_ = schema_id;
	_tmp2_ = settings_model_core_get_key (self, key_path, _tmp1_);
	key = _tmp2_;
	_tmp3_ = key;
	if (_tmp3_ == NULL) {
		g_warning ("dconf-model.vala:752: Non-existing key gsettings set-value request.");
		settings_model_core_set_dconf_value (self, key_path, key_value);
	} else {
		Key* _tmp4_;
		_tmp4_ = key;
		if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_KEY, Key))) {
			Key* _tmp5_;
			GSettings* _tmp6_;
			GSettings* _tmp7_;
			Key* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = key;
			_tmp6_ = gsettings_key_get_settings (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp7_ = _tmp6_;
			_tmp8_ = key;
			_tmp9_ = setting_object_get_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_KEY, Key));
			_tmp10_ = _tmp9_;
			g_settings_set_value (_tmp7_, _tmp10_, key_value);
		} else {
			Key* _tmp11_;
			_tmp11_ = key;
			if (IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_KEY, Key))) {
				Key* _tmp12_;
				g_warning ("dconf-model.vala:759: Key without schema gsettings set-value request.");
				settings_model_core_set_dconf_value (self, key_path, key_value);
				_tmp12_ = key;
				g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_KEY, Key), "value-changed");
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_g_object_unref0 (key);
	_g_free0 (schema_id);
}

void
_settings_model_core_set_dconf_key_value (SettingsModelCore* self,
                                          const gchar* full_name,
                                          GVariant* key_value)
{
	Key* key = NULL;
	Key* _tmp0_;
	Key* _tmp1_;
	Key* _tmp2_;
	Key* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_tmp0_ = settings_model_core_get_key (self, full_name, "");
	key = _tmp0_;
	settings_model_core_set_dconf_value (self, full_name, key_value);
	_tmp1_ = key;
	if (_tmp1_ == NULL) {
		if (key_value == NULL) {
			g_warning ("dconf-model.vala:774: Non-existing key erase request.");
		} else {
			g_warning ("dconf-model.vala:775: Non-existing key dconf set-value request.");
		}
		_g_object_unref0 (key);
		return;
	}
	_tmp2_ = key;
	if (!IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_KEY, Key))) {
		if (key_value == NULL) {
			g_warning ("dconf-model.vala:780: Non-DConfKey key erase request.");
		} else {
			g_warning ("dconf-model.vala:781: Non-DConfKey key dconf set-value request.");
		}
	}
	_tmp3_ = key;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_KEY, Key), TYPE_KEY, Key), "value-changed");
	_g_object_unref0 (key);
}

static void
settings_model_core_set_dconf_value (SettingsModelCore* self,
                                     const gchar* full_name,
                                     GVariant* key_value)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	{
		DConfClient* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->client;
		dconf_client_write_sync (_tmp0_, full_name, key_value, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (self->priv->last_change_tag);
		self->priv->last_change_tag = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("dconf-model.vala:794: %s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
_settings_model_core_set_key_to_default (SettingsModelCore* self,
                                         const gchar* key_path,
                                         guint16 gkey_context_id)
{
	GSettingsKey* gkey = NULL;
	GSettingsKey* _tmp0_;
	GSettings* settings = NULL;
	GSettingsKey* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettingsKey* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GSettings* _tmp9_;
	GSettingsBackend* _tmp10_;
	GSettingsBackend* _tmp11_;
	GSettingsBackend* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_tmp0_ = settings_model_core_get_specific_gsettings_key (self, key_path, gkey_context_id);
	gkey = _tmp0_;
	_tmp1_ = gkey;
	_tmp2_ = gsettings_key_get_settings (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	settings = _tmp4_;
	_tmp5_ = settings;
	_tmp6_ = gkey;
	_tmp7_ = setting_object_get_name ((SettingObject*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_reset (_tmp5_, _tmp8_);
	_tmp9_ = settings;
	g_object_get (_tmp9_, "backend", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp12_));
	_tmp14_ = g_strcmp0 (_tmp13_, "GDelayedSettingsBackend") == 0;
	_g_object_unref0 (_tmp12_);
	if (_tmp14_) {
		GSettings* _tmp15_;
		GSettingsBackend* _tmp16_;
		GSettingsBackend* _tmp17_;
		GSettingsBackend* _tmp18_;
		_tmp15_ = settings;
		g_object_get (_tmp15_, "backend", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		g_settings_backend_changed (_tmp18_, key_path, NULL);
		_g_object_unref0 (_tmp18_);
	}
	_g_object_unref0 (settings);
	_g_object_unref0 (gkey);
}

static inline gboolean
settings_model_core_is_key_default (GSettingsKey* gkey)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (gkey != NULL, FALSE);
	_tmp0_ = gsettings_key_get_settings (gkey);
	_tmp1_ = _tmp0_;
	_tmp2_ = setting_object_get_name ((SettingObject*) gkey);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_get_user_value (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_variant_unref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

gboolean
_settings_model_core_key_has_schema (SettingsModelCore* self,
                                     const gchar* key_path)
{
	Key* key = NULL;
	Key* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Key* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_tmp0_ = settings_model_core_get_key (self, key_path, "");
	key = _tmp0_;
	_tmp2_ = key;
	if (_tmp2_ != NULL) {
		Key* _tmp3_;
		_tmp3_ = key;
		_tmp1_ = IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_KEY, Key));
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (key);
	return result;
}

gboolean
_settings_model_core_is_key_ghost (SettingsModelCore* self,
                                   const gchar* key_path)
{
	DConfClient* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_tmp0_ = self->priv->client;
	_tmp1_ = settings_model_core_get_dconf_key_value_or_null (key_path, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_variant_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SettingsModelCore* self;
		self = _data8_->self;
		_dconf_changeset_unref0 (_data8_->dconf_changeset);
		_g_hash_table_unref0 (_data8_->delayed_settings_hashtable);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
__lambda26_ (Block8Data* _data8_,
             const gchar* key_path,
             GVariant* planned_value)
{
	SettingsModelCore* self;
	Key* key = NULL;
	Key* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Key* _tmp2_;
	self = _data8_->self;
	g_return_if_fail (key_path != NULL);
	_tmp0_ = settings_model_core_get_key (self, key_path, "");
	key = _tmp0_;
	_tmp2_ = key;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		Key* _tmp3_;
		_tmp3_ = key;
		_tmp1_ = IS_DCONF_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_KEY, Key));
	}
	if (_tmp1_) {
		DConfChangeset* _tmp4_;
		Key* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_data8_->dconf_changeset_has_change = TRUE;
		_tmp4_ = _data8_->dconf_changeset;
		_tmp5_ = key;
		_tmp6_ = setting_object_get_full_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_KEY, Key));
		_tmp7_ = _tmp6_;
		dconf_changeset_set (_tmp4_, _tmp7_, planned_value);
	} else {
		Key* _tmp8_;
		_tmp8_ = key;
		if (IS_GSETTINGS_KEY (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_KEY, Key))) {
			gchar* key_descriptor = NULL;
			Key* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* settings_descriptor = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			GSettings* settings = NULL;
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			gconstpointer _tmp17_;
			GSettings* _tmp18_;
			GSettings* _tmp19_;
			self->priv->gsettings_change = TRUE;
			_tmp9_ = key;
			_tmp10_ = gsettings_key_get_descriptor (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp11_ = _tmp10_;
			key_descriptor = _tmp11_;
			_tmp12_ = key_descriptor;
			_tmp13_ = key_descriptor;
			_tmp14_ = string_slice (_tmp12_, (glong) 0, (glong) string_last_index_of_char (_tmp13_, (gunichar) ' ', 0));
			settings_descriptor = _tmp14_;
			_tmp15_ = _data8_->delayed_settings_hashtable;
			_tmp16_ = settings_descriptor;
			_tmp17_ = g_hash_table_lookup (_tmp15_, _tmp16_);
			_tmp18_ = _g_object_ref0 ((GSettings*) _tmp17_);
			settings = _tmp18_;
			_tmp19_ = settings;
			if (_tmp19_ == NULL) {
				Key* _tmp20_;
				GSettings* _tmp21_;
				GSettings* _tmp22_;
				GSettings* _tmp23_;
				GSettings* _tmp24_;
				GHashTable* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				GSettings* _tmp28_;
				GSettings* _tmp29_;
				_tmp20_ = key;
				_tmp21_ = gsettings_key_get_settings (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_KEY, Key), TYPE_GSETTINGS_KEY, GSettingsKey));
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (settings);
				settings = _tmp23_;
				_tmp24_ = settings;
				g_settings_delay (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_settings_get_type (), GSettings));
				_tmp25_ = _data8_->delayed_settings_hashtable;
				_tmp26_ = settings_descriptor;
				_tmp27_ = g_strdup (_tmp26_);
				_tmp28_ = settings;
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_settings_get_type (), GSettings));
				g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
			}
			if (planned_value == NULL) {
				GSettings* _tmp30_;
				Key* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				GSettings* _tmp34_;
				GSettingsBackend* _tmp35_;
				GSettingsBackend* _tmp36_;
				GSettingsBackend* _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp39_;
				_tmp30_ = settings;
				_tmp31_ = key;
				_tmp32_ = setting_object_get_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_KEY, Key));
				_tmp33_ = _tmp32_;
				g_settings_reset (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_settings_get_type (), GSettings), _tmp33_);
				_tmp34_ = settings;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_settings_get_type (), GSettings), "backend", &_tmp35_, NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = _tmp36_;
				_tmp38_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp37_));
				_tmp39_ = g_strcmp0 (_tmp38_, "GDelayedSettingsBackend") == 0;
				_g_object_unref0 (_tmp37_);
				if (_tmp39_) {
					GSettings* _tmp40_;
					GSettingsBackend* _tmp41_;
					GSettingsBackend* _tmp42_;
					GSettingsBackend* _tmp43_;
					Key* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					_tmp40_ = settings;
					g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, g_settings_get_type (), GSettings), "backend", &_tmp41_, NULL);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_;
					_tmp44_ = key;
					_tmp45_ = setting_object_get_full_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_KEY, Key));
					_tmp46_ = _tmp45_;
					g_settings_backend_changed (_tmp43_, _tmp46_, NULL);
					_g_object_unref0 (_tmp43_);
				}
			} else {
				GSettings* _tmp47_;
				Key* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp47_ = settings;
				_tmp48_ = key;
				_tmp49_ = setting_object_get_name ((SettingObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_KEY, Key));
				_tmp50_ = _tmp49_;
				g_settings_set_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, g_settings_get_type (), GSettings), _tmp50_, (GVariant*) planned_value);
			}
			_g_object_unref0 (settings);
			_g_free0 (settings_descriptor);
			_g_free0 (key_descriptor);
		} else {
			g_assert_not_reached ();
		}
	}
	_g_object_unref0 (key);
}

static void
___lambda26__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda26_ (self, (const gchar*) key, (GVariant*) value);
}

static gboolean
__lambda32_ (SettingsModelCore* self,
             const gchar* key_descriptor,
             GSettings* schema_settings)
{
	gboolean result;
	g_return_val_if_fail (key_descriptor != NULL, FALSE);
	g_return_val_if_fail (schema_settings != NULL, FALSE);
	g_settings_apply (schema_settings);
	result = TRUE;
	return result;
}

static gboolean
___lambda32__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda32_ ((SettingsModelCore*) self, (const gchar*) key, (GSettings*) value);
	return result;
}

void
_settings_model_core_apply_key_value_changes (SettingsModelCore* self,
                                              GHashTable* changes)
{
	Block8Data* _data8_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	DConfChangeset* _tmp3_;
	GHashTable* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changes != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_data8_->delayed_settings_hashtable = _tmp2_;
	_tmp3_ = dconf_changeset_new ();
	_data8_->dconf_changeset = _tmp3_;
	_data8_->dconf_changeset_has_change = FALSE;
	g_hash_table_foreach (changes, ___lambda26__gh_func, _data8_);
	_tmp4_ = _data8_->delayed_settings_hashtable;
	g_hash_table_foreach_remove (_tmp4_, ___lambda32__ghr_func, self);
	if (_data8_->dconf_changeset_has_change) {
		{
			DConfClient* _tmp5_;
			DConfChangeset* _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp5_ = self->priv->client;
			_tmp6_ = _data8_->dconf_changeset;
			dconf_client_change_sync (_tmp5_, _tmp6_, &_tmp7_, NULL, &_inner_error0_);
			_g_free0 (self->priv->last_change_tag);
			self->priv->last_change_tag = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = _error_;
			_tmp9_ = _tmp8_->message;
			g_warning ("dconf-model.vala:873: %s", _tmp9_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block8_data_unref (_data8_);
			_data8_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

GVariant*
_settings_model_core_get_key_properties (SettingsModelCore* self,
                                         const gchar* key_path,
                                         guint16 key_context_id,
                                         guint16 _query)
{
	Key* key = NULL;
	Key* _tmp0_;
	PropertyQuery query = 0U;
	gboolean all_properties_queried = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RegistryVariantDict* variantdict = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp20_ = FALSE;
	Key* _tmp35_;
	RegistryVariantDict* _tmp53_;
	GVariant* _tmp54_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_tmp0_ = settings_model_core_get_specific_key (self, key_path, key_context_id);
	key = _tmp0_;
	query = (PropertyQuery) _query;
	all_properties_queried = query == 0;
	if (all_properties_queried) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (query & PROPERTY_QUERY_HASH) == PROPERTY_QUERY_HASH;
	}
	if (_tmp2_) {
		Key* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		_tmp3_ = key;
		_tmp4_ = key_get_all_fixed_properties (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Key* _tmp6_;
		_tmp6_ = key;
		key_generate_key_fixed_properties (_tmp6_);
	}
	if (all_properties_queried) {
		Key* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		RegistryVariantDict* _tmp10_;
		_tmp7_ = key;
		_tmp8_ = key_get_all_fixed_properties (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = registry_variant_dict_new_from_aqv ((GVariant*) _tmp9_);
		_g_object_unref0 (variantdict);
		variantdict = _tmp10_;
	} else {
		RegistryVariantDict* _tmp11_;
		Key* _tmp12_;
		_tmp11_ = registry_variant_dict_new ();
		_g_object_unref0 (variantdict);
		variantdict = _tmp11_;
		_tmp12_ = key;
		key_get_key_fixed_properties (_tmp12_, query, &variantdict);
	}
	if (all_properties_queried) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = (query & PROPERTY_QUERY_HASH) == PROPERTY_QUERY_HASH;
	}
	if (_tmp13_) {
		RegistryVariantDict* _tmp14_;
		Key* _tmp15_;
		guint _tmp16_;
		guint _tmp17_;
		GVariant* _tmp18_;
		GVariant* _tmp19_;
		_tmp14_ = variantdict;
		_tmp15_ = key;
		_tmp16_ = key_get_key_hash (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_variant_new_uint32 ((guint32) _tmp17_);
		g_variant_ref_sink (_tmp18_);
		_tmp19_ = _tmp18_;
		registry_variant_dict_insert_value (_tmp14_, (guint16) PROPERTY_QUERY_HASH, _tmp19_);
		_g_variant_unref0 (_tmp19_);
	}
	if (all_properties_queried) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = (query & PROPERTY_QUERY_KEY_VALUE) == PROPERTY_QUERY_KEY_VALUE;
	}
	if (_tmp20_) {
		Key* _tmp21_;
		_tmp21_ = key;
		if (IS_GSETTINGS_KEY (_tmp21_)) {
			RegistryVariantDict* _tmp22_;
			Key* _tmp23_;
			GVariant* _tmp24_;
			GVariant* _tmp25_;
			GVariant* _tmp26_;
			GVariant* _tmp27_;
			_tmp22_ = variantdict;
			_tmp23_ = key;
			_tmp24_ = settings_model_core_get_gsettings_key_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp25_ = _tmp24_;
			_tmp26_ = g_variant_new_variant (_tmp25_);
			g_variant_ref_sink (_tmp26_);
			_tmp27_ = _tmp26_;
			registry_variant_dict_insert_value (_tmp22_, (guint16) PROPERTY_QUERY_KEY_VALUE, _tmp27_);
			_g_variant_unref0 (_tmp27_);
			_g_variant_unref0 (_tmp25_);
		} else {
			Key* _tmp28_;
			_tmp28_ = key;
			if (IS_DCONF_KEY (_tmp28_)) {
				RegistryVariantDict* _tmp29_;
				DConfClient* _tmp30_;
				GVariant* _tmp31_;
				GVariant* _tmp32_;
				GVariant* _tmp33_;
				GVariant* _tmp34_;
				_tmp29_ = variantdict;
				_tmp30_ = self->priv->client;
				_tmp31_ = settings_model_core_get_dconf_key_value (key_path, _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_variant_new_variant (_tmp32_);
				g_variant_ref_sink (_tmp33_);
				_tmp34_ = _tmp33_;
				registry_variant_dict_insert_value (_tmp29_, (guint16) PROPERTY_QUERY_KEY_VALUE, _tmp34_);
				_g_variant_unref0 (_tmp34_);
				_g_variant_unref0 (_tmp32_);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp35_ = key;
	if (IS_GSETTINGS_KEY (_tmp35_)) {
		gboolean _tmp36_ = FALSE;
		gboolean _tmp41_ = FALSE;
		if (all_properties_queried) {
			_tmp36_ = TRUE;
		} else {
			_tmp36_ = (query & PROPERTY_QUERY_KEY_CONFLICT) == PROPERTY_QUERY_KEY_CONFLICT;
		}
		if (_tmp36_) {
			RegistryVariantDict* _tmp37_;
			Key* _tmp38_;
			GVariant* _tmp39_;
			GVariant* _tmp40_;
			_tmp37_ = variantdict;
			_tmp38_ = key;
			_tmp39_ = g_variant_new_byte ((guint8) G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_GSETTINGS_KEY, GSettingsKey)->key_conflict);
			g_variant_ref_sink (_tmp39_);
			_tmp40_ = _tmp39_;
			registry_variant_dict_insert_value (_tmp37_, (guint16) PROPERTY_QUERY_KEY_CONFLICT, _tmp40_);
			_g_variant_unref0 (_tmp40_);
		}
		if (all_properties_queried) {
			_tmp41_ = TRUE;
		} else {
			_tmp41_ = (query & PROPERTY_QUERY_IS_DEFAULT) == PROPERTY_QUERY_IS_DEFAULT;
		}
		if (_tmp41_) {
			RegistryVariantDict* _tmp42_;
			Key* _tmp43_;
			GSettings* _tmp44_;
			GSettings* _tmp45_;
			Key* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			GVariant* _tmp49_;
			GVariant* _tmp50_;
			GVariant* _tmp51_;
			GVariant* _tmp52_;
			_tmp42_ = variantdict;
			_tmp43_ = key;
			_tmp44_ = gsettings_key_get_settings (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_GSETTINGS_KEY, GSettingsKey));
			_tmp45_ = _tmp44_;
			_tmp46_ = key;
			_tmp47_ = setting_object_get_name ((SettingObject*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_settings_get_user_value (_tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_variant_new_boolean (_tmp50_ == NULL);
			g_variant_ref_sink (_tmp51_);
			_tmp52_ = _tmp51_;
			registry_variant_dict_insert_value (_tmp42_, (guint16) PROPERTY_QUERY_IS_DEFAULT, _tmp52_);
			_g_variant_unref0 (_tmp52_);
			_g_variant_unref0 (_tmp50_);
		}
	}
	_tmp53_ = variantdict;
	_tmp54_ = registry_variant_dict_end (_tmp53_);
	result = _tmp54_;
	_g_object_unref0 (variantdict);
	_g_object_unref0 (key);
	return result;
}

gchar*
settings_model_core_get_suggested_gsettings_key_copy_text (SettingsModelCore* self,
                                                           const gchar* key_path,
                                                           guint16 gkey_context_id)
{
	GSettingsKey* gkey = NULL;
	GSettingsKey* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_tmp0_ = settings_model_core_get_specific_gsettings_key (self, key_path, gkey_context_id);
	gkey = _tmp0_;
	_tmp1_ = _settings_model_core_get_suggested_gsettings_key_copy_text (gkey);
	result = _tmp1_;
	_g_object_unref0 (gkey);
	return result;
}

static inline gchar*
_settings_model_core_get_suggested_gsettings_key_copy_text (GSettingsKey* gkey)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (gkey != NULL, NULL);
	_tmp0_ = gsettings_key_get_descriptor (gkey);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = settings_model_core_get_gsettings_key_value (gkey);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_print (_tmp6_, FALSE);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_variant_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp10_;
	return result;
}

gchar*
settings_model_core_get_suggested_dconf_key_copy_text (SettingsModelCore* self,
                                                       const gchar* key_path)
{
	DConfClient* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_tmp0_ = self->priv->client;
	_tmp1_ = _settings_model_core_get_suggested_dconf_key_copy_text (key_path, _tmp0_);
	result = _tmp1_;
	return result;
}

static inline gchar*
_settings_model_core_get_suggested_dconf_key_copy_text (const gchar* key_path,
                                                        DConfClient* client)
{
	GVariant* key_value = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gchar* result;
	g_return_val_if_fail (key_path != NULL, NULL);
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = settings_model_core_get_dconf_key_value_or_null (key_path, client);
	key_value = _tmp0_;
	_tmp1_ = key_value;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (_ ("%s (key erased)"), key_path);
		result = _tmp2_;
		_g_variant_unref0 (key_value);
		return result;
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GVariant* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = g_strconcat (key_path, " ", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = key_value;
		_tmp6_ = g_variant_print ((GVariant*) _tmp5_, FALSE);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		result = _tmp9_;
		_g_variant_unref0 (key_value);
		return result;
	}
}

SettingsModelCore*
settings_model_core_construct (GType object_type)
{
	SettingsModelCore * self = NULL;
	self = (SettingsModelCore*) g_object_new (object_type, NULL);
	return self;
}

static gboolean
settings_model_core_get_refresh_source (SettingsModelCore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_refresh_source;
	return result;
}

void
settings_model_core_set_refresh_source (SettingsModelCore* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_refresh_source = value;
}

static gboolean
settings_model_core_get_use_shortpaths (SettingsModelCore* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_shortpaths;
	return result;
}

void
settings_model_core_set_use_shortpaths (SettingsModelCore* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_use_shortpaths = value;
}

static void
g_cclosure_user_marshal_VOID__BOXED_BOOLEAN (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_UINT_VARIANT_BOOLEAN (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_UINT_VARIANT_BOOLEAN) (gpointer data1, const char* arg_1, guint16 arg_2, gpointer arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_VARIANT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_VARIANT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_variant (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static void
settings_model_core_class_init (SettingsModelCoreClass * klass,
                                gpointer klass_data)
{
	settings_model_core_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsModelCore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_model_core_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_settings_model_core_set_property;
	G_OBJECT_CLASS (klass)->finalize = settings_model_core_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_MODEL_CORE_REFRESH_SOURCE_PROPERTY, settings_model_core_properties[SETTINGS_MODEL_CORE_REFRESH_SOURCE_PROPERTY] = g_param_spec_boolean ("refresh-source", "refresh-source", "refresh-source", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_MODEL_CORE_USE_SHORTPATHS_PROPERTY, settings_model_core_properties[SETTINGS_MODEL_CORE_USE_SHORTPATHS_PROPERTY] = g_param_spec_boolean ("use-shortpaths", "use-shortpaths", "use-shortpaths", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	settings_model_core_signals[SETTINGS_MODEL_CORE_PATHS_CHANGED_SIGNAL] = g_signal_new ("paths-changed", TYPE_SETTINGS_MODEL_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_HASH_TABLE, G_TYPE_BOOLEAN);
	settings_model_core_signals[SETTINGS_MODEL_CORE_GKEY_VALUE_PUSH_SIGNAL] = g_signal_new ("gkey-value-push", TYPE_SETTINGS_MODEL_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_VARIANT_BOOLEAN, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_VARIANT, G_TYPE_BOOLEAN);
	settings_model_core_signals[SETTINGS_MODEL_CORE_DKEY_VALUE_PUSH_SIGNAL] = g_signal_new ("dkey-value-push", TYPE_SETTINGS_MODEL_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_VARIANT);
}

static void
settings_model_core_instance_init (SettingsModelCore * self,
                                   gpointer klass)
{
	SourceManager* _tmp0_;
	DConfClient* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GListStore* _tmp9_;
	self->priv = settings_model_core_get_instance_private (self);
	_tmp0_ = source_manager_new ();
	self->priv->source_manager = _tmp0_;
	self->priv->_refresh_source = TRUE;
	_tmp1_ = dconf_client_new ();
	self->priv->client = _tmp1_;
	self->priv->last_change_tag = NULL;
	self->copy_action = FALSE;
	self->priv->gsettings_change = FALSE;
	self->priv->_use_shortpaths = FALSE;
	self->priv->paths_has_changed = FALSE;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_object_unref0_);
	self->priv->saved_keys = _tmp4_;
	self->priv->context_index = (guint16) 2;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, NULL);
	self->priv->contexts_hashtable_1 = _tmp7_;
	_tmp8_ = g_hash_table_new_full (__settings_model_core_contexts_hashtable_2_lambda35__ghash_func, __settings_model_core_contexts_hashtable_2_lambda36__gequal_func, NULL, _g_free0_);
	self->priv->contexts_hashtable_2 = _tmp8_;
	self->priv->_case_sensitive = FALSE;
	self->priv->contexts_list = NULL;
	_tmp9_ = g_list_store_new (TYPE_KEY);
	self->priv->watched_keys = _tmp9_;
}

static void
settings_model_core_finalize (GObject * obj)
{
	SettingsModelCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS_MODEL_CORE, SettingsModelCore);
	_g_object_unref0 (self->priv->source_manager);
	_g_object_unref0 (self->priv->client);
	_g_free0 (self->priv->last_change_tag);
	_g_hash_table_unref0 (self->priv->saved_keys);
	_g_hash_table_unref0 (self->priv->contexts_hashtable_1);
	_g_hash_table_unref0 (self->priv->contexts_hashtable_2);
	(self->priv->contexts_list == NULL) ? NULL : (self->priv->contexts_list = (g_list_free (self->priv->contexts_list), NULL));
	_g_object_unref0 (self->priv->watched_keys);
	G_OBJECT_CLASS (settings_model_core_parent_class)->finalize (obj);
}

static GType
settings_model_core_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsModelCoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_model_core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsModelCore), 0, (GInstanceInitFunc) settings_model_core_instance_init, NULL };
	GType settings_model_core_type_id;
	settings_model_core_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsModelCore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SettingsModelCore_private_offset = g_type_add_instance_private (settings_model_core_type_id, sizeof (SettingsModelCorePrivate));
	return settings_model_core_type_id;
}

GType
settings_model_core_get_type (void)
{
	static volatile gsize settings_model_core_type_id__once = 0;
	if (g_once_init_enter (&settings_model_core_type_id__once)) {
		GType settings_model_core_type_id;
		settings_model_core_type_id = settings_model_core_get_type_once ();
		g_once_init_leave (&settings_model_core_type_id__once, settings_model_core_type_id);
	}
	return settings_model_core_type_id__once;
}

static void
_vala_settings_model_core_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SettingsModelCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS_MODEL_CORE, SettingsModelCore);
	switch (property_id) {
		case SETTINGS_MODEL_CORE_REFRESH_SOURCE_PROPERTY:
		g_value_set_boolean (value, settings_model_core_get_refresh_source (self));
		break;
		case SETTINGS_MODEL_CORE_USE_SHORTPATHS_PROPERTY:
		g_value_set_boolean (value, settings_model_core_get_use_shortpaths (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_settings_model_core_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SettingsModelCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SETTINGS_MODEL_CORE, SettingsModelCore);
	switch (property_id) {
		case SETTINGS_MODEL_CORE_REFRESH_SOURCE_PROPERTY:
		settings_model_core_set_refresh_source (self, g_value_get_boolean (value));
		break;
		case SETTINGS_MODEL_CORE_USE_SHORTPATHS_PROPERTY:
		settings_model_core_set_use_shortpaths (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
settings_model_refresh_relocatable_schema_paths (SettingsModel* self,
                                                 gboolean user_schemas,
                                                 gboolean built_in_schemas,
                                                 gboolean internal_schemas,
                                                 gboolean startup_schemas,
                                                 GVariant* user_paths_variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (user_paths_variant != NULL);
	_settings_model_core_refresh_relocatable_schema_paths ((SettingsModelCore*) self, user_schemas, built_in_schemas, internal_schemas, startup_schemas, user_paths_variant);
}

void
settings_model_add_mapping (SettingsModel* self,
                            const gchar* schema,
                            const gchar* folder_path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema != NULL);
	g_return_if_fail (folder_path != NULL);
	_vala_return_if_fail (model_utils_is_folder_path (folder_path), "ModelUtils.is_folder_path (folder_path)");
	_settings_model_core_add_mapping ((SettingsModelCore*) self, schema, folder_path);
}

void
settings_model_finalize_model (SettingsModel* self)
{
	g_return_if_fail (self != NULL);
	_settings_model_core_finalize_model ((SettingsModelCore*) self);
}

GVariant*
_settings_model_get_folder_properties (SettingsModel* self,
                                       const gchar* folder_path)
{
	RegistryVariantDict* variantdict = NULL;
	RegistryVariantDict* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_tmp0_ = registry_variant_dict_new ();
	variantdict = _tmp0_;
	_tmp1_ = model_utils_get_name (folder_path);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_new_string (_tmp2_);
	g_variant_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	registry_variant_dict_insert_value (variantdict, (guint16) PROPERTY_QUERY_KEY_NAME, _tmp4_);
	_g_variant_unref0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = registry_variant_dict_end (variantdict);
	result = _tmp5_;
	_g_object_unref0 (variantdict);
	return result;
}

GVariant*
settings_model_get_children (SettingsModel* self,
                             const gchar* folder_path,
                             gboolean watch,
                             gboolean clean_watched)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_vala_return_val_if_fail (model_utils_is_folder_path (folder_path), "ModelUtils.is_folder_path (folder_path)", NULL);
	_tmp0_ = _settings_model_core_get_children ((SettingsModelCore*) self, folder_path, watch, clean_watched);
	result = _tmp0_;
	return result;
}

guint16*
settings_model_get_sorted_context_id (SettingsModel* self,
                                      gboolean case_sensitive,
                                      gint* result_length1)
{
	gint _tmp0_ = 0;
	guint16* _tmp1_;
	guint16* _tmp2_;
	gint _tmp2__length1;
	guint16* result;
	g_return_val_if_fail (self != NULL, NULL);
	settings_model_core_sort_contexts_list ((SettingsModelCore*) self, case_sensitive);
	_tmp1_ = _settings_model_core_get_sorted_context_id ((SettingsModelCore*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
settings_model_keys_value_push (SettingsModel* self)
{
	g_return_if_fail (self != NULL);
	_settings_model_core_keys_value_push ((SettingsModelCore*) self);
}

void
settings_model_key_value_push (SettingsModel* self,
                               const gchar* key_path,
                               guint16 key_context_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_vala_return_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)");
	_vala_return_if_fail (!model_utils_is_undefined_context_id (key_context_id), "!ModelUtils.is_undefined_context_id (key_context_id)");
	_vala_return_if_fail (!model_utils_is_folder_context_id (key_context_id), "!ModelUtils.is_folder_context_id (key_context_id)");
	_settings_model_core_key_value_push ((SettingsModelCore*) self, key_path, key_context_id);
}

void
settings_model_clean_watched_keys (SettingsModel* self)
{
	g_return_if_fail (self != NULL);
	_settings_model_core_clean_watched_keys ((SettingsModelCore*) self);
}

void
settings_model_copy_action_called (SettingsModel* self)
{
	g_return_if_fail (self != NULL);
	((SettingsModelCore*) self)->copy_action = TRUE;
}

gboolean
settings_model_get_object (SettingsModel* self,
                           const gchar* path,
                           guint16* context_id,
                           gchar** name,
                           gboolean watch)
{
	guint16 _vala_context_id = 0U;
	gchar* _vala_name = NULL;
	guint16 _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp2_ = _settings_model_core_get_object ((SettingsModelCore*) self, path, &_tmp0_, &_tmp1_, watch);
	_vala_context_id = _tmp0_;
	_g_free0 (_vala_name);
	_vala_name = _tmp1_;
	result = _tmp2_;
	if (context_id) {
		*context_id = _vala_context_id;
	}
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}

gchar*
settings_model_get_fallback_path (SettingsModel* self,
                                  const gchar* path)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	if (model_utils_is_folder_path (path)) {
		gchar* _tmp0_;
		_tmp0_ = _settings_model_core_get_folder_fallback_path ((SettingsModelCore*) self, path);
		result = _tmp0_;
		return result;
	}
	if (_settings_model_core_key_exists_2 ((SettingsModelCore*) self, path)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (path);
		result = _tmp1_;
		return result;
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = model_utils_get_parent_path (path);
		_tmp3_ = _tmp2_;
		_tmp4_ = _settings_model_core_get_folder_fallback_path ((SettingsModelCore*) self, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		result = _tmp5_;
		return result;
	}
}

gchar*
settings_model_get_startup_path_fallback (SettingsModel* self,
                                          const gchar* path)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = _settings_model_core_get_startup_path_fallback ((SettingsModelCore*) self, path);
	result = _tmp0_;
	return result;
}

guint16
settings_model_get_fallback_context (SettingsModel* self,
                                     const gchar* key_path,
                                     guint16 context_id,
                                     const gchar* schema_id)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (key_path != NULL, 0U);
	g_return_val_if_fail (schema_id != NULL, 0U);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", 0U);
	result = _settings_model_core_get_fallback_context ((SettingsModelCore*) self, key_path, context_id, schema_id);
	return result;
}

void
settings_model_set_gsettings_key_value (SettingsModel* self,
                                        const gchar* key_path,
                                        guint16 gkey_context_id,
                                        GVariant* key_value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	g_return_if_fail (key_value != NULL);
	_vala_return_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)");
	_vala_return_if_fail (!model_utils_is_undefined_context_id (gkey_context_id), "!ModelUtils.is_undefined_context_id (gkey_context_id)");
	_vala_return_if_fail (!model_utils_is_folder_context_id (gkey_context_id), "!ModelUtils.is_folder_context_id (gkey_context_id)");
	_vala_return_if_fail (!model_utils_is_dconf_context_id (gkey_context_id), "!ModelUtils.is_dconf_context_id (gkey_context_id)");
	_settings_model_core_set_gsettings_key_value ((SettingsModelCore*) self, key_path, gkey_context_id, key_value);
}

void
settings_model_set_key_to_default (SettingsModel* self,
                                   const gchar* key_path,
                                   guint16 gkey_context_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_vala_return_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)");
	_vala_return_if_fail (!model_utils_is_undefined_context_id (gkey_context_id), "!ModelUtils.is_undefined_context_id (gkey_context_id)");
	_vala_return_if_fail (!model_utils_is_folder_context_id (gkey_context_id), "!ModelUtils.is_folder_context_id (gkey_context_id)");
	_vala_return_if_fail (!model_utils_is_dconf_context_id (gkey_context_id), "!ModelUtils.is_dconf_context_id (gkey_context_id)");
	_settings_model_core_set_key_to_default ((SettingsModelCore*) self, key_path, gkey_context_id);
}

void
settings_model_set_dconf_key_value (SettingsModel* self,
                                    const gchar* key_path,
                                    GVariant* key_value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	g_return_if_fail (key_value != NULL);
	_vala_return_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)");
	_settings_model_core_set_dconf_key_value ((SettingsModelCore*) self, key_path, key_value);
}

void
settings_model_erase_key (SettingsModel* self,
                          const gchar* key_path)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_vala_return_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)");
	_settings_model_core_set_dconf_key_value ((SettingsModelCore*) self, key_path, NULL);
}

void
settings_model_apply_key_value_changes (SettingsModel* self,
                                        GHashTable* changes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (changes != NULL);
	_settings_model_core_apply_key_value_changes ((SettingsModelCore*) self, changes);
}

gboolean
settings_model_key_exists (SettingsModel* self,
                           const gchar* key_path,
                           guint16 key_context_id)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", FALSE);
	_vala_return_val_if_fail (!model_utils_is_undefined_context_id (key_context_id), "!ModelUtils.is_undefined_context_id (key_context_id)", FALSE);
	_vala_return_val_if_fail (!model_utils_is_folder_context_id (key_context_id), "!ModelUtils.is_folder_context_id (key_context_id)", FALSE);
	result = _settings_model_core_key_exists ((SettingsModelCore*) self, key_path, key_context_id);
	return result;
}

gboolean
settings_model_key_has_schema (SettingsModel* self,
                               const gchar* key_path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", FALSE);
	result = _settings_model_core_key_has_schema ((SettingsModelCore*) self, key_path);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
settings_model_is_key_ghost (SettingsModel* self,
                             const gchar* key_path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", FALSE);
	if (_settings_model_core_key_has_schema ((SettingsModelCore*) self, key_path)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = string_to_string (key_path);
		_tmp1_ = g_strconcat ("Function is_key_ghost called for path:\n  ", _tmp0_, "\nbut key found there has a schema.", NULL);
		_tmp2_ = _tmp1_;
		g_warning ("dconf-model.vala:1126: %s", _tmp2_);
		_g_free0 (_tmp2_);
	}
	result = _settings_model_core_is_key_ghost ((SettingsModelCore*) self, key_path);
	return result;
}

GVariant*
settings_model_get_folder_properties (SettingsModel* self,
                                      const gchar* folder_path)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (folder_path != NULL, NULL);
	_vala_return_val_if_fail (model_utils_is_folder_path (folder_path), "ModelUtils.is_folder_path (folder_path)", NULL);
	_tmp0_ = _settings_model_get_folder_properties (self, folder_path);
	result = _tmp0_;
	return result;
}

GVariant*
settings_model_get_key_properties (SettingsModel* self,
                                   const gchar* key_path,
                                   guint16 key_context_id,
                                   guint16 query)
{
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", NULL);
	_vala_return_val_if_fail (!model_utils_is_undefined_context_id (key_context_id), "!ModelUtils.is_undefined_context_id (key_context_id)", NULL);
	_vala_return_val_if_fail (!model_utils_is_folder_context_id (key_context_id), "!ModelUtils.is_folder_context_id (key_context_id)", NULL);
	_tmp0_ = _settings_model_core_get_key_properties ((SettingsModelCore*) self, key_path, key_context_id, query);
	result = _tmp0_;
	return result;
}

gchar*
settings_model_get_suggested_key_copy_text (SettingsModel* self,
                                            const gchar* key_path,
                                            guint16 key_context_id)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_vala_return_val_if_fail (model_utils_is_key_path (key_path), "ModelUtils.is_key_path (key_path)", NULL);
	_vala_return_val_if_fail (!model_utils_is_undefined_context_id (key_context_id), "!ModelUtils.is_undefined_context_id (key_context_id)", NULL);
	_vala_return_val_if_fail (!model_utils_is_folder_context_id (key_context_id), "!ModelUtils.is_folder_context_id (key_context_id)", NULL);
	if (model_utils_is_dconf_context_id (key_context_id)) {
		gchar* _tmp0_;
		_tmp0_ = settings_model_core_get_suggested_dconf_key_copy_text ((SettingsModelCore*) self, key_path);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = settings_model_core_get_suggested_gsettings_key_copy_text ((SettingsModelCore*) self, key_path, key_context_id);
		result = _tmp1_;
		return result;
	}
}

SettingsModel*
settings_model_construct (GType object_type)
{
	SettingsModel * self = NULL;
	self = (SettingsModel*) settings_model_core_construct (object_type);
	return self;
}

SettingsModel*
settings_model_new (void)
{
	return settings_model_construct (TYPE_SETTINGS_MODEL);
}

static void
settings_model_class_init (SettingsModelClass * klass,
                           gpointer klass_data)
{
	settings_model_parent_class = g_type_class_peek_parent (klass);
}

static void
settings_model_instance_init (SettingsModel * self,
                              gpointer klass)
{
}

static GType
settings_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsModel), 0, (GInstanceInitFunc) settings_model_instance_init, NULL };
	GType settings_model_type_id;
	settings_model_type_id = g_type_register_static (TYPE_SETTINGS_MODEL_CORE, "SettingsModel", &g_define_type_info, 0);
	return settings_model_type_id;
}

GType
settings_model_get_type (void)
{
	static volatile gsize settings_model_type_id__once = 0;
	if (g_once_init_enter (&settings_model_type_id__once)) {
		GType settings_model_type_id;
		settings_model_type_id = settings_model_get_type_once ();
		g_once_init_leave (&settings_model_type_id__once, settings_model_type_id);
	}
	return settings_model_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

