/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.fibs.geotag.tasks.BackgroundTaskListener;
import org.fibs.geotag.tasks.InterruptibleTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class BackgroundTask<V>
extends InterruptibleTask<String, V>
implements PropertyChangeListener {
    private static final I18n i18n = I18nFactory.getI18n(BackgroundTask.class);
    private String name;
    private static List<BackgroundTaskListener> listeners = new ArrayList<BackgroundTaskListener>();
    private String oldProgressMessage = null;

    public BackgroundTask(String name) {
        this.name = name;
        this.addPropertyChangeListener(this);
    }

    public String getName() {
        return this.name;
    }

    public abstract int getMinProgress();

    public abstract int getMaxProgress();

    public abstract int getCurrentProgress();

    public void setProgressMessage() {
        this.setProgressMessage(i18n.tr("Image"));
    }

    public void setProgressMessage(String prefix) {
        String progressMessage = String.valueOf(prefix) + ' ' + this.getCurrentProgress() + ' ' + i18n.tr("of") + ' ' + this.getMaxProgress();
        this.firePropertyChange("progress", this.oldProgressMessage, progressMessage.toString());
        this.oldProgressMessage = progressMessage.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        block6: {
            block4: {
                SwingWorker.StateValue state;
                block5: {
                    if (!"state".equals(event.getPropertyName())) break block4;
                    state = (SwingWorker.StateValue)((Object)event.getNewValue());
                    if (state != SwingWorker.StateValue.STARTED) break block5;
                    for (BackgroundTaskListener listener : listeners) {
                        listener.backgroundTaskStarted(this);
                    }
                    break block6;
                }
                if (state != SwingWorker.StateValue.DONE) break block6;
                for (BackgroundTaskListener listener : listeners) {
                    listener.backgroundTaskFinished(this);
                }
                break block6;
            }
            if ("progress".equals(event.getPropertyName())) {
                String progressMessage = (String)event.getNewValue();
                for (BackgroundTaskListener listener : listeners) {
                    listener.backgroundTaskProgress(this, progressMessage);
                }
            }
        }
    }

    public static void addBackgroundTaskListener(BackgroundTaskListener listener) {
        listeners.add(listener);
    }

    public static void removeBackgroundTaskListener(BackgroundTaskListener listener) {
        listeners.remove(listener);
    }
}

