/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.Track;
import tim.prune.function.compress.SummaryLabel;
import tim.prune.function.compress.TrackDetails;

public abstract class CompressionAlgorithm {
    protected final JCheckBox _activateCheckBox;
    protected SummaryLabel _summaryLabel = null;
    protected final Track _track;
    protected final TrackDetails _trackDetails;

    public CompressionAlgorithm(Track track, TrackDetails trackDetails, ActionListener actionListener) {
        this._track = track;
        this._trackDetails = trackDetails;
        this._activateCheckBox = new JCheckBox(I18nManager.getText(this.getTitleTextKey()));
        this._activateCheckBox.setSelected(false);
        this._activateCheckBox.addActionListener(actionListener);
    }

    public boolean isActivated() {
        return this._activateCheckBox.isSelected();
    }

    public JPanel getGuiComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._activateCheckBox, "North");
        Component component = this.getSpecificGuiComponents();
        if (component != null) {
            jPanel.add(component, "Center");
        }
        this._summaryLabel = new SummaryLabel(this._track);
        jPanel.add((Component)this._summaryLabel, "South");
        return jPanel;
    }

    public int preview(boolean[] blArray) {
        int n = 0;
        if (this.isActivated()) {
            this._trackDetails.initialise();
            n = this.compress(blArray);
            this._summaryLabel.setValue(n);
        } else {
            this._summaryLabel.clearValue();
        }
        return n;
    }

    protected abstract String getTitleTextKey();

    protected abstract Component getSpecificGuiComponents();

    protected abstract int compress(boolean[] var1);

    public String getSettingsString() {
        return this._activateCheckBox.isSelected() ? "1" : "";
    }

    public void applySettingsString(String string) {
        this._activateCheckBox.setSelected(string != null && !string.isEmpty());
    }
}

