/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.minimize.MMConstraint;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.minimize.forcefield.MMFFAngleCalc;
import org.jmol.minimize.forcefield.MMFFDistanceCalc;
import org.jmol.minimize.forcefield.MMFFESCalc;
import org.jmol.minimize.forcefield.MMFFOOPCalc;
import org.jmol.minimize.forcefield.MMFFSBCalc;
import org.jmol.minimize.forcefield.MMFFTorsionCalc;
import org.jmol.minimize.forcefield.MMFFVDWCalc;

class CalculationsMMFF
extends Calculations {
    static final double FPAR = 143.9325;
    public static final int DA_D = 68;
    public static final int DA_DA = 133;
    Calculation bondCalc;
    Calculation angleCalc;
    Calculation torsionCalc;
    Calculation oopCalc;
    Calculation vdwCalc;
    Calculation esCalc;
    Calculation sbCalc;
    ForceFieldMMFF mmff;

    CalculationsMMFF(ForceField ff, Map<Object, Object> ffParams, MinAtom[] minAtoms, MinBond[] minBonds, MinAngle[] minAngles, MinTorsion[] minTorsions, MinPosition[] minPositions, Lst<MMConstraint> constraints) {
        super(ff, minAtoms, minBonds, minAngles, minTorsions, minPositions, constraints);
        this.mmff = (ForceFieldMMFF)ff;
        this.ffParams = ffParams;
        this.bondCalc = new MMFFDistanceCalc().set(this);
        this.angleCalc = new MMFFAngleCalc().set(this);
        this.sbCalc = new MMFFSBCalc().set(this);
        this.torsionCalc = new MMFFTorsionCalc().set(this);
        this.oopCalc = new MMFFOOPCalc().set(this);
        this.vdwCalc = new MMFFVDWCalc().set(this);
        this.esCalc = new MMFFESCalc().set(this);
    }

    @Override
    String getUnits() {
        return "kcal";
    }

    @Override
    boolean setupCalculations() {
        MMFFDistanceCalc distanceCalc = (MMFFDistanceCalc)new MMFFDistanceCalc().set(this);
        Lst<Object> calc = this.calculations[0] = new Lst<Object[]>();
        for (int i = 0; i < this.bondCount; ++i) {
            distanceCalc.setData(calc, this.minBonds[i]);
        }
        this.calculations[1] = new Lst();
        calc = this.calculations[1];
        MMFFAngleCalc angleCalc = (MMFFAngleCalc)new MMFFAngleCalc().set(this);
        for (int i = 0; i < this.angleCount; ++i) {
            angleCalc.setData(calc, this.minAngles[i]);
        }
        this.calculations[3] = new Lst();
        calc = this.calculations[3];
        MMFFSBCalc sbCalc = (MMFFSBCalc)new MMFFSBCalc().set(this);
        for (int i = 0; i < this.angleCount; ++i) {
            sbCalc.setData(calc, this.minAngles[i]);
        }
        this.calculations[2] = new Lst();
        calc = this.calculations[2];
        MMFFTorsionCalc torsionCalc = (MMFFTorsionCalc)new MMFFTorsionCalc().set(this);
        for (int i = 0; i < this.torsionCount; ++i) {
            torsionCalc.setData(calc, this.minTorsions[i]);
        }
        this.calculations[4] = new Lst();
        calc = this.calculations[4];
        MMFFOOPCalc oopCalc = (MMFFOOPCalc)new MMFFOOPCalc().set(this);
        for (int i = 0; i < this.ac; ++i) {
            if (!CalculationsMMFF.isInvertible(this.minAtoms[i])) continue;
            oopCalc.setData(calc, i);
        }
        this.calculations[5] = new Lst<Object[]>();
        this.calculations[6] = new Lst<Object[]>();
        this.pairSearch(this.calculations[5], new MMFFVDWCalc().set(this), this.calculations[6], new MMFFESCalc().set(this));
        return true;
    }

    @Override
    protected boolean isLinear(int i) {
        return MinAtom.isLinear(this.minAtoms[i]);
    }

    private static boolean isInvertible(MinAtom a) {
        switch (a.ffType) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 10: 
            case 30: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 69: 
            case 78: 
            case 80: 
            case 81: 
        }
        return true;
    }

    @Override
    double compute(int iType, Object[] dataIn) {
        switch (iType) {
            case 0: {
                return this.bondCalc.compute(dataIn);
            }
            case 1: {
                return this.angleCalc.compute(dataIn);
            }
            case 3: {
                return this.sbCalc.compute(dataIn);
            }
            case 2: {
                return this.torsionCalc.compute(dataIn);
            }
            case 4: {
                return this.oopCalc.compute(dataIn);
            }
            case 5: {
                return this.vdwCalc.compute(dataIn);
            }
            case 6: {
                return this.esCalc.compute(dataIn);
            }
        }
        return 0.0;
    }

    @Override
    Object getParameterObj(MinObject a) {
        return a.key == null || a.ddata != null ? a.ddata : (double[])this.ffParams.get(a.key);
    }

    @Override
    String getDebugHeader(int iType) {
        switch (iType) {
            case -1: {
                return "MMFF94 Force Field -- T. A. Halgren, J. Comp. Chem. 5 & 6 490-519ff (1996).\n";
            }
            case 2: {
                return "\nT O R S I O N A L (" + this.minTorsions.length + " torsions)\n\n      ATOMS           ATOM TYPES          TORSION\n  I   J   K   L   I     J     K     L      ANGLE       V1       V2       V3     ENERGY\n--------------------------------------------------------------------------------------\n";
            }
        }
        return this.getDebugHeader2(iType);
    }

    @Override
    String getDebugLine(int iType, Calculation c) {
        float energy = this.ff.toUserUnits(c.energy);
        switch (iType) {
            case 1: 
            case 3: {
                return PT.sprintf("%11s  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", "ssssFI", new Object[]{MinObject.decodeKey(c.key), this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, this.minAtoms[c.ic].sType, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[1], (float)c.dData[0], energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber(), this.minAtoms[c.ic].atom.getAtomNumber()}});
            }
            case 2: {
                return PT.sprintf("%15s  %-5s %-5s %-5s %-5s  %8.3f %8.3f %8.3f %8.3f %8.3f", "sssssF", new Object[]{MinObject.decodeKey(c.key), this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, this.minAtoms[c.ic].sType, this.minAtoms[c.id].sType, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[0], (float)c.dData[1], (float)c.dData[2], energy}});
            }
        }
        return this.getDebugLineC(iType, c);
    }
}

