/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.webexport.ArrayListTransferHandler;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.Widgets;

abstract class WebPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    protected String panelName;
    protected String htmlAppletTemplate;
    protected String listLabel;
    protected String appletInfoDivs;
    protected JSpinner appletSizeSpinnerW;
    protected JSpinner appletSizeSpinnerH;
    protected JSpinner appletSizeSpinnerP;
    private JScrollPane editorScrollPane;
    private JButton saveButton;
    private JButton viewButton;
    private JButton helpButton;
    private JButton addInstanceButton;
    private JButton deleteInstanceButton;
    private JButton showInstanceButton;
    private JTextField remoteAppletPath;
    private JTextField localAppletPath;
    private JTextField pageAuthorName;
    private JTextField webPageTitle;
    private JFileChooser fc;
    protected JList<JmolInstance> instanceList;
    protected Widgets theWidgets;
    protected int nWidgets;
    private Checkbox[] widgetCheckboxes;
    protected Viewer vwr;
    private int panelIndex;
    private WebPanel[] webPanels;
    private int errCount;
    private String htmlPath;

    abstract String getAppletDefs(int var1, String var2, StringBuilder var3, JmolInstance var4);

    abstract String fixHtml(String var1);

    abstract JPanel appletParamPanel();

    protected WebPanel(Viewer vwr, JFileChooser fc, WebPanel[] webPanels, int panelIndex) {
        this.vwr = vwr;
        this.fc = fc;
        this.webPanels = webPanels;
        this.panelIndex = panelIndex;
        this.theWidgets = new Widgets();
        this.nWidgets = this.theWidgets.widgetList.length;
        this.widgetCheckboxes = new Checkbox[this.nWidgets];
        this.remoteAppletPath = new JTextField(20);
        this.remoteAppletPath.addActionListener(this);
        this.remoteAppletPath.setText(WebExport.getAppletPath(true));
        this.localAppletPath = new JTextField(20);
        this.localAppletPath.addActionListener(this);
        this.localAppletPath.setText(WebExport.getAppletPath(false));
        this.pageAuthorName = new JTextField(20);
        this.pageAuthorName.addActionListener(this);
        this.pageAuthorName.setText(WebExport.getPageAuthorName());
        this.webPageTitle = new JTextField(20);
        this.webPageTitle.addActionListener(this);
        this.webPageTitle.setText(GT.$("A web page with JSmol objects"));
    }

    JPanel getPanel(int infoWidth, int infoHeight) {
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(1);
        this.instanceList.setTransferHandler(new ArrayListTransferHandler(this));
        this.instanceList.setCellRenderer(new InstanceCellRenderer());
        this.instanceList.setDragEnabled(true);
        this.instanceList.setPreferredSize(new Dimension(350, 200));
        this.instanceList.addListSelectionListener(this);
        JScrollPane instanceListView = new JScrollPane(this.instanceList);
        instanceListView.setPreferredSize(new Dimension(350, 200));
        JPanel instanceSet = new JPanel();
        instanceSet.setLayout(new BorderLayout());
        instanceSet.add((Component)new JLabel(this.listLabel), "North");
        instanceSet.add((Component)instanceListView, "Center");
        instanceSet.add((Component)new JLabel(GT.$("click and drag to reorder")), "South");
        this.addInstanceButton = new JButton(GT.$("Add present Jmol state as instance..."));
        this.addInstanceButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setMaximumSize(new Dimension(350, 50));
        this.deleteInstanceButton = new JButton(GT.$("Delete selected"));
        this.deleteInstanceButton.addActionListener(this);
        buttonPanel.add(this.deleteInstanceButton);
        JPanel paramPanel = this.appletParamPanel();
        paramPanel.setMaximumSize(new Dimension(350, 70));
        JPanel instanceButtonPanel = new JPanel();
        instanceButtonPanel.add(this.addInstanceButton);
        instanceButtonPanel.setSize(300, 70);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)instanceButtonPanel, "North");
        p.add((Component)buttonPanel, "South");
        JPanel instancePanel = new JPanel();
        instancePanel.setLayout(new BorderLayout());
        instancePanel.add((Component)instanceSet, "Center");
        instancePanel.add((Component)p, "South");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.setMinimumSize(new Dimension(350, 350));
        rightPanel.setMaximumSize(new Dimension(350, 1000));
        rightPanel.add((Component)paramPanel, "North");
        rightPanel.add((Component)instancePanel, "Center");
        rightPanel.setBorder(BorderFactory.createTitledBorder(GT.$("JSmol Instances:")));
        JPanel widgetPanel = new JPanel();
        widgetPanel.setMinimumSize(new Dimension(150, 150));
        widgetPanel.setLayout(new BoxLayout(widgetPanel, 1));
        widgetPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Select widgets:")));
        for (int i = 0; i < this.nWidgets; ++i) {
            this.widgetCheckboxes[i] = new Checkbox(this.theWidgets.widgetList[i].name);
            this.widgetCheckboxes[i].addItemListener(this);
            widgetPanel.add(this.widgetCheckboxes[i]);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel leftPanel = this.getLeftPanel(infoWidth, infoHeight);
        leftPanel.setMaximumSize(new Dimension(350, 1000));
        panel.add((Component)leftPanel, "West");
        panel.add((Component)rightPanel, "Center");
        panel.add((Component)widgetPanel, "East");
        this.enableButtons(this.instanceList);
        return panel;
    }

    protected JList<JmolInstance> getInstanceList() {
        return this.instanceList;
    }

    private JPanel getLeftPanel(int w, int h) {
        this.helpButton = new JButton(GT.$("Help/Instructions"));
        this.helpButton.addActionListener(this);
        String templateImage = this.panelName + ".png";
        URL pageCartoon = GuiMap.getResource(this, templateImage);
        ImageIcon pageImage = null;
        if (pageCartoon != null) {
            pageImage = new ImageIcon(pageCartoon, GT.$("Cartoon of Page"));
        } else {
            System.err.println("Error Loading Page Cartoon Image " + templateImage);
        }
        JLabel pageCartoonLabel = new JLabel(pageImage);
        JPanel pageCartoonPanel = new JPanel();
        pageCartoonPanel.setLayout(new BorderLayout());
        pageCartoonPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Cartoon of Page") + ":"));
        pageCartoonPanel.add(pageCartoonLabel);
        this.saveButton = new JButton(GT.$("Save HTML as..."));
        this.saveButton.addActionListener(this);
        this.viewButton = new JButton(GT.$("View HTML"));
        this.viewButton.addActionListener(this);
        JPanel savePanel = new JPanel();
        savePanel.add(this.saveButton);
        savePanel.add(this.viewButton);
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new BorderLayout());
        pathPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Relative server path to JSmol.min.js:")));
        pathPanel.add((Component)this.remoteAppletPath, "North");
        JPanel pathPanel2 = new JPanel();
        pathPanel2.setLayout(new BorderLayout());
        pathPanel2.setBorder(BorderFactory.createTitledBorder(GT.$("Relative local path to JSmol.min.js:")));
        pathPanel2.add((Component)this.localAppletPath, "North");
        JPanel authorPanel = new JPanel();
        authorPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Author (your name):")));
        authorPanel.add((Component)this.pageAuthorName, "North");
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.setBorder(BorderFactory.createTitledBorder(GT.$("Browser window title for this web page:")));
        titlePanel.add((Component)this.webPageTitle, "North");
        titlePanel.add((Component)savePanel, "South");
        JPanel pathPanels = new JPanel();
        pathPanels.setLayout(new BorderLayout());
        pathPanels.add((Component)pathPanel, "North");
        pathPanels.add((Component)pathPanel2, "South");
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BorderLayout());
        settingsPanel.add((Component)pathPanels, "North");
        settingsPanel.add((Component)authorPanel, "Center");
        settingsPanel.add((Component)titlePanel, "South");
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BorderLayout());
        leftpanel.add((Component)this.helpButton, "North");
        leftpanel.add((Component)pageCartoonPanel, "Center");
        leftpanel.add((Component)settingsPanel, "South");
        return leftpanel;
    }

    int getInfoWidth() {
        return this.editorScrollPane.getWidth();
    }

    int getInfoHeight() {
        return this.editorScrollPane.getHeight();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
        int[] list = this.instanceList.getSelectedIndices();
        if (list.length == 0) {
            return;
        }
        JmolInstance instance = (JmolInstance)listModel.get(list[0]);
        Object source = e.getSource();
        int stateChange = e.getStateChange();
        for (int i = 0; i < this.nWidgets; ++i) {
            if (source != this.widgetCheckboxes[i]) continue;
            if (stateChange == 1) {
                instance.addWidget(i);
            }
            if (stateChange != 2) continue;
            instance.deleteWidget(i);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.helpButton) {
            HelpDialog webExportHelp = new HelpDialog(WebExport.getFrame(), GuiMap.getHtmlResource(this, this.panelName + "_instructions"));
            webExportHelp.setVisible(true);
            webExportHelp.setDefaultCloseOperation(2);
            return;
        }
        if (e.getSource() == this.remoteAppletPath) {
            String path = this.remoteAppletPath.getText();
            WebExport.setAppletPath(path, true);
            return;
        }
        if (e.getSource() == this.localAppletPath) {
            String path = this.localAppletPath.getText();
            WebExport.setAppletPath(path, false);
            return;
        }
        if (e.getSource() == this.addInstanceButton) {
            JmolInstance instance;
            String label = this.instanceList.getSelectedIndices().length != 1 ? "" : this.getInstanceName(-1);
            String name = JOptionPane.showInputDialog(GT.$("Give the occurrence of JSmol a name:"), (Object)label);
            if (name == null || name.length() == 0) {
                return;
            }
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int width = 300;
            int height = 300;
            if (this.appletSizeSpinnerH != null) {
                width = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
                height = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            }
            if ((instance = JmolInstance.getInstance(this.vwr, name, width, height, this.nWidgets)) == null) {
                LogPanel.log(GT.$("Error creating new instance containing script(s) and image."));
                return;
            }
            int i = this.instanceList.getModel().getSize();
            while (--i >= 0 && !this.getInstanceName(i).equals(instance.name)) {
            }
            String m = GT.$("added Instance {0}");
            if (i < 0) {
                i = listModel.getSize();
                listModel.addElement(instance);
                LogPanel.log(GT.o(m, instance.name));
            } else {
                listModel.setElementAt(instance, i);
                LogPanel.log(GT.o(m, instance.name));
            }
            this.instanceList.setSelectedIndex(i);
            this.syncLists();
            return;
        }
        if (e.getSource() == this.deleteInstanceButton) {
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int[] todelete = this.instanceList.getSelectedIndices();
            for (int i = 0; i < todelete.length; ++i) {
                JmolInstance instance = (JmolInstance)listModel.get(todelete[i]);
                try {
                    instance.delete();
                    continue;
                }
                catch (IOException err) {
                    LogPanel.log(err.getMessage());
                }
            }
            listModel.removeRange(todelete[0], todelete[todelete.length - 1]);
            this.syncLists();
            return;
        }
        if (e.getSource() == this.showInstanceButton) {
            DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
            int[] list = this.instanceList.getSelectedIndices();
            if (list.length != 1) {
                return;
            }
            JmolInstance instance = (JmolInstance)listModel.get(list[0]);
            this.vwr.evalStringQuiet(")" + instance.script);
            return;
        }
        if (e.getSource() == this.viewButton) {
            this.vwr.showUrl(this.htmlPath);
        } else if (e.getSource() == this.saveButton) {
            this.fc.setDialogTitle(GT.$("Select a folder to create or an HTML file to save"));
            int returnVal = this.fc.showSaveDialog(this);
            if (returnVal != 0) {
                return;
            }
            File file = this.fc.getSelectedFile();
            this.htmlPath = "file:///" + file.getAbsolutePath().replace('\\', '/');
            String retVal = null;
            this.errCount = 0;
            try {
                String path = this.remoteAppletPath.getText();
                WebExport.setAppletPath(path, true);
                path = this.localAppletPath.getText();
                WebExport.setAppletPath(path, false);
                String authorName = this.pageAuthorName.getText();
                WebExport.setWebPageAuthor(authorName);
                retVal = this.fileWriter(file, this.instanceList);
                this.viewButton.setEnabled(true);
            }
            catch (IOException IOe) {
                LogPanel.log(IOe.getMessage());
                ++this.errCount;
            }
            if (retVal != null) {
                LogPanel.log(GT.o(GT.$("file {0} created"), retVal));
            } else {
                LogPanel.log(GT.$("Call to FileWriter unsuccessful."));
                ++this.errCount;
            }
            if (this.errCount > 0) {
                LogPanel.log(GT.$("Errors occurred during web page creation.  See Log Tab!"));
            }
            return;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList whichList = (JList)e.getSource();
        if (whichList.isSelectionEmpty()) {
            return;
        }
        if (whichList.getMinSelectionIndex() != whichList.getMaxSelectionIndex()) {
            return;
        }
        int index = whichList.getSelectedIndex();
        JmolInstance instance = (JmolInstance)whichList.getModel().getElementAt(index);
        int width = instance.width;
        int height = instance.height;
        if (this.appletSizeSpinnerW != null) {
            this.appletSizeSpinnerW.getModel().setValue(width);
        }
        if (this.appletSizeSpinnerH != null) {
            this.appletSizeSpinnerH.getModel().setValue(height);
        }
        this.vwr.evalStringQuiet(")" + instance.script);
        for (int i = 0; i < this.nWidgets; ++i) {
            this.widgetCheckboxes[i].setState(instance.whichWidgets.get(i));
        }
    }

    String getInstanceName(int i) {
        JmolInstance instance;
        if (i < 0) {
            i = this.instanceList.getSelectedIndex();
        }
        return (instance = this.instanceList.getModel().getElementAt(i)) == null ? "" : instance.name;
    }

    String fileWriter(File file, JList<JmolInstance> InstanceList) throws IOException {
        StringBuilder appletDefs;
        String html;
        String fileName;
        String datadirPath = file.getPath().replace('\\', '/');
        String datadirName = file.getName();
        if (datadirName.indexOf(".htm") < 0) {
            File f = new File(datadirPath + ".html");
            if (f.exists()) {
                datadirName = datadirName + ".html";
                file = f;
            } else {
                f = new File(datadirPath + ".htm");
                if (f.exists()) {
                    datadirName = datadirName + ".htm";
                    file = f;
                }
            }
        }
        if (datadirName.indexOf(".htm") > 0) {
            fileName = datadirName;
            datadirPath = file.getParent();
            file = new File(datadirPath);
            datadirName = file.getName();
        } else {
            fileName = datadirName + ".html";
        }
        datadirPath = datadirPath.replace('\\', '/');
        fileName = datadirPath + "/" + fileName;
        boolean made_datadir = file.exists() && file.isDirectory() || file.mkdir();
        DefaultListModel listModel = (DefaultListModel)InstanceList.getModel();
        LogPanel.log("");
        if (made_datadir) {
            LogPanel.log(GT.o(GT.$("Using directory {0}"), datadirPath));
            LogPanel.log("  " + GT.o(GT.$("adding {0}"), "support.js"));
            this.vwr.writeTextFile(datadirPath + "/support.js", GuiMap.getResourceString(this, "support.js"));
            for (int i = 0; i < listModel.getSize(); ++i) {
                JmolInstance thisInstance = (JmolInstance)listModel.getElementAt(i);
                String javaname = thisInstance.javaname;
                String script = thisInstance.script;
                LogPanel.log("  ...jmolApplet" + i);
                LogPanel.log("      ..." + GT.o(GT.$("adding {0}"), javaname + ".png"));
                thisInstance.movepict(datadirPath);
                Lst<String> filesToCopy = new Lst<String>();
                Lst<String> filesToCopyUTF = new Lst<String>();
                String localPath = this.localAppletPath.getText();
                if (localPath.equals(".") || this.remoteAppletPath.getText().equals(".")) {
                    try {
                        String jmolJarDirPath = this.jmolJarPath().substring(0, this.jmolJarPath().lastIndexOf("/"));
                        filesToCopy.addLast(jmolJarDirPath + "/jsmol.zip");
                        filesToCopyUTF.addLast(jmolJarDirPath + "/jsmol.zip");
                    }
                    catch (UnsupportedEncodingException e) {
                        LogPanel.log(GT.$("There was an error in the text encoding so the path to jsmol.zip is unknown."));
                    }
                }
                FileManager.getFileReferences(script, filesToCopy, filesToCopyUTF);
                ArrayList<String> copiedFileNames = new ArrayList<String>();
                int nFiles = filesToCopy.size();
                for (int iFile = 0; iFile < nFiles; ++iFile) {
                    String name = (String)filesToCopyUTF.get(iFile);
                    int pt = name.indexOf("::");
                    String type = "";
                    if (pt >= 0) {
                        type = name.substring(0, pt + 2);
                        name = name.substring(pt + 2);
                    }
                    String newName = this.copyBinaryFile(name, datadirPath);
                    copiedFileNames.add(PT.escUnicode(type + newName.substring(newName.lastIndexOf(47) + 1)));
                }
                script = WebPanel.replaceQuotedStrings(script, filesToCopy, copiedFileNames);
                LogPanel.log("      ..." + GT.o(GT.$("adding {0}"), javaname + ".spt"));
                this.vwr.writeTextFile(datadirPath + "/" + javaname + ".spt", script);
            }
            html = GuiMap.getResourceString(this, this.panelName + "_template");
            html = this.fixHtml(html);
            String jsStr = "";
            BS whichWidgets = this.allSelectedWidgets();
            for (int i = 0; i < this.nWidgets; ++i) {
                String[] supportFileNames;
                int nFiles;
                if (!whichWidgets.get(i)) continue;
                String scriptFileName = this.theWidgets.widgetList[i].getJavaScriptFileName();
                if (!scriptFileName.equalsIgnoreCase("none")) {
                    jsStr = jsStr + "\n<script src=\"" + scriptFileName + "\" type=\"text/javascript\"></script>";
                    LogPanel.log("  " + GT.o(GT.$("adding {0}"), scriptFileName));
                    this.vwr.writeTextFile(datadirPath + "/" + scriptFileName + "", GuiMap.getResourceString(this, scriptFileName));
                }
                if ((nFiles = (supportFileNames = this.theWidgets.widgetList[i].getSupportFileNames()).length) == 0) continue;
                for (int fileN = 0; fileN < nFiles; ++fileN) {
                    URL fileURL;
                    String inFile;
                    String outFile = inFile = supportFileNames[fileN];
                    if (inFile.lastIndexOf("/") != -1) {
                        outFile = inFile.substring(inFile.lastIndexOf("/") + 1);
                    }
                    if ((fileURL = GuiMap.getResource(this, inFile)) == null) {
                        LogPanel.log("    " + GT.o(GT.$("Unable to load resource {0}"), inFile));
                        ++this.errCount;
                        continue;
                    }
                    InputStream is = fileURL.openConnection().getInputStream();
                    FileOutputStream os = new FileOutputStream(datadirPath + "/" + outFile);
                    int temp = is.read();
                    while (temp != -1) {
                        os.write(temp);
                        temp = is.read();
                    }
                    os.flush();
                    os.close();
                    LogPanel.log("  " + GT.o(GT.$("adding {0}"), outFile));
                }
            }
            html = PT.rep(html, "@WIDGETJSFILES@", jsStr);
            this.appletInfoDivs = "";
            appletDefs = new StringBuilder();
            this.htmlAppletTemplate = GuiMap.getResourceString(this, this.panelName + "_template2");
            for (int i = 0; i < listModel.getSize(); ++i) {
                html = this.getAppletDefs(i, html, appletDefs, (JmolInstance)listModel.getElementAt(i));
            }
            html = PT.rep(html, "@AUTHOR@", GT.escapeHTML(this.pageAuthorName.getText()));
            html = PT.rep(html, "@TITLE@", GT.escapeHTML(this.webPageTitle.getText()));
            html = PT.rep(html, "@REMOTEAPPLETPATH@", this.remoteAppletPath.getText());
            String localPath = this.localAppletPath.getText();
            if (localPath.contentEquals(".")) {
                localPath = "jsmol";
            }
            html = PT.rep(html, "@LOCALAPPLETPATH@", localPath);
            html = PT.rep(html, "@DATADIRNAME@", datadirName);
            if (this.appletInfoDivs.length() > 0) {
                this.appletInfoDivs = "\n<div style='display:none'>\n" + this.appletInfoDivs + "\n</div>\n";
            }
        } else {
            IOException IOe = new IOException(GT.$("Error creating directory: ") + datadirPath);
            throw IOe;
        }
        String str = appletDefs.toString();
        html = PT.rep(html, "@APPLETINFO@", this.appletInfoDivs);
        html = PT.rep(html, "@APPLETDEFS@", str);
        html = PT.rep(html, "@CREATIONDATA@", GT.escapeHTML(WebExport.TimeStamp_WebLink()));
        html = PT.rep(html, "@AUTHORDATA@", GT.escapeHTML(GT.$("Based on a template by A. Herr&#x00E1;ez and J. Gutow")));
        html = PT.rep(html, "@LOGDATA@", "<pre>\n" + LogPanel.getText() + "\n</pre>\n");
        LogPanel.log("      ..." + GT.o(GT.$("creating {0}"), fileName));
        this.vwr.writeTextFile(fileName, html);
        return fileName;
    }

    public static String replaceQuotedStrings(String s, ArrayList<String> list, ArrayList<String> newList) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String name = list.get(i);
            String newName = newList.get(i);
            if (newName.equals(name)) continue;
            s = PT.rep(s, "\"" + name + "\"", "\"" + newName + "\"");
        }
        return s;
    }

    public BS allSelectedWidgets() {
        BS selectedWidgets = BS.newN(this.nWidgets);
        DefaultListModel listModel = (DefaultListModel)this.instanceList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            JmolInstance thisInstance = (JmolInstance)listModel.getElementAt(i);
            selectedWidgets.or(thisInstance.whichWidgets);
        }
        return selectedWidgets;
    }

    private String copyBinaryFile(String fullPathName, String dataPath) {
        String name = fullPathName.substring(fullPathName.lastIndexOf(47) + 1).replace('|', '_');
        if (name.contentEquals("jsmol.zip")) {
            LogPanel.log(GT.o(GT.$("copying and unzipping jsmol.zip directory into {0}"), dataPath));
            String tempDP = this.copyandUnzip(fullPathName, dataPath, name);
            return tempDP;
        }
        name = dataPath + "/" + name;
        String gzname = name + ".gz";
        File outFile = new File(name);
        File gzoutFile = new File(gzname);
        if (outFile.exists()) {
            return name;
        }
        if (gzoutFile.exists()) {
            return gzname;
        }
        try {
            Object ret = this.vwr.fm.getFileAsBytes(fullPathName, null);
            if (ret instanceof String) {
                LogPanel.log(GT.o(GT.$("Could not find or open:\n{0}\nPlease check that you are using a Jmol.jar that is part of a full Jmol distribution."), fullPathName));
                ++this.errCount;
            } else {
                LogPanel.log("      ..." + GT.o(GT.$("copying\n{0}\n         to"), fullPathName));
                byte[] data = (byte[])ret;
                String[] retName = new String[]{name};
                int maxUnzipped = name.indexOf(".js") >= 0 ? Integer.MAX_VALUE : 100000;
                String err = WebPanel.writeFileZipped(retName, data, maxUnzipped);
                if (!retName[0].equals(name)) {
                    name = retName[0];
                    LogPanel.log("      ..." + GT.$("compressing large data file to") + "\n" + name);
                }
                LogPanel.log(name);
                if (err != null) {
                    LogPanel.log(err);
                    ++this.errCount;
                }
            }
        }
        catch (Exception e) {
            LogPanel.log(e.getMessage());
            ++this.errCount;
        }
        return name;
    }

    private static String writeFileZipped(String[] retName, byte[] data, int maxUnzipped) {
        String err = null;
        try {
            boolean doCompress = false;
            if (data.length > maxUnzipped) {
                doCompress = true;
                for (int i = 0; i < 10; ++i) {
                    if (data[i] >= 10) continue;
                    doCompress = false;
                }
            }
            if (doCompress) {
                retName[0] = retName[0] + ".gz";
                GZIPOutputStream gzFile = new GZIPOutputStream(new FileOutputStream(retName[0]));
                gzFile.write(data);
                gzFile.flush();
                gzFile.close();
            } else {
                FileOutputStream os = new FileOutputStream(retName[0]);
                os.write(data);
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            err = e.getMessage();
        }
        return err;
    }

    private String copyandUnzip(String fullPathName, String dataPath, String name) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fullPathName);
            Enumeration<? extends ZipEntry> files = zipFile.entries();
            File f = null;
            FileOutputStream fos = null;
            byte[] buffer = new byte[1024];
            while (files.hasMoreElements()) {
                block12: {
                    try {
                        fos = null;
                        ZipEntry entry = files.nextElement();
                        if (entry.getName().endsWith(".htm") || entry.getName().contains("data" + File.separator) || entry.getName().contains(".html")) break block12;
                        InputStream eis = zipFile.getInputStream(entry);
                        f = new File(dataPath + File.separator + entry.getName());
                        if (entry.isDirectory()) {
                            Logger.info("creating directory " + f);
                            f.mkdirs();
                        } else {
                            f.getParentFile().mkdirs();
                            f.createNewFile();
                            fos = new FileOutputStream(f);
                            int bytesRead = 0;
                            while ((bytesRead = eis.read(buffer)) != -1) {
                                fos.write(buffer, 0, bytesRead);
                            }
                        }
                    }
                    catch (IOException e) {
                        Logger.error(e.getMessage());
                        break;
                    }
                }
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            LogPanel.log(GT.$("Error encountered while openning zip file. You may not have\na complete copy of the Jmol distribution.  Check for the file jsmol.zip.\n" + e.getMessage()));
            ++this.errCount;
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataPath;
    }

    private URL jmolJarURL() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    private String jmolJarPath() throws UnsupportedEncodingException {
        String pathStr = null;
        URL jarURL = this.jmolJarURL();
        pathStr = URLDecoder.decode(jarURL.toString(), System.getProperty("file.encoding"));
        pathStr = pathStr.substring(pathStr.indexOf(":") + 1, pathStr.length());
        return pathStr;
    }

    void syncLists() {
        DefaultListModel model1 = (DefaultListModel)this.instanceList.getModel();
        for (int j = 0; j < this.webPanels.length; ++j) {
            if (j == this.panelIndex) continue;
            JList<JmolInstance> list = this.webPanels[j].instanceList;
            DefaultListModel model2 = (DefaultListModel)list.getModel();
            model2.clear();
            int n = model1.getSize();
            for (int i = 0; i < n; ++i) {
                model2.addElement(model1.get(i));
            }
            list.setSelectedIndices(new int[0]);
            this.webPanels[j].enableButtons(list);
        }
        this.enableButtons(this.instanceList);
    }

    void enableButtons(JList<?> list) {
        int nSelected = list.getSelectedIndices().length;
        int nListed = list.getModel().getSize();
        this.saveButton.setEnabled(nListed > 0);
        this.viewButton.setEnabled(false);
        this.deleteInstanceButton.setEnabled(nSelected > 0);
    }

    public static boolean checkOption(Object o) {
        return o instanceof Boolean && (Boolean)o != false || o instanceof Integer && (Integer)o != 0;
    }

    class InstanceCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        InstanceCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(" " + ((JmolInstance)value).name);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            WebPanel.this.enableButtons(list);
            return this;
        }
    }
}

