/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.log;

import java.util.ServiceLoader;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogFactory;

public class LogManager {
    private static String logSystem;
    public static final String LOGSYSTEM_JAVA_UTIL_LOGGING = "jul";
    public static final String LOGSYSTEM_LOG4J2 = "log4j2";

    public static void setLogSystem(String logSystem) {
        LogManager.logSystem = logSystem;
    }

    private static LogFactory getLogFactory() {
        return LogFactoryHolder.INSTANCE;
    }

    protected LogManager() {
    }

    public static void shutdown() {
        LogManager.getLogFactory().shutdown();
    }

    public static Log getLog(Class<?> clazz) {
        return LogManager.getLogFactory().getLog(clazz);
    }

    public static Log getLog(String name) {
        return LogManager.getLogFactory().getLog(name);
    }

    public static Log getRootLogger() {
        return LogManager.getLog("");
    }

    private static class LogFactoryHolder {
        static final LogFactory INSTANCE = LogFactoryHolder.createLogFactory();

        private LogFactoryHolder() {
        }

        private static LogFactory createLogFactory() {
            ServiceLoader<LogFactory> factories = ServiceLoader.load(LogFactory.class);
            if (logSystem == null) {
                logSystem = System.getProperty("jcs.logSystem", LogManager.LOGSYSTEM_JAVA_UTIL_LOGGING);
            }
            for (LogFactory factory : factories) {
                if (!logSystem.equalsIgnoreCase(factory.getName())) continue;
                return factory;
            }
            throw new RuntimeException("Could not find factory implementation for log subsystem " + logSystem);
        }
    }
}

