/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.I18n;

public class OsmWriter
extends XmlWriter
implements PrimitiveVisitor {
    public static final String DEFAULT_API_VERSION = "0.6";
    private final boolean osmConform;
    private boolean withBody = true;
    private boolean withVisible = true;
    private boolean isOsmChange;
    private String version;
    private Changeset changeset;
    protected static final Comparator<AbstractPrimitive> byIdComparator = (o1, o2) -> {
        long i1 = o1.getUniqueId();
        long i2 = o2.getUniqueId();
        if (i1 < 0L && i2 < 0L) {
            return Long.compare(i2, i1);
        }
        return Long.compare(i1, i2);
    };
    protected static final Comparator<Map.Entry<String, String>> byKeyComparator = Map.Entry.comparingByKey();

    protected OsmWriter(PrintWriter out, boolean osmConform, String version) {
        super(out);
        this.osmConform = osmConform;
        this.version = version == null ? DEFAULT_API_VERSION : version;
    }

    public void setWithBody(boolean wb) {
        this.withBody = wb;
    }

    public void setWithVisible(boolean wv) {
        this.withVisible = wv;
    }

    public void setIsOsmChange(boolean isOsmChange) {
        this.isOsmChange = isOsmChange;
    }

    public void setChangeset(Changeset cs) {
        this.changeset = cs;
    }

    public void setVersion(String v) {
        this.version = v;
    }

    public void header() {
        this.header(DownloadPolicy.NORMAL, UploadPolicy.NORMAL);
    }

    public void header(DownloadPolicy download, UploadPolicy upload) {
        this.header(download, upload, false);
    }

    private void header(DownloadPolicy download, UploadPolicy upload, boolean locked) {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        if (download != null && download != DownloadPolicy.NORMAL) {
            this.out.print("' download='");
            this.out.print(download.getXmlFlag());
        }
        if (upload != null && upload != UploadPolicy.NORMAL) {
            this.out.print("' upload='");
            this.out.print(upload.getXmlFlag());
        }
        if (locked) {
            this.out.print("' locked='true");
        }
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    protected <T extends OsmPrimitive> Collection<T> sortById(Collection<T> primitives) {
        ArrayList<Object> result = new ArrayList<Object>(primitives.size());
        result.addAll(primitives);
        result.sort(byIdComparator);
        return result;
    }

    public void write(DataSet data) {
        this.header(data.getDownloadPolicy(), data.getUploadPolicy(), data.isLocked());
        this.writeDataSources(data);
        this.writeContent(data);
        this.footer();
    }

    public void writeContent(DataSet ds) {
        this.setWithVisible(UploadPolicy.NORMAL == ds.getUploadPolicy());
        this.writeNodes(ds.getNodes());
        this.writeWays(ds.getWays());
        this.writeRelations(ds.getRelations());
    }

    public void writeNodes(Collection<Node> nodes) {
        for (Node n : this.sortById(nodes)) {
            if (!this.shouldWrite(n)) continue;
            this.visit(n);
        }
    }

    public void writeWays(Collection<Way> ways) {
        for (Way w : this.sortById(ways)) {
            if (!this.shouldWrite(w)) continue;
            this.visit(w);
        }
    }

    public void writeRelations(Collection<Relation> relations) {
        for (Relation r : this.sortById(relations)) {
            if (!this.shouldWrite(r)) continue;
            this.visit(r);
        }
    }

    protected boolean shouldWrite(OsmPrimitive osm) {
        return !osm.isNewOrUndeleted() || !osm.isDeleted();
    }

    public void writeDataSources(DataSet ds) {
        for (DataSource s : ds.getDataSources()) {
            this.out.append("  <bounds minlat='").append(DecimalDegreesCoordinateFormat.INSTANCE.latToString(s.bounds.getMin()));
            this.out.append("' minlon='").append(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(s.bounds.getMin()));
            this.out.append("' maxlat='").append(DecimalDegreesCoordinateFormat.INSTANCE.latToString(s.bounds.getMax()));
            this.out.append("' maxlon='").append(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(s.bounds.getMax()));
            this.out.append("' origin='").append(XmlWriter.encode(s.origin)).append("' />");
            this.out.println();
        }
    }

    void writeLatLon(LatLon ll) {
        if (ll != null) {
            this.out.append(" lat='").append(LatLon.cDdHighPrecisionFormatter.format(ll.lat())).append("'");
            this.out.append(" lon='").append(LatLon.cDdHighPrecisionFormatter.format(ll.lon())).append("'");
        }
    }

    @Override
    public void visit(INode n) {
        if (n.isIncomplete()) {
            return;
        }
        this.addCommon(n, "node");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.writeLatLon(n.getCoor());
            this.addTags(n, "node", true);
        }
    }

    @Override
    public void visit(IWay<?> w) {
        if (w.isIncomplete()) {
            return;
        }
        this.addCommon(w, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < w.getNodesCount(); ++i) {
                this.out.append("    <nd ref='").append(String.valueOf(w.getNodeId(i))).append("' />");
                this.out.println();
            }
            this.addTags(w, "way", false);
        }
    }

    @Override
    public void visit(IRelation<?> e) {
        if (e.isIncomplete()) {
            return;
        }
        this.addCommon(e, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (int i = 0; i < e.getMembersCount(); ++i) {
                this.out.print("    <member type='");
                this.out.print(e.getMemberType(i).getAPIName());
                this.out.append("' ref='").append(String.valueOf(e.getMemberId(i)));
                this.out.append("' role='").append(XmlWriter.encode(e.getRole(i))).append("' />");
                this.out.println();
            }
            this.addTags(e, "relation", false);
        }
    }

    public void visit(Changeset cs) {
        Instant closedDate;
        Instant createdDate;
        this.out.append("  <changeset id='").append(String.valueOf(cs.getId())).append("'");
        if (cs.getUser() != null) {
            this.out.append(" user='").append(XmlWriter.encode(cs.getUser().getName())).append("'");
            this.out.append(" uid='").append(String.valueOf(cs.getUser().getId())).append("'");
        }
        if ((createdDate = cs.getCreatedAt()) != null) {
            this.out.append(" created_at='").append(String.valueOf(createdDate)).append("'");
        }
        if ((closedDate = cs.getClosedAt()) != null) {
            this.out.append(" closed_at='").append(String.valueOf(closedDate)).append("'");
        }
        this.out.append(" open='").append(cs.isOpen() ? "true" : "false").append("'");
        if (cs.getMin() != null) {
            this.out.append(" min_lon='").append(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(cs.getMin())).append("'");
            this.out.append(" min_lat='").append(DecimalDegreesCoordinateFormat.INSTANCE.latToString(cs.getMin())).append("'");
        }
        if (cs.getMax() != null) {
            this.out.append(" max_lon='").append(DecimalDegreesCoordinateFormat.INSTANCE.lonToString(cs.getMax())).append("'");
            this.out.append(" max_lat='").append(DecimalDegreesCoordinateFormat.INSTANCE.latToString(cs.getMax())).append("'");
        }
        this.out.println(">");
        this.addTags(cs, "changeset", false);
    }

    protected void addTags(Tagged osm, String tagname, boolean tagOpen) {
        if (osm.hasKeys()) {
            if (tagOpen) {
                this.out.println(">");
            }
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(osm.getKeys().entrySet());
            entries.sort(byKeyComparator);
            for (Map.Entry entry : entries) {
                this.out.append("    <tag k='").append(XmlWriter.encode((String)entry.getKey()));
                this.out.append("' v='").append(XmlWriter.encode((String)entry.getValue())).append("' />");
                this.out.println();
            }
            this.out.println("  </" + tagname + '>');
        } else if (tagOpen) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + tagname + '>');
        }
    }

    protected void addCommon(IPrimitive osm, String tagname) {
        this.out.append("  <").append(tagname);
        if (osm.getUniqueId() == 0L) {
            throw new IllegalStateException(I18n.tr("Unexpected id 0 for osm primitive found", new Object[0]));
        }
        this.out.append(" id='").append(String.valueOf(osm.getUniqueId())).append("'");
        if (!this.isOsmChange) {
            if (!this.osmConform) {
                String action = null;
                if (osm.isDeleted()) {
                    action = "delete";
                } else if (osm.isModified()) {
                    action = "modify";
                }
                if (action != null) {
                    this.out.append(" action='").append(action).append("'");
                }
            }
            if (!osm.isTimestampEmpty()) {
                this.out.append(" timestamp='").append(String.valueOf(osm.getInstant())).append("'");
            }
            if (osm.getUser() != null) {
                if (osm.getUser().isLocalUser()) {
                    this.out.append(" user='").append(XmlWriter.encode(osm.getUser().getName())).append("'");
                } else if (osm.getUser().isOsmUser()) {
                    this.out.append(" uid='").append(String.valueOf(osm.getUser().getId())).append("'");
                    this.out.append(" user='").append(XmlWriter.encode(osm.getUser().getName())).append("'");
                }
            }
            if (this.withVisible) {
                this.out.append(" visible='").append(String.valueOf(osm.isVisible())).append("'");
            }
        }
        if (osm.getVersion() != 0) {
            this.out.append(" version='").append(String.valueOf(osm.getVersion())).append("'");
        }
        if (this.changeset != null && this.changeset.getId() != 0) {
            this.out.append(" changeset='").append(String.valueOf(this.changeset.getId())).append("'");
        } else if (osm.getChangesetId() > 0 && !osm.isNew()) {
            this.out.append(" changeset='").append(String.valueOf(osm.getChangesetId())).append("'");
        }
    }
}

