/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GeoUrlToBounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class OsmUrlToBounds {
    private static final String SHORTLINK_PREFIX = "http://osm.org/go/";
    private static volatile Supplier<Dimension> mapSize = () -> new Dimension(800, 600);
    private static final char[] SHORTLINK_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '@'};
    private static final int TILE_SIZE_IN_PIXELS = 256;

    private OsmUrlToBounds() {
    }

    public static Bounds parse(String url) {
        if (url.startsWith("geo:")) {
            return GeoUrlToBounds.parse(url);
        }
        try {
            if (url.contains("%")) {
                url = Utils.decodeUrl(url);
            }
        }
        catch (IllegalArgumentException ex) {
            Logging.error(ex);
        }
        Bounds b = OsmUrlToBounds.parseShortLink(url);
        if (b != null) {
            return b;
        }
        if (url.contains("#map") || url.contains("/#")) {
            return OsmUrlToBounds.parseHashURLs(url);
        }
        int i = url.indexOf(63);
        if (i == -1) {
            return null;
        }
        String[] args = url.substring(i + 1).split("&", -1);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String arg : args) {
            int eq = arg.indexOf(61);
            if (eq == -1) continue;
            map.put(arg.substring(0, eq), arg.substring(eq + 1));
        }
        try {
            if (map.containsKey("bbox")) {
                String[] bbox = ((String)map.get("bbox")).split(",", -1);
                b = new Bounds(Double.parseDouble(bbox[1]), Double.parseDouble(bbox[0]), Double.parseDouble(bbox[3]), Double.parseDouble(bbox[2]));
            } else if (map.containsKey("minlat")) {
                double minlat = Double.parseDouble((String)map.get("minlat"));
                double minlon = Double.parseDouble((String)map.get("minlon"));
                double maxlat = Double.parseDouble((String)map.get("maxlat"));
                double maxlon = Double.parseDouble((String)map.get("maxlon"));
                b = new Bounds(minlat, minlon, maxlat, maxlon);
            } else {
                String z = (String)map.get("zoom");
                b = OsmUrlToBounds.positionToBounds(OsmUrlToBounds.parseDouble(map, "lat"), OsmUrlToBounds.parseDouble(map, "lon"), z == null ? 18 : Integer.parseInt(z));
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
            Logging.log(Logging.LEVEL_ERROR, url, ex);
        }
        return b;
    }

    private static Bounds parseHashURLs(String url) {
        double lon;
        double lat;
        int zoom;
        String coordPart;
        String[] parts;
        int startIndex = url.indexOf(35);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = url.indexOf(38, startIndex);
        if (endIndex == -1) {
            endIndex = url.length();
        }
        if ((parts = (coordPart = url.substring(startIndex + (url.contains("#map=") ? "#map=".length() : "#".length()), endIndex)).split("/", -1)).length < 3) {
            Logging.warn(I18n.tr("URL does not contain {0}/{1}/{2}", I18n.tr("zoom", new Object[0]), I18n.tr("latitude", new Object[0]), I18n.tr("longitude", new Object[0])));
            return null;
        }
        try {
            zoom = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), e);
            return null;
        }
        try {
            lat = Double.parseDouble(parts[1]);
        }
        catch (NumberFormatException e) {
            Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), e);
            return null;
        }
        try {
            lon = Double.parseDouble(parts[2]);
        }
        catch (NumberFormatException e) {
            Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), e);
            return null;
        }
        return OsmUrlToBounds.positionToBounds(lat, lon, zoom);
    }

    private static double parseDouble(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return Double.parseDouble(map.get(key));
        }
        if (map.containsKey('m' + key)) {
            return Double.parseDouble(map.get('m' + key));
        }
        throw new IllegalArgumentException(map.toString() + " does not contain " + key);
    }

    private static Bounds parseShortLink(String url) {
        if (!url.startsWith(SHORTLINK_PREFIX)) {
            return null;
        }
        String shortLink = url.substring(SHORTLINK_PREFIX.length());
        HashMap<Character, Integer> array = new HashMap<Character, Integer>();
        for (int i = 0; i < SHORTLINK_CHARS.length; ++i) {
            array.put(Character.valueOf(SHORTLINK_CHARS[i]), i);
        }
        long x = 0L;
        long y = 0L;
        int zoom = 0;
        int zoomOffset = 0;
        for (int j = 0; j < shortLink.length(); ++j) {
            char ch = shortLink.charAt(j);
            if (array.containsKey(Character.valueOf(ch))) {
                int val = (Integer)array.get(Character.valueOf(ch));
                for (int i = 0; i < 3; ++i) {
                    x <<= 1;
                    if ((val & 0x20) != 0) {
                        x |= 1L;
                    }
                    y <<= 1;
                    if (((val <<= 1) & 0x20) != 0) {
                        y |= 1L;
                    }
                    val <<= 1;
                }
                zoom += 3;
                continue;
            }
            --zoomOffset;
        }
        return OsmUrlToBounds.positionToBounds((double)(y <<= 32 - zoom) * 180.0 / 4.294967296E9 - 90.0, (double)(x <<= 32 - zoom) * 360.0 / 4.294967296E9 - 180.0, zoom - 8 - zoomOffset % 3 - 2);
    }

    public static void setMapSizeSupplier(Supplier<Dimension> mapSizeSupplier) {
        mapSize = Objects.requireNonNull(mapSizeSupplier, "mapSizeSupplier");
    }

    public static Bounds positionToBounds(double lat, double lon, int zoom) {
        Dimension screenSize = mapSize.get();
        double scale = (double)((1L << zoom) * 256L) / (Math.PI * 2 * Ellipsoid.WGS84.a);
        double deltaX = screenSize.getWidth() / 2.0 / scale;
        double deltaY = screenSize.getHeight() / 2.0 / scale;
        Projection mercator = Projections.getProjectionByCode("EPSG:3857");
        EastNorth projected = mercator.latlon2eastNorth(new LatLon(lat, lon));
        return new Bounds(mercator.eastNorth2latlon(projected.add(-deltaX, -deltaY)), mercator.eastNorth2latlon(projected.add(deltaX, deltaY)));
    }

    public static int getZoom(Bounds b) {
        Projection mercator = Projections.getProjectionByCode("EPSG:3857");
        EastNorth min = mercator.latlon2eastNorth(b.getMin());
        EastNorth max = mercator.latlon2eastNorth(b.getMax());
        double deltaX = max.getX() - min.getX();
        double scale = mapSize.get().getWidth() / deltaX;
        double x = scale * (Math.PI * 2 * Ellipsoid.WGS84.a) / 256.0;
        return (int)Math.round(Math.log(x) / Math.log(2.0));
    }

    public static String getURL(Bounds b) {
        return OsmUrlToBounds.getURL(b.getCenter(), OsmUrlToBounds.getZoom(b));
    }

    public static String getURL(LatLon pos, int zoom) {
        return OsmUrlToBounds.getURL(pos.lat(), pos.lon(), zoom);
    }

    public static String getURL(double dlat, double dlon, int zoom) {
        int decimals = (int)Math.pow(10.0, (double)zoom / 3.0);
        double lat = Math.round(dlat * (double)decimals);
        double lon = Math.round(dlon * (double)decimals);
        return Config.getUrls().getOSMWebsite() + "/#map=" + zoom + '/' + (lat /= (double)decimals) + '/' + (lon /= (double)decimals);
    }
}

