/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncKrbPrivPart {
    public byte[] userData = null;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;

    public EncKrbPrivPart(byte[] byArray, KerberosTime kerberosTime, Integer n, Integer n2, HostAddress hostAddress, HostAddress hostAddress2) {
        if (byArray != null) {
            this.userData = (byte[])byArray.clone();
        }
        this.timestamp = kerberosTime;
        this.usec = n;
        this.seqNumber = n2;
        this.sAddress = hostAddress;
        this.rAddress = hostAddress2;
    }

    public EncKrbPrivPart(byte[] byArray) throws Asn1Exception, IOException {
        this.init(new DerValue(byArray));
    }

    public EncKrbPrivPart(DerValue derValue) throws Asn1Exception, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, IOException {
        if ((derValue.getTag() & 0x1F) != 28 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.userData = derValue3.getData().getOctetString();
        this.timestamp = KerberosTime.parse(derValue2.getData(), (byte)1, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            this.usec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.usec = null;
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.seqNumber = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.seqNumber = null;
        }
        this.sAddress = HostAddress.parse(derValue2.getData(), (byte)4, false);
        if (derValue2.getData().available() > 0) {
            this.rAddress = HostAddress.parse(derValue2.getData(), (byte)5, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOctetString(this.userData);
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        if (this.timestamp != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream);
        }
        if (this.seqNumber != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)5), this.rAddress.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, true, (byte)28), derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

