/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.java_signature;

import java.util.List;
import org.jruby.ast.java_signature.ParameterNode;
import org.jruby.ast.java_signature.TypeNode;

public class SignatureNode {
    protected List<Object> modifiers;
    protected final String name;
    protected final List<ParameterNode> parameterList;
    protected String extraTypeInfo;
    protected List<TypeNode> throwTypes;

    public SignatureNode(String name2, List<ParameterNode> parameterList) {
        this.name = name2;
        this.parameterList = parameterList;
    }

    public String getName() {
        return this.name;
    }

    public List<ParameterNode> getParameters() {
        return this.parameterList;
    }

    public void setModifiers(List<Object> modifiers) {
        this.modifiers = modifiers;
    }

    public void setExtraTypeInfo(String extraTypeInfo) {
        this.extraTypeInfo = extraTypeInfo;
    }

    public List<Object> getModifiers() {
        return this.modifiers;
    }

    public void setThrows(List<TypeNode> throwTypes) {
        this.throwTypes = throwTypes;
    }

    public List<TypeNode> getThrows() {
        return this.throwTypes;
    }

    public String toString() {
        int i2;
        StringBuilder builder = new StringBuilder();
        for (Object modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        if (this.extraTypeInfo != null) {
            builder.append(this.extraTypeInfo).append(' ');
        }
        builder.append(this.name).append('(');
        int length2 = this.parameterList.size();
        for (i2 = 0; i2 < length2 - 1; ++i2) {
            builder.append(this.parameterList.get(i2)).append(", ");
        }
        if (length2 > 0) {
            builder.append(this.parameterList.get(length2 - 1));
        }
        builder.append(')');
        length2 = this.throwTypes.size();
        if (length2 > 0) {
            builder.append(" throws ");
            for (i2 = 0; i2 < length2 - 1; ++i2) {
                builder.append(this.throwTypes.get(i2)).append(", ");
            }
            builder.append(this.throwTypes.get(length2 - 1));
        }
        return builder.toString();
    }
}

