/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.PrintStream;

class OutputChoice {
    final OutputChoiceType outputChoiceType;
    final PrintStream targetPrintStream;

    OutputChoice(OutputChoiceType outputChoiceType) {
        if (outputChoiceType == OutputChoiceType.FILE) {
            throw new IllegalArgumentException();
        }
        this.outputChoiceType = outputChoiceType;
        this.targetPrintStream = outputChoiceType == OutputChoiceType.CACHED_SYS_OUT ? System.out : (outputChoiceType == OutputChoiceType.CACHED_SYS_ERR ? System.err : null);
    }

    OutputChoice(PrintStream printStream) {
        this.outputChoiceType = OutputChoiceType.FILE;
        this.targetPrintStream = printStream;
    }

    PrintStream getTargetPrintStream() {
        switch (this.outputChoiceType) {
            case SYS_OUT: {
                return System.out;
            }
            case SYS_ERR: {
                return System.err;
            }
            case CACHED_SYS_ERR: 
            case CACHED_SYS_OUT: 
            case FILE: {
                return this.targetPrintStream;
            }
        }
        throw new IllegalArgumentException();
    }

    static final class OutputChoiceType
    extends Enum<OutputChoiceType> {
        public static final /* enum */ OutputChoiceType SYS_OUT = new OutputChoiceType();
        public static final /* enum */ OutputChoiceType CACHED_SYS_OUT = new OutputChoiceType();
        public static final /* enum */ OutputChoiceType SYS_ERR = new OutputChoiceType();
        public static final /* enum */ OutputChoiceType CACHED_SYS_ERR = new OutputChoiceType();
        public static final /* enum */ OutputChoiceType FILE = new OutputChoiceType();
        private static final /* synthetic */ OutputChoiceType[] $VALUES;

        public static OutputChoiceType[] values() {
            return (OutputChoiceType[])$VALUES.clone();
        }

        static {
            $VALUES = new OutputChoiceType[]{SYS_OUT, CACHED_SYS_OUT, SYS_ERR, CACHED_SYS_ERR, FILE};
        }
    }
}

