/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.ExpectSymbolTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeParameterRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010+2\u0006\u0010(\u001a\u00020)J\u0010\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020&2\u0006\u0010(\u001a\u00020&H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020-H\u0016J(\u00101\u001a\u000202*\u0002022\u0006\u00103\u001a\u00020\u00102\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u000e\u00105\u001a\u0004\u0018\u000106*\u000206H\u0002J\u000e\u00107\u001a\u0004\u0018\u000106*\u000206H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover;", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "doRemove", "", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Z)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeParameterSubstitutionMap", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "getActualClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getActualConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "getActualFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getActualProperty", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isOptionalAnnotationClass", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldRemoveTopLevelDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "transformFlat", "", "tryCopyDefaultArguments", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitFile", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/IrStatement;", "copyAndActualizeDefaultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "actualFunction", "expectActualTypeParametersMap", "findActualForExpect", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "findExpectForActual", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nExpectDeclarationRemover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n*L\n1#1,187:1\n1#2:188\n26#3,10:189\n*S KotlinDebug\n*F\n+ 1 ExpectDeclarationRemover.kt\norg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationRemover\n*L\n168#1:189,10\n*E\n"})
public class ExpectDeclarationRemover
extends ExpectSymbolTransformer
implements FileLoweringPass {
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    private final boolean doRemove;
    @NotNull
    private final Map<Pair<IrFunction, IrFunction>, Map<IrTypeParameter, IrTypeParameter>> typeParameterSubstitutionMap;

    public ExpectDeclarationRemover(@NotNull ReferenceSymbolTable symbolTable, boolean doRemove) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        this.symbolTable = symbolTable;
        this.doRemove = doRemove;
        this.typeParameterSubstitutionMap = new LinkedHashMap();
    }

    @NotNull
    public final ReferenceSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ExpectDeclarationRemover(@NotNull BackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this(context.getIr().getSymbols().getExternalSymbolTable(), true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.visitFile(irFile);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.doRemove) {
            CollectionsKt.removeAll(declaration.getDeclarations(), (Function1)new Function1<IrDeclaration, Boolean>(this){
                final /* synthetic */ ExpectDeclarationRemover this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull IrDeclaration it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return ExpectDeclarationRemover.access$shouldRemoveTopLevelDeclaration(this.this$0, it);
                }
            });
        }
        return super.visitFile(declaration);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.tryCopyDefaultArguments(declaration);
        return super.visitValueParameter(declaration);
    }

    @Nullable
    public final List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (AdditionalIrUtilsKt.isTopLevelDeclaration(declaration) && this.shouldRemoveTopLevelDeclaration(declaration)) {
            return CollectionsKt.emptyList();
        }
        if (declaration instanceof IrValueParameter) {
            this.tryCopyDefaultArguments((IrValueParameter)declaration);
        }
        return null;
    }

    @Override
    @Nullable
    protected IrClassSymbol getActualClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        ClassDescriptor classDescriptor2 = memberDescriptor instanceof ClassDescriptor ? (ClassDescriptor)memberDescriptor : null;
        if (classDescriptor2 == null) {
            return null;
        }
        return this.symbolTable.referenceClass(classDescriptor2);
    }

    @Override
    @Nullable
    protected ExpectSymbolTransformer.ActualPropertyResult getActualProperty(@NotNull PropertyDescriptor descriptor2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        PropertyDescriptor propertyDescriptor = memberDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)memberDescriptor : null;
        if (propertyDescriptor == null) {
            return null;
        }
        IrPropertySymbol newSymbol = this.symbolTable.referenceProperty(propertyDescriptor);
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getGetter();
        if (propertyGetterDescriptor != null) {
            PropertyGetterDescriptor it = propertyGetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol2 = this.symbolTable.referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol2 = null;
        }
        IrSimpleFunctionSymbol newGetter = irSimpleFunctionSymbol2;
        PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)newSymbol.getDescriptor()).getSetter();
        if (propertySetterDescriptor != null) {
            PropertySetterDescriptor it = propertySetterDescriptor;
            boolean bl = false;
            irSimpleFunctionSymbol = this.symbolTable.referenceSimpleFunction(it);
        } else {
            irSimpleFunctionSymbol = null;
        }
        IrSimpleFunctionSymbol newSetter = irSimpleFunctionSymbol;
        return new ExpectSymbolTransformer.ActualPropertyResult(newSymbol, newGetter, newSetter);
    }

    @Override
    @Nullable
    protected IrConstructorSymbol getActualConstructor(@NotNull ClassConstructorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        ClassConstructorDescriptor classConstructorDescriptor = memberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)memberDescriptor : null;
        if (classConstructorDescriptor == null) {
            return null;
        }
        return this.symbolTable.referenceConstructor(classConstructorDescriptor);
    }

    @Override
    @Nullable
    protected IrSimpleFunctionSymbol getActualFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        MemberDescriptor memberDescriptor = this.findActualForExpect(descriptor2);
        FunctionDescriptor functionDescriptor = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
        if (functionDescriptor == null) {
            return null;
        }
        return this.symbolTable.referenceSimpleFunction(functionDescriptor);
    }

    private final MemberDescriptor findActualForExpect(MemberDescriptor $this$findActualForExpect) {
        if (!$this$findActualForExpect.isExpect()) {
            throw new IllegalStateException($this$findActualForExpect.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull(ExpectedActualResolverKt.findCompatibleActualsForExpected$default($this$findActualForExpect, DescriptorUtilsKt.getModule($this$findActualForExpect), null, 2, null));
    }

    private final boolean shouldRemoveTopLevelDeclaration(IrDeclaration declaration) {
        IrDeclaration irDeclaration2;
        return this.doRemove && ((irDeclaration2 = declaration) instanceof IrClass ? ((IrClass)declaration).isExpect() : (irDeclaration2 instanceof IrProperty ? ((IrProperty)declaration).isExpect() : (irDeclaration2 instanceof IrFunction ? ((IrFunction)declaration).isExpect() : false)));
    }

    private final boolean isOptionalAnnotationClass(IrClass klass) {
        return klass.getKind() == ClassKind.ANNOTATION_CLASS && klass.isExpect() && AdditionalIrUtilsKt.hasAnnotation(klass.getAnnotations(), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME());
    }

    private final void tryCopyDefaultArguments(IrValueParameter declaration) {
        Object object;
        int index2;
        IrFunction function2;
        block12: {
            block11: {
                if (declaration.getDefaultValue() != null) {
                    return;
                }
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrFunction irFunction2 = irDeclarationParent instanceof IrFunction ? (IrFunction)irDeclarationParent : null;
                if (irFunction2 == null) {
                    return;
                }
                function2 = irFunction2;
                if (function2 instanceof IrConstructor && this.isOptionalAnnotationClass(AdditionalIrUtilsKt.getConstructedClass((IrConstructor)function2))) {
                    return;
                }
                if (!function2.getDescriptor().isActual()) {
                    return;
                }
                index2 = declaration.getIndex();
                if (index2 < 0) {
                    return;
                }
                boolean bl = Intrinsics.areEqual(function2.getValueParameters().get(index2), declaration);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                MemberDescriptor memberDescriptor = this.findExpectForActual(function2.getDescriptor());
                object = memberDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)memberDescriptor : null;
                if (object == null) break block11;
                FunctionDescriptor it = object;
                boolean bl2 = false;
                IrFunction irFunction3 = IrUtilsKt.referenceFunction(this.symbolTable, it).getOwner();
                object = irFunction3;
                if (irFunction3 != null) break block12;
            }
            return;
        }
        Object expectFunction = object;
        IrExpressionBody irExpressionBody = ((IrFunction)expectFunction).getValueParameters().get(index2).getDefaultValue();
        if (irExpressionBody == null) {
            return;
        }
        IrExpressionBody defaultValue = irExpressionBody;
        Pair<Object, IrFunction> expectToActual = TuplesKt.to(expectFunction, function2);
        if (!this.typeParameterSubstitutionMap.containsKey(expectToActual)) {
            List<IrTypeParameter> functionTypeParameters = IrTypeSystemContextKt.extractTypeParameters(function2);
            List<IrTypeParameter> expectFunctionTypeParameters = IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)expectFunction);
            List typeParametersMapping = CollectionsKt.zip((Iterable)expectFunctionTypeParameters, (Iterable)functionTypeParameters);
            boolean bl = false;
            this.typeParameterSubstitutionMap.put(expectToActual, MapsKt.toMap(typeParametersMapping));
        }
        IrExpressionBody originalDefault = defaultValue;
        boolean bl = false;
        declaration.setDefaultValue(this.copyAndActualizeDefaultValue(originalDefault, function2, MapsKt.getValue(this.typeParameterSubstitutionMap, expectToActual)));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpressionBody copyAndActualizeDefaultValue(IrExpressionBody $this$copyAndActualizeDefaultValue, IrFunction actualFunction, Map<IrTypeParameter, ? extends IrTypeParameter> expectActualTypeParametersMap) {
        void symbolRemapper2;
        void $this$deepCopyWithSymbols$iv$iv;
        void $this$deepCopyWithSymbols$iv;
        IrElement irElement = $this$copyAndActualizeDefaultValue;
        boolean $i$f$deepCopyWithSymbols = false;
        void var6_6 = $this$deepCopyWithSymbols$iv;
        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
        boolean $i$f$deepCopyWithSymbols2 = false;
        IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
        DeepCopyTypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
        SymbolRemapper symbolRemapper3 = symbolRemapper$iv$iv;
        void var12_11 = $this$deepCopyWithSymbols$iv$iv;
        boolean bl = false;
        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var12_11.transform(new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper2, new IrTypeParameterRemapper(expectActualTypeParametersMap)), null), actualFunction);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
        }
        return ((IrExpressionBody)((IrElement)((IrExpressionBody)irElement2))).transform((IrElementTransformer)new IrElementTransformerVoid(this){
            final /* synthetic */ ExpectDeclarationRemover this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                this.transformChildrenVoid(expression2);
                return LowerUtilsKt.actualize(expression2, (Function1<? super IrClass, ? extends IrClass>)new Function1<IrClass, IrClass>(this.this$0){
                    final /* synthetic */ ExpectDeclarationRemover this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrClass invoke(@NotNull IrClass it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        ReferenceSymbolTable referenceSymbolTable = this.this$0.getSymbolTable();
                        MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this.this$0, it.getDescriptor());
                        Intrinsics.checkNotNull(memberDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        return (IrClass)referenceSymbolTable.referenceClass((ClassDescriptor)memberDescriptor).getOwner();
                    }
                }, (Function1<? super IrFunction, ? extends IrFunction>)new Function1<IrFunction, IrFunction>(this.this$0){
                    final /* synthetic */ ExpectDeclarationRemover this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final IrFunction invoke(@NotNull IrFunction it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        ReferenceSymbolTable referenceSymbolTable = this.this$0.getSymbolTable();
                        MemberDescriptor memberDescriptor = ExpectDeclarationRemover.access$findActualForExpect(this.this$0, it.getDescriptor());
                        Intrinsics.checkNotNull(memberDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                        return IrUtilsKt.referenceFunction(referenceSymbolTable, (FunctionDescriptor)memberDescriptor).getOwner();
                    }
                });
            }
        }, (Object)null);
    }

    private final MemberDescriptor findExpectForActual(MemberDescriptor $this$findExpectForActual) {
        if (!$this$findExpectForActual.isActual()) {
            throw new IllegalStateException($this$findExpectForActual.toString());
        }
        return (MemberDescriptor)CollectionsKt.singleOrNull(ExpectedActualResolverKt.findCompatibleExpectsForActual$default($this$findExpectForActual, null, 1, null));
    }

    public static final /* synthetic */ boolean access$shouldRemoveTopLevelDeclaration(ExpectDeclarationRemover $this, IrDeclaration declaration) {
        return $this.shouldRemoveTopLevelDeclaration(declaration);
    }

    public static final /* synthetic */ MemberDescriptor access$findActualForExpect(ExpectDeclarationRemover $this, MemberDescriptor $receiver) {
        return $this.findActualForExpect($receiver);
    }
}

