/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.jvm.JvmIrSerializer;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmGlobalDeclarationTable;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIrSerializerSession;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrMessageLoggerKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmIrSerializerImpl;", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "makeSerializerSession", "Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "fileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "serializeIrFile", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelIrClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.entrypoint"})
public final class JvmIrSerializerImpl
implements JvmIrSerializer {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final DeclarationTable declarationTable;

    public JvmIrSerializerImpl(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        this.configuration = configuration2;
        this.declarationTable = new DeclarationTable(new JvmGlobalDeclarationTable());
    }

    @Override
    @Nullable
    public byte[] serializeIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        FqName fileClassFqName = FileClassLoweringKt.getFileClassInfo(irFile).getFileClassFqName();
        JvmIr.ClassOrFile classOrFile = this.makeSerializerSession(fileClassFqName).serializeJvmIrFile(irFile);
        return (byte[])(classOrFile != null ? classOrFile.toByteArray() : null);
    }

    @Override
    @Nullable
    public byte[] serializeTopLevelIrClass(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        boolean bl = irClass2.getParent() instanceof IrFile;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrDeclarationParent irDeclarationParent = irClass2.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
        FqName fileClassFqName = FileClassLoweringKt.getFileClassInfo((IrFile)irDeclarationParent).getFileClassFqName();
        JvmIr.ClassOrFile classOrFile = this.makeSerializerSession(fileClassFqName).serializeTopLevelClass(irClass2);
        return (byte[])(classOrFile != null ? classOrFile.toByteArray() : null);
    }

    private final JvmIrSerializerSession makeSerializerSession(FqName fileClassFqName) {
        IrMessageLogger irMessageLogger = IrMessageLoggerKt.getIrMessageLogger(this.configuration);
        Map map = new LinkedHashMap();
        JvmSerializeIrMode jvmSerializeIrMode = this.configuration.get(JVMConfigurationKeys.SERIALIZE_IR);
        if (jvmSerializeIrMode == null) {
            jvmSerializeIrMode = JvmSerializeIrMode.NONE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jvmSerializeIrMode, "configuration.get(JVMCon\u2026: JvmSerializeIrMode.NONE");
        return new JvmIrSerializerSession(irMessageLogger, this.declarationTable, map, jvmSerializeIrMode, fileClassFqName, CommonConfigurationKeysKt.getLanguageVersionSettings(this.configuration), false, 64, null);
    }
}

