/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ElementTypeUtils;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirGenerationKt;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.builder.BaseFirBuilder;
import org.jetbrains.kotlin.fir.builder.CalleeAndReceiver;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.builder.FirLabelBuilder;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.diagnostics.ConeNotAnnotationContainer;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnderscoreUsageWithoutBackticks;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAbstractFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnonymousFunctionExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayOfCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBlockBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBreakExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCatchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckNotNullCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirContinueExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirDoWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirElseIfTrueConditionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirEmptyExpressionBlockBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirEqualityOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirErrorExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirGetClassCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirImplicitInvokeCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLambdaArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirLoopJumpBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirNamedArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirQualifiedErrorAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThrowExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTryExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirTypeOperatorCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirUnitExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenBranchBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhileLoopBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.lightTree.LightTree2Fir;
import org.jetbrains.kotlin.fir.lightTree.converter.BaseConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ConverterUtilKt;
import org.jetbrains.kotlin.fir.lightTree.converter.DeclarationsConverter;
import org.jetbrains.kotlin.fir.lightTree.converter.ExpressionsConverter;
import org.jetbrains.kotlin.fir.lightTree.fir.DestructuringDeclaration;
import org.jetbrains.kotlin.fir.lightTree.fir.ValueParameter;
import org.jetbrains.kotlin.fir.lightTree.fir.WhenEntry;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitSuperReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirExplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.stubs.elements.KtConstantExpressionElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtNameReferenceExpressionElementType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001yB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b#H\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0006H\u0002J&\u0010(\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,\u0018\u00010)2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0006H\u0002J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0006H\u0002J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0006H\u0002J\u0016\u00106\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00062\u0006\u00107\u001a\u00020!J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u0006H\u0002J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0006H\u0002J\u0010\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180?2\u0006\u0010@\u001a\u00020\u0006H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0006H\u0002J\u0010\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0012\u0010E\u001a\u00020+2\b\u0010F\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010G\u001a\u00020\u00182\u0006\u0010H\u001a\u00020\u0006H\u0002J\u0014\u0010I\u001a\u0004\u0018\u00010+2\b\u0010F\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020\u0006H\u0002J\u0010\u0010L\u001a\u00020\u00182\u0006\u0010M\u001a\u00020\u0006H\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0006H\u0002J\u0010\u0010Q\u001a\u00020\u00182\u0006\u0010R\u001a\u00020\u0006H\u0002J\u0010\u0010S\u001a\u00020O2\u0006\u0010T\u001a\u00020\u0006H\u0002J\u0010\u0010U\u001a\u00020O2\u0006\u0010V\u001a\u00020\u0006H\u0002J\u0010\u0010W\u001a\u00020\u00182\u0006\u0010X\u001a\u00020\u0006H\u0002J\u0010\u0010Y\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020\u0006H\u0002J\u0010\u0010[\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020\u0006H\u0002J\u0010\u0010]\u001a\u00020\u00182\u0006\u0010^\u001a\u00020\u0006H\u0002J\u0014\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00180?2\u0006\u0010`\u001a\u00020\u0006J \u0010a\u001a\u00020\u00182\u0006\u0010b\u001a\u00020\u00062\u000e\u0010c\u001a\n\u0012\u0004\u0012\u00020e\u0018\u00010dH\u0002J \u0010f\u001a\u00020\u00182\u0006\u0010b\u001a\u00020\u00062\u000e\u0010c\u001a\n\u0012\u0004\u0012\u00020e\u0018\u00010dH\u0002J \u0010g\u001a\u00020\u00182\u0006\u0010b\u001a\u00020\u00062\u000e\u0010c\u001a\n\u0012\u0004\u0012\u00020e\u0018\u00010dH\u0002J \u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020\u00062\u000e\u0010c\u001a\n\u0012\u0004\u0012\u00020e\u0018\u00010dH\u0002J\u0010\u0010k\u001a\u00020\u00182\u0006\u0010l\u001a\u00020\u0006H\u0002J\u0010\u0010m\u001a\u00020\u00152\u0006\u0010n\u001a\u00020\u0006H\u0002J\u0018\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020r2\u0006\u0010P\u001a\u00020\u0006H\u0002J.\u0010s\u001a\u0002Ht\"\n\b\u0000\u0010t\u0018\u0001*\u00020\u00152\b\u00101\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u00107\u001a\u00020!H\u0086\b\u00a2\u0006\u0002\u0010uJ\u0010\u0010v\u001a\u00020w2\u0006\u0010=\u001a\u00020\u0006H\u0002J\u0016\u0010x\u001a\u00020\u0018*\u0004\u0018\u00010\u00062\u0006\u00107\u001a\u00020!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006z"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter;", "Lorg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "declarationsConverter", "Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lcom/intellij/util/diff/FlyweightCapableTreeStructure;Lorg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter;Lorg/jetbrains/kotlin/fir/builder/Context;)V", "offset", "", "getOffset", "()I", "usedAsExpression", "", "getUsedAsExpression", "(Lcom/intellij/lang/LighterASTNode;)Z", "convertAnnotatedExpression", "Lorg/jetbrains/kotlin/fir/FirElement;", "annotatedExpression", "convertArrayAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "arrayAccess", "convertBinaryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "binaryExpression", "convertBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "toFirOperation", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "Lkotlin/ExtensionFunctionType;", "convertCallExpression", "callSuffix", "convertCallableReferenceExpression", "callableReferenceExpression", "convertCatchClause", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/fir/lightTree/fir/ValueParameter;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "catchClause", "convertClassLiteralExpression", "classLiteralExpression", "convertCollectionLiteralExpression", "expression", "convertConstantExpression", "constantExpression", "convertDoWhile", "doWhileLoop", "convertExpression", "errorReason", "convertFinally", "finallyExpression", "convertFor", "forLoop", "convertIfExpression", "ifExpression", "convertIndices", "", "indices", "convertLabeledExpression", "labeledExpression", "convertLambdaExpression", "lambdaExpression", "convertLoopBody", "body", "convertLoopJump", "jump", "convertLoopOrIfBody", "convertQualifiedExpression", "dotQualifiedExpression", "convertReturn", "returnExpression", "convertSimpleNameExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "referenceExpression", "convertStringTemplate", "stringTemplate", "convertSuperExpression", "superExpression", "convertThisExpression", "thisExpression", "convertThrow", "throwExpression", "convertTryExpression", "tryExpression", "convertUnaryExpression", "unaryExpression", "convertValueArgument", "valueArgument", "convertValueArguments", "valueArguments", "convertWhenConditionExpression", "whenCondition", "whenRefWithSubject", "Lorg/jetbrains/kotlin/fir/FirExpressionRef;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "convertWhenConditionInRange", "convertWhenConditionIsPattern", "convertWhenEntry", "Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "whenEntry", "convertWhenExpression", "whenExpression", "convertWhile", "whileLoop", "createSimpleNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "sourceElement", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAsFirExpression", "R", "(Lcom/intellij/lang/LighterASTNode;Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/FirElement;", "parseIfExpression", "Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter$IfNodeComponents;", "convertShortOrLongStringTemplate", "IfNodeComponents", "light-tree2fir"})
@SourceDebugExtension(value={"SMAP\nExpressionsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BaseConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/BaseConverter\n+ 4 FirAnonymousFunctionBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirAnonymousFunctionBuilderKt\n+ 5 FirLabelBuilder.kt\norg/jetbrains/kotlin/fir/builder/FirLabelBuilderKt\n+ 6 FirValueParameterBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirValueParameterBuilderKt\n+ 7 DeclarationsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/DeclarationsConverter\n+ 8 FirReturnExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirReturnExpressionBuilderKt\n+ 9 FirUnitExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirUnitExpressionBuilderKt\n+ 10 FirSingleExpressionBlock.kt\norg/jetbrains/kotlin/fir/expressions/impl/FirSingleExpressionBlockKt\n+ 11 FirAnonymousFunctionExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirAnonymousFunctionExpressionBuilderKt\n+ 12 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 13 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n+ 14 FirEqualityOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirEqualityOperatorCallBuilderKt\n+ 15 FirTypeOperatorCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTypeOperatorCallBuilderKt\n+ 16 FirCheckNotNullCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCheckNotNullCallBuilderKt\n+ 17 FirGetClassCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirGetClassCallBuilderKt\n+ 18 FirCallableReferenceAccessBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCallableReferenceAccessBuilderKt\n+ 19 FirErrorExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirErrorExpressionBuilderKt\n+ 20 FirQualifiedErrorAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirQualifiedErrorAccessExpressionBuilderKt\n+ 21 FirErrorNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirErrorNamedReferenceBuilderKt\n+ 22 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 23 FirPropertyBuilder.kt\norg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilderKt\n+ 24 FirWhenExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenExpressionBuilderKt\n+ 25 FirWhenBranchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenBranchBuilderKt\n+ 26 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt\n+ 27 FirElseIfTrueConditionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirElseIfTrueConditionBuilderKt$buildElseIfTrueCondition$1\n+ 28 FirWhenSubjectExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirWhenSubjectExpressionBuilderKt\n+ 29 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n+ 30 FirArrayOfCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArrayOfCallBuilderKt\n+ 31 FirPropertyAccessExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirPropertyAccessExpressionBuilderKt\n+ 32 FirBlockBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirBlockBuilderKt\n+ 33 FirTryExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirTryExpressionBuilderKt\n+ 34 FirCatchBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirCatchBuilderKt\n+ 35 FirThrowExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThrowExpressionBuilderKt\n+ 36 FirThisReceiverExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirThisReceiverExpressionBuilderKt\n+ 37 FirExplicitThisReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitThisReferenceBuilderKt\n+ 38 FirExplicitSuperReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirExplicitSuperReferenceBuilderKt\n+ 39 FirLambdaArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirLambdaArgumentExpressionBuilderKt\n+ 40 FirNamedArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirNamedArgumentExpressionBuilderKt\n+ 41 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n*L\n1#1,1499:1\n67#1:1501\n68#1,5:1503\n67#1:1508\n68#1,5:1510\n67#1:1570\n68#1,5:1572\n67#1:1577\n68#1,5:1579\n67#1:1606\n68#1,5:1608\n66#1,2:1628\n68#1,5:1631\n67#1:1653\n68#1,5:1655\n67#1:1660\n68#1,5:1662\n66#1,2:1685\n68#1,5:1688\n67#1:1704\n68#1,5:1706\n67#1:1726\n68#1,5:1728\n67#1:1748\n68#1,5:1750\n67#1:1812\n68#1,5:1814\n67#1:1834\n68#1,5:1836\n67#1:1841\n68#1,5:1843\n67#1:1896\n68#1,5:1898\n67#1:1922\n68#1,5:1924\n67#1:1972\n68#1,5:1974\n67#1:2002\n68#1,5:2004\n67#1:2028\n68#1,5:2030\n67#1:2054\n68#1,5:2056\n67#1:2072\n68#1,5:2074\n67#1:2090\n68#1,5:2092\n66#1,2:2128\n68#1,5:2131\n66#1,2:2136\n68#1,5:2139\n66#1,2:2144\n68#1,5:2147\n67#1:2241\n68#1,5:2243\n67#1:2271\n68#1,5:2273\n67#1:2293\n68#1,5:2295\n66#1,2:2349\n68#1,5:2352\n67#1:2368\n68#1,5:2370\n67#1:2384\n68#1,5:2386\n67#1:2391\n68#1,5:2393\n1#2:1500\n1#2:1502\n1#2:1509\n1#2:1571\n1#2:1578\n1#2:1607\n1#2:1630\n1#2:1654\n1#2:1661\n1#2:1687\n1#2:1705\n1#2:1727\n1#2:1749\n1#2:1813\n1#2:1835\n1#2:1842\n1#2:1897\n1#2:1923\n1#2:1973\n1#2:2003\n1#2:2029\n1#2:2055\n1#2:2073\n1#2:2091\n1#2:2130\n1#2:2138\n1#2:2146\n1#2:2242\n1#2:2272\n1#2:2294\n1#2:2351\n1#2:2369\n1#2:2385\n1#2:2392\n176#3,12:1515\n176#3,12:1558\n176#3,10:1596\n187#3:1613\n176#3,10:1618\n187#3:1636\n176#3,12:1637\n176#3,10:1675\n187#3:1693\n176#3,10:1694\n187#3:1711\n176#3,10:1716\n187#3:1733\n176#3,10:1738\n187#3:1759\n176#3,12:1768\n176#3,10:1802\n187#3:1819\n176#3,10:1820\n187#3:1848\n176#3,12:1874\n176#3,10:1886\n187#3:1903\n176#3,10:1912\n187#3:1929\n176#3,12:1938\n176#3,10:1962\n187#3:1979\n176#3,10:1992\n187#3:2009\n176#3,10:2018\n187#3:2035\n176#3,10:2044\n187#3:2061\n176#3,10:2062\n187#3:2079\n176#3,10:2080\n187#3:2097\n176#3,10:2118\n187#3:2152\n176#3,12:2153\n176#3,12:2177\n176#3,12:2189\n176#3,12:2209\n176#3,10:2231\n187#3:2248\n176#3,12:2249\n176#3,10:2261\n187#3:2278\n176#3,10:2283\n187#3:2300\n176#3,12:2313\n190#3,12:2333\n204#3:2357\n176#3,10:2358\n187#3:2375\n116#4,4:1527\n38#5,4:1531\n100#6,4:1535\n80#7,4:1539\n85#7,2:1551\n60#8,4:1543\n47#9,4:1547\n47#9,4:2279\n71#10:1553\n47#11,4:1554\n73#12,4:1584\n73#12,4:1667\n73#12,4:1980\n73#12,4:2102\n73#12,4:2110\n41#13,4:1588\n41#13,4:1671\n41#13,4:1780\n41#13,4:1784\n41#13,4:1984\n41#13,4:2040\n41#13,4:2106\n41#13,4:2114\n57#14,4:1592\n57#14,4:1904\n61#15,4:1614\n61#15,4:1958\n53#16,4:1649\n51#17,4:1712\n67#18,4:1734\n61#19,4:1755\n61#19,4:1764\n61#19,4:1934\n61#19,4:1954\n61#20,4:1760\n40#21,4:1788\n40#21,4:1792\n1360#22:1796\n1446#22,5:1797\n1620#22,3:1849\n115#23,4:1830\n115#23,4:2173\n64#24,4:1852\n64#24,4:2201\n42#25,4:1856\n42#25,4:1860\n42#25,4:1864\n42#25,4:2205\n42#25,4:2221\n46#26,5:1868\n46#26,5:2225\n46#27:1873\n46#27:2230\n54#28,4:1908\n54#28,4:1930\n54#28,4:1950\n33#29,4:1988\n33#29,4:2014\n50#30,4:2010\n68#31,4:2036\n68#31,4:2325\n54#32,4:2098\n58#33,4:2165\n42#34,4:2169\n56#35,4:2301\n82#36,4:2305\n41#37,4:2309\n41#38,4:2329\n53#39,4:2345\n58#40,4:2376\n53#41,4:2380\n*S KotlinDebug\n*F\n+ 1 ExpressionsConverter.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter\n*L\n121#1:1501\n121#1:1503,5\n124#1:1508\n124#1:1510,5\n276#1:1570\n276#1:1572,5\n280#1:1577\n280#1:1579,5\n344#1:1606\n344#1:1608,5\n380#1:1628,2\n380#1:1631,5\n414#1:1653\n414#1:1655,5\n428#1:1660\n428#1:1662,5\n458#1:1685,2\n458#1:1688,5\n476#1:1704\n476#1:1706,5\n503#1:1726\n503#1:1728,5\n538#1:1748\n538#1:1750,5\n707#1:1812\n707#1:1814,5\n745#1:1834\n745#1:1836,5\n748#1:1841\n748#1:1843,5\n833#1:1896\n833#1:1898,5\n875#1:1922\n875#1:1924,5\n954#1:1972\n954#1:1974,5\n981#1:2002\n981#1:2004,5\n998#1:2028\n998#1:2030,5\n1051#1:2054\n1051#1:2056,5\n1069#1:2072\n1069#1:2074,5\n1095#1:2090\n1095#1:2092,5\n1186#1:2128,2\n1186#1:2131,5\n1188#1:2136,2\n1188#1:2139,5\n1191#1:2144,2\n1191#1:2147,5\n1327#1:2241\n1327#1:2243,5\n1384#1:2271\n1384#1:2273,5\n1405#1:2293\n1405#1:2295,5\n1459#1:2349,2\n1459#1:2352,5\n1479#1:2368\n1479#1:2370,5\n618#1:2384\n618#1:2386,5\n628#1:2391\n628#1:2393,5\n121#1:1502\n124#1:1509\n276#1:1571\n280#1:1578\n344#1:1607\n380#1:1630\n414#1:1654\n428#1:1661\n458#1:1687\n476#1:1705\n503#1:1727\n538#1:1749\n707#1:1813\n745#1:1835\n748#1:1842\n833#1:1897\n875#1:1923\n954#1:1973\n981#1:2003\n998#1:2029\n1051#1:2055\n1069#1:2073\n1095#1:2091\n1186#1:2130\n1188#1:2138\n1191#1:2146\n1327#1:2242\n1384#1:2272\n1405#1:2294\n1459#1:2351\n1479#1:2369\n618#1:2385\n628#1:2392\n145#1:1515,12\n249#1:1558,12\n340#1:1596,10\n340#1:1613\n366#1:1618,10\n366#1:1636\n398#1:1637,12\n451#1:1675,10\n451#1:1693\n475#1:1694,10\n475#1:1711\n497#1:1716,10\n497#1:1733\n528#1:1738,10\n528#1:1759\n608#1:1768,12\n706#1:1802,10\n706#1:1819\n728#1:1820,10\n728#1:1848\n812#1:1874,12\n831#1:1886,10\n831#1:1903\n866#1:1912,10\n866#1:1929\n913#1:1938,12\n951#1:1962,10\n951#1:1979\n980#1:1992,10\n980#1:2009\n997#1:2018,10\n997#1:2035\n1048#1:2044,10\n1048#1:2061\n1066#1:2062,10\n1066#1:2079\n1092#1:2080,10\n1092#1:2097\n1181#1:2118,10\n1181#1:2152\n1206#1:2153,12\n1247#1:2177,12\n1263#1:2189,12\n1295#1:2209,12\n1325#1:2231,10\n1325#1:2248\n1360#1:2249,12\n1381#1:2261,10\n1381#1:2278\n1404#1:2283,10\n1404#1:2300\n1433#1:2313,12\n1452#1:2333,12\n1452#1:2357\n1473#1:2358,10\n1473#1:2375\n155#1:1527,4\n165#1:1531,4\n177#1:1535,4\n203#1:1539,4\n203#1:1551,2\n214#1:1543,4\n217#1:1547,4\n1388#1:2279,4\n227#1:1553\n233#1:1554,4\n297#1:1584,4\n430#1:1667,4\n958#1:1980,4\n1111#1:2102,4\n1123#1:2110,4\n299#1:1588,4\n432#1:1671,4\n640#1:1780,4\n648#1:1784,4\n961#1:1984,4\n1029#1:2040,4\n1113#1:2106,4\n1125#1:2114,4\n319#1:1592,4\n846#1:1904,4\n348#1:1614,4\n936#1:1958,4\n412#1:1649,4\n479#1:1712,4\n511#1:1734,4\n547#1:1755,4\n589#1:1764,4\n885#1:1934,4\n927#1:1954,4\n580#1:1760,4\n659#1:1788,4\n668#1:1792,4\n682#1:1796\n682#1:1797,5\n756#1:1849,3\n731#1:1830,4\n1220#1:2173,4\n762#1:1852,4\n1279#1:2201,4\n773#1:1856,4\n780#1:1860,4\n787#1:1864,4\n1284#1:2205,4\n1305#1:2221,4\n789#1:1868,5\n1307#1:2225,5\n789#1:1873\n1307#1:2230\n850#1:1908,4\n880#1:1930,4\n922#1:1950,4\n967#1:1988,4\n986#1:2014,4\n984#1:2010,4\n1015#1:2036,4\n1439#1:2325,4\n1105#1:2098,4\n1213#1:2165,4\n1219#1:2169,4\n1408#1:2301,4\n1420#1:2305,4\n1422#1:2309,4\n1441#1:2329,4\n1457#1:2345,4\n1485#1:2376,4\n1491#1:2380,4\n*E\n"})
public final class ExpressionsConverter
extends BaseConverter {
    @NotNull
    private final DeclarationsConverter declarationsConverter;

    public ExpressionsConverter(@NotNull FirSession session, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull DeclarationsConverter declarationsConverter, @NotNull Context<LighterASTNode> context) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(declarationsConverter, "declarationsConverter");
        Intrinsics.checkNotNullParameter(context, "context");
        super(session, tree, context);
        this.declarationsConverter = declarationsConverter;
    }

    public /* synthetic */ ExpressionsConverter(FirSession firSession, FlyweightCapableTreeStructure flyweightCapableTreeStructure, DeclarationsConverter declarationsConverter, Context context, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            context = new Context<LighterASTNode>();
        }
        this(firSession, flyweightCapableTreeStructure, declarationsConverter, context);
    }

    @Override
    public int getOffset() {
        return this.declarationsConverter.getOffset();
    }

    public final /* synthetic */ <R extends FirElement> R getAsFirExpression(LighterASTNode expression2, String errorReason) {
        FirElement firElement;
        FirElement firElement2;
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        boolean $i$f$getAsFirExpression = false;
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            firElement2 = this.convertExpression(it, errorReason);
        } else {
            firElement2 = null;
        }
        FirElement converted = firElement2;
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement3 = converted;
        if (firElement3 != null) {
            firElement = firElement3;
        } else {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, expression2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected), converted);
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement = firErrorExpression;
        }
        return (R)firElement;
    }

    public static /* synthetic */ FirElement getAsFirExpression$default(ExpressionsConverter $this, LighterASTNode expression2, String errorReason, int n, Object object) {
        FirElement firElement;
        FirElement firElement2;
        if ((n & 2) != 0) {
            errorReason = "";
        }
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        boolean $i$f$getAsFirExpression = false;
        LighterASTNode lighterASTNode2 = expression2;
        if (lighterASTNode2 != null) {
            LighterASTNode it = lighterASTNode2;
            boolean bl = false;
            firElement2 = $this.convertExpression(it, errorReason);
        } else {
            firElement2 = null;
        }
        FirElement converted = firElement2;
        Intrinsics.reifiedOperationMarker(2, "R");
        FirElement firElement3 = converted;
        if (firElement3 != null) {
            firElement = firElement3;
        } else {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this, expression2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected), converted);
            Intrinsics.reifiedOperationMarker(1, "R");
            firElement = firErrorExpression;
        }
        return firElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirElement convertExpression(@NotNull LighterASTNode expression2, @NotNull String errorReason) {
        FirElement firElement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(errorReason, "errorReason");
        IElementType iElementType = expression2.getTokenType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION)) {
            FlyweightCapableTreeStructure<LighterASTNode> lambdaTree = LightTree2Fir.Companion.buildLightTreeLambdaExpression(this.getAsText(expression2));
            this.getContext().forwardLabelUsagePermission(expression2, lambdaTree.getRoot());
            DeclarationsConverter lambdaDeclarationsConverter = new DeclarationsConverter(this.getBaseSession(), this.declarationsConverter.getBaseScopeProvider$light_tree2fir(), lambdaTree, this.getOffset() + expression2.getStartOffset(), this.getContext(), null, null, 96, null);
            ExpressionsConverter expressionsConverter = new ExpressionsConverter(this.getBaseSession(), lambdaTree, lambdaDeclarationsConverter, this.getContext());
            LighterASTNode lighterASTNode2 = lambdaTree.getRoot();
            Intrinsics.checkNotNullExpressionValue(lighterASTNode2, "lambdaTree.root");
            firElement = expressionsConverter.convertLambdaExpression(lighterASTNode2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_EXPRESSION)) {
            firElement = this.convertBinaryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BINARY_WITH_TYPE)) {
            firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.1.INSTANCE);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IS_EXPRESSION)) {
            firElement = this.convertBinaryWithTypeRHSExpression(expression2, convertExpression.2.INSTANCE);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION)) {
            firElement = this.convertLabeledExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PREFIX_EXPRESSION) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.POSTFIX_EXPRESSION)) {
            firElement = this.convertUnaryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) {
            firElement = this.convertAnnotatedExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_LITERAL_EXPRESSION)) {
            firElement = this.convertClassLiteralExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION)) {
            firElement = this.convertCallableReferenceExpression(expression2);
        } else if (KtTokens.QUALIFIED_ACCESS.contains(iElementType)) {
            firElement = this.convertQualifiedExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CALL_EXPRESSION)) {
            firElement = this.convertCallExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN)) {
            firElement = this.convertWhenExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
            firElement = this.convertArrayAccessExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.COLLECTION_LITERAL_EXPRESSION)) {
            firElement = this.convertCollectionLiteralExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
            firElement = this.convertStringTemplate(expression2);
        } else if (iElementType instanceof KtConstantExpressionElementType) {
            firElement = this.convertConstantExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
            firElement = this.convertSimpleNameExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.DO_WHILE)) {
            firElement = this.convertDoWhile(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHILE)) {
            firElement = this.convertWhile(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FOR)) {
            firElement = this.convertFor(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TRY)) {
            firElement = this.convertTryExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.IF)) {
            firElement = this.convertIfExpression(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BREAK) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CONTINUE)) {
            firElement = this.convertLoopJump(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.RETURN)) {
            firElement = this.convertReturn(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.THROW)) {
            firElement = this.convertThrow(expression2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
            FirElement converted$iv;
            FirElement firElement2;
            FirElement firElement3;
            void this_$iv;
            LighterASTNode content2 = this.getExpressionInParentheses(expression2);
            this.getContext().forwardLabelUsagePermission(expression2, content2);
            ExpressionsConverter lambdaDeclarationsConverter = this;
            String errorReason$iv = "Empty parentheses";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode3 = content2;
            if (lighterASTNode3 != null) {
                LighterASTNode it$iv = lighterASTNode3;
                boolean bl = false;
                firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
            } else {
                firElement3 = null;
            }
            if (!((firElement2 = (converted$iv = firElement3)) instanceof FirElement)) {
                firElement2 = firElement = null;
            }
            if (firElement2 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(content2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, content2, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
        } else if (((Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_DELEGATE) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.INDICES)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LOOP_RANGE)) {
            FirElement converted$iv;
            FirElement firElement4;
            FirElement firElement5;
            void this_$iv;
            ExpressionsConverter content2 = this;
            LighterASTNode expression$iv = this.getExpressionInParentheses(expression2);
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode4 = expression$iv;
            if (lighterASTNode4 != null) {
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl = false;
                firElement5 = this_$iv.convertExpression(it$iv, errorReason);
            } else {
                firElement5 = null;
            }
            if (!((firElement4 = (converted$iv = firElement5)) instanceof FirElement)) {
                firElement4 = firElement = null;
            }
            if (firElement4 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
        } else {
            firElement = Intrinsics.areEqual(iElementType, KtNodeTypes.THIS_EXPRESSION) ? (FirElement)this.convertThisExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION) ? (FirElement)this.convertSuperExpression(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_LITERAL) ? this.declarationsConverter.convertObjectLiteral(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? (FirElement)this.declarationsConverter.convertFunctionDeclaration(expression2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.DESTRUCTURING_DECLARATION) ? (FirElement)this.declarationsConverter.convertDestructingDeclaration$light_tree2fir(expression2).toFirDestructingDeclaration(this.getBaseModuleData()) : (FirElement)FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected), null, 4, null)))));
        }
        return firElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final FirExpression convertLambdaExpression(LighterASTNode lambdaExpression) {
        FirAnonymousFunctionExpressionBuilder firAnonymousFunctionExpressionBuilder;
        FirBlock firBlock;
        Object object;
        Object object2;
        Object kid$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        List valueParameterList = new ArrayList();
        LighterASTNode block = null;
        boolean hasArrow = false;
        FirAnonymousFunctionSymbol functionSymbol = new FirAnonymousFunctionSymbol();
        BaseConverter baseConverter = this;
        IElementType iElementType = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkNotNullExpressionValue(iElementType, "FUNCTION_LITERAL");
        LighterASTNode lighterASTNode2 = CollectionsKt.first(this.getChildNodesByType(lambdaExpression, iElementType));
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        Object kidsArray$iv = this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv);
        int n = ((LighterASTNode[])kidsArray$iv).length;
        for (int i = 0; i < n && (kid$iv = kidsArray$iv[i]) != null; ++i) {
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, (LighterASTNode)kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            object2 = it.getTokenType();
            if (Intrinsics.areEqual(object2, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                CollectionsKt.addAll((Collection)valueParameterList, DeclarationsConverter.convertValueParameters$default(this.declarationsConverter, it, functionSymbol, BaseFirBuilder.ValueParameterDeclaration.LAMBDA, null, 8, null));
                continue;
            }
            if (Intrinsics.areEqual(object2, KtNodeTypes.BLOCK)) {
                block = it;
                continue;
            }
            if (!Intrinsics.areEqual(object2, KtTokens.ARROW)) continue;
            hasArrow = true;
        }
        KtLightSourceElement expressionSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lambdaExpression, null, 1, null);
        FirFunctionTarget target = null;
        boolean $i$f$buildAnonymousFunction = false;
        Object $this$convertLambdaExpression_u24lambda_u2410 = kidsArray$iv = new FirAnonymousFunctionBuilder();
        boolean bl = false;
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setSource(expressionSource);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setModuleData(this.getBaseModuleData());
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setReturnTypeRef(this.getImplicitType());
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setReceiverParameter(ConversionUtilsKt.asReceiverParameter(this.getImplicitType()));
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setSymbol(functionSymbol);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setLambda(true);
        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setHasExplicitParameterList(hasArrow);
        Object object3 = $this$convertLambdaExpression_u24lambda_u2410;
        FirLabel firLabel = this.getContext().getLastLabel(lambdaExpression);
        if (firLabel == null) {
            Name name2 = CollectionsKt.lastOrNull(this.getContext().getCalleeNamesForLambda());
            if (name2 != null) {
                void it;
                kid$iv = name2;
                object = object3;
                boolean bl2 = false;
                boolean $i$f$buildLabel = false;
                Object $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u243_u24lambda_u242 = object2 = new FirLabelBuilder();
                boolean bl3 = false;
                ((FirLabelBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u243_u24lambda_u242).setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.GeneratedLambdaLabel.INSTANCE));
                String string2 = it.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "it.asString()");
                ((FirLabelBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u243_u24lambda_u242).setName(string2);
                firLabel = ((FirLabelBuilder)object2).build();
                object3 = object;
            } else {
                firLabel = null;
            }
        }
        ((FirAnonymousFunctionBuilder)object3).setLabel(firLabel);
        FirLabel firLabel2 = ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).getLabel();
        target = new FirFunctionTarget(firLabel2 != null ? firLabel2.getName() : null, true);
        ((Collection)this.getContext().getFirFunctionTargets()).add(target);
        List destructuringStatements = new ArrayList();
        for (ValueParameter valueParameter2 : valueParameterList) {
            FirValueParameter firValueParameter2;
            Object name3;
            DestructuringDeclaration multiDeclaration = valueParameter2.getDestructuringDeclaration();
            Collection bl2 = ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).getValueParameters();
            if (multiDeclaration != null) {
                FirValueParameterBuilder bl3;
                name3 = SpecialNames.DESTRUCT;
                boolean $i$f$buildValueParameter = false;
                FirValueParameterBuilder $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244 = bl3 = new FirValueParameterBuilder();
                boolean bl4 = false;
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setSource(valueParameter2.getFirValueParameter().getSource());
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setContainingFunctionSymbol(functionSymbol);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setModuleData(this.getBaseModuleData());
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setReturnTypeRef(valueParameter2.getFirValueParameter().getReturnTypeRef());
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setName((Name)name3);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setSymbol(new FirValueParameterSymbol((Name)name3));
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setDefaultValue(null);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setCrossinline(false);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setNoinline(false);
                $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u244.setVararg(false);
                FirValueParameter multiParameter = bl3.build();
                CollectionsKt.addAll((Collection)destructuringStatements, (Iterable)ConverterUtilKt.generateDestructuringBlock(this.getBaseModuleData(), multiDeclaration, multiParameter, false).getStatements());
                firValueParameter2 = multiParameter;
            } else {
                firValueParameter2 = valueParameter2.getFirValueParameter();
            }
            name3 = firValueParameter2;
            bl2.add(name3);
        }
        Object object4 = $this$convertLambdaExpression_u24lambda_u2410;
        if (block != null) {
            FirBlock firBlock2;
            void newOffset$iv;
            void this_$iv2;
            DeclarationsConverter declarationsConverter = this.declarationsConverter;
            int valueParameter2 = expressionSource.getStartOffset();
            object = object4;
            boolean $i$f$withOffset = false;
            int oldOffset$iv = this_$iv2.getOffset();
            this_$iv2.setOffset((int)newOffset$iv);
            try {
                Object it;
                boolean bl5 = false;
                Object $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = object2 = this.declarationsConverter.convertBlockExpressionWithoutBuilding(block);
                boolean bl6 = false;
                FirStatement firStatement = CollectionsKt.firstOrNull(((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248).getStatements());
                if (firStatement != null) {
                    it = firStatement;
                    boolean bl7 = false;
                    if (ConversionUtilsKt.isContractBlockFirCheck((FirStatement)it)) {
                        ((FirAnonymousFunctionBuilder)$this$convertLambdaExpression_u24lambda_u2410).setContractDescription(ConversionUtilsKt.toLegacyRawContractDescription((FirFunctionCall)it));
                        ((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248).getStatements().set(0, new FirContractCallBlock((FirFunctionCall)it));
                    }
                }
                if (((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248).getStatements().isEmpty()) {
                    void $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246;
                    FirUnitExpressionBuilder firUnitExpressionBuilder;
                    void $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                    boolean $i$f$buildReturnExpression = false;
                    FirReturnExpressionBuilder firReturnExpressionBuilder = new FirReturnExpressionBuilder();
                    it = firReturnExpressionBuilder;
                    List<FirStatement> list2 = ((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248).getStatements();
                    boolean bl8 = false;
                    $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitReturn.FromExpressionBody.INSTANCE));
                    $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247.setTarget(target);
                    boolean $i$f$buildUnitExpression = false;
                    FirUnitExpressionBuilder firUnitExpressionBuilder2 = firUnitExpressionBuilder = new FirUnitExpressionBuilder();
                    void var31_46 = $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                    boolean bl9 = false;
                    $this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.setSource(KtSourceElementKt.fakeElement(expressionSource, KtFakeSourceElementKind.ImplicitUnit.INSTANCE));
                    var31_46.setResult(firUnitExpressionBuilder.build());
                    list2.add(firReturnExpressionBuilder.build());
                }
                ((FirBlockBuilder)$this$convertLambdaExpression_u24lambda_u2410_u24lambda_u249_u24lambda_u248).getStatements().addAll(0, destructuringStatements);
                firBlock2 = ((FirBlockBuilder)object2).build();
            }
            finally {
                this_$iv2.setOffset(oldOffset$iv);
            }
            firBlock = firBlock2;
            object4 = object;
        } else {
            FirStatement statement$iv = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("Lambda has no body", DiagnosticKind.Syntax), null, 4, null);
            boolean $i$f$buildSingleExpressionBlock = false;
            firBlock = new FirSingleExpressionBlock(statement$iv);
        }
        ((FirAnonymousFunctionBuilder)object4).setBody(firBlock);
        this.removeLast(this.getContext().getFirFunctionTargets());
        FirAnonymousFunction it = $i$f$buildAnonymousFunction = ((FirAnonymousFunctionBuilder)kidsArray$iv).build();
        boolean bl10 = false;
        target.bind((FirTargetElement)it);
        FirAnonymousFunction anonymousFunction2 = $i$f$buildAnonymousFunction;
        boolean $i$f$buildAnonymousFunctionExpression = false;
        FirAnonymousFunctionExpressionBuilder $this$convertLambdaExpression_u24lambda_u2412 = firAnonymousFunctionExpressionBuilder = new FirAnonymousFunctionExpressionBuilder();
        boolean bl11 = false;
        $this$convertLambdaExpression_u24lambda_u2412.setSource(expressionSource);
        $this$convertLambdaExpression_u24lambda_u2412.setAnonymousFunction(anonymousFunction2);
        return firAnonymousFunctionExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirStatement convertBinaryExpression(LighterASTNode binaryExpression) {
        FirStatement firStatement;
        FirElement firElement;
        FirElement converted$iv;
        FirElement firElement2;
        FirElement firElement3;
        IElementType this_$iv;
        void expression$iv;
        FirExpression firExpression2;
        ExpressionsConverter expression$iv2;
        IElementType operationToken;
        void $this$forEachChildren$iv;
        void this_$iv2;
        boolean isLeftArgument = false;
        isLeftArgument = true;
        String operationTokenName = null;
        LighterASTNode leftArgNode = null;
        LighterASTNode rightArg = null;
        KtSourceElement operationReferenceSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = binaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : this_$iv2.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv2, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                isLeftArgument = false;
                operationTokenName = this.getAsText(it);
                operationReferenceSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            if (isLeftArgument) {
                leftArgNode = it;
                continue;
            }
            rightArg = it;
        }
        KtLightSourceElement baseSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null);
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        if (Intrinsics.areEqual(operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(string2), KtTokens.IDENTIFIER)) {
            ((Collection)this.getContext().getCalleeNamesForLambda()).add(ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null));
        } else {
            ((Collection)this.getContext().getCalleeNamesForLambda()).add(null);
        }
        if (rightArg != null) {
            FirElement firElement4;
            void this_$iv3;
            ExpressionsConverter $i$f$forEachChildren2 = this;
            LighterASTNode[] kidsArray$iv = rightArg;
            String errorReason$iv = "No right operand";
            boolean $i$f$getAsFirExpression = false;
            void it$iv = expression$iv2;
            boolean bl = false;
            FirElement converted$iv2 = this_$iv3.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            FirElement firElement5 = converted$iv2;
            if (!(firElement5 instanceof FirExpression)) {
                firElement5 = null;
            }
            if ((firElement4 = (FirElement)((FirExpression)firElement5)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv3, expression$iv2, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv2);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement4 = firErrorExpression;
            }
            firExpression2 = (FirExpression)firElement4;
        } else {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No right operand", DiagnosticKind.Syntax), null, 4, null);
        }
        FirExpression rightArgAsFir = firExpression2;
        expression$iv2 = this;
        LighterASTNode errorReason$iv = leftArgNode;
        Object errorReason$iv2 = "No left operand";
        boolean $i$f$getAsFirExpression = false;
        void v5 = expression$iv;
        if (v5 != null) {
            void it$iv = v5;
            boolean bl = false;
            firElement3 = ((ExpressionsConverter)((Object)this_$iv)).convertExpression((LighterASTNode)it$iv, (String)errorReason$iv2);
        } else {
            firElement3 = null;
        }
        if (!((firElement2 = (converted$iv = firElement3)) instanceof FirExpression)) {
            firElement2 = null;
        }
        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)((Object)this_$iv), expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic((String)errorReason$iv2, DiagnosticKind.ExpressionExpected), converted$iv);
            if (firErrorExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
            }
            firElement = firErrorExpression;
        }
        FirExpression leftArgAsFir = (FirExpression)firElement;
        this.removeLast(this.getContext().getCalleeNamesForLambda());
        this_$iv = operationToken;
        if (Intrinsics.areEqual(this_$iv, KtTokens.ELVIS)) {
            return ConversionUtilsKt.generateNotNullOrOther(leftArgAsFir, rightArgAsFir, baseSource);
        }
        if (Intrinsics.areEqual(this_$iv, KtTokens.ANDAND) ? true : Intrinsics.areEqual(this_$iv, KtTokens.OROR)) {
            return ConversionUtilsKt.generateLazyLogicalOperation(leftArgAsFir, rightArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.ANDAND), baseSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "IN_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet, this_$iv)) {
            return ConversionUtilsKt.generateContainsOperation(rightArgAsFir, leftArgAsFir, Intrinsics.areEqual(operationToken, KtTokens.NOT_IN), baseSource, operationReferenceSource);
        }
        ImmutableSet<KtSingleValueToken> immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet2, "COMPARISON_OPERATIONS");
        if (CollectionsKt.contains((Iterable)immutableSet2, this_$iv)) {
            return ConversionUtilsKt.generateComparisonExpression(leftArgAsFir, rightArgAsFir, operationToken, baseSource, operationReferenceSource);
        }
        Name conventionCallName = ConversionUtilsKt.toBinaryName(operationToken);
        if (conventionCallName != null || Intrinsics.areEqual(operationToken, KtTokens.IDENTIFIER)) {
            void $this$convertBinaryExpression_u24lambda_u2415_u24lambda_u2414;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
            boolean $i$f$buildFunctionCall = false;
            Object $this$convertBinaryExpression_u24lambda_u2415 = errorReason$iv2 = new FirFunctionCallBuilder();
            boolean bl = false;
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2415).setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            Object object = $this$convertBinaryExpression_u24lambda_u2415;
            boolean bl2 = false;
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)operationReferenceSource;
            $this$convertBinaryExpression_u24lambda_u2415_u24lambda_u2414.setSource(ktLightSourceElement != null ? (KtSourceElement)ktLightSourceElement : ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2415).getSource());
            Name name2 = conventionCallName;
            if (name2 == null) {
                name2 = ConverterUtilKt.nameAsSafeName$default(operationTokenName, null, 1, null);
            }
            $this$convertBinaryExpression_u24lambda_u2415_u24lambda_u2414.setName(name2);
            ((FirFunctionCallBuilder)object).setCalleeReference(firSimpleNamedReferenceBuilder.build());
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2415).setExplicitReceiver(leftArgAsFir);
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2415).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(rightArgAsFir));
            ((FirFunctionCallBuilder)$this$convertBinaryExpression_u24lambda_u2415).setOrigin(conventionCallName != null ? FirFunctionCallOrigin.Operator : FirFunctionCallOrigin.Infix);
            firStatement = ((FirFunctionCallBuilder)errorReason$iv2).build();
        } else {
            FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder;
            FirOperation firOperation = ConversionUtilsKt.toFirOperation(operationToken);
            if (FirOperation.Companion.getASSIGNMENTS().contains((Object)firOperation)) {
                return this.generateAssignment(leftArgNode, BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null), (errorReason$iv2 = leftArgNode) != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, errorReason$iv2, null, 1, null) : null, rightArgAsFir, firOperation, leftArgAsFir.getAnnotations(), rightArg, (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateAssignment) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateAssignment, "$this$generateAssignment");
                        ExpressionsConverter $this$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode it$iv = $this$generateAssignment;
                        boolean bl = false;
                        FirElement converted$iv = $this$iv.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement2 = converted$iv;
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this$iv, $this$generateAssignment, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                });
            }
            boolean $i$f$buildEqualityOperatorCall = false;
            FirEqualityOperatorCallBuilder $this$convertBinaryExpression_u24lambda_u2416 = firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
            boolean bl = false;
            $this$convertBinaryExpression_u24lambda_u2416.setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
            $this$convertBinaryExpression_u24lambda_u2416.setOperation(firOperation);
            $this$convertBinaryExpression_u24lambda_u2416.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(leftArgAsFir, rightArgAsFir));
            firStatement = firEqualityOperatorCallBuilder.build();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final FirTypeOperatorCall convertBinaryWithTypeRHSExpression(LighterASTNode binaryExpression, Function1<? super String, ? extends FirOperation> toFirOperation) {
        void $this$forEachChildren$iv;
        void this_$iv;
        String operationTokenName = null;
        FirElement leftArgAsFir = null;
        FirTypeRef firType = null;
        BaseConverter baseConverter = this;
        Object object = binaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OPERATION_REFERENCE)) {
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No left operand";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            leftArgAsFir = firElement;
        }
        boolean $i$f$buildTypeOperatorCall = false;
        Object $this$convertBinaryWithTypeRHSExpression_u24lambda_u2418 = object = new FirTypeOperatorCallBuilder();
        boolean bl = false;
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2418).setSource(BaseFirBuilder.toFirSourceElement$default(this, binaryExpression, null, 1, null));
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2418).setOperation(toFirOperation.invoke(string2));
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
            firTypeRef = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2418).setConversionTypeRef(firTypeRef);
        FirExpression firExpression2 = (FirExpression)leftArgAsFir;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No left operand", DiagnosticKind.Syntax), null, 4, null);
        }
        ((FirTypeOperatorCallBuilder)$this$convertBinaryWithTypeRHSExpression_u24lambda_u2418).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firExpression2));
        return ((FirTypeOperatorCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertLabeledExpression(LighterASTNode labeledExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        KtSourceElement errorLabelSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = labeledExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            this.getContext().setNewLabelUserNode(it);
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.LABEL_QUALIFIER)) {
                String rawName = it.toString();
                String string2 = rawName.substring(0, rawName.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                BaseFirBuilder baseFirBuilder = this;
                IElementType iElementType2 = KtNodeTypes.LABEL;
                Intrinsics.checkNotNullExpressionValue(iElementType2, "LABEL");
                Pair<FirLabel, KtSourceElement> pair = this.buildLabelAndErrorSource(string2, BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, CollectionsKt.single(this.getChildNodesByType(it, iElementType2)), null, 1, null));
                this.getContext().addNewLabel(pair.getFirst());
                errorLabelSource = pair.getSecond();
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) {
                firExpression2 = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, it, null, 2, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirElement)) {
                firElement2 = firElement = null;
            }
            if (firElement2 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        this.getContext().dropLastLabel();
        return this.buildExpressionWithErrorLabel(firExpression2, errorLabelSource, BaseFirBuilder.toFirSourceElement$default(this, labeledExpression, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertUnaryExpression(LighterASTNode unaryExpression) {
        FirExpression firExpression2;
        FirCheckNotNullCallBuilder $this$convertUnaryExpression_u24lambda_u2421;
        void $this$forEachChildren$iv;
        void this_$iv;
        String operationTokenName = null;
        LighterASTNode argument2 = null;
        LighterASTNode operationReference = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = unaryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren2 = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                operationReference = it;
                operationTokenName = this.getAsText(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            argument2 = it;
        }
        String string2 = operationTokenName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("operationTokenName");
            string2 = null;
        }
        IElementType operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(string2);
        Name conventionCallName = ConversionUtilsKt.toUnaryName(operationToken);
        if (Intrinsics.areEqual(operationToken, KtTokens.EXCLEXCL)) {
            FirElement firElement;
            FirElement converted$iv;
            FirElement firElement2;
            FirElement firElement3;
            void this_$iv2;
            void expression$iv;
            LighterASTNode kid$iv;
            boolean $i$f$buildCheckNotNullCall = false;
            $this$convertUnaryExpression_u24lambda_u2421 = $i$f$forEachChildren2 = new FirCheckNotNullCallBuilder();
            boolean bl = false;
            $this$convertUnaryExpression_u24lambda_u2421.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            ExpressionsConverter expressionsConverter = this;
            kid$iv = argument2;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression = false;
            void v1 = expression$iv;
            if (v1 != null) {
                void it$iv = v1;
                boolean bl2 = false;
                firElement3 = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                firElement3 = null;
            }
            if (!((firElement2 = (converted$iv = firElement3)) instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$convertUnaryExpression_u24lambda_u2421.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList((FirExpression)firElement));
            firExpression2 = $i$f$forEachChildren2.build();
        } else if (conventionCallName != null) {
            KtLightSourceElement ktLightSourceElement;
            void $this$convertUnaryExpression_u24lambda_u2424_u24lambda_u2423;
            FirFunctionCallBuilder firFunctionCallBuilder;
            FirExpression receiver;
            FirElement firElement;
            FirElement firElement4;
            Object converted$iv;
            Object object;
            FirExpression this_$iv3;
            void expression$iv;
            ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.INCREMENT_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, "INCREMENT_OPERATIONS");
            if (CollectionsKt.contains((Iterable)immutableSet, operationToken)) {
                return this.generateIncrementOrDecrementBlock(unaryExpression, operationReference, argument2, conventionCallName, Intrinsics.areEqual(unaryExpression.getTokenType(), KtNodeTypes.PREFIX_EXPRESSION), (Function1)new Function1<LighterASTNode, FirExpression>(this){
                    final /* synthetic */ ExpressionsConverter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FirExpression invoke(@NotNull LighterASTNode $this$generateIncrementOrDecrementBlock) {
                        FirElement firElement;
                        Intrinsics.checkNotNullParameter($this$generateIncrementOrDecrementBlock, "$this$generateIncrementOrDecrementBlock");
                        ExpressionsConverter $this$iv = this.this$0;
                        String errorReason$iv = "";
                        boolean $i$f$getAsFirExpression = false;
                        LighterASTNode it$iv = $this$generateIncrementOrDecrementBlock;
                        boolean bl = false;
                        FirElement converted$iv = $this$iv.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement2 = converted$iv;
                        if (!(firElement2 instanceof FirExpression)) {
                            firElement2 = null;
                        }
                        if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default($this$iv, $this$generateIncrementOrDecrementBlock, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                            }
                            firElement = firErrorExpression;
                        }
                        return (FirExpression)firElement;
                    }
                });
            }
            ExpressionsConverter $i$f$forEachChildren2 = this;
            $this$convertUnaryExpression_u24lambda_u2421 = argument2;
            String errorReason$iv = "No operand";
            boolean $i$f$getAsFirExpression = false;
            void v8 = expression$iv;
            if (v8 != null) {
                void it$iv = v8;
                boolean bl = false;
                object = ((ExpressionsConverter)((Object)this_$iv3)).convertExpression((LighterASTNode)it$iv, errorReason$iv);
            } else {
                object = converted$iv = null;
            }
            if (!((firElement4 = converted$iv) instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(expression$iv != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)((Object)this_$iv3), expression$iv, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), (FirElement)converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            if ((this_$iv3 = this.convertUnaryPlusMinusCallOnIntegerLiteralIfNecessary(unaryExpression, receiver = (FirExpression)firElement, operationToken)) != null) {
                FirExpression it = this_$iv3;
                boolean bl = false;
                return it;
            }
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder $this$convertUnaryExpression_u24lambda_u2424 = firFunctionCallBuilder = new FirFunctionCallBuilder();
            boolean bl = false;
            $this$convertUnaryExpression_u24lambda_u2424.setSource(BaseFirBuilder.toFirSourceElement$default(this, unaryExpression, null, 1, null));
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            converted$iv = firSimpleNamedReferenceBuilder;
            FirFunctionCallBuilder firFunctionCallBuilder2 = $this$convertUnaryExpression_u24lambda_u2424;
            boolean bl3 = false;
            LighterASTNode lighterASTNode3 = operationReference;
            $this$convertUnaryExpression_u24lambda_u2424_u24lambda_u2423.setSource(lighterASTNode3 != null && (ktLightSourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode3, null, 1, null)) != null ? (KtSourceElement)ktLightSourceElement : $this$convertUnaryExpression_u24lambda_u2424.getSource());
            $this$convertUnaryExpression_u24lambda_u2424_u24lambda_u2423.setName(conventionCallName);
            firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$convertUnaryExpression_u24lambda_u2424.setExplicitReceiver(receiver);
            $this$convertUnaryExpression_u24lambda_u2424.setOrigin(FirFunctionCallOrigin.Operator);
            firExpression2 = firFunctionCallBuilder.build();
        } else {
            throw new IllegalStateException("Unexpected expression: " + this.getAsText(unaryExpression));
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertAnnotatedExpression(LighterASTNode annotatedExpression) {
        FirElement result2;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        List firAnnotationList = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = annotatedExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION)) {
                CollectionsKt.addAll((Collection)firAnnotationList, (Iterable)this.declarationsConverter.convertAnnotation(it));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATION_ENTRY)) {
                ((Collection)firAnnotationList).add(DeclarationsConverter.convertAnnotationEntry$default(this.declarationsConverter, it, null, null, 6, null));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firExpression2 = this.declarationsConverter.convertBlockExpression(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            this.getContext().forwardLabelUsagePermission(annotatedExpression, it);
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirElement)) {
                firElement2 = firElement = null;
            }
            if (firElement2 == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.FirElement");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirElement firElement = firExpression2;
        if (firElement == null) {
            firElement = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeNotAnnotationContainer("???"), null, 4, null);
        }
        if (!((result2 = firElement) instanceof FirAnnotationContainer)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ((FirAnnotationContainer)result2).replaceAnnotations(UtilsKt.smartPlus(((FirAnnotationContainer)result2).getAnnotations(), firAnnotationList));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertClassLiteralExpression(LighterASTNode classLiteralExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firReceiverExpression = null;
        BaseConverter baseConverter = this;
        Object object = classLiteralExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No receiver in class literal";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firReceiverExpression = firElement;
        }
        boolean $i$f$buildGetClassCall = false;
        Object $this$convertClassLiteralExpression_u24lambda_u2427 = object = new FirGetClassCallBuilder();
        boolean bl = false;
        ((FirGetClassCallBuilder)$this$convertClassLiteralExpression_u24lambda_u2427).setSource(BaseFirBuilder.toFirSourceElement$default(this, classLiteralExpression, null, 1, null));
        FirExpression firExpression2 = (FirExpression)firReceiverExpression;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No receiver in class literal", DiagnosticKind.Syntax), null, 4, null);
        }
        ((FirGetClassCallBuilder)$this$convertClassLiteralExpression_u24lambda_u2427).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(firExpression2));
        return ((FirGetClassCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallableReferenceExpression(LighterASTNode callableReferenceExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isReceiver = false;
        isReceiver = true;
        boolean hasQuestionMarkAtLHS = false;
        FirElement firReceiverExpression = null;
        FirNamedReference namedReference = null;
        BaseConverter baseConverter = this;
        Object object = callableReferenceExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtTokens.COLONCOLON)) {
                isReceiver = false;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.QUEST)) {
                hasQuestionMarkAtLHS = true;
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            if (isReceiver) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "Incorrect receiver expression";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
                FirElement firElement2 = converted$iv;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firReceiverExpression = firElement;
                continue;
            }
            namedReference = this.createSimpleNamedReference(BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), it);
        }
        boolean $i$f$buildCallableReferenceAccess = false;
        Object $this$convertCallableReferenceExpression_u24lambda_u2429 = object = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2429).setSource(BaseFirBuilder.toFirSourceElement$default(this, callableReferenceExpression, null, 1, null));
        FirNamedReference firNamedReference = namedReference;
        if (firNamedReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException("namedReference");
            firNamedReference = null;
        }
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2429).setCalleeReference(firNamedReference);
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2429).setExplicitReceiver((FirExpression)firReceiverExpression);
        ((FirCallableReferenceAccessBuilder)$this$convertCallableReferenceExpression_u24lambda_u2429).setHasQuestionMarkAtLHS(hasQuestionMarkAtLHS);
        return ((FirCallableReferenceAccessBuilder)object).build();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final FirExpression convertQualifiedExpression(LighterASTNode dotQualifiedExpression) {
        isSelector = false;
        isSafe = false;
        firSelector = new Ref.ObjectRef<T>();
        firReceiver = null;
        var6_6 = this;
        var7_7 = dotQualifiedExpression;
        skipTokens$iv = new KtToken[]{};
        $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            block15: {
                if (kid$iv == null) break;
                tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                it = kid$iv;
                $i$a$-forEachChildren-ExpressionsConverter$convertQualifiedExpression$1 = false;
                tokenType = it.getTokenType();
                if (Intrinsics.areEqual(tokenType, KtTokens.DOT)) {
                    isSelector = true;
                    continue;
                }
                if (Intrinsics.areEqual(tokenType, KtTokens.SAFE_ACCESS)) {
                    isSafe = true;
                    isSelector = true;
                    continue;
                }
                isEffectiveSelector = isSelector != false && Intrinsics.areEqual(tokenType, TokenType.ERROR_ELEMENT) == false;
                var19_27 = this;
                errorReason$iv = "Incorrect " + (isEffectiveSelector != false ? "selector" : "receiver") + " expression";
                $i$f$getAsFirExpression = false;
                it$iv = it;
                $i$a$-let-ExpressionsConverter$getAsFirExpression$converted$1$iv = false;
                converted$iv = this_$iv.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                v0 = converted$iv;
                if (!(v0 instanceof FirExpression)) {
                    v0 = null;
                }
                if ((v1 = (FirElement)((FirExpression)v0)) == null) {
                    v2 = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    v1 = v2;
                }
                firExpression = (FirExpression)v1;
                if (!isEffectiveSelector) break block15;
                callExpressionCallee = Intrinsics.areEqual(tokenType, KtNodeTypes.CALL_EXPRESSION) != false ? this.getFirstChildExpressionUnwrapped(it) : null;
                v3 = firSelector;
                if (tokenType instanceof KtNameReferenceExpressionElementType) ** GOTO lbl-1000
                if (Intrinsics.areEqual(tokenType, KtNodeTypes.CALL_EXPRESSION)) {
                    v4 = callExpressionCallee;
                    ** if (Intrinsics.areEqual((Object)(v4 != null ? v4.getTokenType() : null), (Object)KtNodeTypes.LAMBDA_EXPRESSION)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v5 = firExpression;
                    ** GOTO lbl65
                }
lbl-1000:
                // 2 sources

                {
                    $i$f$buildErrorExpression = false;
                    var21_31 = new FirErrorExpressionBuilder();
                    it$iv = var21_31;
                    var26_36 = v3;
                    $i$a$-buildErrorExpression-ExpressionsConverter$convertQualifiedExpression$1$1 = false;
                    $this$convertQualifiedExpression_u24lambda_u2431_u24lambda_u2430.setSource(callExpressionCallee != null && (var24_34 = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, callExpressionCallee, null, 1, null)) != null ? (KtSourceElement)var24_34 : BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null));
                    $this$convertQualifiedExpression_u24lambda_u2431_u24lambda_u2430.setDiagnostic(new ConeSimpleDiagnostic("The expression cannot be a selector (occur after a dot)", callExpressionCallee == null ? DiagnosticKind.IllegalSelector : DiagnosticKind.NoReceiverAllowed));
                    $this$convertQualifiedExpression_u24lambda_u2431_u24lambda_u2430.setExpression(firExpression);
                    v3 = var26_36;
                    v5 = var21_31.build();
                }
lbl65:
                // 2 sources

                v3.element = v5;
                continue;
            }
            firReceiver = firExpression;
        }
        result = null;
        result = (FirQualifiedAccessExpression)firSelector.element;
        var8_8 /* !! */  = firSelector.element;
        v6 = var8_8 /* !! */  instanceof FirQualifiedAccessExpression != false ? (FirQualifiedAccessExpression)var8_8 /* !! */  : null;
        if (v6 != null) {
            it = v6;
            $i$a$-let-ExpressionsConverter$convertQualifiedExpression$2 = false;
            if (isSafe) {
                it.replaceSource(this.toFirSourceElement(dotQualifiedExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredSafeCallExpression.INSTANCE));
                v7 = firReceiver;
                Intrinsics.checkNotNull(v7);
                return ConversionUtilsKt.createSafeCall(it, v7, BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null));
            }
            v8 = BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null);
            v9 = firReceiver;
            Intrinsics.checkNotNull(v9);
            result = this.convertFirSelector(it, v8, v9);
        }
        receiver = firReceiver;
        if (receiver != null) {
            it = firSelector.element;
            v10 /* !! */  = var8_8 /* !! */  = it instanceof FirErrorExpression != false ? (FirErrorExpression)it : null;
            if (var8_8 /* !! */  != null) {
                errorExpression /* !! */  = var8_8 /* !! */ ;
                $i$a$-let-ExpressionsConverter$convertQualifiedExpression$3 = false;
                $i$f$buildQualifiedErrorAccessExpression = false;
                $this$convertQualifiedExpression_u24lambda_u2434_u24lambda_u2433 = var13_20 = new FirQualifiedErrorAccessExpressionBuilder();
                $i$a$-buildQualifiedErrorAccessExpression-ExpressionsConverter$convertQualifiedExpression$3$1 = false;
                $this$convertQualifiedExpression_u24lambda_u2434_u24lambda_u2433.setReceiver(receiver);
                $this$convertQualifiedExpression_u24lambda_u2434_u24lambda_u2433.setSelector((FirErrorExpression)errorExpression /* !! */ );
                $this$convertQualifiedExpression_u24lambda_u2434_u24lambda_u2433.setSource(BaseFirBuilder.toFirSourceElement$default(this, dotQualifiedExpression, null, 1, null));
                $this$convertQualifiedExpression_u24lambda_u2434_u24lambda_u2433.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression with unexpected selector", DiagnosticKind.Syntax));
                return var13_20.build();
            }
        }
        if ((v11 = (FirExpression)result) == null) {
            $i$f$buildErrorExpression = false;
            $this$convertQualifiedExpression_u24lambda_u2435 = var10_16 = new FirErrorExpressionBuilder();
            $i$a$-buildErrorExpression-ExpressionsConverter$convertQualifiedExpression$4 = false;
            $this$convertQualifiedExpression_u24lambda_u2435.setSource(null);
            $this$convertQualifiedExpression_u24lambda_u2435.setDiagnostic(new ConeSimpleDiagnostic("Qualified expression without selector", DiagnosticKind.Syntax));
            $this$convertQualifiedExpression_u24lambda_u2435.setExpression(firReceiver);
            v11 = var10_16.build();
        }
        return v11;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCallExpression(LighterASTNode callSuffix) {
        FirQualifiedAccessExpressionBuilder builder2;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder;
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder2;
        boolean $i$f$buildErrorNamedReference;
        CalleeAndReceiver calleeAndReceiver;
        boolean bl;
        Object $i$f$forEachChildren22;
        boolean $i$f$buildSimpleNamedReference;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<String> name2 = new Ref.ObjectRef<String>();
        List firTypeArguments = new ArrayList();
        List valueArguments = new ArrayList();
        Ref.ObjectRef<FirExpression> additionalArgument = new Ref.ObjectRef<FirExpression>();
        Ref.BooleanRef hasArguments = new Ref.BooleanRef();
        Ref.ObjectRef<LighterASTNode> superNode = new Ref.ObjectRef<LighterASTNode>();
        BaseConverter baseConverter = this;
        Object object = callSuffix;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode lighterASTNode2 : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (lighterASTNode2 == null) break;
            IElementType tokenType$iv = lighterASTNode2.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, lighterASTNode2);
                continue;
            }
            LighterASTNode child = lighterASTNode2;
            boolean bl62 = false;
            ExpressionsConverter.convertCallExpression$lambda$38$process(name2, this, superNode, firTypeArguments, hasArguments, valueArguments, additionalArgument, child);
        }
        KtLightSourceElement source = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, callSuffix, null, 1, null);
        if (name2.element != null) {
            KtLightSourceElement ktLightSourceElement;
            $i$f$buildSimpleNamedReference = false;
            $i$f$forEachChildren22 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder $this$convertCallExpression_u24lambda_u2439 = $i$f$forEachChildren22;
            bl = false;
            LighterASTNode lighterASTNode2 = this.getFirstChildExpressionUnwrapped(callSuffix);
            $this$convertCallExpression_u24lambda_u2439.setSource(lighterASTNode2 != null && (ktLightSourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode2, null, 1, null)) != null ? (KtSourceElement)ktLightSourceElement : (KtSourceElement)source);
            $this$convertCallExpression_u24lambda_u2439.setName(ConverterUtilKt.nameAsSafeName$default((String)name2.element, null, 1, null));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl2 = false;
            FirExpression firExpression2 = null;
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression2, bl2, n, defaultConstructorMarker);
        } else if (additionalArgument.element != null) {
            $i$f$buildSimpleNamedReference = false;
            $i$f$forEachChildren22 = new FirSimpleNamedReferenceBuilder();
            FirSimpleNamedReferenceBuilder $this$convertCallExpression_u24lambda_u2440 = $i$f$forEachChildren22;
            bl = false;
            $this$convertCallExpression_u24lambda_u2440.setSource(source);
            $this$convertCallExpression_u24lambda_u2440.setName(OperatorNameConventions.INVOKE);
            FirNamedReference firNamedReference = ((FirSimpleNamedReferenceBuilder)$i$f$forEachChildren22).build();
            Object t = additionalArgument.element;
            Intrinsics.checkNotNull(t);
            boolean bl3 = true;
            FirExpression firExpression3 = (FirExpression)t;
            FirNamedReference firNamedReference2 = firNamedReference;
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference2, firExpression3, bl3);
        } else if (superNode.element != null) {
            $i$f$buildErrorNamedReference = false;
            Object $this$convertCallExpression_u24lambda_u2441 = $i$f$forEachChildren22 = new FirErrorNamedReferenceBuilder();
            bl = false;
            Object t = superNode.element;
            Intrinsics.checkNotNull(t);
            LighterASTNode node = (LighterASTNode)t;
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2441).setSource(BaseFirBuilder.toFirSourceElement$default(this, node, null, 1, null));
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2441).setDiagnostic(new ConeSimpleDiagnostic("Super cannot be a callee", DiagnosticKind.SuperNotAllowed));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl4 = false;
            FirExpression firExpression4 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression4, bl4, n, defaultConstructorMarker);
        } else {
            $i$f$buildErrorNamedReference = false;
            Object $this$convertCallExpression_u24lambda_u2442 = $i$f$forEachChildren22 = new FirErrorNamedReferenceBuilder();
            bl = false;
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2442).setSource(source);
            ((FirErrorNamedReferenceBuilder)$this$convertCallExpression_u24lambda_u2442).setDiagnostic(new ConeSimpleDiagnostic("Call has no callee", DiagnosticKind.Syntax));
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl5 = false;
            FirExpression firExpression5 = null;
            FirNamedReference firNamedReference = ((FirErrorNamedReferenceBuilder)$i$f$forEachChildren22).build();
            calleeAndReceiver = new CalleeAndReceiver(firNamedReference, firExpression5, bl5, n, defaultConstructorMarker);
        }
        object = calleeAndReceiver;
        FirNamedReference calleeReference = ((CalleeAndReceiver)object).component1();
        FirExpression explicitReceiver = ((CalleeAndReceiver)object).component2();
        boolean isImplicitInvoke = ((CalleeAndReceiver)object).component3();
        if (hasArguments.element) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            FirAnnotationContainerBuilder builder3;
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            FirAnnotationContainerBuilder $this$convertCallExpression_u24lambda_u2444 = firAnnotationContainerBuilder = (builder3 = isImplicitInvoke ? new FirImplicitInvokeCallBuilder() : new FirFunctionCallBuilder());
            boolean bl6 = false;
            ((FirAbstractFunctionCallBuilder)((Object)$this$convertCallExpression_u24lambda_u2444)).setSource(source);
            ((FirAbstractFunctionCallBuilder)((Object)$this$convertCallExpression_u24lambda_u2444)).setCalleeReference(calleeReference);
            ((Collection)this.getContext().getCalleeNamesForLambda()).add(calleeReference.getName());
            Iterable bl62 = valueArguments;
            FirCallBuilder firCallBuilder = $this$convertCallExpression_u24lambda_u2444;
            boolean $i$f$flatMap = false;
            void var21_57 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl7 = false;
                Iterable list$iv$iv = this.convertValueArguments(it);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            ConverterUtilKt.extractArgumentsFrom(firCallBuilder, (List)destination$iv$iv);
            this.removeLast(this.getContext().getCalleeNamesForLambda());
            firQualifiedAccessExpressionBuilder2 = firAnnotationContainerBuilder;
        } else {
            firQualifiedAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder = firQualifiedAccessExpressionBuilder;
            boolean bl7 = false;
            firPropertyAccessExpressionBuilder.setSource(source);
            firPropertyAccessExpressionBuilder.setCalleeReference(calleeReference);
            firQualifiedAccessExpressionBuilder2 = firQualifiedAccessExpressionBuilder;
        }
        FirQualifiedAccessExpressionBuilder firQualifiedAccessExpressionBuilder3 = firQualifiedAccessExpressionBuilder = (builder2 = firQualifiedAccessExpressionBuilder2);
        boolean bl8 = false;
        firQualifiedAccessExpressionBuilder3.setExplicitReceiver(explicitReceiver);
        CollectionsKt.addAll((Collection)firQualifiedAccessExpressionBuilder3.getTypeArguments(), firTypeArguments);
        return firQualifiedAccessExpressionBuilder.build();
    }

    private final FirExpression convertStringTemplate(LighterASTNode stringTemplate) {
        return BaseFirBuilder.toInterpolatingCall$default(this, this.getChildrenAsArray(stringTemplate), stringTemplate, null, new Function2<LighterASTNode, String, FirExpression>(this){
            final /* synthetic */ ExpressionsConverter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final FirExpression invoke(@Nullable LighterASTNode $this$toInterpolatingCall, @NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ExpressionsConverter.access$convertShortOrLongStringTemplate(this.this$0, $this$toInterpolatingCall, it);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertShortOrLongStringTemplate(LighterASTNode $this$convertShortOrLongStringTemplate, String errorReason) {
        FirExpression firExpression2;
        FirElement firExpression3 = null;
        if ($this$convertShortOrLongStringTemplate != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            BaseConverter baseConverter = this;
            LighterASTNode lighterASTNode2 = $this$convertShortOrLongStringTemplate;
            KtToken[] ktTokenArray = new KtToken[2];
            Intrinsics.checkNotNullExpressionValue(KtTokens.LONG_TEMPLATE_ENTRY_START, "LONG_TEMPLATE_ENTRY_START");
            Intrinsics.checkNotNullExpressionValue(KtTokens.LONG_TEMPLATE_ENTRY_END, "LONG_TEMPLATE_ENTRY_END");
            KtToken[] skipTokens$iv = ktTokenArray;
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                LighterASTNode it = kid$iv;
                boolean bl = false;
                ExpressionsConverter this_$iv2 = this;
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason);
                FirElement firElement2 = converted$iv;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firExpression3 = firElement;
            }
        }
        if ((firExpression2 = (FirExpression)firExpression3) == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic(errorReason, DiagnosticKind.Syntax), null, 4, null);
        }
        return firExpression2;
    }

    private final FirExpression convertConstantExpression(LighterASTNode constantExpression) {
        return this.generateConstantExpressionByLiteral(constantExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenExpression(LighterASTNode whenExpression) {
        FirWhenExpression firWhenExpression;
        Object converted$iv;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Object object;
        Object it;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement subjectExpression = null;
        Ref.ObjectRef subjectVariable = new Ref.ObjectRef();
        List whenEntryNodes = new ArrayList();
        List whenEntries = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            ExpressionsConverter this_$iv2;
            boolean $i$f$getAsFirExpression;
            String errorReason$iv;
            if (kid$iv == null) break;
            tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            it = kid$iv;
            boolean bl = false;
            object = it.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.PROPERTY)) {
                void variable2;
                FirDeclaration firDeclaration = DeclarationsConverter.convertPropertyDeclaration$default(this.declarationsConverter, (LighterASTNode)it, null, 2, null);
                Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable");
                FirVariable firVariable = (FirVariable)firDeclaration;
                Ref.ObjectRef objectRef = subjectVariable;
                boolean bl2 = false;
                boolean $i$f$buildProperty = false;
                firAnnotationContainerBuilder = new FirPropertyBuilder();
                FirPropertyBuilder $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448 = firAnnotationContainerBuilder;
                boolean bl3 = false;
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setSource(BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null));
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setModuleData(this.getBaseModuleData());
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setReturnTypeRef(variable2.getReturnTypeRef());
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setName(variable2.getName());
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setInitializer(variable2.getInitializer());
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setVar(false);
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setSymbol(new FirPropertySymbol(variable2.getName()));
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setLocal(true);
                $this$convertWhenExpression_u24lambda_u2450_u24lambda_u2449_u24lambda_u2448.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
                objectRef.element = ((FirPropertyBuilder)firAnnotationContainerBuilder).build();
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                FirElement firElement2;
                ExpressionsConverter expressionsConverter = this;
                errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
                $i$f$getAsFirExpression = false;
                Object it$iv = it;
                boolean bl4 = false;
                converted$iv = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                Object object2 = converted$iv;
                if (!(object2 instanceof FirExpression)) {
                    object2 = null;
                }
                if ((firElement2 = (FirElement)((FirExpression)object2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), (FirElement)converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement2 = firErrorExpression;
                }
                subjectExpression = firElement2;
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.WHEN_ENTRY)) {
                ((Collection)whenEntryNodes).add(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression((LighterASTNode)it)) continue;
            this_$iv2 = this;
            errorReason$iv = "Incorrect when subject expression: " + this.getAsText(whenExpression);
            $i$f$getAsFirExpression = false;
            Object it$iv = it;
            boolean bl5 = false;
            converted$iv = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
            Object object3 = converted$iv;
            if (!(object3 instanceof FirExpression)) {
                object3 = null;
            }
            if ((firElement = (FirElement)((FirExpression)object3)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), (FirElement)converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            subjectExpression = firElement;
        }
        FirPureAbstractElement firPureAbstractElement = (FirVariable)subjectVariable.element;
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getInitializer()) == null) {
            firPureAbstractElement = (FirExpression)subjectExpression;
        }
        boolean hasSubject = (subjectExpression = firPureAbstractElement) != null;
        FirExpressionRef<FirExpression> subject = new FirExpressionRef<FirExpression>();
        Iterable $this$mapTo$iv = whenEntryNodes;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            LighterASTNode lighterASTNode3 = (LighterASTNode)item$iv;
            Collection collection = whenEntries;
            boolean bl = false;
            it = tokenType$iv = subject;
            void var16_26 = it2;
            object = this;
            boolean bl6 = false;
            boolean bl7 = hasSubject;
            collection.add(super.convertWhenEntry((LighterASTNode)var16_26, (FirExpressionRef<FirWhenExpression>)(bl7 ? tokenType$iv : null)));
        }
        boolean $i$f$buildWhenExpression = false;
        FirWhenExpressionBuilder $this$convertWhenExpression_u24lambda_u2456 = $i$f$mapTo = new FirWhenExpressionBuilder();
        boolean bl = false;
        $this$convertWhenExpression_u24lambda_u2456.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenExpression, null, 1, null));
        $this$convertWhenExpression_u24lambda_u2456.setSubject((FirExpression)subjectExpression);
        $this$convertWhenExpression_u24lambda_u2456.setSubjectVariable((FirVariable)subjectVariable.element);
        $this$convertWhenExpression_u24lambda_u2456.setUsedAsExpression(this.getUsedAsExpression(whenExpression));
        for (WhenEntry entry : whenEntries) {
            FirWhenBranch firWhenBranch;
            FirBlock branch = entry.getFirBlock();
            KtLightSourceElement entrySource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, entry.getNode(), null, 1, null);
            Collection collection = $this$convertWhenExpression_u24lambda_u2456.getBranches();
            if (!entry.isElse()) {
                FirWhenBranchBuilder firWhenBranchBuilder;
                FirExpression firCondition;
                if (hasSubject) {
                    firCondition = entry.toFirWhenCondition();
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2453 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                    boolean bl8 = false;
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2453.setSource(entrySource);
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2453.setCondition(firCondition);
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2453.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                } else {
                    firCondition = entry.toFirWhenConditionWithoutSubject();
                    boolean $i$f$buildWhenBranch = false;
                    FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2454 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                    boolean bl9 = false;
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2454.setSource(entrySource);
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2454.setCondition(firCondition);
                    $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2454.setResult(branch);
                    firWhenBranch = firWhenBranchBuilder.build();
                }
            } else {
                FirWhenBranchBuilder firWhenBranchBuilder;
                boolean $i$f$buildWhenBranch = false;
                FirWhenBranchBuilder $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2455 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl10 = false;
                $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2455.setSource(entrySource);
                boolean $i$f$buildElseIfTrueCondition = false;
                firAnnotationContainerBuilder = new FirElseIfTrueConditionBuilder();
                converted$iv = firAnnotationContainerBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2455;
                boolean bl11 = false;
                Object $this$null = converted$iv;
                firWhenBranchBuilder2.setCondition(((FirElseIfTrueConditionBuilder)firAnnotationContainerBuilder).build());
                $this$convertWhenExpression_u24lambda_u2456_u24lambda_u2455.setResult(branch);
                firWhenBranch = firWhenBranchBuilder.build();
            }
            object = firWhenBranch;
            collection.add(object);
        }
        FirWhenExpression it3 = firWhenExpression = $i$f$mapTo.build();
        boolean bl12 = false;
        if (hasSubject) {
            subject.bind(it3);
        }
        return firWhenExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final WhenEntry convertWhenEntry(LighterASTNode whenEntry, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isElse = false;
        FirBlock firBlock = null;
        firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        List conditions2 = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenEntry;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                ((Collection)conditions2).add(this.convertWhenConditionExpression(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                ((Collection)conditions2).add(this.convertWhenConditionInRange(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.WHEN_CONDITION_IS_PATTERN)) {
                ((Collection)conditions2).add(this.convertWhenConditionIsPattern(it, whenRefWithSubject));
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.ELSE_KEYWORD)) {
                isElse = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                firBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            firBlock = this.declarationsConverter.convertBlock(it);
        }
        return new WhenEntry(conditions2, firBlock, whenEntry, isElse);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionExpression(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder;
        FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder;
        FirExpression calculatedFirExpression;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode lighterASTNode3 : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (lighterASTNode3 == null) break;
            IElementType tokenType$iv = lighterASTNode3.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, lighterASTNode3);
                continue;
            }
            LighterASTNode it = lighterASTNode3;
            boolean bl = false;
            it.getTokenType();
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No expression in condition with expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = calculatedFirExpression = (FirExpression)FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.Syntax), null, 4, null);
        }
        if (whenRefWithSubject == null) {
            return calculatedFirExpression;
        }
        boolean $i$f$buildEqualityOperatorCall = false;
        FirEqualityOperatorCallBuilder $this$convertWhenConditionExpression_u24lambda_u2461 = firEqualityOperatorCallBuilder = new FirEqualityOperatorCallBuilder();
        boolean bl = false;
        $this$convertWhenConditionExpression_u24lambda_u2461.setSource(this.toFirSourceElement(whenCondition, (KtFakeSourceElementKind)KtFakeSourceElementKind.WhenCondition.INSTANCE));
        $this$convertWhenConditionExpression_u24lambda_u2461.setOperation(FirOperation.EQ);
        boolean $i$f$buildWhenSubjectExpression = false;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder2 = firWhenSubjectExpressionBuilder = new FirWhenSubjectExpressionBuilder();
        FirEqualityOperatorCallBuilder firEqualityOperatorCallBuilder2 = $this$convertWhenConditionExpression_u24lambda_u2461;
        boolean bl3 = false;
        firWhenSubjectExpressionBuilder2.setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        firWhenSubjectExpressionBuilder2.setWhenRef(whenRefWithSubject);
        firEqualityOperatorCallBuilder2.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(firWhenSubjectExpressionBuilder.build(), calculatedFirExpression));
        return firEqualityOperatorCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionInRange(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isNegate = false;
        FirElement firExpression2 = null;
        KtSourceElement conditionSource = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE) && Intrinsics.areEqual(this.getAsText(it), KtTokens.NOT_IN.getValue())) {
                conditionSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                isNegate = true;
                continue;
            }
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.OPERATION_REFERENCE)) {
                conditionSource = BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No range in condition with range";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            FirAnnotationContainerBuilder $this$convertWhenConditionInRange_u24lambda_u2464 = firAnnotationContainerBuilder = new FirErrorExpressionBuilder();
            boolean bl = false;
            ((FirErrorExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2464).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            ((FirErrorExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2464).setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.ExpressionExpected));
            return ((FirErrorExpressionBuilder)firAnnotationContainerBuilder).build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionInRange_u24lambda_u2463 = firAnnotationContainerBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl = false;
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2463).setWhenRef(whenRefWithSubject);
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionInRange_u24lambda_u2463).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        FirWhenSubjectExpression subjectExpression = ((FirWhenSubjectExpressionBuilder)firAnnotationContainerBuilder).build();
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No range in condition with range", DiagnosticKind.Syntax), null, 4, null);
        }
        FirExpression calculatedFirExpression = firExpression3;
        return ConversionUtilsKt.generateContainsOperation(calculatedFirExpression, subjectExpression, isNegate, BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null), conditionSource);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertWhenConditionIsPattern(LighterASTNode whenCondition, FirExpressionRef<FirWhenExpression> whenRefWithSubject) {
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirOperation firOperation = null;
        FirTypeRef firType = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = whenCondition;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_REFERENCE)) {
                firType = this.declarationsConverter.convertType(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.IS_KEYWORD)) {
                firOperation = FirOperation.IS;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtTokens.NOT_IS)) continue;
            firOperation = FirOperation.NOT_IS;
        }
        if (whenRefWithSubject == null) {
            boolean $i$f$buildErrorExpression = false;
            FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2467 = firAnnotationContainerBuilder = new FirErrorExpressionBuilder();
            boolean bl = false;
            ((FirErrorExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
            ((FirErrorExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2467).setDiagnostic(new ConeSimpleDiagnostic("No expression in condition with expression", DiagnosticKind.ExpressionExpected));
            return ((FirErrorExpressionBuilder)firAnnotationContainerBuilder).build();
        }
        boolean $i$f$buildWhenSubjectExpression = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2466 = firAnnotationContainerBuilder = new FirWhenSubjectExpressionBuilder();
        boolean bl = false;
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2466).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        ((FirWhenSubjectExpressionBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2466).setWhenRef(whenRefWithSubject);
        FirWhenSubjectExpression subjectExpression = ((FirWhenSubjectExpressionBuilder)firAnnotationContainerBuilder).build();
        boolean $i$f$buildTypeOperatorCall = false;
        FirAnnotationContainerBuilder $this$convertWhenConditionIsPattern_u24lambda_u2468 = firAnnotationContainerBuilder = new FirTypeOperatorCallBuilder();
        boolean bl2 = false;
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2468).setSource(BaseFirBuilder.toFirSourceElement$default(this, whenCondition, null, 1, null));
        FirOperation firOperation2 = firOperation;
        if (firOperation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firOperation");
            firOperation2 = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2468).setOperation(firOperation2);
        FirTypeRef firTypeRef = firType;
        if (firTypeRef == null) {
            Intrinsics.throwUninitializedPropertyAccessException("firType");
            firTypeRef = null;
        }
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2468).setConversionTypeRef(firTypeRef);
        ((FirTypeOperatorCallBuilder)$this$convertWhenConditionIsPattern_u24lambda_u2468).setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(subjectExpression));
        return ((FirTypeOperatorCallBuilder)firAnnotationContainerBuilder).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertArrayAccessExpression(LighterASTNode arrayAccess) {
        void $this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2472;
        Object $this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2470;
        Object object;
        LighterASTNode lighterASTNode2;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Object tokenType$iv;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        List indices = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode3 = arrayAccess;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains((IElementType)tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.INDICES)) {
                CollectionsKt.addAll((Collection)indices, (Iterable)this.convertIndices(it));
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No array expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirExpression getArgument = this.getContext().getArraySetArgument().remove(arrayAccess);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$convertArrayAccessExpression_u24lambda_u2473 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        boolean isGet = getArgument == null;
        BaseFirBuilder baseFirBuilder = this;
        if (isGet) {
            lighterASTNode2 = arrayAccess;
        } else {
            LighterASTNode lighterASTNode4 = this.getParent(arrayAccess);
            lighterASTNode2 = lighterASTNode4;
            Intrinsics.checkNotNull(lighterASTNode4);
        }
        $this$convertArrayAccessExpression_u24lambda_u2473.setSource(BaseFirBuilder.toFirSourceElement$default(baseFirBuilder, lighterASTNode2, null, 1, null));
        boolean $i$f$buildSimpleNamedReference = false;
        tokenType$iv = object = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$convertArrayAccessExpression_u24lambda_u2473;
        boolean bl3 = false;
        ((FirSimpleNamedReferenceBuilder)$this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2470).setSource(KtSourceElementKt.fakeElement(BaseFirBuilder.toFirSourceElement$default(this, arrayAccess, null, 1, null), KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE));
        ((FirSimpleNamedReferenceBuilder)$this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2470).setName(isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        firFunctionCallBuilder2.setCalleeReference(((FirSimpleNamedReferenceBuilder)object).build());
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No array expression", DiagnosticKind.Syntax), null, 4, null);
        }
        $this$convertArrayAccessExpression_u24lambda_u2473.setExplicitReceiver(firExpression3);
        boolean $i$f$buildArgumentList = false;
        $this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2470 = object = new FirArgumentListBuilder();
        firFunctionCallBuilder2 = $this$convertArrayAccessExpression_u24lambda_u2473;
        boolean bl4 = false;
        CollectionsKt.addAll((Collection)$this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2472.getArguments(), indices);
        FirExpression firExpression4 = getArgument;
        if (firExpression4 != null) {
            FirExpression it = firExpression4;
            boolean bl5 = false;
            ((Collection)$this$convertArrayAccessExpression_u24lambda_u2473_u24lambda_u2472.getArguments()).add(it);
        }
        firFunctionCallBuilder2.setArgumentList(((FirArgumentListBuilder)object).build());
        $this$convertArrayAccessExpression_u24lambda_u2473.setOrigin(FirFunctionCallOrigin.Operator);
        return ConversionUtilsKt.pullUpSafeCallIfNecessary(firFunctionCallBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertCollectionLiteralExpression(LighterASTNode expression2) {
        void $this$convertCollectionLiteralExpression_u24lambda_u2476_u24lambda_u2475;
        FirArgumentListBuilder firArgumentListBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        List firExpressionList = new ArrayList();
        BaseConverter baseConverter = this;
        Object object = expression2;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object2 = this;
            String errorReason$iv = "Incorrect collection literal argument";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object2 = firElement;
            collection.add(object2);
        }
        boolean $i$f$buildArrayOfCall = false;
        Object $this$convertCollectionLiteralExpression_u24lambda_u2476 = object = new FirArrayOfCallBuilder();
        boolean bl = false;
        ((FirArrayOfCallBuilder)$this$convertCollectionLiteralExpression_u24lambda_u2476).setSource(BaseFirBuilder.toFirSourceElement$default(this, expression2, null, 1, null));
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        Object object3 = $this$convertCollectionLiteralExpression_u24lambda_u2476;
        boolean bl3 = false;
        CollectionsKt.addAll((Collection)$this$convertCollectionLiteralExpression_u24lambda_u2476_u24lambda_u2475.getArguments(), firExpressionList);
        ((FirArrayOfCallBuilder)object3).setArgumentList(firArgumentListBuilder.build());
        return ((FirArrayOfCallBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirExpression> convertIndices(LighterASTNode indices) {
        void $this$forEachChildren$iv;
        void this_$iv;
        List firExpressionList = new ArrayList();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = indices;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            Collection collection = firExpressionList;
            Object object = this;
            String errorReason$iv = "Incorrect index expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            object = firElement;
            collection.add(object);
        }
        return firExpressionList;
    }

    private final FirQualifiedAccessExpression convertSimpleNameExpression(LighterASTNode referenceExpression2) {
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        KtLightSourceElement nameSource = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, referenceExpression2, null, 1, null);
        KtSourceElement referenceSourceElement = nameSource.getKind() instanceof KtFakeSourceElementKind ? (KtSourceElement)nameSource : KtSourceElementKt.fakeElement(nameSource, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE);
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$convertSimpleNameExpression_u24lambda_u2478 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        String rawText = this.getAsText(referenceExpression2);
        if (ConversionUtilsKt.isUnderscore(rawText)) {
            $this$convertSimpleNameExpression_u24lambda_u2478.getNonFatalDiagnostics().add(new ConeUnderscoreUsageWithoutBackticks(nameSource));
        }
        $this$convertSimpleNameExpression_u24lambda_u2478.setSource(nameSource);
        $this$convertSimpleNameExpression_u24lambda_u2478.setCalleeReference(this.createSimpleNamedReference(referenceSourceElement, referenceExpression2));
        return firPropertyAccessExpressionBuilder.build();
    }

    private final FirNamedReference createSimpleNamedReference(KtSourceElement sourceElement, LighterASTNode referenceExpression2) {
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder $this$createSimpleNamedReference_u24lambda_u2479 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        boolean bl = false;
        $this$createSimpleNamedReference_u24lambda_u2479.setSource(sourceElement);
        $this$createSimpleNamedReference_u24lambda_u2479.setName(ConverterUtilKt.nameAsSafeName$default(this.getAsText(referenceExpression2), null, 1, null));
        return firSimpleNamedReferenceBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertDoWhile(LighterASTNode doWhileLoop) {
        void $this$forEachChildren$iv;
        void this_$iv;
        void $this$convertDoWhile_u24lambda_u2481;
        FirDoWhileLoopBuilder firDoWhileLoopBuilder;
        Ref.ObjectRef<LighterASTNode> block = new Ref.ObjectRef<LighterASTNode>();
        FirElement firCondition = null;
        FirLoopTarget target = null;
        FirDoWhileLoopBuilder firDoWhileLoopBuilder2 = firDoWhileLoopBuilder = new FirDoWhileLoopBuilder();
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        $this$convertDoWhile_u24lambda_u2481.setSource(BaseFirBuilder.toFirSourceElement$default(this, doWhileLoop, null, 1, null));
        target = this.prepareTarget((FirLoopBuilder)$this$convertDoWhile_u24lambda_u2481, doWhileLoop);
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = doWhileLoop;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl2 = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter2 = this;
            String errorReason$iv = "No condition in do-while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl3 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = firElement;
        }
        FirExpression firExpression2 = (FirExpression)firCondition;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No condition in do-while loop", DiagnosticKind.Syntax), null, 4, null);
        }
        $this$convertDoWhile_u24lambda_u2481.setCondition(firExpression2);
        return expressionsConverter.configure(firDoWhileLoopBuilder, target, (Function0<FirBlock>)new Function0<FirBlock>(this, block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertWhile(LighterASTNode whileLoop) {
        void $this$convertWhile_u24lambda_u2483;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<LighterASTNode> block = new Ref.ObjectRef<LighterASTNode>();
        FirElement firCondition = null;
        BaseConverter baseConverter = this;
        Object object = whileLoop;
        Object skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BODY)) {
                block.element = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "No condition in while loop";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firCondition = firElement;
        }
        FirLoopTarget target = null;
        object = new FirWhileLoopBuilder();
        skipTokens$iv = object;
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        $this$convertWhile_u24lambda_u2483.setSource(BaseFirBuilder.toFirSourceElement$default(this, whileLoop, null, 1, null));
        FirExpression firExpression2 = (FirExpression)firCondition;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No condition in while loop", DiagnosticKind.Syntax), null, 4, null);
        }
        $this$convertWhile_u24lambda_u2483.setCondition(firExpression2);
        target = this.prepareTarget((FirLoopBuilder)$this$convertWhile_u24lambda_u2483, whileLoop);
        return expressionsConverter.configure((FirLoopBuilder)object, target, (Function0<FirBlock>)new Function0<FirBlock>(this, block){
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            @NotNull
            public final FirBlock invoke() {
                return ExpressionsConverter.access$convertLoopBody(this.this$0, (LighterASTNode)this.$block.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final FirElement convertFor(LighterASTNode forLoop) {
        void $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        void $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488;
        void $this$convertFor_u24lambda_u2490_u24lambda_u2489;
        Object $this$convertFor_u24lambda_u2490_u24lambda_u2486_u24lambda_u2485;
        FirAnnotationContainerBuilder $this$convertFor_u24lambda_u2490_u24lambda_u2486;
        Object object;
        FirBlockBuilder firBlockBuilder;
        Object object2;
        Object object3;
        Object it;
        void $this$forEachChildren$iv;
        void this_$iv;
        Ref.ObjectRef<ValueParameter> parameter2 = new Ref.ObjectRef<ValueParameter>();
        FirElement rangeExpression = null;
        Ref.ObjectRef<LighterASTNode> blockNode = new Ref.ObjectRef<LighterASTNode>();
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = forLoop;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            it = kid$iv;
            boolean bl = false;
            object3 = it.getTokenType();
            if (Intrinsics.areEqual(object3, KtNodeTypes.VALUE_PARAMETER)) {
                parameter2.element = DeclarationsConverter.convertValueParameter$default(this.declarationsConverter, (LighterASTNode)it, null, BaseFirBuilder.ValueParameterDeclaration.FOR_LOOP, null, 8, null);
                continue;
            }
            if (Intrinsics.areEqual(object3, KtNodeTypes.LOOP_RANGE)) {
                FirElement firElement;
                void this_$iv2;
                object2 = this;
                String errorReason$iv = "No range in for loop";
                boolean $i$f$getAsFirExpression = false;
                Object it$iv = it;
                boolean bl2 = false;
                FirElement converted$iv = this_$iv2.convertExpression((LighterASTNode)it$iv, errorReason$iv);
                FirElement firElement2 = converted$iv;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                rangeExpression = firElement;
                continue;
            }
            if (!Intrinsics.areEqual(object3, KtNodeTypes.BODY)) continue;
            blockNode.element = it;
        }
        FirExpression firExpression2 = (FirExpression)rangeExpression;
        if (firExpression2 == null) {
            firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("No range in for loop", DiagnosticKind.Syntax), null, 4, null);
        }
        FirExpression calculatedRangeExpression = firExpression2;
        KtLightSourceElement fakeSource = this.toFirSourceElement(forLoop, (KtFakeSourceElementKind)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE);
        FirLoopTarget target = null;
        boolean $i$f$buildBlock = false;
        FirBlockBuilder $this$convertFor_u24lambda_u2490 = firBlockBuilder = new FirBlockBuilder();
        boolean bl = false;
        $this$convertFor_u24lambda_u2490.setSource(fakeSource);
        KtSourceElement ktSourceElement = calculatedRangeExpression.getSource();
        boolean $i$f$buildFunctionCall = false;
        it = object = new FirFunctionCallBuilder();
        Name name2 = SpecialNames.ITERATOR;
        object3 = ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE) : null;
        object2 = this.getBaseModuleData();
        boolean bl3 = false;
        $this$convertFor_u24lambda_u2490_u24lambda_u2486.setSource(fakeSource);
        boolean $i$f$buildSimpleNamedReference = false;
        Object object4 = new FirSimpleNamedReferenceBuilder();
        FirSimpleNamedReferenceBuilder bl2 = object4;
        void var22_28 = $this$convertFor_u24lambda_u2490_u24lambda_u2486;
        boolean bl4 = false;
        ((FirSimpleNamedReferenceBuilder)$this$convertFor_u24lambda_u2490_u24lambda_u2486_u24lambda_u2485).setSource(fakeSource);
        ((FirSimpleNamedReferenceBuilder)$this$convertFor_u24lambda_u2490_u24lambda_u2486_u24lambda_u2485).setName(OperatorNameConventions.ITERATOR);
        var22_28.setCalleeReference(((FirSimpleNamedReferenceBuilder)object4).build());
        $this$convertFor_u24lambda_u2490_u24lambda_u2486.setExplicitReceiver(calculatedRangeExpression);
        Unit unit2 = Unit.INSTANCE;
        FirProperty iteratorVal = FirGenerationKt.generateTemporaryVariable$default((FirModuleData)object2, (KtSourceElement)object3, name2, ((FirFunctionCallBuilder)object).build(), null, null, 48, null);
        ((Collection)$this$convertFor_u24lambda_u2490.getStatements()).add(iteratorVal);
        Collection collection = $this$convertFor_u24lambda_u2490.getStatements();
        object = new FirWhileLoopBuilder();
        $this$convertFor_u24lambda_u2490_u24lambda_u2486 = object;
        object2 = this;
        boolean bl5 = false;
        $this$convertFor_u24lambda_u2490_u24lambda_u2489.setSource(fakeSource);
        boolean $i$f$buildFunctionCall2 = false;
        $this$convertFor_u24lambda_u2490_u24lambda_u2486_u24lambda_u2485 = object4 = new FirFunctionCallBuilder();
        var22_28 = $this$convertFor_u24lambda_u2490_u24lambda_u2489;
        boolean bl6 = false;
        $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488.setSource(fakeSource);
        boolean $i$f$buildSimpleNamedReference2 = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        void var29_35 = $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488;
        boolean bl7 = false;
        $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487.setSource(fakeSource);
        $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488_u24lambda_u2487.setName(OperatorNameConventions.HAS_NEXT);
        var29_35.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$convertFor_u24lambda_u2490_u24lambda_u2489_u24lambda_u2488.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(fakeSource, iteratorVal));
        var22_28.setCondition(((FirFunctionCallBuilder)object4).build());
        target = this.prepareTarget((FirLoopBuilder)$this$convertFor_u24lambda_u2490_u24lambda_u2489, forLoop);
        object = ((BaseFirBuilder)object2).configure((FirLoopBuilder)object, target, (Function0<? extends FirBlock>)new Function0<FirBlock>(blockNode, this, parameter2, fakeSource, iteratorVal){
            final /* synthetic */ Ref.ObjectRef<LighterASTNode> $blockNode;
            final /* synthetic */ ExpressionsConverter this$0;
            final /* synthetic */ Ref.ObjectRef<ValueParameter> $parameter;
            final /* synthetic */ KtLightSourceElement $fakeSource;
            final /* synthetic */ FirProperty $iteratorVal;
            {
                this.$blockNode = $blockNode;
                this.this$0 = $receiver;
                this.$parameter = $parameter;
                this.$fakeSource = $fakeSource;
                this.$iteratorVal = $iteratorVal;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final FirBlock invoke() {
                FirBlockBuilder firBlockBuilder;
                Ref.ObjectRef<LighterASTNode> objectRef = this.$blockNode;
                ExpressionsConverter expressionsConverter = this.this$0;
                Ref.ObjectRef<ValueParameter> objectRef2 = this.$parameter;
                KtLightSourceElement ktLightSourceElement = this.$fakeSource;
                FirProperty firProperty = this.$iteratorVal;
                boolean $i$f$buildBlock = false;
                FirBlockBuilder $this$invoke_u24lambda_u242 = firBlockBuilder = new FirBlockBuilder();
                boolean bl = false;
                LighterASTNode lighterASTNode2 = (LighterASTNode)objectRef.element;
                $this$invoke_u24lambda_u242.setSource(lighterASTNode2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(expressionsConverter, lighterASTNode2, null, 1, null) : null);
                ValueParameter valueParameter2 = (ValueParameter)objectRef2.element;
                if (valueParameter2 != null) {
                    void $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
                    void $this$invoke_u24lambda_u242_u24lambda_u241;
                    FirFunctionCallBuilder firFunctionCallBuilder;
                    ValueParameter valueParameter3 = valueParameter2;
                    DestructuringDeclaration multiDeclaration = valueParameter3.getDestructuringDeclaration();
                    boolean $i$f$buildFunctionCall = false;
                    FirFunctionCallBuilder firFunctionCallBuilder2 = firFunctionCallBuilder = new FirFunctionCallBuilder();
                    Name name2 = multiDeclaration != null ? SpecialNames.DESTRUCT : valueParameter3.getName();
                    KtSourceElement ktSourceElement = valueParameter3.getSource();
                    FirModuleData firModuleData = expressionsConverter.getBaseModuleData();
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241.setSource(ktLightSourceElement);
                    boolean $i$f$buildSimpleNamedReference = false;
                    FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
                    void var22_23 = $this$invoke_u24lambda_u242_u24lambda_u241;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setSource(ktLightSourceElement);
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setName(OperatorNameConventions.NEXT);
                    var22_23.setCalleeReference(firSimpleNamedReferenceBuilder.build());
                    $this$invoke_u24lambda_u242_u24lambda_u241.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(ktLightSourceElement, firProperty));
                    Unit unit2 = Unit.INSTANCE;
                    FirProperty firLoopParameter = FirGenerationKt.generateTemporaryVariable$default(firModuleData, ktSourceElement, name2, firFunctionCallBuilder.build(), valueParameter3.getReturnTypeRef(), null, 32, null);
                    if (multiDeclaration != null) {
                        FirBlock destructuringBlock2 = ConverterUtilKt.generateDestructuringBlock(expressionsConverter.getBaseModuleData(), multiDeclaration, firLoopParameter, true);
                        $this$invoke_u24lambda_u242.getStatements().addAll((Collection<FirStatement>)destructuringBlock2.getStatements());
                    } else {
                        $this$invoke_u24lambda_u242.getStatements().add(firLoopParameter);
                    }
                    ((Collection)$this$invoke_u24lambda_u242.getStatements()).add(ExpressionsConverter.access$convertLoopBody(expressionsConverter, (LighterASTNode)objectRef.element));
                }
                return firBlockBuilder.build();
            }
        });
        collection.add(object);
        return firBlockBuilder.build();
    }

    private final FirBlock convertLoopBody(LighterASTNode body2) {
        FirBlock firBlock = this.convertLoopOrIfBody(body2);
        if (firBlock == null) {
            firBlock = FirEmptyExpressionBlockBuilderKt.buildEmptyExpressionBlock();
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertLoopOrIfBody(LighterASTNode body2) {
        FirBlock firBlock;
        FirElement firBlock2 = null;
        FirElement firStatement = null;
        if (body2 != null) {
            void $this$forEachChildren$iv;
            void this_$iv;
            BaseConverter baseConverter = this;
            LighterASTNode lighterASTNode2 = body2;
            KtToken[] skipTokens$iv = new KtToken[]{};
            boolean $i$f$forEachChildren = false;
            for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                FirElement firElement;
                FirElement converted$iv;
                boolean bl;
                LighterASTNode it$iv;
                boolean $i$f$getAsFirExpression;
                String errorReason$iv;
                if (kid$iv == null) break;
                IElementType tokenType$iv = kid$iv.getTokenType();
                if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                    BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                    continue;
                }
                LighterASTNode it = kid$iv;
                boolean bl2 = false;
                IElementType iElementType = it.getTokenType();
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) {
                    firBlock2 = this.declarationsConverter.convertBlockExpression(it);
                    continue;
                }
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION)) {
                    FirElement firElement2;
                    IElementType iElementType2 = KtNodeTypes.BLOCK;
                    Intrinsics.checkNotNullExpressionValue(iElementType2, "BLOCK");
                    if (this.getChildNodeByType(it, iElementType2) != null) {
                        FirElement firElement3;
                        errorReason$iv = "";
                        $i$f$getAsFirExpression = false;
                        it$iv = it;
                        bl = false;
                        converted$iv = this.convertExpression(it$iv, errorReason$iv);
                        FirElement firElement4 = converted$iv;
                        if (!(firElement4 instanceof FirBlock)) {
                            firElement4 = null;
                        }
                        if ((firElement3 = (FirElement)((FirBlock)firElement4)) == null) {
                            FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                            if (firErrorExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirBlock");
                            }
                            firElement3 = (FirBlock)((Object)firErrorExpression);
                        }
                        firBlock2 = firElement3;
                        continue;
                    }
                    errorReason$iv = "";
                    $i$f$getAsFirExpression = false;
                    it$iv = it;
                    bl = false;
                    converted$iv = this.convertExpression(it$iv, errorReason$iv);
                    FirElement firElement5 = converted$iv;
                    if (!(firElement5 instanceof FirStatement)) {
                        firElement5 = null;
                    }
                    if ((firElement2 = (FirElement)((FirStatement)firElement5)) == null) {
                        FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                        if (firErrorExpression == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                        }
                        firElement2 = firErrorExpression;
                    }
                    firStatement = firElement2;
                    continue;
                }
                if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
                errorReason$iv = "";
                $i$f$getAsFirExpression = false;
                it$iv = it;
                bl = false;
                converted$iv = this.convertExpression(it$iv, errorReason$iv);
                FirElement firElement6 = converted$iv;
                if (!(firElement6 instanceof FirStatement)) {
                    firElement6 = null;
                }
                if ((firElement = (FirElement)((FirStatement)firElement6)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
                    }
                    firElement = firErrorExpression;
                }
                firStatement = firElement;
            }
        }
        FirStatement firStatement2 = (FirStatement)firStatement;
        if (firStatement2 != null) {
            FirStatement it = firStatement2;
            boolean bl = false;
            firBlock = new FirSingleExpressionBlock(it);
        } else {
            firBlock = firBlock2;
        }
        return firBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertTryExpression(LighterASTNode tryExpression) {
        Object object;
        void $this$forEachChildren$iv;
        void this_$iv;
        FirBlock tryBlock = null;
        List catchClauses = new ArrayList();
        FirBlock finallyBlock = null;
        BaseConverter baseConverter = this;
        Object object2 = tryExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            object = it.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.BLOCK)) {
                tryBlock = this.declarationsConverter.convertBlock(it);
                continue;
            }
            if (Intrinsics.areEqual(object, KtNodeTypes.CATCH)) {
                if (this.convertCatchClause(it) != null) {
                    Triple<ValueParameter, FirBlock, KtLightSourceElement> triple;
                    Triple<ValueParameter, FirBlock, KtLightSourceElement> oneClause = triple;
                    boolean bl2 = false;
                    ((Collection)catchClauses).add(oneClause);
                }
                continue;
            }
            if (!Intrinsics.areEqual(object, KtNodeTypes.FINALLY)) continue;
            finallyBlock = this.convertFinally(it);
        }
        boolean $i$f$buildTryExpression = false;
        Object $this$convertTryExpression_u24lambda_u2498 = object2 = new FirTryExpressionBuilder();
        boolean bl = false;
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2498).setSource(BaseFirBuilder.toFirSourceElement$default(this, tryExpression, null, 1, null));
        FirBlock firBlock = tryBlock;
        if (firBlock == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tryBlock");
            firBlock = null;
        }
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2498).setTryBlock(firBlock);
        ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2498).setFinallyBlock(finallyBlock);
        for (Triple triple : catchClauses) {
            void it;
            void $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495;
            ValueParameter parameter2 = (ValueParameter)triple.component1();
            FirBlock block = (FirBlock)triple.component2();
            KtLightSourceElement clauseSource = (KtLightSourceElement)triple.component3();
            if (parameter2 == null) continue;
            Collection collection = ((FirTryExpressionBuilder)$this$convertTryExpression_u24lambda_u2498).getCatches();
            boolean $i$f$buildCatch = false;
            Object $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497 = object = new FirCatchBuilder();
            boolean bl3 = false;
            boolean $i$f$buildProperty = false;
            Object object3 = new FirPropertyBuilder();
            FirPropertyBuilder firPropertyBuilder = object3;
            Object object4 = $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497;
            boolean bl4 = false;
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setSource(parameter2.getSource());
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setModuleData(this.getBaseModuleData());
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setReturnTypeRef(parameter2.getReturnTypeRef());
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setVar(false);
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setStatus(new FirResolvedDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL, EffectiveVisibility.Local.INSTANCE));
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setLocal(true);
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setName(parameter2.getName());
            $this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.setSymbol(new FirPropertySymbol(new CallableId($this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.getName(), null, 2, null)));
            CollectionsKt.addAll((Collection)$this$convertTryExpression_u24lambda_u2498_u24lambda_u2497_u24lambda_u2495.getAnnotations(), (Iterable)parameter2.getAnnotations());
            FirProperty firProperty = ((FirPropertyBuilder)object3).build();
            object3 = firProperty;
            boolean bl5 = false;
            ClassMembersKt.setCatchParameter((FirProperty)it, true);
            ((FirCatchBuilder)object4).setParameter(firProperty);
            ((FirCatchBuilder)$this$convertTryExpression_u24lambda_u2498_u24lambda_u2497).setBlock(block);
            ((FirCatchBuilder)$this$convertTryExpression_u24lambda_u2498_u24lambda_u2497).setSource(clauseSource);
            FirCatch firCatch = ((FirCatchBuilder)object).build();
            collection.add(firCatch);
        }
        return ((FirTryExpressionBuilder)object2).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<ValueParameter, FirBlock, KtLightSourceElement> convertCatchClause(LighterASTNode catchClause) {
        void $this$forEachChildren$iv;
        void this_$iv;
        ValueParameter valueParameter2 = null;
        LighterASTNode blockNode = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = catchClause;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_PARAMETER_LIST)) {
                if ((ValueParameter)CollectionsKt.firstOrNull(DeclarationsConverter.convertValueParameters$default(this.declarationsConverter, it, new FirAnonymousFunctionSymbol(), BaseFirBuilder.ValueParameterDeclaration.CATCH, null, 8, null)) != null) continue;
                return null;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return new Triple<Object, FirBlock, KtSourceElement>(valueParameter2, this.declarationsConverter.convertBlock(blockNode), BaseFirBuilder.toFirSourceElement$default(this, catchClause, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final FirBlock convertFinally(LighterASTNode finallyExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        LighterASTNode blockNode = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = finallyExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.BLOCK)) continue;
            blockNode = it;
        }
        return this.declarationsConverter.convertBlock(blockNode);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertIfExpression(LighterASTNode ifExpression) {
        FirWhenExpressionBuilder $this$convertIfExpression_u24lambda_u24106;
        FirWhenExpressionBuilder firWhenExpressionBuilder;
        block5: {
            boolean cascadeIf;
            IfNodeComponents components2 = null;
            components2 = this.parseIfExpression(ifExpression);
            boolean $i$f$buildWhenExpression = false;
            $this$convertIfExpression_u24lambda_u24106 = firWhenExpressionBuilder = new FirWhenExpressionBuilder();
            boolean bl = false;
            $this$convertIfExpression_u24lambda_u24106.setSource(BaseFirBuilder.toFirSourceElement$default(this, ifExpression, null, 1, null));
            do {
                void $this$forEachChildren$iv;
                void this_$iv;
                FirWhenBranchBuilder firWhenBranchBuilder;
                IfNodeComponents $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102 = components2;
                boolean $i$a$-with-ExpressionsConverter$convertIfExpression$1$22 = false;
                Object trueBranch = this.convertLoopBody($this$convertIfExpression_u24lambda_u24106_u24lambda_u24102.getThenBlock());
                Collection collection = $this$convertIfExpression_u24lambda_u24106.getBranches();
                boolean $i$f$buildWhenBranch22 = false;
                FirWhenBranchBuilder $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102_u24lambda_u24101 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                int n = 0;
                LighterASTNode lighterASTNode2 = $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102.getThenBlock();
                $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102_u24lambda_u24101.setSource(lighterASTNode2 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode2, null, 1, null) : null);
                FirExpression firExpression2 = $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102.getFirCondition();
                if (firExpression2 == null) {
                    firExpression2 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("If statement should have condition", DiagnosticKind.Syntax), null, 4, null);
                }
                $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102_u24lambda_u24101.setCondition(firExpression2);
                $this$convertIfExpression_u24lambda_u24106_u24lambda_u24102_u24lambda_u24101.setResult((FirBlock)trueBranch);
                FirWhenBranch $i$f$buildWhenBranch22 = firWhenBranchBuilder.build();
                collection.add($i$f$buildWhenBranch22);
                if (components2.getElseBlock() == null) break block5;
                cascadeIf = false;
                LighterASTNode lighterASTNode3 = components2.getElseBlock();
                if (lighterASTNode3 == null) continue;
                BaseConverter $i$a$-with-ExpressionsConverter$convertIfExpression$1$22 = this;
                trueBranch = lighterASTNode3;
                KtToken[] skipTokens$iv = new KtToken[]{};
                boolean $i$f$forEachChildren = false;
                for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
                    if (kid$iv == null) break;
                    IElementType tokenType$iv = kid$iv.getTokenType();
                    if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
                    if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                        BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                        continue;
                    }
                    LighterASTNode it = kid$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.IF)) continue;
                    cascadeIf = true;
                    components2 = this.parseIfExpression(it);
                }
            } while (cascadeIf);
            IfNodeComponents $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105 = components2;
            boolean bl3 = false;
            FirBlock elseBranch = this.convertLoopOrIfBody($this$convertIfExpression_u24lambda_u24106_u24lambda_u24105.getElseBlock());
            if (elseBranch != null) {
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder;
                FirWhenBranchBuilder firWhenBranchBuilder;
                Collection collection = $this$convertIfExpression_u24lambda_u24106.getBranches();
                boolean $i$f$buildWhenBranch = false;
                FirWhenBranchBuilder $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104 = firWhenBranchBuilder = new FirWhenBranchBuilder();
                boolean bl4 = false;
                LighterASTNode lighterASTNode4 = $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105.getElseBlock();
                $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104.setSource(lighterASTNode4 != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, lighterASTNode4, null, 1, null) : null);
                boolean $i$f$buildElseIfTrueCondition = false;
                FirElseIfTrueConditionBuilder firElseIfTrueConditionBuilder2 = firElseIfTrueConditionBuilder = new FirElseIfTrueConditionBuilder();
                FirWhenBranchBuilder firWhenBranchBuilder2 = $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104;
                boolean bl5 = false;
                FirElseIfTrueConditionBuilder $this$null = firElseIfTrueConditionBuilder2;
                firWhenBranchBuilder2.setCondition(firElseIfTrueConditionBuilder.build());
                $this$convertIfExpression_u24lambda_u24106_u24lambda_u24105_u24lambda_u24104.setResult(elseBranch);
                FirWhenBranch firWhenBranch = firWhenBranchBuilder.build();
                collection.add(firWhenBranch);
            }
        }
        $this$convertIfExpression_u24lambda_u24106.setUsedAsExpression(this.getUsedAsExpression(ifExpression));
        return firWhenExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final IfNodeComponents parseIfExpression(LighterASTNode ifExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firCondition = null;
        LighterASTNode thenBlock = null;
        LighterASTNode elseBlock = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = ifExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONDITION)) {
                FirElement firElement;
                void this_$iv2;
                ExpressionsConverter expressionsConverter = this;
                String errorReason$iv = "If statement should have condition";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode it$iv = it;
                boolean bl2 = false;
                FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
                FirElement firElement2 = converted$iv;
                if (!(firElement2 instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                firCondition = firElement;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.THEN)) {
                thenBlock = it;
                continue;
            }
            if (!Intrinsics.areEqual(iElementType, KtNodeTypes.ELSE)) continue;
            elseBlock = it;
        }
        return new IfNodeComponents((FirExpression)firCondition, thenBlock, elseBlock);
    }

    private final boolean getUsedAsExpression(LighterASTNode $this$usedAsExpression) {
        LighterASTNode lighterASTNode2 = this.getParent($this$usedAsExpression);
        if (lighterASTNode2 == null) {
            return true;
        }
        LighterASTNode parent2 = lighterASTNode2;
        while (Intrinsics.areEqual(this.getElementType(parent2), KtNodeTypes.ANNOTATED_EXPRESSION) || Intrinsics.areEqual(this.getElementType(parent2), KtNodeTypes.LABELED_EXPRESSION)) {
            if (this.getParent(parent2) != null) continue;
            return true;
        }
        IElementType parentTokenType = parent2.getTokenType();
        if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.BLOCK)) {
            return false;
        }
        if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.THEN) || Intrinsics.areEqual(parentTokenType, KtNodeTypes.ELSE) || Intrinsics.areEqual(parentTokenType, KtNodeTypes.WHEN_ENTRY)) {
            LighterASTNode lighterASTNode3 = this.getParent(parent2);
            return lighterASTNode3 != null ? this.getUsedAsExpression(lighterASTNode3) : true;
        }
        if (!Intrinsics.areEqual(parentTokenType, KtNodeTypes.BODY)) {
            return true;
        }
        LighterASTNode lighterASTNode4 = this.getParent(parent2);
        IElementType iElementType = lighterASTNode4 != null ? lighterASTNode4.getTokenType() : null;
        if (iElementType == null) {
            return true;
        }
        IElementType type2 = iElementType;
        return !Intrinsics.areEqual(type2, KtNodeTypes.FOR) && !Intrinsics.areEqual(type2, KtNodeTypes.WHILE) && !Intrinsics.areEqual(type2, KtNodeTypes.DO_WHILE);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertLoopJump(LighterASTNode jump) {
        void $this$convertLoopJump_u24lambda_u24109;
        FirLoopJumpBuilder firLoopJumpBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        boolean isBreak = false;
        isBreak = true;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = jump;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren22 = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtTokens.CONTINUE_KEYWORD)) continue;
            isBreak = false;
        }
        FirLoopJumpBuilder jumpBuilder = isBreak ? new FirBreakExpressionBuilder() : new FirContinueExpressionBuilder();
        KtLightSourceElement sourceElement = (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, jump, null, 1, null);
        FirLoopJumpBuilder $i$f$forEachChildren22 = firLoopJumpBuilder = jumpBuilder;
        ExpressionsConverter expressionsConverter = this;
        boolean bl = false;
        ((FirLoopJumpBuilder)$this$convertLoopJump_u24lambda_u24109).setSource(sourceElement);
        return expressionsConverter.bindLabel(firLoopJumpBuilder, jump).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertReturn(LighterASTNode returnExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        String labelName = null;
        FirElement firExpression2 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = returnExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.LABEL_QUALIFIER)) {
                labelName = StringsKt.replace$default(ConverterUtilKt.getAsStringWithoutBacktick(it), "@", "", false, 4, null);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Incorrect return expression";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            FirUnitExpressionBuilder firUnitExpressionBuilder;
            boolean $i$f$buildUnitExpression = false;
            FirUnitExpressionBuilder $this$convertReturn_u24lambda_u24111 = firUnitExpressionBuilder = new FirUnitExpressionBuilder();
            boolean bl = false;
            $this$convertReturn_u24lambda_u24111.setSource(this.toFirSourceElement(returnExpression, (KtFakeSourceElementKind)KtFakeSourceElementKind.ImplicitUnit.INSTANCE));
            firExpression3 = firUnitExpressionBuilder.build();
        }
        FirExpression calculatedFirExpression = firExpression3;
        return this.toReturn(calculatedFirExpression, BaseFirBuilder.toFirSourceElement$default(this, returnExpression, null, 1, null), labelName, true);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertThrow(LighterASTNode throwExpression) {
        void $this$forEachChildren$iv;
        void this_$iv;
        FirElement firExpression2 = null;
        BaseConverter baseConverter = this;
        Object object = throwExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Nothing to throw";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression2 = firElement;
        }
        boolean $i$f$buildThrowExpression = false;
        Object $this$convertThrow_u24lambda_u24113 = object = new FirThrowExpressionBuilder();
        boolean bl = false;
        ((FirThrowExpressionBuilder)$this$convertThrow_u24lambda_u24113).setSource(BaseFirBuilder.toFirSourceElement$default(this, throwExpression, null, 1, null));
        FirExpression firExpression3 = (FirExpression)firExpression2;
        if (firExpression3 == null) {
            firExpression3 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("Nothing to throw", DiagnosticKind.Syntax), null, 4, null);
        }
        ((FirThrowExpressionBuilder)$this$convertThrow_u24lambda_u24113).setException(firExpression3);
        return ((FirThrowExpressionBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertThisExpression(LighterASTNode thisExpression) {
        void $this$convertThisExpression_u24lambda_u24115_u24lambda_u24114;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder;
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
        String label = this.getLabelName(thisExpression);
        boolean $i$f$buildThisReceiverExpression = false;
        FirThisReceiverExpressionBuilder $this$convertThisExpression_u24lambda_u24115 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
        boolean bl = false;
        $this$convertThisExpression_u24lambda_u24115.setSource(BaseFirBuilder.toFirSourceElement$default(this, thisExpression, null, 1, null));
        boolean $i$f$buildExplicitThisReference = false;
        FirExplicitThisReferenceBuilder firExplicitThisReferenceBuilder2 = firExplicitThisReferenceBuilder = new FirExplicitThisReferenceBuilder();
        FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$convertThisExpression_u24lambda_u24115;
        boolean bl2 = false;
        $this$convertThisExpression_u24lambda_u24115_u24lambda_u24114.setLabelName(label);
        firThisReceiverExpressionBuilder2.setCalleeReference(firExplicitThisReferenceBuilder.build());
        return firThisReceiverExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FirQualifiedAccessExpression convertSuperExpression(LighterASTNode superExpression) {
        void $this$convertSuperExpression_u24lambda_u24118_u24lambda_u24117;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        String label = this.getLabelName(superExpression);
        FirTypeRef superTypeRef = null;
        superTypeRef = this.getImplicitType();
        BaseConverter baseConverter = this;
        Object object = superExpression;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.TYPE_REFERENCE)) continue;
            superTypeRef = this.declarationsConverter.convertType(it);
        }
        boolean $i$f$buildPropertyAccessExpression = false;
        Object $this$convertSuperExpression_u24lambda_u24118 = object = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        ((FirPropertyAccessExpressionBuilder)$this$convertSuperExpression_u24lambda_u24118).setSource(BaseFirBuilder.toFirSourceElement$default(this, superExpression, null, 1, null));
        boolean $i$f$buildExplicitSuperReference = false;
        FirExplicitSuperReferenceBuilder firExplicitSuperReferenceBuilder2 = firExplicitSuperReferenceBuilder = new FirExplicitSuperReferenceBuilder();
        Object object2 = $this$convertSuperExpression_u24lambda_u24118;
        boolean bl2 = false;
        $this$convertSuperExpression_u24lambda_u24118_u24lambda_u24117.setLabelName(label);
        $this$convertSuperExpression_u24lambda_u24118_u24lambda_u24117.setSuperTypeRef(superTypeRef);
        ((FirPropertyAccessExpressionBuilder)object2).setCalleeReference(firExplicitSuperReferenceBuilder.build());
        return ((FirPropertyAccessExpressionBuilder)object).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirExpression> convertValueArguments(@NotNull LighterASTNode valueArguments) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(valueArguments, "valueArguments");
        BaseConverter baseConverter = this;
        LighterASTNode $this$forEachChildrenReturnList$iv = valueArguments;
        boolean $i$f$forEachChildrenReturnList = false;
        LighterASTNode[] kidsArray$iv = this_$iv.getChildrenAsArray($this$forEachChildrenReturnList$iv);
        List container$iv = new ArrayList();
        for (LighterASTNode kid$iv : kidsArray$iv) {
            FirElement firElement;
            FirLambdaArgumentExpressionBuilder firLambdaArgumentExpressionBuilder;
            void container;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            List list2 = container$iv;
            LighterASTNode node = kid$iv;
            boolean bl = false;
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT)) {
                ((Collection)container).add(this.convertValueArgument(node));
                continue;
            }
            if (!((Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_EXPRESSION) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LABELED_EXPRESSION)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.ANNOTATED_EXPRESSION))) continue;
            Collection collection = (Collection)container;
            boolean $i$f$buildLambdaArgumentExpression = false;
            FirLambdaArgumentExpressionBuilder $this$convertValueArguments_u24lambda_u24120_u24lambda_u24119 = firLambdaArgumentExpressionBuilder = new FirLambdaArgumentExpressionBuilder();
            boolean bl2 = false;
            $this$convertValueArguments_u24lambda_u24120_u24lambda_u24119.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArguments, null, 1, null));
            String errorReason$iv = "";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = node;
            boolean bl3 = false;
            FirElement converted$iv = this.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default(this, node, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            $this$convertValueArguments_u24lambda_u24120_u24lambda_u24119.setExpression((FirExpression)firElement);
            FirLambdaArgumentExpression firLambdaArgumentExpression = firLambdaArgumentExpressionBuilder.build();
            collection.add(firLambdaArgumentExpression);
        }
        return container$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression convertValueArgument(LighterASTNode valueArgument) {
        FirExpression firExpression2;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        void $this$forEachChildren$iv;
        void this_$iv;
        String identifier = null;
        boolean isSpread = false;
        FirElement firExpression3 = null;
        BaseConverter baseConverter = this;
        LighterASTNode lighterASTNode2 = valueArgument;
        KtToken[] skipTokens$iv = new KtToken[]{};
        boolean $i$f$forEachChildren = false;
        for (LighterASTNode kid$iv : this_$iv.getChildrenAsArray((LighterASTNode)$this$forEachChildren$iv)) {
            FirElement firElement;
            void this_$iv2;
            if (kid$iv == null) break;
            IElementType tokenType$iv = kid$iv.getTokenType();
            if (KtTokens.COMMENTS.contains(tokenType$iv) || Intrinsics.areEqual(tokenType$iv, KtTokens.WHITE_SPACE) || Intrinsics.areEqual(tokenType$iv, KtTokens.SEMICOLON) || ArraysKt.contains(skipTokens$iv, tokenType$iv)) continue;
            if (Intrinsics.areEqual(tokenType$iv, TokenType.ERROR_ELEMENT)) {
                BaseConverter.access$reportSyntaxError((BaseConverter)this_$iv, kid$iv);
                continue;
            }
            LighterASTNode it = kid$iv;
            boolean bl = false;
            IElementType iElementType = it.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_NAME)) {
                identifier = this.getAsText(it);
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtTokens.MUL)) {
                isSpread = true;
                continue;
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) {
                firExpression3 = this.convertStringTemplate(it);
                continue;
            }
            if (iElementType instanceof KtConstantExpressionElementType) {
                firExpression3 = this.convertConstantExpression(it);
                continue;
            }
            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
            ExpressionsConverter expressionsConverter = this;
            String errorReason$iv = "Argument is absent";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode it$iv = it;
            boolean bl2 = false;
            FirElement converted$iv = this_$iv2.convertExpression(it$iv, errorReason$iv);
            FirElement firElement2 = converted$iv;
            if (!(firElement2 instanceof FirExpression)) {
                firElement2 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression((KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv2, it, null, 1, null), new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            firExpression3 = firElement;
        }
        FirExpression firExpression4 = firExpression3;
        if (firExpression4 == null) {
            firExpression4 = FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSimpleDiagnostic("Argument is absent", DiagnosticKind.Syntax), null, 4, null);
        }
        FirExpression calculatedFirExpression = firExpression4;
        if (identifier != null) {
            boolean $i$f$buildNamedArgumentExpression = false;
            firAnnotationContainerBuilder = new FirNamedArgumentExpressionBuilder();
            FirNamedArgumentExpressionBuilder $this$convertValueArgument_u24lambda_u24122 = firAnnotationContainerBuilder;
            boolean bl = false;
            $this$convertValueArgument_u24lambda_u24122.setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            $this$convertValueArgument_u24lambda_u24122.setExpression(calculatedFirExpression);
            $this$convertValueArgument_u24lambda_u24122.setSpread(isSpread);
            $this$convertValueArgument_u24lambda_u24122.setName(ConverterUtilKt.nameAsSafeName$default(identifier, null, 1, null));
            firExpression2 = ((FirNamedArgumentExpressionBuilder)firAnnotationContainerBuilder).build();
        } else if (isSpread) {
            boolean $i$f$buildSpreadArgumentExpression = false;
            FirAnnotationContainerBuilder $this$convertValueArgument_u24lambda_u24123 = firAnnotationContainerBuilder = new FirSpreadArgumentExpressionBuilder();
            boolean bl = false;
            ((FirSpreadArgumentExpressionBuilder)$this$convertValueArgument_u24lambda_u24123).setSource(BaseFirBuilder.toFirSourceElement$default(this, valueArgument, null, 1, null));
            ((FirSpreadArgumentExpressionBuilder)$this$convertValueArgument_u24lambda_u24123).setExpression(calculatedFirExpression);
            firExpression2 = ((FirSpreadArgumentExpressionBuilder)firAnnotationContainerBuilder).build();
        } else {
            firExpression2 = calculatedFirExpression;
        }
        return firExpression2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void convertCallExpression$lambda$38$process(Ref.ObjectRef<String> name2, ExpressionsConverter this$0, Ref.ObjectRef<LighterASTNode> superNode, List<FirTypeProjection> firTypeArguments, Ref.BooleanRef hasArguments, List<LighterASTNode> valueArguments, Ref.ObjectRef<FirExpression> additionalArgument, LighterASTNode node) {
        IElementType iElementType = node.getTokenType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
            name2.element = this$0.getAsText(node);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_EXPRESSION)) {
            superNode.element = node;
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.PARENTHESIZED)) {
            Unit unit2;
            LighterASTNode lighterASTNode2 = this$0.getExpressionInParentheses(node);
            if (lighterASTNode2 != null) {
                LighterASTNode it = lighterASTNode2;
                boolean bl2 = false;
                ExpressionsConverter.convertCallExpression$lambda$38$process(name2, this$0, superNode, firTypeArguments, hasArguments, valueArguments, additionalArgument, it);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            if (unit2 == null) {
                FirElement firElement;
                FirElement converted$iv;
                FirElement firElement2;
                FirElement firElement3;
                void this_$iv;
                ExpressionsConverter $this$convertCallExpression_u24lambda_u2438_u24process_u24lambda_u2437 = this$0;
                boolean bl = false;
                ExpressionsConverter bl2 = $this$convertCallExpression_u24lambda_u2438_u24process_u24lambda_u2437;
                String errorReason$iv = "Incorrect invoke receiver";
                boolean $i$f$getAsFirExpression = false;
                LighterASTNode lighterASTNode3 = node;
                if (lighterASTNode3 != null) {
                    LighterASTNode it$iv = lighterASTNode3;
                    boolean bl3 = false;
                    firElement3 = this_$iv.convertExpression(it$iv, errorReason$iv);
                } else {
                    firElement3 = null;
                }
                if (!((firElement2 = (converted$iv = firElement3)) instanceof FirExpression)) {
                    firElement2 = null;
                }
                if ((firElement = (FirElement)((FirExpression)firElement2)) == null) {
                    FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(node != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, node, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                    if (firErrorExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                    }
                    firElement = firErrorExpression;
                }
                additionalArgument.element = firElement;
            }
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.TYPE_ARGUMENT_LIST)) {
            CollectionsKt.addAll((Collection)firTypeArguments, (Iterable)this$0.declarationsConverter.convertTypeArguments(node, true));
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.VALUE_ARGUMENT_LIST) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.LAMBDA_ARGUMENT)) {
            hasArguments.element = true;
            ((Collection)valueArguments).add(node);
        } else if (!Intrinsics.areEqual(node.getTokenType(), TokenType.ERROR_ELEMENT)) {
            FirElement firElement;
            FirElement converted$iv;
            FirElement firElement4;
            FirElement firElement5;
            void this_$iv;
            ExpressionsConverter expressionsConverter = this$0;
            String errorReason$iv = "Incorrect invoke receiver";
            boolean $i$f$getAsFirExpression = false;
            LighterASTNode lighterASTNode4 = node;
            if (lighterASTNode4 != null) {
                LighterASTNode it$iv = lighterASTNode4;
                boolean bl = false;
                firElement5 = this_$iv.convertExpression(it$iv, errorReason$iv);
            } else {
                firElement5 = null;
            }
            if (!((firElement4 = (converted$iv = firElement5)) instanceof FirExpression)) {
                firElement4 = null;
            }
            if ((firElement = (FirElement)((FirExpression)firElement4)) == null) {
                FirErrorExpression firErrorExpression = FirExpressionUtilKt.buildErrorExpression(node != null ? (KtLightSourceElement)BaseFirBuilder.toFirSourceElement$default((BaseFirBuilder)this_$iv, node, null, 1, null) : null, new ConeSimpleDiagnostic(errorReason$iv, DiagnosticKind.ExpressionExpected), converted$iv);
                if (firErrorExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirExpression");
                }
                firElement = firErrorExpression;
            }
            additionalArgument.element = firElement;
        }
    }

    public static final /* synthetic */ FirExpression access$convertShortOrLongStringTemplate(ExpressionsConverter $this, LighterASTNode $receiver, String errorReason) {
        return $this.convertShortOrLongStringTemplate($receiver, errorReason);
    }

    public static final /* synthetic */ FirBlock access$convertLoopBody(ExpressionsConverter $this, LighterASTNode body2) {
        return $this.convertLoopBody(body2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/converter/ExpressionsConverter$IfNodeComponents;", "", "firCondition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "thenBlock", "Lcom/intellij/lang/LighterASTNode;", "elseBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lcom/intellij/lang/LighterASTNode;Lcom/intellij/lang/LighterASTNode;)V", "getElseBlock", "()Lcom/intellij/lang/LighterASTNode;", "getFirCondition", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getThenBlock", "light-tree2fir"})
    private static final class IfNodeComponents {
        @Nullable
        private final FirExpression firCondition;
        @Nullable
        private final LighterASTNode thenBlock;
        @Nullable
        private final LighterASTNode elseBlock;

        public IfNodeComponents(@Nullable FirExpression firCondition, @Nullable LighterASTNode thenBlock, @Nullable LighterASTNode elseBlock) {
            this.firCondition = firCondition;
            this.thenBlock = thenBlock;
            this.elseBlock = elseBlock;
        }

        @Nullable
        public final FirExpression getFirCondition() {
            return this.firCondition;
        }

        @Nullable
        public final LighterASTNode getThenBlock() {
            return this.thenBlock;
        }

        @Nullable
        public final LighterASTNode getElseBlock() {
            return this.elseBlock;
        }
    }
}

