/*! For license information please see bookmarks-src_components_ViewPrivate_vue.js.LICENSE.txt */
"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_ViewPrivate_vue"],{39282:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.copy-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n","",{version:3,sources:["webpack://./src/components/CopyDialog.vue"],names:[],mappings:";AAuDA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021 Artem Lavrukhin <lavryha4590@gmail.com>\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"showNcModal\" :title=\"title\" @close=\"onClose\">\n\t\t<div class=\"copy-dialog\">\n\t\t\t<FolderPicker :title=\"title\" :filter=\"filterFolders\" @submit=\"onSubmit\" />\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport FolderPicker from './FolderPicker.vue'\n\nexport default {\n\tname: 'CopyDialog',\n\tcomponents: {\n\t\tFolderPicker,\n\t\tNcModal,\n\t},\n\tcomputed: {\n\t\tshowNcModal() {\n\t\t\treturn this.$store.state.displayCopyDialog\n\t\t},\n\t\tselection() {\n\t\t\treturn this.$store.state.selection\n\t\t},\n\t\ttitle() {\n\t\t\treturn n('bookmarks',\n\t\t\t\t'Adding %n bookmark to new folder',\n\t\t\t\t'Adding %n bookmarks to new folder',\n\t\t\t\tthis.selection.bookmarks.length\n\t\t\t)\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSubmit(folderId) {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, false)\n\t\t\tawait this.$store.dispatch(actions.NcNcModal, folderId)\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, false)\n\t\t},\n\t\tfilterFolders(child) {\n\t\t\treturn !this.selection.folders.some(folder => folder.id === child.id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.copy-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},4227:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.app-content-list {\n\tpadding: 5px;\n\tpadding-top: 45px;\n\toverflow-y: scroll;\n\theight: calc(100vh - 50px);\n}\n","",{version:3,sources:["webpack://./src/components/FolderOverview.vue"],names:[],mappings:";AA+CA;CACA,YAAA;CACA,iBAAA;CACA,kBAAA;CACA,0BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppContentList :show-details=\"showDetails\" @update:show-details=\"$emit('update:show-details', $event)\">\n\t\t<TreeFolder v-for=\"folder in rootFolder.children\"\n\t\t\t:key=\"folder.id\"\n\t\t\t:folder=\"folder\"\n\t\t\t@select=\"onSelect($event)\" />\n\t</NcAppContentList>\n</template>\n\n<script>\nimport { NcAppContentList } from '@nextcloud/vue'\nimport TreeFolder from './TreeFolder.vue'\nimport { privateRoutes } from '../router.js'\n\nexport default {\n\tname: 'FolderOverview',\n\tcomponents: {\n\t\tTreeFolder,\n\t\tNcAppContentList,\n\t},\n\tprops: {\n\t\tshowDetails: {\n\t\t\ttype: Boolean,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tcomputed: {\n\t\trootFolder() {\n\t\t\treturn this.$store.getters.getFolder(-1)[0]\n\t\t},\n\t},\n\tmethods: {\n\t\tonSelect(folder) {\n\t\t\tthis.$router.push({ name: privateRoutes.FOLDER, params: { folder } })\n\t\t\tthis.$emit('update:show-details', true)\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.app-content-list {\n\tpadding: 5px;\n\tpadding-top: 45px;\n\toverflow-y: scroll;\n\theight: calc(100vh - 50px);\n}\n</style>\n"],sourceRoot:""}]);const s=a},97054:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.loading[data-v-81e688b4] {\n\tmin-width: 300px;\n\theight: 200px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n\ttext-align: center;\n}\n","",{version:3,sources:["webpack://./src/components/LoadingModal.vue"],names:[],mappings:";AAwDA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;CACA,kBAAA;AACA",sourcesContent:["<template>\n\t<NcModal v-if=\"showNcModal\" :can-close=\"false\">\n\t\t<div class=\"loading icon-loading\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\n\nexport default {\n\tname: 'LoadingModal',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tstates: {\n\t\t\t\tdeleteBookmarks: this.t('bookmarks', 'Deleting bookmarks'),\n\t\t\t\tdeleteSelection: this.t('bookmarks', 'Deleting selection'),\n\t\t\t\timportBookmarks: this.t('bookmarks', 'Importing bookmarks'),\n\t\t\t\tmoveSelection: this.t('bookmkarks', 'Moving selection'),\n\t\t\t\tcopySelection: this.t('bookmkarks', 'Adding selection to folders'),\n\t\t\t},\n\t\t\tshowNcModal: false,\n\t\t\tshowTimeout: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tstate() {\n\t\t\treturn Object.keys(this.states).find(state => this.$store.state.loading[state])\n\t\t},\n\t\ttitle() {\n\t\t\tconst state = this.state\n\t\t\tif (state) {\n\t\t\t\treturn this.states[state]\n\t\t\t} else {\n\t\t\t\treturn ''\n\t\t\t}\n\t\t},\n\t},\n\twatch: {\n\t\tstate(newState, previous) {\n\t\t\tif (this.state && !previous) {\n\t\t\t\tthis.showTimeout = setTimeout(() => {\n\t\t\t\t\tthis.showNcModal = true\n\t\t\t\t}, 500)\n\t\t\t} else if (!this.state && previous) {\n\t\t\t\tclearTimeout(this.showTimeout)\n\t\t\t\tthis.showNcModal = false\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.loading {\n\tmin-width: 300px;\n\theight: 200px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n\ttext-align: center;\n}\n</style>\n"],sourceRoot:""}]);const s=a},94055:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.move-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n","",{version:3,sources:["webpack://./src/components/MoveDialog.vue"],names:[],mappings:";AAuEA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"showNcModal\" :title=\"title\" @close=\"onClose\">\n\t\t<div class=\"move-dialog\">\n\t\t\t<FolderPicker :title=\"title\" :filter=\"filterFolders\" @submit=\"onSubmit\" />\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport FolderPicker from './FolderPicker.vue'\n\nexport default {\n\tname: 'MoveDialog',\n\tcomponents: {\n\t\tFolderPicker,\n\t\tNcModal,\n\t},\n\tcomputed: {\n\t\tshowNcModal() {\n\t\t\treturn this.$store.state.displayMoveDialog\n\t\t},\n\t\tselection() {\n\t\t\treturn this.$store.state.selection\n\t\t},\n\t\ttitle() {\n\t\t\tif (this.selection.folders.length) {\n\t\t\t\tif (this.selection.bookmarks.length) {\n\t\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t\t'Moving %n folder and some bookmarks',\n\t\t\t\t\t\t'Moving %n folders and some bookmarks',\n\t\t\t\t\t\tthis.selection.folders.length\n\t\t\t\t\t)\n\t\t\t\t} else {\n\t\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t\t'Moving %n folder',\n\t\t\t\t\t\t'Moving %n folders',\n\t\t\t\t\t\tthis.selection.folders.length\n\t\t\t\t\t)\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\treturn n('bookmarks',\n\t\t\t\t\t'Moving %n bookmark',\n\t\t\t\t\t'Moving %n bookmarks',\n\t\t\t\t\tthis.selection.bookmarks.length\n\t\t\t\t)\n\t\t\t}\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onSubmit(folderId) {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, false)\n\t\t\tawait this.$store.dispatch(actions.MOVE_SELECTION, folderId)\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, false)\n\t\t},\n\t\tfilterFolders(child) {\n\t\t\treturn !this.selection.folders.some(folder => folder.id === child.id)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.move-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 20px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},7727:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.navigation .dropTarget--available {\n\tbackground: var(--color-primary-light);\n}\n.navigation .dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n","",{version:3,sources:["webpack://./src/components/Navigation.vue"],names:[],mappings:";AA4NA;CACA,sCAAA;AACA;AAEA;CACA,8CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppNavigation class="navigation">\n\t\t<template #list>\n\t\t\t<NcAppNavigationItem key="menu-home"\n\t\t\t\t:to="{ name: routes.HOME }"\n\t\t\t\t:title="t(\'bookmarks\', \'All bookmarks\')"\n\t\t\t\t:exact="true">\n\t\t\t\t<HomeIcon slot="icon" />\n\t\t\t\t<NcAppNavigationCounter slot="counter">\n\t\t\t\t\t{{ allBookmarksCount | largeNumbers }}\n\t\t\t\t</NcAppNavigationCounter>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-recent"\n\t\t\t\t:to="{ name: routes.RECENT }"\n\t\t\t\t:title="t(\'bookmarks\', \'Recent\')">\n\t\t\t\t<HistoryIcon slot="icon" />\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-shared-folders"\n\t\t\t\t:to="{ name: routes.SHARED_FOLDERS }"\n\t\t\t\t:title="t(\'bookmarks\', \'Shared with you\')">\n\t\t\t\t<ShareVariantIcon slot="icon" />\n\t\t\t\t<NcAppNavigationCounter v-show="Boolean(sharedFoldersCount)" slot="counter">\n\t\t\t\t\t{{ sharedFoldersCount | largeNumbers }}\n\t\t\t\t</NcAppNavigationCounter>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-archived"\n\t\t\t\t:to="{ name: routes.ARCHIVED }"\n\t\t\t\t:title="t(\'bookmarks\', \'Files\')">\n\t\t\t\t<FileDocumentMultipleIcon slot="icon" />\n\t\t\t\t<NcAppNavigationCounter v-show="Boolean(archivedBookmarksCount)" slot="counter">\n\t\t\t\t\t{{ archivedBookmarksCount }}\n\t\t\t\t</NcAppNavigationCounter>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-duplicated"\n\t\t\t\t:to="{ name: routes.DUPLICATED }"\n\t\t\t\t:title="t(\'bookmarks\', \'Duplicates\')">\n\t\t\t\t<VectorLinkIcon slot="icon" />\n\t\t\t\t<NcAppNavigationCounter v-show="Boolean(duplicatedBookmarksCount)" slot="counter">\n\t\t\t\t\t{{ duplicatedBookmarksCount | largeNumbers }}\n\t\t\t\t</NcAppNavigationCounter>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationItem key="menu-unavailable"\n\t\t\t\t:to="{ name: routes.UNAVAILABLE }"\n\t\t\t\t:title="t(\'bookmarks\', \'Broken links\')">\n\t\t\t\t<LinkVariantOffIcon slot="icon" />\n\t\t\t\t<NcAppNavigationCounter v-show="Boolean(unavailableBookmarksCount)" slot="counter">\n\t\t\t\t\t{{ unavailableBookmarksCount | largeNumbers }}\n\t\t\t\t</NcAppNavigationCounter>\n\t\t\t</NcAppNavigationItem>\n\t\t\t<NcAppNavigationSpacer />\n\t\t\t<NcAppNavigationNewItem key="menu-new-tag"\n\t\t\t\t:title="t(\'bookmarks\', \'New tag\')"\n\t\t\t\t@new-item="onNewTag">\n\t\t\t\t<TagPlusIcon slot="icon" />\n\t\t\t</NcAppNavigationNewItem>\n\t\t\t<template v-if="Boolean(tags.length)">\n\t\t\t\t<NcAppNavigationItem key="menu-tags"\n\t\t\t\t\t:title="t(\'bookmarks\', \'Search tags\')"\n\t\t\t\t\t@click="onSearchTags">\n\t\t\t\t\t<TagMultipleIcon slot="icon" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t\t<NcAppNavigationItem v-for="tag in tags"\n\t\t\t\t\t:key="\'tag-\'+tag.name"\n\t\t\t\t\tv-drop-target="{allow: (e) => allowDropOnTag(tag.name, e), drop: (e) => onDropOnTag(tag.name, e)}"\n\t\t\t\t\t:to="tag.route"\n\t\t\t\t\t:force-menu="true"\n\t\t\t\t\t:edit-label="t(\'bookmarks\', \'Rename\')"\n\t\t\t\t\t:editable="!isPublic"\n\t\t\t\t\t:title="tag.name"\n\t\t\t\t\t@update:title="onRenameTag(tag.name, $event)">\n\t\t\t\t\t<TagIcon slot="icon" />\n\t\t\t\t\t<NcAppNavigationCounter slot="counter">\n\t\t\t\t\t\t{{ tag.count | largeNumbers }}\n\t\t\t\t\t</NcAppNavigationCounter>\n\t\t\t\t\t<template v-if="!isPublic" slot="actions">\n\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onDeleteTag(tag.name)">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<DeleteIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Delete\') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</template>\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t\t<NcAppNavigationItem key="menu-untagged"\n\t\t\t\t\t:to="{ name: routes.UNTAGGED }"\n\t\t\t\t\t:title="t(\'bookmarks\', \'Untagged\')">\n\t\t\t\t\t<TagOffIcon slot="icon" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t</template>\n\t\t\t<template v-if="Number(bookmarksLimit) > 0">\n\t\t\t\t<NcAppNavigationSpacer />\n\t\t\t\t<NcAppNavigationItem :pinned="true" :title="t(\'bookmarks\', \'{used} bookmarks of {available} available\', {used: allBookmarksCount, available: bookmarksLimit})">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<GaugeIcon />\n\t\t\t\t\t</template>\n\t\t\t\t\t<ProgressBar :val="allBookmarksCount" :max="bookmarksLimit" />\n\t\t\t\t</NcAppNavigationItem>\n\t\t\t</template>\n\t\t</template>\n\t\t<template #footer>\n\t\t\t<NcAppNavigationSettings v-if="!isPublic">\n\t\t\t\t<Settings />\n\t\t\t</NcAppNavigationSettings>\n\t\t</template>\n\t</NcAppNavigation>\n</template>\n\n<script>\nimport { NcActionButton, NcAppNavigation, NcAppNavigationItem, NcAppNavigationNewItem, NcAppNavigationCounter, NcAppNavigationSettings, NcAppNavigationSpacer } from \'@nextcloud/vue\'\nimport HomeIcon from \'vue-material-design-icons/Home.vue\'\nimport HistoryIcon from \'vue-material-design-icons/History.vue\'\nimport TagOffIcon from \'vue-material-design-icons/TagOff.vue\'\nimport LinkVariantOffIcon from \'vue-material-design-icons/LinkVariantOff.vue\'\nimport ShareVariantIcon from \'vue-material-design-icons/ShareVariant.vue\'\nimport FileDocumentMultipleIcon from \'vue-material-design-icons/FileDocumentMultiple.vue\'\nimport TagPlusIcon from \'vue-material-design-icons/TagPlus.vue\'\nimport TagMultipleIcon from \'vue-material-design-icons/TagMultiple.vue\'\nimport VectorLinkIcon from \'vue-material-design-icons/VectorLink.vue\'\nimport TagIcon from \'vue-material-design-icons/Tag.vue\'\nimport DeleteIcon from \'vue-material-design-icons/Delete.vue\'\nimport GaugeIcon from \'vue-material-design-icons/Gauge.vue\'\nimport ProgressBar from \'vue-simple-progress\'\nimport Settings from \'./Settings.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'Navigation\',\n\tcomponents: {\n\t\tNcAppNavigation,\n\t\tNcAppNavigationItem,\n\t\tNcAppNavigationNewItem,\n\t\tNcAppNavigationCounter,\n\t\tNcAppNavigationSettings,\n\t\tNcAppNavigationSpacer,\n\t\tNcActionButton,\n\t\tSettings,\n\t\tProgressBar,\n\t\tHistoryIcon,\n\t\tTagOffIcon,\n\t\tLinkVariantOffIcon,\n\t\tTagPlusIcon,\n\t\tTagMultipleIcon,\n\t\tFileDocumentMultipleIcon,\n\t\tShareVariantIcon,\n\t\tVectorLinkIcon,\n\t\tHomeIcon,\n\t\tTagIcon,\n\t\tDeleteIcon,\n\t\tGaugeIcon,\n\t},\n\n\tfilters: {\n\t\tlargeNumbers(num) {\n\t\t\treturn num >= 1000 ? (Math.round(num / 100) / 10) + \'K\' : num\n\t\t},\n\t},\n\tdata() {\n\t\treturn {}\n\t},\n\tcomputed: {\n\t\ttags() {\n\t\t\treturn this.$store.state.tags.map(tag => ({\n\t\t\t\troute: { name: this.routes.TAGS, params: { tags: tag.name } },\n\t\t\t\tname: tag.name,\n\t\t\t\tcount: tag.count,\n\t\t\t}))\n\t\t},\n\t\tallBookmarksCount() {\n\t\t\treturn this.$store.state.countsByFolder[-1]\n\t\t},\n\t\tunavailableBookmarksCount() {\n\t\t\treturn this.$store.state.unavailableCount\n\t\t},\n\t\tsharedFoldersCount() {\n\t\t\treturn Object.keys(this.$store.state.sharedFoldersById).length\n\t\t},\n\t\tarchivedBookmarksCount() {\n\t\t\treturn this.$store.state.archivedCount\n\t\t},\n\t\tduplicatedBookmarksCount() {\n\t\t\treturn this.$store.state.duplicatedCount\n\t\t},\n\t\tbookmarksLimit() {\n\t\t\treturn this.$store.state.settings.limit\n\t\t},\n\t},\n\n\tcreated() {\n\t},\n\n\tmethods: {\n\t\tonSearchTags() {\n\t\t\tthis.$router.push({ name: this.routes.TAGS })\n\t\t},\n\t\tonDeleteTag(tag) {\n\t\t\tthis.$store.dispatch(actions.DELETE_TAG, tag)\n\t\t},\n\t\tonRenameTag(oldName, newName) {\n\t\t\tthis.$store.dispatch(actions.RENAME_TAG, { oldName, newName })\n\t\t},\n\t\tonNewTag(tagName) {\n\t\t\tthis.$store.commit(mutations.ADD_TAG, tagName)\n\t\t},\n\t\tallowDropOnTag(tagName) {\n\t\t\treturn !this.$store.state.selection.folders.length && this.$store.state.selection.bookmarks.length\n\t\t},\n\t\tonDropOnTag(tagName) {\n\t\t\tthis.$store.dispatch(actions.TAG_SELECTION, { tags: [tagName], originalTags: [] })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\n.navigation .dropTarget--available {\n\tbackground: var(--color-primary-light);\n}\n\n.navigation .dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n</style>\n'],sourceRoot:""}]);const s=a},71758:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n.settings label,\n.settings input,\n.settings select,\n.settings button,\n.settings label a.button {\n\tdisplay: block;\n\twidth: 100%;\n}\n.settings input[type=checkbox] {\n\tdisplay: inline-block;\n\tposition: relative;\n\ttop: 0.5em;\n\twidth: 1.2em;\n}\n.settings label {\n\tmargin-top: 10px;\n}\n.settings h3 {\n\tfont-weight: bold;\n}\n.settings a:link:not(.button) {\n\ttext-decoration: underline;\n}\n","",{version:3,sources:["webpack://./src/components/Settings.vue"],names:[],mappings:";AA4LA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,aAAA;AACA;AAEA;;;;;CAKA,cAAA;CACA,WAAA;AACA;AAEA;CACA,qBAAA;CACA,kBAAA;CACA,UAAA;CACA,YAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,0BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"settings\">\n\t\t<input type=\"file\"\n\t\t\tclass=\"import\"\n\t\t\tsize=\"5\"\n\t\t\t@change=\"onImportSubmit\">\n\t\t<button @click=\"onImportOpen\">\n\t\t\t<span :class=\"{'icon-upload': !importing, 'icon-loading-small': importing}\" />{{ t('bookmarks', 'Import') }}\n\t\t</button>\n\t\t<button @click=\"onExport\">\n\t\t\t<span class=\"icon-download\" /> {{ t('bookmarks', 'Export') }}\n\t\t</button>\n\n\t\t<label><h3>{{ t('bookmarks', 'Archive path') }}</h3>\n\t\t\t<p>{{ t('bookmarks',\n\t\t\t\t'Enter the path of a folder in your Files where bookmarked files should be stored.'\n\t\t\t) }}</p>\n\t\t\t<input :value=\"archivePath\"\n\t\t\t\t:readonly=\"true\"\n\t\t\t\t@click=\"onChangeArchivePath\">\n\t\t</label>\n\n\t\t<label><h3>{{ t('bookmarks', 'Backups') }}</h3>\n\t\t\t<p><label><input type=\"checkbox\" :checked=\"backupEnabled\" @input=\"onChangeBackupEnabled\">{{ t('bookmarks', 'Enable bookmarks backups') }}</label></p>\n\t\t\t<p>{{ t('bookmarks',\n\t\t\t\t'Enter the path of a folder in your Files where backups will be stored.'\n\t\t\t) }}</p>\n\t\t\t<input :value=\"backupPath\"\n\t\t\t\t:readonly=\"true\"\n\t\t\t\t@click=\"onChangeBackupPath\">\n\t\t</label>\n\n\t\t<h3>{{ t('bookmarks', 'Client apps') }}</h3>\n\t\t<p>\n\t\t\t{{\n\t\t\t\tt('bookmarks',\n\t\t\t\t\t'Also check out the collection of client apps that integrate with this app: '\n\t\t\t\t)\n\t\t\t}}\n\t\t\t<a href=\"https://github.com/nextcloud/bookmarks#third-party-clients\">{{\n\t\t\t\tt('bookmarks', 'Client apps')\n\t\t\t}}</a>\n\t\t</p>\n\n\t\t<label>\n\t\t\t<h3>{{ t('bookmarks', 'Install web app on device') }}</h3>\n\t\t\t<p>{{ t('bookmarks', 'You can install this app on your device home screen to quickly access your bookmarks on your phone. You can easily remove the app from your home screen again, if you don\\'t like it.') }}</p>\n\t\t\t<a class=\"button center\" href=\"#\" @click.prevent=\"clickAddToHomeScreen\">{{ t('bookmarks', 'Install on home screen') }}</a>\n\t\t</label>\n\n\t\t<label><h3>{{ t('bookmarks', 'Bookmarklet') }}</h3>\n\t\t\t<p>{{ t('bookmarks',\n\t\t\t\t'Drag this to your browser bookmarks and click it to quickly bookmark a webpage.'\n\t\t\t) }}</p>\n\t\t\t<a class=\"button center\"\n\t\t\t\t:href=\"bookmarklet\"\n\t\t\t\t@click.prevent=\"void 0\">{{\n\t\t\t\t\tt('bookmarks', 'Add to {instanceName}', {\n\t\t\t\t\t\tinstanceName: oc_defaults.name\n\t\t\t\t\t})\n\t\t\t\t}}</a>\n\t\t</label>\n\t</div>\n</template>\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { actions } from '../store/index.js'\nimport { getRequestToken } from '@nextcloud/auth'\nimport { getFilePickerBuilder } from '@nextcloud/dialogs'\n\nexport default {\n\tname: 'Settings',\n\tcomponents: {},\n\tdata() {\n\t\treturn {\n\t\t\timporting: false,\n\t\t\tdeleting: false,\n\t\t\taddToHomeScreen: null,\n\t\t\tarchivePathPicker: getFilePickerBuilder(this.t('bookmarks', 'Archive path'))\n\t\t\t\t.allowDirectories(true)\n\t\t\t\t.setModal(true)\n\t\t\t\t.setType(1)// CHOOSE\n\t\t\t\t.setMultiSelect(false)\n\t\t\t\t.build(),\n\t\t\tbackupPathPicker: getFilePickerBuilder(this.t('bookmarks', 'Backup path'))\n\t\t\t\t.allowDirectories(true)\n\t\t\t\t.setModal(true)\n\t\t\t\t.setType(1)// CHOOSE\n\t\t\t\t.setMultiSelect(false)\n\t\t\t\t.build(),\n\t\t}\n\t},\n\tcomputed: {\n\t\toc_defaults() {\n\t\t\treturn window.oc_defaults\n\t\t},\n\t\tbookmarklet() {\n\t\t\tconst bookmarkletUrl\n\t\t\t\t\t= window.location.origin + generateUrl('/apps/bookmarks/bookmarklet')\n\t\t\treturn `javascript:(function(){var a=window,b=document,c=encodeURIComponent,e=c(document.title),d=a.open('${bookmarkletUrl}?url='+c(b.location)+'&title='+e,'bkmk_popup','left='+((a.screenX||a.screenLeft)+10)+',top='+((a.screenY||a.screenTop)+10)+',height=650px,width=550px,resizable=1,alwaysRaised=1');a.setTimeout(function(){d.focus()},300);})();`\n\t\t},\n\t\tarchivePath() {\n\t\t\treturn this.$store.state.settings.archivePath\n\t\t},\n\t\tbackupPath() {\n\t\t\treturn this.$store.state.settings.backupPath\n\t\t},\n\t\tbackupEnabled() {\n\t\t\treturn Boolean(this.$store.state.settings.backupEnabled)\n\t\t},\n\t},\n\tmounted() {\n\t\twindow.addEventListener('beforeinstallprompt', (e) => {\n\t\t\t// Prevent Chrome 67 and earlier from automatically showing the prompt\n\t\t\te.preventDefault()\n\t\t\t// Stash the event so it can be triggered later.\n\t\t\tthis.addToHomeScreen = e\n\t\t\tthis.showAddToHomeScreen = true\n\t\t})\n\t},\n\tmethods: {\n\t\tonImportOpen(e) {\n\t\t\te.target.previousElementSibling.click()\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t\tonExport() {\n\t\t\twindow.location\n\t\t\t\t= 'bookmark/export?requesttoken='\n\t\t\t\t\t+ encodeURIComponent(getRequestToken())\n\t\t},\n\t\tasync onChangeArchivePath(e) {\n\t\t\tconst path = await this.archivePathPicker.pick()\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'archivePath',\n\t\t\t\tvalue: path,\n\t\t\t})\n\t\t},\n\t\tasync onChangeBackupPath(e) {\n\t\t\tif (!this.backupEnabled) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst path = await this.backupPathPicker.pick()\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'backupPath',\n\t\t\t\tvalue: path,\n\t\t\t})\n\t\t},\n\t\tasync onChangeBackupEnabled(e) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'backupEnabled',\n\t\t\t\tvalue: !this.backupEnabled,\n\t\t\t})\n\t\t},\n\t\tclickAddToHomeScreen() {\n\t\t\tif (!this.addToHomeScreen) {\n\t\t\t\talert(this.t('bookmarks', 'Please select \"Add to home screen\" in your browser menu'))\n\t\t\t\treturn\n\t\t\t}\n\t\t\t// Show the prompt\n\t\t\tthis.addToHomeScreen.prompt()\n\t\t\t// Wait for the user to respond to the prompt\n\t\t\tthis.addToHomeScreen.userChoice.then((choiceResult) => {\n\t\t\t\tif (choiceResult.outcome === 'accepted') {\n\t\t\t\t\tconsole.warn('User accepted the A2HS prompt')\n\t\t\t\t} else {\n\t\t\t\t\tconsole.warn('User dismissed the A2HS prompt')\n\t\t\t\t}\n\t\t\t\tthis.addToHomeScreen = null\n\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tleft: -1000px;\n}\n\n.settings label,\n.settings input,\n.settings select,\n.settings button,\n.settings label a.button {\n\tdisplay: block;\n\twidth: 100%;\n}\n\n.settings input[type=checkbox] {\n\tdisplay: inline-block;\n\tposition: relative;\n\ttop: 0.5em;\n\twidth: 1.2em;\n}\n\n.settings label {\n\tmargin-top: 10px;\n}\n\n.settings h3 {\n\tfont-weight: bold;\n}\n\n.settings a:link:not(.button) {\n\ttext-decoration: underline;\n}\n</style>\n"],sourceRoot:""}]);const s=a},36599:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.sidebar h3 {\n\tmargin-top: 20px;\n}\n.sidebar .tags {\n\twidth: 100%;\n}\n.sidebar .notes {\n\tflex-grow: 1;\n\tmin-height: 80px;\n}\n.sidebar .details__line {\n\tdisplay: flex;\n\talign-items: flex-start;\n\tmargin-bottom: 10px;\n}\n.sidebar .details__line > * {\n\tflex-grow: 0;\n}\n.sidebar .details__line > :nth-child(2) {\n\tflex-grow: 1;\n}\n.sidebar .details__line .notes {\n\tflex-grow: 1;\n}\n.sidebar .details__url {\n\tflex-grow: 1;\n\tpadding: 8px 0;\n\ttext-overflow: ellipsis;\n\theight: 2em;\n\tdisplay: inline-block;\n\toverflow: hidden;\n}\n.sidebar .details__action {\n\tflex-grow: 0;\n}\n.sidebar .folders {\n\tdisplay: flex;\n\talign-items: flex-start;\n}\n.sidebar .folders__folder {\n\tborder: 1px solid var(--color-border);\n\tpadding: 2px 10px;\n\tborder-radius: var(--border-radius-large);\n\tmargin-right: 5px;\n\tcursor: pointer;\n\tdisplay: flex;\n}\n.sidebar .folders__folder * {\n\tcursor: pointer;\n}\n","",{version:3,sources:["webpack://./src/components/SidebarBookmark.vue"],names:[],mappings:";AAoSA;CACA,gBAAA;AACA;AAEA;CACA,WAAA;AACA;AAEA;CACA,YAAA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;CACA,uBAAA;CACA,mBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,YAAA;CACA,cAAA;CACA,uBAAA;CACA,WAAA;CACA,qBAAA;CACA,gBAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,uBAAA;AACA;AAEA;CACA,qCAAA;CACA,iBAAA;CACA,yCAAA;CACA,iBAAA;CACA,eAAA;CACA,aAAA;AACA;AAEA;CACA,eAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppSidebar v-if="isActive"\n\t\tclass="sidebar"\n\t\t:title="bookmark.title"\n\t\t:title-editable="editingTitle"\n\t\t:title-placeholder="t(\'bookmarks\', \'Title\')"\n\t\t:subtitle="addedDate"\n\t\t:background="background"\n\t\t@update:active="activeTab = $event"\n\t\t@update:title="onEditTitleUpdate"\n\t\t@submit-title="onEditTitleSubmit"\n\t\t@dismiss-editing="onEditTitleCancel"\n\t\t@close="onClose">\n\t\t<template v-if="!editingTitle" slot="secondary-actions">\n\t\t\t<NcActionButton @click="onEditTitle">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PencilIcon />\n\t\t\t\t</template>\n\t\t\t</NcActionButton>\n\t\t</template>\n\t\t<template v-if="editingTitle" slot="secondary-actions">\n\t\t\t<NcActionButton @click="onEditTitleCancel">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<CloseIcon />\n\t\t\t\t</template>\n\t\t\t</NcActionButton>\n\t\t</template>\n\t\t<NcAppSidebarTab id="bookmark-details"\n\t\t\t:name="t(\'bookmarks\', \'Details\')"\n\t\t\t:order="0">\n\t\t\t<template #icon>\n\t\t\t\t<InformationVariantIcon />\n\t\t\t</template>\n\t\t\t<div>\n\t\t\t\t<div v-if="!editingUrl" class="details__line">\n\t\t\t\t\t<OpenInNewIcon :aria-label="t(\'bookmarks\', \'Link\')" :title="t(\'bookmarks\', \'Link\')" />\n\t\t\t\t\t<a class="details__url" :href="bookmark.url">{{ bookmark.url }}</a>\n\t\t\t\t\t<NcActions v-if="isEditable" class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditUrl">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<PencilIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t\t<div v-else class="details__line">\n\t\t\t\t\t<OpenInNewIcon :aria-label="t(\'bookmarks\', \'Link\')" :title="t(\'bookmarks\', \'Link\')" />\n\t\t\t\t\t<input v-model="url" class="details__url">\n\t\t\t\t\t<NcActions class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditUrlSubmit">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<ArrowRightIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t\t<NcActions class="details__action">\n\t\t\t\t\t\t<NcActionButton @click="onEditUrlCancel">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<CloseIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<FolderIcon />\n\t\t\t\t\t<div class="folders">\n\t\t\t\t\t\t<span v-for="folderId in bookmark.folders"\n\t\t\t\t\t\t\t:key="folderId"\n\t\t\t\t\t\t\tv-tooltip="getFolderPath(folderId)"\n\t\t\t\t\t\t\tclass="folders__folder"\n\t\t\t\t\t\t\t@click="onOpenFolder(folderId)">\n\t\t\t\t\t\t\t<FolderIcon /> {{ getFolder(folderId).title || (getFolder(folderId).parent_folder ? t(\'bookmarks\', \'Untitled folder\') : t(\'bookmarks\', \'Root folder\')) }}\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<TagIcon :aria-label="t(\'bookmarks\', \'Tags\')" :title="t(\'bookmarks\', \'Tags\')" />\n\t\t\t\t\t<NcMultiselect class="tags"\n\t\t\t\t\t\t:value="tags"\n\t\t\t\t\t\t:auto-limit="false"\n\t\t\t\t\t\t:limit="7"\n\t\t\t\t\t\t:options="allTags"\n\t\t\t\t\t\t:multiple="true"\n\t\t\t\t\t\t:taggable="true"\n\t\t\t\t\t\topen-direction="below"\n\t\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Select tags and create new ones\')"\n\t\t\t\t\t\t:disabled="!isEditable"\n\t\t\t\t\t\t@input="onTagsChange"\n\t\t\t\t\t\t@tag="onAddTag" />\n\t\t\t\t</div>\n\t\t\t\t<div class="details__line">\n\t\t\t\t\t<PencilBoxIcon role="figure"\n\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Notes\')"\n\t\t\t\t\t\t:title="t(\'bookmarks\', \'Notes\')" />\n\t\t\t\t\t<NcRichContenteditable :value.sync="bookmark.description"\n\t\t\t\t\t\t:contenteditable="isEditable"\n\t\t\t\t\t\t:auto-complete="() => {}"\n\t\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Notes for this bookmark …\')"\n\t\t\t\t\t\t:multiline="true"\n\t\t\t\t\t\tclass="notes"\n\t\t\t\t\t\t@update:value="onNotesChange" />\n\t\t\t\t</div>\n\t\t\t\t<div v-if="archivedFile" class="details__line">\n\t\t\t\t\t<FileDocumentIcon role="figure"\n\t\t\t\t\t\t:aria-label="t(\'bookmarks\', \'Archived file\')"\n\t\t\t\t\t\t:title="t(\'bookmarks\', \'Archived file\')" />\n\t\t\t\t\t<NcButton :href="archivedFileUrl" target="_blank" type="primary">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<DownloadIcon :size="18" :fill-color="colorMainText" />\n\t\t\t\t\t\t</template>{{ t(\'bookmarks\', \'Download file\') }}\n\t\t\t\t\t</NcButton>\n\t\t\t\t\t<NcButton :href="archivedFile" target="_blank">\n\t\t\t\t\t\t{{ t(\'bookmarks\', \'Open file location\') }}\n\t\t\t\t\t</NcButton>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</NcAppSidebarTab>\n\t</NcAppSidebar>\n</template>\n<script>\nimport { NcAppSidebar, NcRichContenteditable, NcActionButton, NcActions, NcMultiselect, NcAppSidebarTab, NcButton } from \'@nextcloud/vue\'\nimport FileDocumentIcon from \'vue-material-design-icons/FileDocument.vue\'\nimport FolderIcon from \'vue-material-design-icons/Folder.vue\'\nimport InformationVariantIcon from \'vue-material-design-icons/InformationVariant.vue\'\nimport PencilIcon from \'vue-material-design-icons/Pencil.vue\'\nimport ArrowRightIcon from \'vue-material-design-icons/ArrowRight.vue\'\nimport TagIcon from \'vue-material-design-icons/Tag.vue\'\nimport OpenInNewIcon from \'vue-material-design-icons/OpenInNew.vue\'\nimport CloseIcon from \'vue-material-design-icons/Close.vue\'\nimport PencilBoxIcon from \'vue-material-design-icons/PencilBox.vue\'\nimport DownloadIcon from \'vue-material-design-icons/Download.vue\'\n\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport { generateRemoteUrl, generateUrl } from \'@nextcloud/router\'\nimport humanizeDuration from \'humanize-duration\'\nimport { actions, mutations } from \'../store/index.js\'\n\nconst MAX_RELATIVE_DATE = 1000 * 60 * 60 * 24 * 7 // one week\n\nexport default {\n\tname: \'SidebarBookmark\',\n\tcomponents: { NcAppSidebar, NcAppSidebarTab, NcMultiselect, NcActions, NcActionButton, NcRichContenteditable, FileDocumentIcon, FolderIcon, InformationVariantIcon, PencilIcon, ArrowRightIcon, TagIcon, OpenInNewIcon, CloseIcon, PencilBoxIcon, DownloadIcon, NcButton },\n\tdata() {\n\t\treturn {\n\t\t\ttitle: \'\',\n\t\t\teditingTitle: false,\n\t\t\turl: \'\',\n\t\t\teditingUrl: false,\n\t\t\tactiveTab: \'\',\n\t\t\tshowContentModal: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === \'bookmark\'\n\t\t},\n\t\tbookmark() {\n\t\t\tif (!this.isActive) return\n\t\t\treturn this.$store.getters.getBookmark(this.$store.state.sidebar.id)\n\t\t},\n\t\tbackground() {\n\t\t\treturn generateUrl(`/apps/bookmarks/bookmark/${this.bookmark.id}/image`)\n\t\t},\n\t\taddedDate() {\n\t\t\tconst date = new Date(Number(this.bookmark.added) * 1000)\n\t\t\tconst age = Date.now() - date\n\t\t\tif (age < MAX_RELATIVE_DATE) {\n\t\t\t\tconst duration = humanizeDuration(age, {\n\t\t\t\t\tlanguage: OC.getLanguage().split(\'-\')[0],\n\t\t\t\t\tunits: [\'d\', \'h\', \'m\', \'s\'],\n\t\t\t\t\tlargest: 1,\n\t\t\t\t\tround: true,\n\t\t\t\t})\n\t\t\t\treturn this.t(\'bookmarks\', \'Created {time} ago\', { time: duration })\n\t\t\t} else {\n\t\t\t\treturn this.t(\'bookmarks\', \'Created on {date}\', { date: date.toLocaleDateString() })\n\t\t\t}\n\t\t},\n\t\ttags() {\n\t\t\treturn this.bookmark.tags\n\t\t},\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.bookmark.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForBookmark(this.bookmark.id)\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tarchivedFile() {\n\t\t\tif (this.bookmark.archivedFile) {\n\t\t\t\treturn generateUrl(`/apps/files/?fileid=${this.bookmark.archivedFile}`)\n\t\t\t}\n\t\t\treturn null\n\t\t},\n\t\tarchivedFileUrl() {\n\t\t\t// remove `/username/files/`\n\t\t\tconst barePath = this.bookmark.archivedFilePath.split(\'/\').slice(3).join(\'/\')\n\t\t\treturn generateRemoteUrl(`webdav/${barePath}`)\n\t\t},\n\t},\n\tcreated() {\n\t},\n\tmethods: {\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.SET_SIDEBAR, null)\n\t\t},\n\t\tonNotesChange(e) {\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonTagsChange(tags) {\n\t\t\tthis.bookmark.tags = tags\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonAddTag(tag) {\n\t\t\tthis.bookmark.tags.push(tag)\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditTitle() {\n\t\t\tthis.title = this.bookmark.title\n\t\t\tthis.editingTitle = true\n\t\t},\n\t\tonEditTitleUpdate(e) {\n\t\t\tthis.title = e\n\t\t},\n\t\tonEditTitleSubmit() {\n\t\t\tthis.editingTitle = false\n\t\t\tthis.bookmark.title = this.title\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditTitleCancel() {\n\t\t\tthis.editingTitle = false\n\t\t\tthis.title = \'\'\n\t\t},\n\t\tonEditUrl() {\n\t\t\tthis.url = this.bookmark.url\n\t\t\tthis.editingUrl = true\n\t\t},\n\t\tonEditUrlSubmit() {\n\t\t\tthis.editingUrl = false\n\t\t\tthis.bookmark.url = this.url\n\t\t\tthis.scheduleSave()\n\t\t},\n\t\tonEditUrlCancel() {\n\t\t\tthis.editingUrl = false\n\t\t\tthis.url = \'\'\n\t\t},\n\t\tscheduleSave() {\n\t\t\tif (this.changeTimeout) clearTimeout(this.changeTimeout)\n\t\t\tthis.changeTimeout = setTimeout(async () => {\n\t\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_TAGS)\n\t\t\t}, 1000)\n\t\t},\n\t\tonOpenFolder(id) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: id } })\n\t\t\tthis.onClose()\n\t\t},\n\t\tgetFolder(id) {\n\t\t\tconst path = this.$store.getters.getFolder(id)\n\t\t\tconst folder = path[0]\n\t\t\treturn folder\n\t\t},\n\t\tgetFolderPath(id) {\n\t\t\tconst path = this.$store.getters.getFolder(id).reverse().map(folder => folder.title)\n\t\t\treturn \'/\' + path.join(\'/\')\n\t\t},\n\t\topenViewer() {\n\t\t\ttry {\n\t\t\t\tOCA.Viewer.open({\n\t\t\t\t\tpath: \'/\' + this.bookmark.archivedFilePath.split(\'/\').slice(2).join(\'/\'),\n\t\t\t\t})\n\t\t\t} catch (e) {\n\t\t\t\tthis.$store.commit(mutations.SHOW_ERROR, e.message)\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.sidebar h3 {\n\tmargin-top: 20px;\n}\n\n.sidebar .tags {\n\twidth: 100%;\n}\n\n.sidebar .notes {\n\tflex-grow: 1;\n\tmin-height: 80px;\n}\n\n.sidebar .details__line {\n\tdisplay: flex;\n\talign-items: flex-start;\n\tmargin-bottom: 10px;\n}\n\n.sidebar .details__line > * {\n\tflex-grow: 0;\n}\n\n.sidebar .details__line > :nth-child(2) {\n\tflex-grow: 1;\n}\n\n.sidebar .details__line .notes {\n\tflex-grow: 1;\n}\n\n.sidebar .details__url {\n\tflex-grow: 1;\n\tpadding: 8px 0;\n\ttext-overflow: ellipsis;\n\theight: 2em;\n\tdisplay: inline-block;\n\toverflow: hidden;\n}\n\n.sidebar .details__action {\n\tflex-grow: 0;\n}\n\n.sidebar .folders {\n\tdisplay: flex;\n\talign-items: flex-start;\n}\n\n.sidebar .folders__folder {\n\tborder: 1px solid var(--color-border);\n\tpadding: 2px 10px;\n\tborder-radius: var(--border-radius-large);\n\tmargin-right: 5px;\n\tcursor: pointer;\n\tdisplay: flex;\n}\n\n.sidebar .folders__folder * {\n\tcursor: pointer;\n}\n</style>\n'],sourceRoot:""}]);const s=a},51437:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.participant-select {\n\tdisplay: flex;\n}\n.participant-select__selection {\n\tflex: 1;\n\tmargin-top: 5px !important;\n}\n.participant-select__actions {\n\tflex-grow: 0;\n}\n.share {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-top: 10px;\n}\n.share__avatar {\n\tflex-grow: 0;\n\theight: 44px;\n\twidth: 44px;\n\tpadding: 10px;\n}\n.share__avatar.active {\n\tbackground-color: var(--color-primary-light);\n\tborder-radius: 44px;\n}\n.share__privs {\n\tdisplay: flex;\n\twidth: 70px;\n\tflex-direction: row;\n\tjustify-content: end;\n}\n.share__privs > * {\n\tpadding-right: 5px;\n}\n.share__title {\n\tflex: 1;\n\tpadding-left: 10px;\n\tmargin: 0 !important;\n}\n.share__actions {\n\tflex-grow: 0;\n}\n","",{version:3,sources:["webpack://./src/components/SidebarFolder.vue"],names:[],mappings:";AA8UA;CACA,aAAA;AACA;AAEA;CACA,OAAA;CACA,0BAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,gBAAA;AACA;AAEA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,aAAA;AACA;AAEA;CACA,4CAAA;CACA,mBAAA;AACA;AAEA;CACA,aAAA;CACA,WAAA;CACA,mBAAA;CACA,oBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,OAAA;CACA,kBAAA;CACA,oBAAA;AACA;AAEA;CACA,YAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcAppSidebar v-if=\"isActive\"\n\t\tclass=\"sidebar\"\n\t\t:title=\"folder.title\"\n\t\t:active.sync=\"activeTab\"\n\t\t@close=\"onClose\">\n\t\t<NcAppSidebarTab id=\"folder-details\"\n\t\t\t:name=\"t('bookmarks', 'Details')\"\n\t\t\t:order=\"0\">\n\t\t\t<template #icon>\n\t\t\t\t<InformationVariantIcon />\n\t\t\t</template>\n\t\t\t<h3>{{ t('bookmarks', 'Owner') }}</h3>\n\t\t\t<NcUserBubble :user=\"folder.userId\" :display-name=\"folder.userDisplayName\" />\n\t\t\t<h3>{{ t('bookmarks', 'Bookmarks') }}</h3>\n\t\t\t{{ bookmarkCount }}\n\t\t</NcAppSidebarTab>\n\t\t<NcAppSidebarTab v-if=\"isSharable\"\n\t\t\tid=\"folder-sharing\"\n\t\t\t:name=\"t('bookmarks', 'Sharing')\"\n\t\t\t:order=\"1\">\n\t\t\t<template #icon>\n\t\t\t\t<ShareVariantIcon />\n\t\t\t</template>\n\t\t\t<div class=\"participant-select\">\n\t\t\t\t<AccountIcon :class=\"{'share__avatar': true }\" />\n\t\t\t\t<NcMultiselect v-model=\"participant\"\n\t\t\t\t\tlabel=\"displayName\"\n\t\t\t\t\ttrack-by=\"user\"\n\t\t\t\t\tclass=\"participant-select__selection\"\n\t\t\t\t\t:user-select=\"true\"\n\t\t\t\t\t:options=\"participantSearchResults\"\n\t\t\t\t\t:loading=\"isSearching\"\n\t\t\t\t\t:placeholder=\"t('bookmarks', 'Select a user or group')\"\n\t\t\t\t\t@select=\"onAddShare\"\n\t\t\t\t\t@search-change=\"onParticipantSearch\" />\n\t\t\t</div>\n\t\t\t<div class=\"share\">\n\t\t\t\t<LinkIcon :class=\"{'share__avatar': true, active: publicLink }\" />\n\t\t\t\t<h3 class=\"share__title\">\n\t\t\t\t\t{{ t('bookmarks', 'Share link') }}\n\t\t\t\t</h3>\n\t\t\t\t<div class=\"share__privs\">\n\t\t\t\t\t<div v-if=\"publicLink\"\n\t\t\t\t\t\tv-tooltip=\"t('bookmarks', 'Reading allowed')\"\n\t\t\t\t\t\t:aria-label=\"t('bookmarks', 'Reading allowed')\">\n\t\t\t\t\t\t<EyeIcon :size=\"20\"\n\t\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t<NcActions class=\"share__actions\">\n\t\t\t\t\t<template v-if=\"publicLink\">\n\t\t\t\t\t\t<NcActionButton @click=\"onCopyPublicLink\">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<ClipboardIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Copy link') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t<NcActionButton icon=\"icon-clippy\" @click=\"onCopyRssLink\">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<RssIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Copy RSS feed') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t<NcActionSeparator />\n\t\t\t\t\t\t<NcActionButton @click=\"onDeletePublicLink\">\n\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t<DeleteIcon />\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Delete link') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</template>\n\t\t\t\t\t<NcActionButton v-else @click=\"onAddPublicLink\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<PlusIcon />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t{{ t('bookmarks', 'Create public link') }}\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t</div>\n\t\t\t<div v-for=\"share of shares\" :key=\"share.id\">\n\t\t\t\t<div class=\"share\">\n\t\t\t\t\t<NcAvatar :user=\"share.participant\" class=\"share__avatar\" :size=\"44\" />\n\t\t\t\t\t<h3 class=\"share__title\">\n\t\t\t\t\t\t{{ share.participant }}\n\t\t\t\t\t</h3>\n\t\t\t\t\t<div class=\"share__privs\">\n\t\t\t\t\t\t<div v-if=\"share.canShare\"\n\t\t\t\t\t\t\tv-tooltip=\"t('bookmarks', 'Resharing allowed')\"\n\t\t\t\t\t\t\t:aria-label=\"t('bookmarks','Resharing allowed')\">\n\t\t\t\t\t\t\t<ShareAllIcon :size=\"20\"\n\t\t\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div v-if=\"share.canWrite\"\n\t\t\t\t\t\t\tv-tooltip=\"t('bookmarks','Editing allowed')\"\n\t\t\t\t\t\t\t:aria-label=\"t('bookmarks','Editing allowed')\">\n\t\t\t\t\t\t\t<PencilIcon :size=\"20\"\n\t\t\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div v-tooltip=\"t('bookmarks','Reading allowed')\"\n\t\t\t\t\t\t\t:aria-label=\"t('bookmarks', 'Reading allowed')\">\n\t\t\t\t\t\t\t<EyeIcon :size=\"20\"\n\t\t\t\t\t\t\t\t:fill-color=\"colorMainText\" />\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<NcActions class=\"share__actions\">\n\t\t\t\t\t\t<NcActionCheckbox :checked=\"share.canWrite\" @update:checked=\"onEditShare(share.id, {canWrite: $event, canShare: share.canShare})\">\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Allow editing') }}\n\t\t\t\t\t\t</NcActionCheckbox>\n\t\t\t\t\t\t<NcActionCheckbox :checked=\"share.canShare\" @update:checked=\"onEditShare(share.id, {canWrite: share.canWrite, canShare: $event})\">\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Allow resharing') }}\n\t\t\t\t\t\t</NcActionCheckbox>\n\t\t\t\t\t\t<NcActionButton icon=\"icon-delete\" @click=\"onDeleteShare(share.id)\">\n\t\t\t\t\t\t\t{{ t('bookmarks', 'Remove share') }}\n\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</NcAppSidebarTab>\n\t</NcAppSidebar>\n</template>\n<script>\nimport { NcAppSidebar, NcUserBubble, NcActionSeparator, NcActionCheckbox, NcActionButton, NcActions, NcMultiselect, NcAvatar, NcAppSidebarTab } from '@nextcloud/vue'\nimport { getCurrentUser } from '@nextcloud/auth'\nimport { generateUrl, generateOcsUrl } from '@nextcloud/router'\nimport axios from '@nextcloud/axios'\nimport { actions, mutations } from '../store/index.js'\nimport EyeIcon from 'vue-material-design-icons/Eye.vue'\nimport PencilIcon from 'vue-material-design-icons/Pencil.vue'\nimport ShareAllIcon from 'vue-material-design-icons/ShareAll.vue'\nimport ShareVariantIcon from 'vue-material-design-icons/ShareVariant.vue'\nimport InformationVariantIcon from 'vue-material-design-icons/InformationVariant.vue'\nimport ClipboardIcon from 'vue-material-design-icons/Clipboard.vue'\nimport DeleteIcon from 'vue-material-design-icons/Delete.vue'\nimport RssIcon from 'vue-material-design-icons/Rss.vue'\nimport PlusIcon from 'vue-material-design-icons/Plus.vue'\nimport LinkIcon from 'vue-material-design-icons/Link.vue'\nimport AccountIcon from 'vue-material-design-icons/Account.vue'\n\nexport default {\n\tname: 'SidebarFolder',\n\tcomponents: { NcAppSidebar, NcAppSidebarTab, NcAvatar, NcMultiselect, NcActionButton, NcActionCheckbox, NcActions, NcUserBubble, NcActionSeparator, EyeIcon, PencilIcon, ShareAllIcon, ShareVariantIcon, InformationVariantIcon, ClipboardIcon, RssIcon, PlusIcon, DeleteIcon, LinkIcon, AccountIcon },\n\tdata() {\n\t\treturn {\n\t\t\tparticipantSearchResults: [],\n\t\t\tparticipant: null,\n\t\t\tisSearching: false,\n\t\t\tactiveTab: '',\n\t\t}\n\t},\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === 'folder'\n\t\t},\n\t\tfolder() {\n\t\t\tif (!this.isActive) return\n\t\t\tconst folders = this.$store.getters.getFolder(this.$store.state.sidebar.id)\n\t\t\tconst folder = folders[0]\n\t\t\tif (folder.userId === getCurrentUser()) {\n\t\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, folder.id)\n\t\t\t\tthis.$store.dispatch(actions.LOAD_PUBLIC_LINK, folder.id)\n\t\t\t}\n\t\t\treturn folder\n\t\t},\n\t\tisOwner() {\n\t\t\tif (!this.folder) return\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.folder.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForFolder(this.folder.id)\n\t\t},\n\t\tisSharable() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canShare)\n\t\t},\n\t\tisEditable() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.isOwner || (!this.isOwner && this.permissions.canWrite)\n\t\t},\n\t\tshares() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.$store.getters.getSharesOfFolder(this.folder.id)\n\t\t},\n\t\ttoken() {\n\t\t\tif (!this.folder) return\n\t\t\treturn this.$store.getters.getTokenOfFolder(this.folder.id)\n\t\t},\n\t\tpublicLink() {\n\t\t\tif (!this.token) return\n\t\t\treturn window.location.origin + generateUrl('/apps/bookmarks/public/' + this.token)\n\t\t},\n\t\trssLink() {\n\t\t\treturn (\n\t\t\t\twindow.location.origin\n\t\t\t\t\t+ generateUrl(\n\t\t\t\t\t\t'/apps/bookmarks/public/rest/v2/bookmark?'\n\t\t\t\t\t\t\t+ new URLSearchParams({\n\t\t\t\t\t\t\t\tformat: 'rss',\n\t\t\t\t\t\t\t\tfolder: this.folder.id,\n\t\t\t\t\t\t\t\tpage: -1,\n\t\t\t\t\t\t\t\ttoken: this.token,\n\t\t\t\t\t\t\t})\n\t\t\t\t\t).toString()\n\t\t\t)\n\t\t},\n\t\tbookmarkCount() {\n\t\t\treturn this.$store.state.countsByFolder[this.folder.id]\n\t\t},\n\t},\n\n\twatch: {\n\t\t'$store.state.sidebar.tab'(newActiveTab) {\n\t\t\tthis.activeTab = newActiveTab\n\t\t},\n\t},\n\n\tmethods: {\n\t\tonClose() {\n\t\t\tthis.$store.commit(mutations.SET_SIDEBAR, null)\n\t\t},\n\t\tasync onAddPublicLink() {\n\t\t\tawait this.$store.dispatch(actions.CREATE_PUBLIC_LINK, this.folder.id)\n\t\t\tthis.onCopyPublicLink()\n\t\t},\n\t\tonCopyPublicLink() {\n\t\t\tnavigator.clipboard.writeText(this.publicLink)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'Link copied'))\n\t\t},\n\t\tonCopyRssLink() {\n\t\t\tnavigator.clipboard.writeText(this.rssLink)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'RSS feed copied'))\n\t\t},\n\t\tasync onDeletePublicLink() {\n\t\t\tawait this.$store.dispatch(actions.DELETE_PUBLIC_LINK, this.folder.id)\n\t\t},\n\t\tasync onParticipantSearch(searchTerm) {\n\t\t\tif (!searchTerm) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.isSearching = true\n\t\t\tconst { data: { ocs: { data, meta } } } = await axios.get(generateOcsUrl('apps/files_sharing/api/v1', 1) + `/sharees?format=json&itemType=folder&search=${searchTerm}&lookup=false&perPage=200&shareType[]=0&shareType[]=1`)\n\t\t\tif (meta.status !== 'ok') {\n\t\t\t\tthis.participantSearchResults = []\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst users = data.exact.users.concat(data.users)\n\t\t\tconst groups = data.exact.groups.concat(data.groups)\n\t\t\tthis.participantSearchResults = users.map(result => ({\n\t\t\t\tuser: result.value.shareWith,\n\t\t\t\tdisplayName: result.label,\n\t\t\t\ticon: 'icon-user',\n\t\t\t\tisNoUser: false,\n\t\t\t})).concat(groups.map(result => ({\n\t\t\t\tuser: result.value.shareWith,\n\t\t\t\tdisplayName: result.label,\n\t\t\t\ticon: 'icon-group',\n\t\t\t\tisNoUser: true,\n\t\t\t})))\n\t\t\tthis.isSearching = false\n\t\t},\n\t\tasync onAddShare(user) {\n\t\t\tawait this.$store.dispatch(actions.CREATE_SHARE, { folderId: this.folder.id, participant: user.user, type: user.isNoUser ? 1 : 0 })\n\t\t},\n\t\tasync onEditShare(shareId, { canWrite, canShare }) {\n\t\t\tawait this.$store.dispatch(actions.EDIT_SHARE, { shareId, canWrite, canShare })\n\t\t},\n\t\tasync onDeleteShare(shareId) {\n\t\t\tawait this.$store.dispatch(actions.DELETE_SHARE, shareId)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\t.participant-select {\n\t\tdisplay: flex;\n\t}\n\n\t.participant-select__selection {\n\t\tflex: 1;\n\t\tmargin-top: 5px !important;\n\t}\n\n\t.participant-select__actions {\n\t\tflex-grow: 0;\n\t}\n\n\t.share {\n\t\tdisplay: flex;\n\t\talign-items: center;\n\t\tmargin-top: 10px;\n\t}\n\n\t.share__avatar {\n\t\tflex-grow: 0;\n\t\theight: 44px;\n\t\twidth: 44px;\n\t\tpadding: 10px;\n\t}\n\n\t.share__avatar.active {\n\t\tbackground-color: var(--color-primary-light);\n\t\tborder-radius: 44px;\n\t}\n\n\t.share__privs {\n\t\tdisplay: flex;\n\t\twidth: 70px;\n\t\tflex-direction: row;\n\t\tjustify-content: end;\n\t}\n\n\t.share__privs > * {\n\t\tpadding-right: 5px;\n\t}\n\n\t.share__title {\n\t\tflex: 1;\n\t\tpadding-left: 10px;\n\t\tmargin: 0 !important;\n\t}\n\n\t.share__actions {\n\t\tflex-grow: 0;\n\t}\n</style>\n"],sourceRoot:""}]);const s=a},84412:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.app-content {\n\tposition: relative !important;\n}\n","",{version:3,sources:["webpack://./src/components/ViewPrivate.vue"],names:[],mappings:";AAiOA;CACA,6BAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcContent app-name=\"bookmarks\">\n\t\t<Navigation />\n\t\t<NcAppContent :show-details.sync=\"showDetails\">\n\t\t\t<template v-if=\"showFolderOverview\" #list>\n\t\t\t\t<FolderOverview :show-details.sync=\"showDetails\" />\n\t\t\t</template>\n\t\t\t<template #default>\n\t\t\t\t<Controls />\n\t\t\t\t<BookmarksList />\n\t\t\t</template>\n\t\t</NcAppContent>\n\t\t<SidebarBookmark />\n\t\t<SidebarFolder />\n\t\t<MoveDialog />\n\t\t<CopyDialog />\n\t\t<LoadingModal />\n\t\t<BookmarkContent />\n\t</NcContent>\n</template>\n\n<script>\nimport { NcContent, NcAppContent } from '@nextcloud/vue'\nimport Navigation from './Navigation.vue'\nimport FolderOverview from './FolderOverview.vue'\nimport BookmarksList from './BookmarksList.vue'\nimport Controls from './Controls.vue'\nimport SidebarBookmark from './SidebarBookmark.vue'\nimport SidebarFolder from './SidebarFolder.vue'\nimport MoveDialog from './MoveDialog.vue'\nimport CopyDialog from './CopyDialog.vue'\nimport { privateRoutes } from '../router.js'\nimport { actions, mutations } from '../store/index.js'\nimport LoadingModal from './LoadingModal.vue'\nimport BookmarkContent from './BookmarkContent.vue'\nimport { getCurrentUser } from '@nextcloud/auth'\n\nexport default {\n\tname: 'ViewPrivate',\n\tcomponents: {\n\t\tBookmarkContent,\n\t\tLoadingModal,\n\t\tNavigation,\n\t\tNcContent,\n\t\tNcAppContent,\n\t\tFolderOverview,\n\t\tControls,\n\t\tBookmarksList,\n\t\tSidebarBookmark,\n\t\tSidebarFolder,\n\t\tMoveDialog,\n\t\tCopyDialog,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewBookmark: false,\n\t\t\tshowDetails: false,\n\t\t\tsmallScreen: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tfolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t\ttags() {\n\t\t\treturn this.$store.state.tags\n\t\t},\n\t\tisFolderView() {\n\t\t\treturn this.$route.name === privateRoutes.FOLDER || this.$route.name === privateRoutes.HOME\n\t\t},\n\t\tshowFolderOverview() {\n\t\t\treturn this.isFolderView && !this.smallScreen && this.folders.length\n\t\t},\n\t},\n\twatch: {\n\t\t$route: 'onRoute',\n\t\tasync showFolderOverview(value) {\n\t\t\t// hack to make bookmarkslist rerender\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'viewMode',\n\t\t\t\tvalue: this.$store.state.viewMode === 'grid' ? 'list' : 'grid',\n\t\t\t})\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'viewMode',\n\t\t\t\tvalue: this.$store.state.viewMode === 'grid' ? 'list' : 'grid',\n\t\t\t})\n\t\t},\n\t},\n\tasync created() {\n\t\tconst mediaQuery = window.matchMedia('(max-width: 1024px)')\n\t\tthis.smallScreen = mediaQuery.matches\n\t\tmediaQuery.addEventListener('change', this.onWindowFormatChange)\n\n\t  if (OCA.Search) {\n\t    // legacy search pre nc v20\n\t\t\tthis.search = new window.OCA.Search(this.onSearch, this.onResetSearch)\n\t\t}\n\t\t// set loading indicator\n\t\tthis.$store.commit(mutations.FETCH_START, { type: 'bookmarks' })\n\n\t\tawait this.reloadSettings()\n\t\tthis.onRoute()\n\t\tthis.reloadFolders()\n\t\tthis.reloadSharedFolders()\n\t\tthis.reloadCount()\n\t\tthis.reloadTags()\n\n\t\tconst currentUser = getCurrentUser()\n\t\tif (currentUser.isAdmin) {\n\t\t\tconst scrapingEnabled = await this.getSettingValue('privacy.enableScraping')\n\t\t\tconst alreadyShown = window.localStorage && window.localStorage.getItem('bookmarks.scrapingNoteShown')\n\t\t\tif (scrapingEnabled !== 'true' && alreadyShown !== 'true') {\n\t\t\t\twindow.localStorage && window.localStorage.setItem('bookmarks.scrapingNoteShown', 'true')\n\t\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'Network access is disabled by default. Go to administrator settings for the bookmarks app to allow fetching previews and favicons.'))\n\t\t\t}\n\t\t}\n\t},\n\n\tmethods: {\n\t\tasync onRoute() {\n\t\t\tconst route = this.$route\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tswitch (route.name) {\n\t\t\tcase privateRoutes.HOME:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_FOLDER, '-1')\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.RECENT:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_RECENT)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.UNTAGGED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_UNTAGGED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.UNAVAILABLE:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_UNAVAILABLE)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.ARCHIVED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_ARCHIVED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.DUPLICATED:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_DUPLICATED)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.SHARED_FOLDERS:\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_SHARED_FOLDERS)\n\t\t\t\tthis.$store.commit(mutations.REMOVE_ALL_BOOKMARKS)\n\t\t\t\tthis.$store.commit(mutations.FETCH_END, 'bookmarks')\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.BOOKMARK:\n\t\t\t\tawait this.$store.dispatch(actions.LOAD_BOOKMARK, route.params.bookmark)\n\t\t\t\tthis.$store.dispatch(actions.OPEN_BOOKMARK, route.params.bookmark)\n\t\t\t\tthis.$store.commit(mutations.FETCH_END, 'bookmarks')\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.FOLDER:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_FOLDER, route.params.folder)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.TAGS:\n\t\t\t\tthis.$store.dispatch(\n\t\t\t\t\tactions.FILTER_BY_TAGS,\n\t\t\t\t\troute.params.tags.split(',')\n\t\t\t\t)\n\t\t\t\tbreak\n\t\t\tcase privateRoutes.SEARCH:\n\t\t\t\tthis.$store.dispatch(actions.FILTER_BY_SEARCH, route.params.search)\n\t\t\t\tbreak\n\t\t\tdefault:\n\t\t\t\tthrow new Error('Nothing here. Move along.')\n\t\t\t}\n\t\t},\n\n\t\tasync reloadTags() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_TAGS)\n\t\t},\n\t\tasync reloadFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_FOLDERS)\n\t\t},\n\t\tasync reloadSharedFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_SHARED_FOLDERS)\n\t\t},\n\t\tasync reloadSettings() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_SETTINGS)\n\t\t},\n\t\tasync reloadCount() {\n\t\t\treturn Promise.all([\n\t\t\t\tthis.$store.dispatch(actions.COUNT_BOOKMARKS, -1),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_UNAVAILABLE),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_ARCHIVED),\n\t\t\t\tthis.$store.dispatch(actions.COUNT_DUPLICATED),\n\t\t\t])\n\t\t},\n\n\t\tonSearch(search) {\n\t\t\tthis.$router.push({ name: privateRoutes.SEARCH, params: { search } })\n\t\t},\n\n\t\tonResetSearch() {\n\t\t\tthis.$router.push({ name: privateRoutes.HOME })\n\t\t},\n\n\t\tasync getSettingValue(setting) {\n\t\t\tconst resDocument = await new Promise((resolve, reject) =>\n\t\t\t\tOCP.AppConfig.getValue('bookmarks', setting, null, {\n\t\t\t\t\tsuccess: resolve,\n\t\t\t\t\terror: reject,\n\t\t\t\t})\n\t\t\t)\n\t\t\tif (resDocument.querySelector('status').textContent !== 'ok') {\n\t\t\t\tconsole.error('Failed request', resDocument)\n\t\t\t\treturn\n\t\t\t}\n\t\t\tconst dataEl = resDocument.querySelector('data')\n\t\t\treturn dataEl.firstElementChild.textContent\n\t\t},\n\n\t\tonWindowFormatChange(mediaQuery) {\n\t\t\tthis.smallScreen = mediaQuery.matches\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.app-content {\n\tposition: relative !important;\n}\n</style>\n"],sourceRoot:""}]);const s=a},20843:(e,o,r)=>{r.r(o),r.d(o,{default:()=>pe});var i=r(15961),a=r(97974),s=r(20093),c=r(91746),l=r(3916),u=r(8356),d=r(52465),h=r(38545),p=r(95492),m=r(37302),f=r(68299),v=r(11341),g=r(96564),k=r(54028),A=r.n(k),b=r(79753),y=r(81283),w=r(45994),_=r(82880),N=r(25108);function C(t){return C="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},C(t)}function S(){S=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new E(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(x([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==C(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return T()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function E(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function x(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:T}}function T(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=x,E.prototype={constructor:E,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:x(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function E(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function x(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){E(i,o,r,a,s,"next",t)}function s(t){E(i,o,r,a,s,"throw",t)}a(void 0)}))}}const T={name:"Settings",components:{},data:function(){return{importing:!1,deleting:!1,addToHomeScreen:null,archivePathPicker:(0,_.getFilePickerBuilder)(this.t("bookmarks","Archive path")).allowDirectories(!0).setModal(!0).setType(1).setMultiSelect(!1).build(),backupPathPicker:(0,_.getFilePickerBuilder)(this.t("bookmarks","Backup path")).allowDirectories(!0).setModal(!0).setType(1).setMultiSelect(!1).build()}},computed:{oc_defaults:function(){return window.oc_defaults},bookmarklet:function(){var t=window.location.origin+(0,b.generateUrl)("/apps/bookmarks/bookmarklet");return"javascript:(function(){var a=window,b=document,c=encodeURIComponent,e=c(document.title),d=a.open('".concat(t,"?url='+c(b.location)+'&title='+e,'bkmk_popup','left='+((a.screenX||a.screenLeft)+10)+',top='+((a.screenY||a.screenTop)+10)+',height=650px,width=550px,resizable=1,alwaysRaised=1');a.setTimeout(function(){d.focus()},300);})();")},archivePath:function(){return this.$store.state.settings.archivePath},backupPath:function(){return this.$store.state.settings.backupPath},backupEnabled:function(){return Boolean(this.$store.state.settings.backupEnabled)}},mounted:function(){var t=this;window.addEventListener("beforeinstallprompt",(function(e){e.preventDefault(),t.addToHomeScreen=e,t.showAddToHomeScreen=!0}))},methods:{onImportOpen:function(t){t.target.previousElementSibling.click()},onImportSubmit:function(t){var e=this;return x(S().mark((function n(){return S().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return e.importing=!0,n.prev=1,n.next=4,e.$store.dispatch(y.Nw.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:e.$route.params.folder||-1});case 4:n.next=9;break;case 6:n.prev=6,n.t0=n.catch(1),N.warn(n.t0);case 9:e.importing=!1;case 10:case"end":return n.stop()}}),n,null,[[1,6]])})))()},onExport:function(){window.location="bookmark/export?requesttoken="+encodeURIComponent((0,w.IH)())},onChangeArchivePath:function(t){var e=this;return x(S().mark((function t(){var n;return S().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,e.archivePathPicker.pick();case 2:return n=t.sent,t.next=5,e.$store.dispatch(y.Nw.SET_SETTING,{key:"archivePath",value:n});case 5:case"end":return t.stop()}}),t)})))()},onChangeBackupPath:function(t){var e=this;return x(S().mark((function t(){var n;return S().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(e.backupEnabled){t.next=2;break}return t.abrupt("return");case 2:return t.next=4,e.backupPathPicker.pick();case 4:return n=t.sent,t.next=7,e.$store.dispatch(y.Nw.SET_SETTING,{key:"backupPath",value:n});case 7:case"end":return t.stop()}}),t)})))()},onChangeBackupEnabled:function(t){var e=this;return x(S().mark((function t(){return S().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,e.$store.dispatch(y.Nw.SET_SETTING,{key:"backupEnabled",value:!e.backupEnabled});case 2:case"end":return t.stop()}}),t)})))()},clickAddToHomeScreen:function(){var t=this;this.addToHomeScreen?(this.addToHomeScreen.prompt(),this.addToHomeScreen.userChoice.then((function(e){"accepted"===e.outcome?N.warn("User accepted the A2HS prompt"):N.warn("User dismissed the A2HS prompt"),t.addToHomeScreen=null}))):alert(this.t("bookmarks",'Please select "Add to home screen" in your browser menu'))}}};var I=r(93379),L=r.n(I),O=r(7795),P=r.n(O),B=r(90569),D=r.n(B),F=r(3565),$=r.n(F),R=r(19216),M=r.n(R),U=r(44589),G=r.n(U),j=r(71758),Z={};Z.styleTagTransform=G(),Z.setAttributes=$(),Z.insert=D().bind(null,"head"),Z.domAPI=P(),Z.insertStyleElement=M();L()(j.Z,Z);j.Z&&j.Z.locals&&j.Z.locals;var H=r(51900);const V=(0,H.Z)(T,(function(){var t=this,e=t._self._c;return e("div",{staticClass:"settings"},[e("input",{staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("button",{on:{click:t.onImportOpen}},[e("span",{class:{"icon-upload":!t.importing,"icon-loading-small":t.importing}}),t._v(t._s(t.t("bookmarks","Import"))+"\n\t")]),t._v(" "),e("button",{on:{click:t.onExport}},[e("span",{staticClass:"icon-download"}),t._v(" "+t._s(t.t("bookmarks","Export"))+"\n\t")]),t._v(" "),e("label",[e("h3",[t._v(t._s(t.t("bookmarks","Archive path")))]),t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","Enter the path of a folder in your Files where bookmarked files should be stored.")))]),t._v(" "),e("input",{attrs:{readonly:!0},domProps:{value:t.archivePath},on:{click:t.onChangeArchivePath}})]),t._v(" "),e("label",[e("h3",[t._v(t._s(t.t("bookmarks","Backups")))]),t._v(" "),e("p",[e("label",[e("input",{attrs:{type:"checkbox"},domProps:{checked:t.backupEnabled},on:{input:t.onChangeBackupEnabled}}),t._v(t._s(t.t("bookmarks","Enable bookmarks backups")))])]),t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","Enter the path of a folder in your Files where backups will be stored.")))]),t._v(" "),e("input",{attrs:{readonly:!0},domProps:{value:t.backupPath},on:{click:t.onChangeBackupPath}})]),t._v(" "),e("h3",[t._v(t._s(t.t("bookmarks","Client apps")))]),t._v(" "),e("p",[t._v("\n\t\t"+t._s(t.t("bookmarks","Also check out the collection of client apps that integrate with this app: "))+"\n\t\t"),e("a",{attrs:{href:"https://github.com/nextcloud/bookmarks#third-party-clients"}},[t._v(t._s(t.t("bookmarks","Client apps")))])]),t._v(" "),e("label",[e("h3",[t._v(t._s(t.t("bookmarks","Install web app on device")))]),t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","You can install this app on your device home screen to quickly access your bookmarks on your phone. You can easily remove the app from your home screen again, if you don't like it.")))]),t._v(" "),e("a",{staticClass:"button center",attrs:{href:"#"},on:{click:function(e){return e.preventDefault(),t.clickAddToHomeScreen.apply(null,arguments)}}},[t._v(t._s(t.t("bookmarks","Install on home screen")))])]),t._v(" "),e("label",[e("h3",[t._v(t._s(t.t("bookmarks","Bookmarklet")))]),t._v(" "),e("p",[t._v(t._s(t.t("bookmarks","Drag this to your browser bookmarks and click it to quickly bookmark a webpage.")))]),t._v(" "),e("a",{staticClass:"button center",attrs:{href:t.bookmarklet},on:{click:function(t){t.preventDefault()}}},[t._v(t._s(t.t("bookmarks","Add to {instanceName}",{instanceName:t.oc_defaults.name})))])])])}),[],!1,null,null,null).exports,Y={name:"Navigation",components:{NcAppNavigation:i.yS,NcAppNavigationItem:i.tn,NcAppNavigationNewItem:i.zQ,NcAppNavigationCounter:i._I,NcAppNavigationSettings:i.AR,NcAppNavigationSpacer:i.NI,NcActionButton:i.Js,Settings:V,ProgressBar:A(),HistoryIcon:s.Z,TagOffIcon:c.Z,LinkVariantOffIcon:l.Z,TagPlusIcon:h.Z,TagMultipleIcon:p.Z,FileDocumentMultipleIcon:d.Z,ShareVariantIcon:u.Z,VectorLinkIcon:m.Z,HomeIcon:a.Z,TagIcon:f.Z,DeleteIcon:v.Z,GaugeIcon:g.Z},filters:{largeNumbers:function(t){return t>=1e3?Math.round(t/100)/10+"K":t}},data:function(){return{}},computed:{tags:function(){var t=this;return this.$store.state.tags.map((function(e){return{route:{name:t.routes.TAGS,params:{tags:e.name}},name:e.name,count:e.count}}))},allBookmarksCount:function(){return this.$store.state.countsByFolder[-1]},unavailableBookmarksCount:function(){return this.$store.state.unavailableCount},sharedFoldersCount:function(){return Object.keys(this.$store.state.sharedFoldersById).length},archivedBookmarksCount:function(){return this.$store.state.archivedCount},duplicatedBookmarksCount:function(){return this.$store.state.duplicatedCount},bookmarksLimit:function(){return this.$store.state.settings.limit}},created:function(){},methods:{onSearchTags:function(){this.$router.push({name:this.routes.TAGS})},onDeleteTag:function(t){this.$store.dispatch(y.Nw.DELETE_TAG,t)},onRenameTag:function(t,e){this.$store.dispatch(y.Nw.RENAME_TAG,{oldName:t,newName:e})},onNewTag:function(t){this.$store.commit(y.P$.ADD_TAG,t)},allowDropOnTag:function(t){return!this.$store.state.selection.folders.length&&this.$store.state.selection.bookmarks.length},onDropOnTag:function(t){this.$store.dispatch(y.Nw.TAG_SELECTION,{tags:[t],originalTags:[]})}}};var K=r(7727),W={};W.styleTagTransform=G(),W.setAttributes=$(),W.insert=D().bind(null,"head"),W.domAPI=P(),W.insertStyleElement=M();L()(K.Z,W);K.Z&&K.Z.locals&&K.Z.locals;const q=(0,H.Z)(Y,(function(){var t=this,e=t._self._c;return e("NcAppNavigation",{staticClass:"navigation",scopedSlots:t._u([{key:"list",fn:function(){return[e("NcAppNavigationItem",{key:"menu-home",attrs:{to:{name:t.routes.HOME},title:t.t("bookmarks","All bookmarks"),exact:!0}},[e("HomeIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.allBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-recent",attrs:{to:{name:t.routes.RECENT},title:t.t("bookmarks","Recent")}},[e("HistoryIcon",{attrs:{slot:"icon"},slot:"icon"})],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-shared-folders",attrs:{to:{name:t.routes.SHARED_FOLDERS},title:t.t("bookmarks","Shared with you")}},[e("ShareVariantIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{directives:[{name:"show",rawName:"v-show",value:Boolean(t.sharedFoldersCount),expression:"Boolean(sharedFoldersCount)"}],attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.sharedFoldersCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-archived",attrs:{to:{name:t.routes.ARCHIVED},title:t.t("bookmarks","Files")}},[e("FileDocumentMultipleIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{directives:[{name:"show",rawName:"v-show",value:Boolean(t.archivedBookmarksCount),expression:"Boolean(archivedBookmarksCount)"}],attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t.archivedBookmarksCount)+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-duplicated",attrs:{to:{name:t.routes.DUPLICATED},title:t.t("bookmarks","Duplicates")}},[e("VectorLinkIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{directives:[{name:"show",rawName:"v-show",value:Boolean(t.duplicatedBookmarksCount),expression:"Boolean(duplicatedBookmarksCount)"}],attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.duplicatedBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationItem",{key:"menu-unavailable",attrs:{to:{name:t.routes.UNAVAILABLE},title:t.t("bookmarks","Broken links")}},[e("LinkVariantOffIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{directives:[{name:"show",rawName:"v-show",value:Boolean(t.unavailableBookmarksCount),expression:"Boolean(unavailableBookmarksCount)"}],attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t"+t._s(t._f("largeNumbers")(t.unavailableBookmarksCount))+"\n\t\t\t")])],1),t._v(" "),e("NcAppNavigationSpacer"),t._v(" "),e("NcAppNavigationNewItem",{key:"menu-new-tag",attrs:{title:t.t("bookmarks","New tag")},on:{"new-item":t.onNewTag}},[e("TagPlusIcon",{attrs:{slot:"icon"},slot:"icon"})],1),t._v(" "),Boolean(t.tags.length)?[e("NcAppNavigationItem",{key:"menu-tags",attrs:{title:t.t("bookmarks","Search tags")},on:{click:t.onSearchTags}},[e("TagMultipleIcon",{attrs:{slot:"icon"},slot:"icon"})],1),t._v(" "),t._l(t.tags,(function(n){return e("NcAppNavigationItem",{directives:[{name:"drop-target",rawName:"v-drop-target",value:{allow:function(e){return t.allowDropOnTag(n.name,e)},drop:function(e){return t.onDropOnTag(n.name,e)}},expression:"{allow: (e) => allowDropOnTag(tag.name, e), drop: (e) => onDropOnTag(tag.name, e)}"}],key:"tag-"+n.name,attrs:{to:n.route,"force-menu":!0,"edit-label":t.t("bookmarks","Rename"),editable:!t.isPublic,title:n.name},on:{"update:title":function(e){return t.onRenameTag(n.name,e)}}},[e("TagIcon",{attrs:{slot:"icon"},slot:"icon"}),t._v(" "),e("NcAppNavigationCounter",{attrs:{slot:"counter"},slot:"counter"},[t._v("\n\t\t\t\t\t"+t._s(t._f("largeNumbers")(n.count))+"\n\t\t\t\t")]),t._v(" "),t.isPublic?t._e():e("template",{slot:"actions"},[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDeleteTag(n.name)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon")]},proxy:!0}],null,!0)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Delete"))+"\n\t\t\t\t\t")])],1)],2)})),t._v(" "),e("NcAppNavigationItem",{key:"menu-untagged",attrs:{to:{name:t.routes.UNTAGGED},title:t.t("bookmarks","Untagged")}},[e("TagOffIcon",{attrs:{slot:"icon"},slot:"icon"})],1)]:t._e(),t._v(" "),Number(t.bookmarksLimit)>0?[e("NcAppNavigationSpacer"),t._v(" "),e("NcAppNavigationItem",{attrs:{pinned:!0,title:t.t("bookmarks","{used} bookmarks of {available} available",{used:t.allBookmarksCount,available:t.bookmarksLimit})},scopedSlots:t._u([{key:"icon",fn:function(){return[e("GaugeIcon")]},proxy:!0}],null,!1,913921433)},[t._v(" "),e("ProgressBar",{attrs:{val:t.allBookmarksCount,max:t.bookmarksLimit}})],1)]:t._e()]},proxy:!0},{key:"footer",fn:function(){return[t.isPublic?t._e():e("NcAppNavigationSettings",[e("Settings")],1)]},proxy:!0}])})}),[],!1,null,null,null).exports;var z=r(48643),X=r(41209);const J={name:"FolderOverview",components:{TreeFolder:z.Z,NcAppContentList:i.Yx},props:{showDetails:{type:Boolean,required:!0}},computed:{rootFolder:function(){return this.$store.getters.getFolder(-1)[0]}},methods:{onSelect:function(t){this.$router.push({name:X.xu.FOLDER,params:{folder:t}}),this.$emit("update:show-details",!0)}}};var Q=r(4227),tt={};tt.styleTagTransform=G(),tt.setAttributes=$(),tt.insert=D().bind(null,"head"),tt.domAPI=P(),tt.insertStyleElement=M();L()(Q.Z,tt);Q.Z&&Q.Z.locals&&Q.Z.locals;const et=(0,H.Z)(J,(function(){var t=this,e=t._self._c;return e("NcAppContentList",{attrs:{"show-details":t.showDetails},on:{"update:show-details":function(e){return t.$emit("update:show-details",e)}}},t._l(t.rootFolder.children,(function(n){return e("TreeFolder",{key:n.id,attrs:{folder:n},on:{select:function(e){return t.onSelect(e)}}})})),1)}),[],!1,null,null,null).exports;var nt=r(46997),ot=r(13187),rt=r(70178),it=r(44580),at=r(45879),st=r(49976),ct=r(41085),lt=r(9455),ut=r(98293),dt=r(19636),ht=r(47741),pt=r(69695),mt=r.n(pt);function ft(t){return ft="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ft(t)}function vt(){vt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new C(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(S([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==ft(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function gt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function kt(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){gt(i,o,r,a,s,"next",t)}function s(t){gt(i,o,r,a,s,"throw",t)}a(void 0)}))}}const At={name:"SidebarBookmark",components:{NcAppSidebar:i.Xu,NcAppSidebarTab:i.j1,NcMultiselect:i.Z2,NcActions:i.O3,NcActionButton:i.Js,NcRichContenteditable:i.Xj,FileDocumentIcon:rt.Z,FolderIcon:it.default,InformationVariantIcon:at.Z,PencilIcon:st.default,ArrowRightIcon:ct.default,TagIcon:f.Z,OpenInNewIcon:lt.Z,CloseIcon:ut.default,PencilBoxIcon:dt.Z,DownloadIcon:ht.Z,NcButton:i.P2},data:function(){return{title:"",editingTitle:!1,url:"",editingUrl:!1,activeTab:"",showContentModal:!1}},computed:{isActive:function(){return!!this.$store.state.sidebar&&"bookmark"===this.$store.state.sidebar.type},bookmark:function(){if(this.isActive)return this.$store.getters.getBookmark(this.$store.state.sidebar.id)},background:function(){return(0,b.generateUrl)("/apps/bookmarks/bookmark/".concat(this.bookmark.id,"/image"))},addedDate:function(){var t=new Date(1e3*Number(this.bookmark.added)),e=Date.now()-t;if(e<6048e5){var n=mt()(e,{language:OC.getLanguage().split("-")[0],units:["d","h","m","s"],largest:1,round:!0});return this.t("bookmarks","Created {time} ago",{time:n})}return this.t("bookmarks","Created on {date}",{date:t.toLocaleDateString()})},tags:function(){return this.bookmark.tags},allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},isOwner:function(){var t=(0,w.ts)();return t&&this.bookmark.userId===t.uid},permissions:function(){return this.$store.getters.getPermissionsForBookmark(this.bookmark.id)},isEditable:function(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},archivedFile:function(){return this.bookmark.archivedFile?(0,b.generateUrl)("/apps/files/?fileid=".concat(this.bookmark.archivedFile)):null},archivedFileUrl:function(){var t=this.bookmark.archivedFilePath.split("/").slice(3).join("/");return(0,b.generateRemoteUrl)("webdav/".concat(t))}},created:function(){},methods:{onClose:function(){this.$store.commit(y.P$.SET_SIDEBAR,null)},onNotesChange:function(t){this.scheduleSave()},onTagsChange:function(t){this.bookmark.tags=t,this.scheduleSave()},onAddTag:function(t){this.bookmark.tags.push(t),this.scheduleSave()},onEditTitle:function(){this.title=this.bookmark.title,this.editingTitle=!0},onEditTitleUpdate:function(t){this.title=t},onEditTitleSubmit:function(){this.editingTitle=!1,this.bookmark.title=this.title,this.scheduleSave()},onEditTitleCancel:function(){this.editingTitle=!1,this.title=""},onEditUrl:function(){this.url=this.bookmark.url,this.editingUrl=!0},onEditUrlSubmit:function(){this.editingUrl=!1,this.bookmark.url=this.url,this.scheduleSave()},onEditUrlCancel:function(){this.editingUrl=!1,this.url=""},scheduleSave:function(){var t=this;this.changeTimeout&&clearTimeout(this.changeTimeout),this.changeTimeout=setTimeout(kt(vt().mark((function e(){return vt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch(y.Nw.SAVE_BOOKMARK,t.bookmark.id);case 2:return e.next=4,t.$store.dispatch(y.Nw.LOAD_TAGS);case 4:case"end":return e.stop()}}),e)}))),1e3)},onOpenFolder:function(t){this.$router.push({name:this.routes.FOLDER,params:{folder:t}}),this.onClose()},getFolder:function(t){return this.$store.getters.getFolder(t)[0]},getFolderPath:function(t){return"/"+this.$store.getters.getFolder(t).reverse().map((function(t){return t.title})).join("/")},openViewer:function(){try{OCA.Viewer.open({path:"/"+this.bookmark.archivedFilePath.split("/").slice(2).join("/")})}catch(t){this.$store.commit(y.P$.SHOW_ERROR,t.message)}}}};var bt=r(36599),yt={};yt.styleTagTransform=G(),yt.setAttributes=$(),yt.insert=D().bind(null,"head"),yt.domAPI=P(),yt.insertStyleElement=M();L()(bt.Z,yt);bt.Z&&bt.Z.locals&&bt.Z.locals;const wt=(0,H.Z)(At,(function(){var t=this,e=t._self._c;return t.isActive?e("NcAppSidebar",{staticClass:"sidebar",attrs:{title:t.bookmark.title,"title-editable":t.editingTitle,"title-placeholder":t.t("bookmarks","Title"),subtitle:t.addedDate,background:t.background},on:{"update:active":function(e){t.activeTab=e},"update:title":t.onEditTitleUpdate,"submit-title":t.onEditTitleSubmit,"dismiss-editing":t.onEditTitleCancel,close:t.onClose}},[t.editingTitle?t._e():e("template",{slot:"secondary-actions"},[e("NcActionButton",{on:{click:t.onEditTitle},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon")]},proxy:!0}],null,!1,411976917)})],1),t._v(" "),t.editingTitle?e("template",{slot:"secondary-actions"},[e("NcActionButton",{on:{click:t.onEditTitleCancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon")]},proxy:!0}],null,!1,2491825086)})],1):t._e(),t._v(" "),e("NcAppSidebarTab",{attrs:{id:"bookmark-details",name:t.t("bookmarks","Details"),order:0},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon")]},proxy:!0}],null,!1,1289402675)},[t._v(" "),e("div",[t.editingUrl?e("div",{staticClass:"details__line"},[e("OpenInNewIcon",{attrs:{"aria-label":t.t("bookmarks","Link"),title:t.t("bookmarks","Link")}}),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.url,expression:"url"}],staticClass:"details__url",domProps:{value:t.url},on:{input:function(e){e.target.composing||(t.url=e.target.value)}}}),t._v(" "),e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditUrlSubmit},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowRightIcon")]},proxy:!0}],null,!1,1168934321)})],1),t._v(" "),e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditUrlCancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon")]},proxy:!0}],null,!1,2491825086)})],1)],1):e("div",{staticClass:"details__line"},[e("OpenInNewIcon",{attrs:{"aria-label":t.t("bookmarks","Link"),title:t.t("bookmarks","Link")}}),t._v(" "),e("a",{staticClass:"details__url",attrs:{href:t.bookmark.url}},[t._v(t._s(t.bookmark.url))]),t._v(" "),t.isEditable?e("NcActions",{staticClass:"details__action"},[e("NcActionButton",{on:{click:t.onEditUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon")]},proxy:!0}],null,!1,411976917)})],1):t._e()],1),t._v(" "),e("div",{staticClass:"details__line"},[e("FolderIcon"),t._v(" "),e("div",{staticClass:"folders"},t._l(t.bookmark.folders,(function(n){return e("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.getFolderPath(n),expression:"getFolderPath(folderId)"}],key:n,staticClass:"folders__folder",on:{click:function(e){return t.onOpenFolder(n)}}},[e("FolderIcon"),t._v(" "+t._s(t.getFolder(n).title||(t.getFolder(n).parent_folder?t.t("bookmarks","Untitled folder"):t.t("bookmarks","Root folder")))+"\n\t\t\t\t\t")],1)})),0)],1),t._v(" "),e("div",{staticClass:"details__line"},[e("TagIcon",{attrs:{"aria-label":t.t("bookmarks","Tags"),title:t.t("bookmarks","Tags")}}),t._v(" "),e("NcMultiselect",{staticClass:"tags",attrs:{value:t.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,taggable:!0,"open-direction":"below",placeholder:t.t("bookmarks","Select tags and create new ones"),disabled:!t.isEditable},on:{input:t.onTagsChange,tag:t.onAddTag}})],1),t._v(" "),e("div",{staticClass:"details__line"},[e("PencilBoxIcon",{attrs:{role:"figure","aria-label":t.t("bookmarks","Notes"),title:t.t("bookmarks","Notes")}}),t._v(" "),e("NcRichContenteditable",{staticClass:"notes",attrs:{value:t.bookmark.description,contenteditable:t.isEditable,"auto-complete":function(){},placeholder:t.t("bookmarks","Notes for this bookmark …"),multiline:!0},on:{"update:value":[function(e){return t.$set(t.bookmark,"description",e)},t.onNotesChange]}})],1),t._v(" "),t.archivedFile?e("div",{staticClass:"details__line"},[e("FileDocumentIcon",{attrs:{role:"figure","aria-label":t.t("bookmarks","Archived file"),title:t.t("bookmarks","Archived file")}}),t._v(" "),e("NcButton",{attrs:{href:t.archivedFileUrl,target:"_blank",type:"primary"},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DownloadIcon",{attrs:{size:18,"fill-color":t.colorMainText}})]},proxy:!0}],null,!1,793491294)},[t._v(t._s(t.t("bookmarks","Download file"))+"\n\t\t\t\t")]),t._v(" "),e("NcButton",{attrs:{href:t.archivedFile,target:"_blank"}},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Open file location"))+"\n\t\t\t\t")])],1):t._e()])])],2):t._e()}),[],!1,null,null,null).exports;var _t=r(26937),Nt=r(84733),Ct=r(99440),St=r(68248),Et=r(9025),xt=r(69141),Tt=r(4559),It=r(7142);function Lt(t){return Lt="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Lt(t)}function Ot(){Ot=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new C(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(S([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==Lt(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function Pt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function Bt(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){Pt(i,o,r,a,s,"next",t)}function s(t){Pt(i,o,r,a,s,"throw",t)}a(void 0)}))}}const Dt={name:"SidebarFolder",components:{NcAppSidebar:i.Xu,NcAppSidebarTab:i.j1,NcAvatar:i.Xn,NcMultiselect:i.Z2,NcActionButton:i.Js,NcActionCheckbox:i.Bt,NcActions:i.O3,NcUserBubble:i.uq,NcActionSeparator:i.rr,EyeIcon:Nt.default,PencilIcon:st.default,ShareAllIcon:Ct.Z,ShareVariantIcon:u.Z,InformationVariantIcon:at.Z,ClipboardIcon:St.Z,RssIcon:Et.Z,PlusIcon:xt.Z,DeleteIcon:v.Z,LinkIcon:Tt.Z,AccountIcon:It.Z},data:function(){return{participantSearchResults:[],participant:null,isSearching:!1,activeTab:""}},computed:{isActive:function(){return!!this.$store.state.sidebar&&"folder"===this.$store.state.sidebar.type},folder:function(){if(this.isActive){var t=this.$store.getters.getFolder(this.$store.state.sidebar.id)[0];return t.userId===(0,w.ts)()&&(this.$store.dispatch(y.Nw.LOAD_SHARES_OF_FOLDER,t.id),this.$store.dispatch(y.Nw.LOAD_PUBLIC_LINK,t.id)),t}},isOwner:function(){if(this.folder){var t=(0,w.ts)();return t&&this.folder.userId===t.uid}},permissions:function(){return this.$store.getters.getPermissionsForFolder(this.folder.id)},isSharable:function(){if(this.folder)return this.isOwner||!this.isOwner&&this.permissions.canShare},isEditable:function(){if(this.folder)return this.isOwner||!this.isOwner&&this.permissions.canWrite},shares:function(){if(this.folder)return this.$store.getters.getSharesOfFolder(this.folder.id)},token:function(){if(this.folder)return this.$store.getters.getTokenOfFolder(this.folder.id)},publicLink:function(){if(this.token)return window.location.origin+(0,b.generateUrl)("/apps/bookmarks/public/"+this.token)},rssLink:function(){return window.location.origin+(0,b.generateUrl)("/apps/bookmarks/public/rest/v2/bookmark?"+new URLSearchParams({format:"rss",folder:this.folder.id,page:-1,token:this.token})).toString()},bookmarkCount:function(){return this.$store.state.countsByFolder[this.folder.id]}},watch:{"$store.state.sidebar.tab":function(t){this.activeTab=t}},methods:{onClose:function(){this.$store.commit(y.P$.SET_SIDEBAR,null)},onAddPublicLink:function(){var t=this;return Bt(Ot().mark((function e(){return Ot().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch(y.Nw.CREATE_PUBLIC_LINK,t.folder.id);case 2:t.onCopyPublicLink();case 3:case"end":return e.stop()}}),e)})))()},onCopyPublicLink:function(){navigator.clipboard.writeText(this.publicLink),this.$store.commit(y.P$.SET_NOTIFICATION,t("bookmarks","Link copied"))},onCopyRssLink:function(){navigator.clipboard.writeText(this.rssLink),this.$store.commit(y.P$.SET_NOTIFICATION,t("bookmarks","RSS feed copied"))},onDeletePublicLink:function(){var t=this;return Bt(Ot().mark((function e(){return Ot().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,t.$store.dispatch(y.Nw.DELETE_PUBLIC_LINK,t.folder.id);case 2:case"end":return e.stop()}}),e)})))()},onParticipantSearch:function(t){var e=this;return Bt(Ot().mark((function n(){var o,r,i,a,s;return Ot().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:if(t){n.next=2;break}return n.abrupt("return");case 2:return e.isSearching=!0,n.next=5,_t.Z.get((0,b.generateOcsUrl)("apps/files_sharing/api/v1",1)+"/sharees?format=json&itemType=folder&search=".concat(t,"&lookup=false&perPage=200&shareType[]=0&shareType[]=1"));case 5:if(o=n.sent,r=o.data.ocs,i=r.data,"ok"===r.meta.status){n.next=12;break}return e.participantSearchResults=[],n.abrupt("return");case 12:a=i.exact.users.concat(i.users),s=i.exact.groups.concat(i.groups),e.participantSearchResults=a.map((function(t){return{user:t.value.shareWith,displayName:t.label,icon:"icon-user",isNoUser:!1}})).concat(s.map((function(t){return{user:t.value.shareWith,displayName:t.label,icon:"icon-group",isNoUser:!0}}))),e.isSearching=!1;case 16:case"end":return n.stop()}}),n)})))()},onAddShare:function(t){var e=this;return Bt(Ot().mark((function n(){return Ot().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.next=2,e.$store.dispatch(y.Nw.CREATE_SHARE,{folderId:e.folder.id,participant:t.user,type:t.isNoUser?1:0});case 2:case"end":return n.stop()}}),n)})))()},onEditShare:function(t,e){var n=this;return Bt(Ot().mark((function o(){var r,i;return Ot().wrap((function(o){for(;;)switch(o.prev=o.next){case 0:return r=e.canWrite,i=e.canShare,o.next=3,n.$store.dispatch(y.Nw.EDIT_SHARE,{shareId:t,canWrite:r,canShare:i});case 3:case"end":return o.stop()}}),o)})))()},onDeleteShare:function(t){var e=this;return Bt(Ot().mark((function n(){return Ot().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.next=2,e.$store.dispatch(y.Nw.DELETE_SHARE,t);case 2:case"end":return n.stop()}}),n)})))()}}};var Ft=r(51437),$t={};$t.styleTagTransform=G(),$t.setAttributes=$(),$t.insert=D().bind(null,"head"),$t.domAPI=P(),$t.insertStyleElement=M();L()(Ft.Z,$t);Ft.Z&&Ft.Z.locals&&Ft.Z.locals;const Rt=(0,H.Z)(Dt,(function(){var t=this,e=t._self._c;return t.isActive?e("NcAppSidebar",{staticClass:"sidebar",attrs:{title:t.folder.title,active:t.activeTab},on:{"update:active":function(e){t.activeTab=e},close:t.onClose}},[e("NcAppSidebarTab",{attrs:{id:"folder-details",name:t.t("bookmarks","Details"),order:0},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon")]},proxy:!0}],null,!1,1289402675)},[t._v(" "),e("h3",[t._v(t._s(t.t("bookmarks","Owner")))]),t._v(" "),e("NcUserBubble",{attrs:{user:t.folder.userId,"display-name":t.folder.userDisplayName}}),t._v(" "),e("h3",[t._v(t._s(t.t("bookmarks","Bookmarks")))]),t._v("\n\t\t"+t._s(t.bookmarkCount)+"\n\t")],1),t._v(" "),t.isSharable?e("NcAppSidebarTab",{attrs:{id:"folder-sharing",name:t.t("bookmarks","Sharing"),order:1},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon")]},proxy:!0}],null,!1,3668921682)},[t._v(" "),e("div",{staticClass:"participant-select"},[e("AccountIcon",{class:{share__avatar:!0}}),t._v(" "),e("NcMultiselect",{staticClass:"participant-select__selection",attrs:{label:"displayName","track-by":"user","user-select":!0,options:t.participantSearchResults,loading:t.isSearching,placeholder:t.t("bookmarks","Select a user or group")},on:{select:t.onAddShare,"search-change":t.onParticipantSearch},model:{value:t.participant,callback:function(e){t.participant=e},expression:"participant"}})],1),t._v(" "),e("div",{staticClass:"share"},[e("LinkIcon",{class:{share__avatar:!0,active:t.publicLink}}),t._v(" "),e("h3",{staticClass:"share__title"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Share link"))+"\n\t\t\t")]),t._v(" "),e("div",{staticClass:"share__privs"},[t.publicLink?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Reading allowed"),expression:"t('bookmarks', 'Reading allowed')"}],attrs:{"aria-label":t.t("bookmarks","Reading allowed")}},[e("EyeIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e()]),t._v(" "),e("NcActions",{staticClass:"share__actions"},[t.publicLink?[e("NcActionButton",{on:{click:t.onCopyPublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ClipboardIcon")]},proxy:!0}],null,!1,3452080612)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Copy link"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{icon:"icon-clippy"},on:{click:t.onCopyRssLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon")]},proxy:!0}],null,!1,682624442)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Copy RSS feed"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionSeparator"),t._v(" "),e("NcActionButton",{on:{click:t.onDeletePublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon")]},proxy:!0}],null,!1,3930079857)},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Delete link"))+"\n\t\t\t\t\t")])]:e("NcActionButton",{on:{click:t.onAddPublicLink},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon")]},proxy:!0}],null,!1,1789392498)},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Create public link"))+"\n\t\t\t\t")])],2)],1),t._v(" "),t._l(t.shares,(function(n){return e("div",{key:n.id},[e("div",{staticClass:"share"},[e("NcAvatar",{staticClass:"share__avatar",attrs:{user:n.participant,size:44}}),t._v(" "),e("h3",{staticClass:"share__title"},[t._v("\n\t\t\t\t\t"+t._s(n.participant)+"\n\t\t\t\t")]),t._v(" "),e("div",{staticClass:"share__privs"},[n.canShare?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Resharing allowed"),expression:"t('bookmarks', 'Resharing allowed')"}],attrs:{"aria-label":t.t("bookmarks","Resharing allowed")}},[e("ShareAllIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e(),t._v(" "),n.canWrite?e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Editing allowed"),expression:"t('bookmarks','Editing allowed')"}],attrs:{"aria-label":t.t("bookmarks","Editing allowed")}},[e("PencilIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1):t._e(),t._v(" "),e("div",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","Reading allowed"),expression:"t('bookmarks','Reading allowed')"}],attrs:{"aria-label":t.t("bookmarks","Reading allowed")}},[e("EyeIcon",{attrs:{size:20,"fill-color":t.colorMainText}})],1)]),t._v(" "),e("NcActions",{staticClass:"share__actions"},[e("NcActionCheckbox",{attrs:{checked:n.canWrite},on:{"update:checked":function(e){return t.onEditShare(n.id,{canWrite:e,canShare:n.canShare})}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Allow editing"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionCheckbox",{attrs:{checked:n.canShare},on:{"update:checked":function(e){return t.onEditShare(n.id,{canWrite:n.canWrite,canShare:e})}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Allow resharing"))+"\n\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{icon:"icon-delete"},on:{click:function(e){return t.onDeleteShare(n.id)}}},[t._v("\n\t\t\t\t\t\t"+t._s(t.t("bookmarks","Remove share"))+"\n\t\t\t\t\t")])],1)],1)])}))],2):t._e()],1):t._e()}),[],!1,null,null,null).exports;var Mt=r(45618);function Ut(t){return Ut="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Ut(t)}function Gt(){Gt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new C(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(S([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==Ut(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function jt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}const Zt={name:"MoveDialog",components:{FolderPicker:Mt.Z,NcModal:i.Jc},computed:{showNcModal:function(){return this.$store.state.displayMoveDialog},selection:function(){return this.$store.state.selection},title:function(){return this.selection.folders.length?this.selection.bookmarks.length?n("bookmarks","Moving %n folder and some bookmarks","Moving %n folders and some bookmarks",this.selection.folders.length):n("bookmarks","Moving %n folder","Moving %n folders",this.selection.folders.length):n("bookmarks","Moving %n bookmark","Moving %n bookmarks",this.selection.bookmarks.length)}},methods:{onSubmit:function(t){var e,n=this;return(e=Gt().mark((function e(){return Gt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return n.$store.commit(y.P$.DISPLAY_MOVE_DIALOG,!1),e.next=3,n.$store.dispatch(y.Nw.MOVE_SELECTION,t);case 3:n.$store.commit(y.P$.RESET_SELECTION);case 4:case"end":return e.stop()}}),e)})),function(){var t=this,n=arguments;return new Promise((function(o,r){var i=e.apply(t,n);function a(t){jt(i,o,r,a,s,"next",t)}function s(t){jt(i,o,r,a,s,"throw",t)}a(void 0)}))})()},onClose:function(){this.$store.commit(y.P$.DISPLAY_MOVE_DIALOG,!1)},filterFolders:function(t){return!this.selection.folders.some((function(e){return e.id===t.id}))}}};var Ht=r(94055),Vt={};Vt.styleTagTransform=G(),Vt.setAttributes=$(),Vt.insert=D().bind(null,"head"),Vt.domAPI=P(),Vt.insertStyleElement=M();L()(Ht.Z,Vt);Ht.Z&&Ht.Z.locals&&Ht.Z.locals;const Yt=(0,H.Z)(Zt,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{title:t.title},on:{close:t.onClose}},[e("div",{staticClass:"move-dialog"},[e("FolderPicker",{attrs:{title:t.title,filter:t.filterFolders},on:{submit:t.onSubmit}})],1)]):t._e()}),[],!1,null,null,null).exports;function Kt(t){return Kt="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Kt(t)}function Wt(){Wt=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new C(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(S([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==Kt(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function qt(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}const zt={name:"CopyDialog",components:{FolderPicker:Mt.Z,NcModal:i.Jc},computed:{showNcModal:function(){return this.$store.state.displayCopyDialog},selection:function(){return this.$store.state.selection},title:function(){return n("bookmarks","Adding %n bookmark to new folder","Adding %n bookmarks to new folder",this.selection.bookmarks.length)}},methods:{onSubmit:function(t){var e,n=this;return(e=Wt().mark((function e(){return Wt().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return n.$store.commit(y.P$.DISPLAY_COPY_DIALOG,!1),e.next=3,n.$store.dispatch(y.Nw.NcNcModal,t);case 3:n.$store.commit(y.P$.RESET_SELECTION);case 4:case"end":return e.stop()}}),e)})),function(){var t=this,n=arguments;return new Promise((function(o,r){var i=e.apply(t,n);function a(t){qt(i,o,r,a,s,"next",t)}function s(t){qt(i,o,r,a,s,"throw",t)}a(void 0)}))})()},onClose:function(){this.$store.commit(y.P$.DISPLAY_COPY_DIALOG,!1)},filterFolders:function(t){return!this.selection.folders.some((function(e){return e.id===t.id}))}}};var Xt=r(39282),Jt={};Jt.styleTagTransform=G(),Jt.setAttributes=$(),Jt.insert=D().bind(null,"head"),Jt.domAPI=P(),Jt.insertStyleElement=M();L()(Xt.Z,Jt);Xt.Z&&Xt.Z.locals&&Xt.Z.locals;const Qt=(0,H.Z)(zt,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{title:t.title},on:{close:t.onClose}},[e("div",{staticClass:"copy-dialog"},[e("FolderPicker",{attrs:{title:t.title,filter:t.filterFolders},on:{submit:t.onSubmit}})],1)]):t._e()}),[],!1,null,null,null).exports;const te={name:"LoadingModal",components:{NcModal:i.Jc},data:function(){return{states:{deleteBookmarks:this.t("bookmarks","Deleting bookmarks"),deleteSelection:this.t("bookmarks","Deleting selection"),importBookmarks:this.t("bookmarks","Importing bookmarks"),moveSelection:this.t("bookmkarks","Moving selection"),copySelection:this.t("bookmkarks","Adding selection to folders")},showNcModal:!1,showTimeout:null}},computed:{state:function(){var t=this;return Object.keys(this.states).find((function(e){return t.$store.state.loading[e]}))},title:function(){var t=this.state;return t?this.states[t]:""}},watch:{state:function(t,e){var n=this;this.state&&!e?this.showTimeout=setTimeout((function(){n.showNcModal=!0}),500):!this.state&&e&&(clearTimeout(this.showTimeout),this.showNcModal=!1)}}};var ee=r(97054),ne={};ne.styleTagTransform=G(),ne.setAttributes=$(),ne.insert=D().bind(null,"head"),ne.domAPI=P(),ne.insertStyleElement=M();L()(ee.Z,ne);ee.Z&&ee.Z.locals&&ee.Z.locals;const oe=(0,H.Z)(te,(function(){var t=this,e=t._self._c;return t.showNcModal?e("NcModal",{attrs:{"can-close":!1}},[e("div",{staticClass:"loading icon-loading"},[e("h3",[t._v(t._s(t.title))])])]):t._e()}),[],!1,null,"81e688b4",null).exports;var re=r(92583),ie=r(25108);function ae(t){return ae="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},ae(t)}function se(){se=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function c(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{c({},"")}catch(t){c=function(t,e,n){return t[e]=n}}function l(t,e,n,r){var i=e&&e.prototype instanceof h?e:h,a=Object.create(i.prototype),s=new C(r||[]);return o(a,"_invoke",{value:y(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=l;var d={};function h(){}function p(){}function m(){}var f={};c(f,i,(function(){return this}));var v=Object.getPrototypeOf,g=v&&v(v(S([])));g&&g!==e&&n.call(g,i)&&(f=g);var k=m.prototype=h.prototype=Object.create(f);function A(t){["next","throw","return"].forEach((function(e){c(t,e,(function(t){return this._invoke(e,t)}))}))}function b(t,e){function r(o,i,a,s){var c=u(t[o],t,i);if("throw"!==c.type){var l=c.arg,d=l.value;return d&&"object"==ae(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){l.value=t,a(l)}),(function(t){return r("throw",t,a,s)}))}s(c.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function y(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return E()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=w(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var c=u(t,e,n);if("normal"===c.type){if(o=n.done?"completed":"suspendedYield",c.arg===d)continue;return{value:c.arg,done:n.done}}"throw"===c.type&&(o="completed",n.method="throw",n.arg=c.arg)}}}function w(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,w(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function _(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function C(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(_,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:E}}function E(){return{value:void 0,done:!0}}return p.prototype=m,o(k,"constructor",{value:m,configurable:!0}),o(m,"constructor",{value:p,configurable:!0}),p.displayName=c(m,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===p||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,m):(t.__proto__=m,c(t,s,"GeneratorFunction")),t.prototype=Object.create(k),t},t.awrap=function(t){return{__await:t}},A(b.prototype),c(b.prototype,a,(function(){return this})),t.AsyncIterator=b,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new b(l(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},A(k),c(k,s,"Generator"),c(k,i,(function(){return this})),c(k,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,C.prototype={constructor:C,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),c=n.call(i,"finallyLoc");if(s&&c){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!c)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function ce(t,e,n,o,r,i,a){try{var s=t[i](a),c=s.value}catch(t){return void n(t)}s.done?e(c):Promise.resolve(c).then(o,r)}function le(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){ce(i,o,r,a,s,"next",t)}function s(t){ce(i,o,r,a,s,"throw",t)}a(void 0)}))}}const ue={name:"ViewPrivate",components:{BookmarkContent:re.Z,LoadingModal:oe,Navigation:q,NcContent:i.qF,NcAppContent:i.Mb,FolderOverview:et,Controls:ot.Z,BookmarksList:nt.Z,SidebarBookmark:wt,SidebarFolder:Rt,MoveDialog:Yt,CopyDialog:Qt},data:function(){return{newBookmark:!1,showDetails:!1,smallScreen:!1}},computed:{folders:function(){return this.$store.state.folders},tags:function(){return this.$store.state.tags},isFolderView:function(){return this.$route.name===X.xu.FOLDER||this.$route.name===X.xu.HOME},showFolderOverview:function(){return this.isFolderView&&!this.smallScreen&&this.folders.length}},watch:{$route:"onRoute",showFolderOverview:function(t){var e=this;return le(se().mark((function t(){return se().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.next=2,e.$store.dispatch(y.Nw.SET_SETTING,{key:"viewMode",value:"grid"===e.$store.state.viewMode?"list":"grid"});case 2:return t.next=4,e.$store.dispatch(y.Nw.SET_SETTING,{key:"viewMode",value:"grid"===e.$store.state.viewMode?"list":"grid"});case 4:case"end":return t.stop()}}),t)})))()}},created:function(){var e=this;return le(se().mark((function n(){var o,r,i;return se().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return o=window.matchMedia("(max-width: 1024px)"),e.smallScreen=o.matches,o.addEventListener("change",e.onWindowFormatChange),OCA.Search&&(e.search=new window.OCA.Search(e.onSearch,e.onResetSearch)),e.$store.commit(y.P$.FETCH_START,{type:"bookmarks"}),n.next=7,e.reloadSettings();case 7:if(e.onRoute(),e.reloadFolders(),e.reloadSharedFolders(),e.reloadCount(),e.reloadTags(),!(0,w.ts)().isAdmin){n.next=19;break}return n.next=16,e.getSettingValue("privacy.enableScraping");case 16:r=n.sent,i=window.localStorage&&window.localStorage.getItem("bookmarks.scrapingNoteShown"),"true"!==r&&"true"!==i&&(window.localStorage&&window.localStorage.setItem("bookmarks.scrapingNoteShown","true"),e.$store.commit(y.P$.SET_NOTIFICATION,t("bookmarks","Network access is disabled by default. Go to administrator settings for the bookmarks app to allow fetching previews and favicons.")));case 19:case"end":return n.stop()}}),n)})))()},methods:{onRoute:function(){var t=this;return le(se().mark((function e(){var n;return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:n=t.$route,t.$store.commit(y.P$.RESET_SELECTION),e.t0=n.name,e.next=e.t0===X.xu.HOME?5:e.t0===X.xu.RECENT?7:e.t0===X.xu.UNTAGGED?9:e.t0===X.xu.UNAVAILABLE?11:e.t0===X.xu.ARCHIVED?13:e.t0===X.xu.DUPLICATED?15:e.t0===X.xu.SHARED_FOLDERS?17:e.t0===X.xu.BOOKMARK?22:e.t0===X.xu.FOLDER?27:e.t0===X.xu.TAGS?29:e.t0===X.xu.SEARCH?31:33;break;case 5:return t.$store.dispatch(y.Nw.FILTER_BY_FOLDER,"-1"),e.abrupt("break",34);case 7:return t.$store.dispatch(y.Nw.FILTER_BY_RECENT),e.abrupt("break",34);case 9:return t.$store.dispatch(y.Nw.FILTER_BY_UNTAGGED),e.abrupt("break",34);case 11:return t.$store.dispatch(y.Nw.FILTER_BY_UNAVAILABLE),e.abrupt("break",34);case 13:return t.$store.dispatch(y.Nw.FILTER_BY_ARCHIVED),e.abrupt("break",34);case 15:return t.$store.dispatch(y.Nw.FILTER_BY_DUPLICATED),e.abrupt("break",34);case 17:return e.next=19,t.$store.dispatch(y.Nw.LOAD_SHARED_FOLDERS);case 19:return t.$store.commit(y.P$.REMOVE_ALL_BOOKMARKS),t.$store.commit(y.P$.FETCH_END,"bookmarks"),e.abrupt("break",34);case 22:return e.next=24,t.$store.dispatch(y.Nw.LOAD_BOOKMARK,n.params.bookmark);case 24:return t.$store.dispatch(y.Nw.OPEN_BOOKMARK,n.params.bookmark),t.$store.commit(y.P$.FETCH_END,"bookmarks"),e.abrupt("break",34);case 27:return t.$store.dispatch(y.Nw.FILTER_BY_FOLDER,n.params.folder),e.abrupt("break",34);case 29:return t.$store.dispatch(y.Nw.FILTER_BY_TAGS,n.params.tags.split(",")),e.abrupt("break",34);case 31:return t.$store.dispatch(y.Nw.FILTER_BY_SEARCH,n.params.search),e.abrupt("break",34);case 33:throw new Error("Nothing here. Move along.");case 34:case"end":return e.stop()}}),e)})))()},reloadTags:function(){var t=this;return le(se().mark((function e(){return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(y.Nw.LOAD_TAGS));case 1:case"end":return e.stop()}}),e)})))()},reloadFolders:function(){var t=this;return le(se().mark((function e(){return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(y.Nw.LOAD_FOLDERS));case 1:case"end":return e.stop()}}),e)})))()},reloadSharedFolders:function(){var t=this;return le(se().mark((function e(){return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(y.Nw.LOAD_SHARED_FOLDERS));case 1:case"end":return e.stop()}}),e)})))()},reloadSettings:function(){var t=this;return le(se().mark((function e(){return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(y.Nw.LOAD_SETTINGS));case 1:case"end":return e.stop()}}),e)})))()},reloadCount:function(){var t=this;return le(se().mark((function e(){return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",Promise.all([t.$store.dispatch(y.Nw.COUNT_BOOKMARKS,-1),t.$store.dispatch(y.Nw.COUNT_UNAVAILABLE),t.$store.dispatch(y.Nw.COUNT_ARCHIVED),t.$store.dispatch(y.Nw.COUNT_DUPLICATED)]));case 1:case"end":return e.stop()}}),e)})))()},onSearch:function(t){this.$router.push({name:X.xu.SEARCH,params:{search:t}})},onResetSearch:function(){this.$router.push({name:X.xu.HOME})},getSettingValue:function(t){return le(se().mark((function e(){var n,o;return se().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.next=2,new Promise((function(e,n){return OCP.AppConfig.getValue("bookmarks",t,null,{success:e,error:n})}));case 2:if("ok"===(n=e.sent).querySelector("status").textContent){e.next=6;break}return ie.error("Failed request",n),e.abrupt("return");case 6:return o=n.querySelector("data"),e.abrupt("return",o.firstElementChild.textContent);case 8:case"end":return e.stop()}}),e)})))()},onWindowFormatChange:function(t){this.smallScreen=t.matches}}};var de=r(84412),he={};he.styleTagTransform=G(),he.setAttributes=$(),he.insert=D().bind(null,"head"),he.domAPI=P(),he.insertStyleElement=M();L()(de.Z,he);de.Z&&de.Z.locals&&de.Z.locals;const pe=(0,H.Z)(ue,(function(){var t=this,e=t._self._c;return e("NcContent",{attrs:{"app-name":"bookmarks"}},[e("Navigation"),t._v(" "),e("NcAppContent",{attrs:{"show-details":t.showDetails},on:{"update:showDetails":function(e){t.showDetails=e},"update:show-details":function(e){t.showDetails=e}},scopedSlots:t._u([t.showFolderOverview?{key:"list",fn:function(){return[e("FolderOverview",{attrs:{"show-details":t.showDetails},on:{"update:showDetails":function(e){t.showDetails=e},"update:show-details":function(e){t.showDetails=e}}})]},proxy:!0}:null,{key:"default",fn:function(){return[e("Controls"),t._v(" "),e("BookmarksList")]},proxy:!0}],null,!0)}),t._v(" "),e("SidebarBookmark"),t._v(" "),e("SidebarFolder"),t._v(" "),e("MoveDialog"),t._v(" "),e("CopyDialog"),t._v(" "),e("LoadingModal"),t._v(" "),e("BookmarkContent")],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-src_components_ViewPrivate_vue.js.map?v=3c6fec318b267de18d52