/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.tikz;

import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.tikz.TikzGraphics;

public class DriverImageTikz
implements UDriver<UImage, TikzGraphics> {
    @Override
    public void draw(UImage shape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        String rawFileName = shape.getRawFileName();
        if (rawFileName != null) {
            double scale = shape.getScale();
            String raw = scale == 1.0 ? "\\includegraphics{" + rawFileName + "}" : "\\includegraphics[scale=" + TikzGraphics.format(scale) + "]{" + rawFileName + "}";
            tikz.appendRaw(x, y, raw);
            return;
        }
        String formula = shape.getFormula();
        if (formula != null) {
            tikz.appendRaw(x, y, formula);
        }
    }
}

