# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.


# This file was generated by libcst.codegen.gen_matcher_classes
from dataclasses import dataclass
from typing import Optional, Sequence, Union
from typing_extensions import Literal
import libcst as cst

from libcst.matchers._matcher_base import AbstractBaseMatcherNodeMeta, BaseMatcherNode, DoNotCareSentinel, DoNotCare, TypeOf, OneOf, AllOf, DoesNotMatch, MatchIfTrue, MatchRegex, MatchMetadata, MatchMetadataIfTrue, ZeroOrMore, AtLeastN, ZeroOrOne, AtMostN, SaveMatchedNode, extract, extractall, findall, matches, replace
from libcst.matchers._decorators import call_if_inside, call_if_not_inside, visit, leave
from libcst.matchers._visitors import MatchDecoratorMismatch, MatcherDecoratableTransformer, MatcherDecoratableVisitor


class _NodeABC(metaclass=AbstractBaseMatcherNodeMeta):
    __slots__ = ()


class BaseAssignTargetExpression(_NodeABC):
    pass


class BaseAugOp(_NodeABC):
    pass


class BaseBinaryOp(_NodeABC):
    pass


class BaseBooleanOp(_NodeABC):
    pass


class BaseComp(_NodeABC):
    pass


class BaseCompOp(_NodeABC):
    pass


class BaseCompoundStatement(_NodeABC):
    pass


class BaseDelTargetExpression(_NodeABC):
    pass


class BaseDict(_NodeABC):
    pass


class BaseDictElement(_NodeABC):
    pass


class BaseElement(_NodeABC):
    pass


class BaseExpression(_NodeABC):
    pass


class BaseFormattedStringContent(_NodeABC):
    pass


class BaseList(_NodeABC):
    pass


class BaseMetadataProvider(_NodeABC):
    pass


class BaseNumber(_NodeABC):
    pass


class BaseParenthesizableWhitespace(_NodeABC):
    pass


class BaseSet(_NodeABC):
    pass


class BaseSimpleComp(_NodeABC):
    pass


class BaseSlice(_NodeABC):
    pass


class BaseSmallStatement(_NodeABC):
    pass


class BaseStatement(_NodeABC):
    pass


class BaseString(_NodeABC):
    pass


class BaseSuite(_NodeABC):
    pass


class BaseUnaryOp(_NodeABC):
    pass


MetadataMatchType = Union[MatchMetadata, MatchMetadataIfTrue]


BaseParenthesizableWhitespaceMatchType = Union['BaseParenthesizableWhitespace', MetadataMatchType, MatchIfTrue[cst.BaseParenthesizableWhitespace]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Add(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AddAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class And(BaseBooleanOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseAssignTargetExpressionMatchType = Union['BaseAssignTargetExpression', MetadataMatchType, MatchIfTrue[cst.BaseAssignTargetExpression]]
AnnotationMatchType = Union['Annotation', MetadataMatchType, MatchIfTrue[cst.Annotation]]
AssignEqualMatchType = Union['AssignEqual', MetadataMatchType, MatchIfTrue[cst.AssignEqual]]
SemicolonMatchType = Union['Semicolon', MetadataMatchType, MatchIfTrue[cst.Semicolon]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AnnAssign(BaseSmallStatement, BaseMatcherNode):
    target: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    annotation: Union[AnnotationMatchType, DoNotCareSentinel, OneOf[AnnotationMatchType], AllOf[AnnotationMatchType]] = DoNotCare()
    value: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    equal: Union[AssignEqualMatchType, DoNotCareSentinel, OneOf[AssignEqualMatchType], AllOf[AssignEqualMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseExpressionMatchType = Union['BaseExpression', MetadataMatchType, MatchIfTrue[cst.BaseExpression]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Annotation(BaseMatcherNode):
    annotation: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    whitespace_before_indicator: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_indicator: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


CommaMatchType = Union['Comma', MetadataMatchType, MatchIfTrue[cst.Comma]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Arg(BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    keyword: Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]], DoNotCareSentinel, OneOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]], AllOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]]] = DoNotCare()
    equal: Union[AssignEqualMatchType, DoNotCareSentinel, OneOf[AssignEqualMatchType], AllOf[AssignEqualMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    star: Union[Literal["", "*", "**"], MetadataMatchType, MatchIfTrue[Literal["", "*", "**"]], DoNotCareSentinel, OneOf[Union[Literal["", "*", "**"], MetadataMatchType, MatchIfTrue[Literal["", "*", "**"]]]], AllOf[Union[Literal["", "*", "**"], MetadataMatchType, MatchIfTrue[Literal["", "*", "**"]]]]] = DoNotCare()
    whitespace_after_star: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_arg: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


NameOrTupleOrListMatchType = Union['Name', 'Tuple', 'List', MetadataMatchType, MatchIfTrue[Union[cst.Name, cst.Tuple, cst.List]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AsName(BaseMatcherNode):
    name: Union[NameOrTupleOrListMatchType, DoNotCareSentinel, OneOf[NameOrTupleOrListMatchType], AllOf[NameOrTupleOrListMatchType]] = DoNotCare()
    whitespace_before_as: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_as: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


SimpleWhitespaceMatchType = Union['SimpleWhitespace', MetadataMatchType, MatchIfTrue[cst.SimpleWhitespace]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Assert(BaseSmallStatement, BaseMatcherNode):
    test: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    msg: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_after_assert: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


AssignTargetMatchType = Union['AssignTarget', MetadataMatchType, MatchIfTrue[cst.AssignTarget]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Assign(BaseSmallStatement, BaseMatcherNode):
    targets: Union[Sequence[Union[AssignTargetMatchType, DoNotCareSentinel, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType], AtLeastN[Union[AssignTargetMatchType, DoNotCareSentinel, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]], AtMostN[Union[AssignTargetMatchType, DoNotCareSentinel, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.AssignTarget]], OneOf[Union[Sequence[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType], AtLeastN[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]], AtMostN[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]]]], MatchIfTrue[Sequence[cst.AssignTarget]]]], AllOf[Union[Sequence[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType], AtLeastN[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]], AtMostN[Union[AssignTargetMatchType, OneOf[AssignTargetMatchType], AllOf[AssignTargetMatchType]]]]], MatchIfTrue[Sequence[cst.AssignTarget]]]]] = DoNotCare()
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AssignEqual(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AssignTarget(BaseMatcherNode):
    target: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    whitespace_before_equal: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_equal: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Asynchronous(BaseMatcherNode):
    whitespace_after: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


NameMatchType = Union['Name', MetadataMatchType, MatchIfTrue[cst.Name]]
DotMatchType = Union['Dot', MetadataMatchType, MatchIfTrue[cst.Dot]]
LeftParenMatchType = Union['LeftParen', MetadataMatchType, MatchIfTrue[cst.LeftParen]]
RightParenMatchType = Union['RightParen', MetadataMatchType, MatchIfTrue[cst.RightParen]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Attribute(BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    attr: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    dot: Union[DotMatchType, DoNotCareSentinel, OneOf[DotMatchType], AllOf[DotMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseAugOpMatchType = Union['BaseAugOp', MetadataMatchType, MatchIfTrue[cst.BaseAugOp]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class AugAssign(BaseSmallStatement, BaseMatcherNode):
    target: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    operator: Union[BaseAugOpMatchType, DoNotCareSentinel, OneOf[BaseAugOpMatchType], AllOf[BaseAugOpMatchType]] = DoNotCare()
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Await(BaseExpression, BaseMatcherNode):
    expression: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_after_await: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseBinaryOpMatchType = Union['BaseBinaryOp', MetadataMatchType, MatchIfTrue[cst.BaseBinaryOp]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BinaryOperation(BaseExpression, BaseMatcherNode):
    left: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    operator: Union[BaseBinaryOpMatchType, DoNotCareSentinel, OneOf[BaseBinaryOpMatchType], AllOf[BaseBinaryOpMatchType]] = DoNotCare()
    right: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitAnd(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitAndAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitInvert(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitOr(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitOrAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitXor(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BitXorAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseBooleanOpMatchType = Union['BaseBooleanOp', MetadataMatchType, MatchIfTrue[cst.BaseBooleanOp]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class BooleanOperation(BaseExpression, BaseMatcherNode):
    left: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    operator: Union[BaseBooleanOpMatchType, DoNotCareSentinel, OneOf[BaseBooleanOpMatchType], AllOf[BaseBooleanOpMatchType]] = DoNotCare()
    right: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Break(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ArgMatchType = Union['Arg', MetadataMatchType, MatchIfTrue[cst.Arg]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Call(BaseExpression, BaseMatcherNode):
    func: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    args: Union[Sequence[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Arg]], OneOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]], AllOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_after_func: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_args: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseSuiteMatchType = Union['BaseSuite', MetadataMatchType, MatchIfTrue[cst.BaseSuite]]
DecoratorMatchType = Union['Decorator', MetadataMatchType, MatchIfTrue[cst.Decorator]]
EmptyLineMatchType = Union['EmptyLine', MetadataMatchType, MatchIfTrue[cst.EmptyLine]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ClassDef(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    name: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    bases: Union[Sequence[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Arg]], OneOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]], AllOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]]] = DoNotCare()
    keywords: Union[Sequence[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, DoNotCareSentinel, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Arg]], OneOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]], AllOf[Union[Sequence[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType], AtLeastN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]], AtMostN[Union[ArgMatchType, OneOf[ArgMatchType], AllOf[ArgMatchType]]]]], MatchIfTrue[Sequence[cst.Arg]]]]] = DoNotCare()
    decorators: Union[Sequence[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Decorator]], OneOf[Union[Sequence[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], MatchIfTrue[Sequence[cst.Decorator]]]], AllOf[Union[Sequence[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], MatchIfTrue[Sequence[cst.Decorator]]]]] = DoNotCare()
    lpar: Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]] = DoNotCare()
    rpar: Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    lines_after_decorators: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_class: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_name: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Colon(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comma(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


strMatchType = Union[str, MetadataMatchType, MatchIfTrue[str]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comment(BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


CompIfMatchType = Union['CompIf', MetadataMatchType, MatchIfTrue[cst.CompIf]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class CompFor(BaseMatcherNode):
    target: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    iter: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    ifs: Union[Sequence[Union[CompIfMatchType, DoNotCareSentinel, OneOf[CompIfMatchType], AllOf[CompIfMatchType], AtLeastN[Union[CompIfMatchType, DoNotCareSentinel, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]], AtMostN[Union[CompIfMatchType, DoNotCareSentinel, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.CompIf]], OneOf[Union[Sequence[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType], AtLeastN[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]], AtMostN[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]]]], MatchIfTrue[Sequence[cst.CompIf]]]], AllOf[Union[Sequence[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType], AtLeastN[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]], AtMostN[Union[CompIfMatchType, OneOf[CompIfMatchType], AllOf[CompIfMatchType]]]]], MatchIfTrue[Sequence[cst.CompIf]]]]] = DoNotCare()
    inner_for_in: Union[Optional["CompFor"], MetadataMatchType, MatchIfTrue[Optional[cst.CompFor]], DoNotCareSentinel, OneOf[Union[Optional["CompFor"], MetadataMatchType, MatchIfTrue[Optional[cst.CompFor]]]], AllOf[Union[Optional["CompFor"], MetadataMatchType, MatchIfTrue[Optional[cst.CompFor]]]]] = DoNotCare()
    asynchronous: Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]], DoNotCareSentinel, OneOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]], AllOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]]] = DoNotCare()
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_for: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_in: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_in: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class CompIf(BaseMatcherNode):
    test: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_test: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ComparisonTargetMatchType = Union['ComparisonTarget', MetadataMatchType, MatchIfTrue[cst.ComparisonTarget]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Comparison(BaseExpression, BaseMatcherNode):
    left: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    comparisons: Union[Sequence[Union[ComparisonTargetMatchType, DoNotCareSentinel, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType], AtLeastN[Union[ComparisonTargetMatchType, DoNotCareSentinel, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]], AtMostN[Union[ComparisonTargetMatchType, DoNotCareSentinel, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.ComparisonTarget]], OneOf[Union[Sequence[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType], AtLeastN[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]], AtMostN[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]]]], MatchIfTrue[Sequence[cst.ComparisonTarget]]]], AllOf[Union[Sequence[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType], AtLeastN[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]], AtMostN[Union[ComparisonTargetMatchType, OneOf[ComparisonTargetMatchType], AllOf[ComparisonTargetMatchType]]]]], MatchIfTrue[Sequence[cst.ComparisonTarget]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseCompOpMatchType = Union['BaseCompOp', MetadataMatchType, MatchIfTrue[cst.BaseCompOp]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ComparisonTarget(BaseMatcherNode):
    operator: Union[BaseCompOpMatchType, DoNotCareSentinel, OneOf[BaseCompOpMatchType], AllOf[BaseCompOpMatchType]] = DoNotCare()
    comparator: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


SimpleStringOrFormattedStringMatchType = Union['SimpleString', 'FormattedString', MetadataMatchType, MatchIfTrue[Union[cst.SimpleString, cst.FormattedString]]]
SimpleStringOrFormattedStringOrConcatenatedStringMatchType = Union['SimpleString', 'FormattedString', 'ConcatenatedString', MetadataMatchType, MatchIfTrue[Union[cst.SimpleString, cst.FormattedString, cst.ConcatenatedString]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ConcatenatedString(BaseExpression, BaseString, BaseMatcherNode):
    left: Union[SimpleStringOrFormattedStringMatchType, DoNotCareSentinel, OneOf[SimpleStringOrFormattedStringMatchType], AllOf[SimpleStringOrFormattedStringMatchType]] = DoNotCare()
    right: Union[SimpleStringOrFormattedStringOrConcatenatedStringMatchType, DoNotCareSentinel, OneOf[SimpleStringOrFormattedStringOrConcatenatedStringMatchType], AllOf[SimpleStringOrFormattedStringOrConcatenatedStringMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_between: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Continue(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


NameOrAttributeOrCallMatchType = Union['Name', 'Attribute', 'Call', MetadataMatchType, MatchIfTrue[Union[cst.Name, cst.Attribute, cst.Call]]]
TrailingWhitespaceMatchType = Union['TrailingWhitespace', MetadataMatchType, MatchIfTrue[cst.TrailingWhitespace]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Decorator(BaseMatcherNode):
    decorator: Union[NameOrAttributeOrCallMatchType, DoNotCareSentinel, OneOf[NameOrAttributeOrCallMatchType], AllOf[NameOrAttributeOrCallMatchType]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_at: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    trailing_whitespace: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseDelTargetExpressionMatchType = Union['BaseDelTargetExpression', MetadataMatchType, MatchIfTrue[cst.BaseDelTargetExpression]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Del(BaseSmallStatement, BaseMatcherNode):
    target: Union[BaseDelTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseDelTargetExpressionMatchType], AllOf[BaseDelTargetExpressionMatchType]] = DoNotCare()
    whitespace_after_del: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseDictElementMatchType = Union['BaseDictElement', MetadataMatchType, MatchIfTrue[cst.BaseDictElement]]
LeftCurlyBraceMatchType = Union['LeftCurlyBrace', MetadataMatchType, MatchIfTrue[cst.LeftCurlyBrace]]
RightCurlyBraceMatchType = Union['RightCurlyBrace', MetadataMatchType, MatchIfTrue[cst.RightCurlyBrace]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Dict(BaseDict, BaseExpression, BaseMatcherNode):
    elements: Union[Sequence[Union[BaseDictElementMatchType, DoNotCareSentinel, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType], AtLeastN[Union[BaseDictElementMatchType, DoNotCareSentinel, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]], AtMostN[Union[BaseDictElementMatchType, DoNotCareSentinel, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseDictElement]], OneOf[Union[Sequence[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType], AtLeastN[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]], AtMostN[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseDictElement]]]], AllOf[Union[Sequence[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType], AtLeastN[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]], AtMostN[Union[BaseDictElementMatchType, OneOf[BaseDictElementMatchType], AllOf[BaseDictElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseDictElement]]]]] = DoNotCare()
    lbrace: Union[LeftCurlyBraceMatchType, DoNotCareSentinel, OneOf[LeftCurlyBraceMatchType], AllOf[LeftCurlyBraceMatchType]] = DoNotCare()
    rbrace: Union[RightCurlyBraceMatchType, DoNotCareSentinel, OneOf[RightCurlyBraceMatchType], AllOf[RightCurlyBraceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


CompForMatchType = Union['CompFor', MetadataMatchType, MatchIfTrue[cst.CompFor]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DictComp(BaseComp, BaseDict, BaseExpression, BaseMatcherNode):
    key: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    value: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    for_in: Union[CompForMatchType, DoNotCareSentinel, OneOf[CompForMatchType], AllOf[CompForMatchType]] = DoNotCare()
    lbrace: Union[LeftCurlyBraceMatchType, DoNotCareSentinel, OneOf[LeftCurlyBraceMatchType], AllOf[LeftCurlyBraceMatchType]] = DoNotCare()
    rbrace: Union[RightCurlyBraceMatchType, DoNotCareSentinel, OneOf[RightCurlyBraceMatchType], AllOf[RightCurlyBraceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_before_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DictElement(BaseDictElement, BaseMatcherNode):
    key: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_before_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Divide(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class DivideAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Dot(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Element(BaseElement, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Ellipsis(BaseExpression, BaseMatcherNode):
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Else(BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


boolMatchType = Union[bool, MetadataMatchType, MatchIfTrue[bool]]
NewlineMatchType = Union['Newline', MetadataMatchType, MatchIfTrue[cst.Newline]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class EmptyLine(BaseMatcherNode):
    indent: Union[boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]] = DoNotCare()
    whitespace: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    comment: Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]], DoNotCareSentinel, OneOf[Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]]]], AllOf[Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]]]]] = DoNotCare()
    newline: Union[NewlineMatchType, DoNotCareSentinel, OneOf[NewlineMatchType], AllOf[NewlineMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Equal(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ExceptHandler(BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    type: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    name: Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]], DoNotCareSentinel, OneOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]], AllOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_except: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ExceptStarHandler(BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    type: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    name: Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]], DoNotCareSentinel, OneOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]], AllOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_except: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_star: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Expr(BaseSmallStatement, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Finally(BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Float(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FloorDivide(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FloorDivideAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class For(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    target: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    iter: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    orelse: Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]], DoNotCareSentinel, OneOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]], AllOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]]] = DoNotCare()
    asynchronous: Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]], DoNotCareSentinel, OneOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]], AllOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_for: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_in: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_in: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseFormattedStringContentMatchType = Union['BaseFormattedStringContent', MetadataMatchType, MatchIfTrue[cst.BaseFormattedStringContent]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedString(BaseExpression, BaseString, BaseMatcherNode):
    parts: Union[Sequence[Union[BaseFormattedStringContentMatchType, DoNotCareSentinel, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType], AtLeastN[Union[BaseFormattedStringContentMatchType, DoNotCareSentinel, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]], AtMostN[Union[BaseFormattedStringContentMatchType, DoNotCareSentinel, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseFormattedStringContent]], OneOf[Union[Sequence[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType], AtLeastN[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]], AtMostN[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]]]], MatchIfTrue[Sequence[cst.BaseFormattedStringContent]]]], AllOf[Union[Sequence[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType], AtLeastN[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]], AtMostN[Union[BaseFormattedStringContentMatchType, OneOf[BaseFormattedStringContentMatchType], AllOf[BaseFormattedStringContentMatchType]]]]], MatchIfTrue[Sequence[cst.BaseFormattedStringContent]]]]] = DoNotCare()
    start: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    end: Union[Literal['"', "'", '"""', "'''"], MetadataMatchType, MatchIfTrue[Literal['"', "'", '"""', "'''"]], DoNotCareSentinel, OneOf[Union[Literal['"', "'", '"""', "'''"], MetadataMatchType, MatchIfTrue[Literal['"', "'", '"""', "'''"]]]], AllOf[Union[Literal['"', "'", '"""', "'''"], MetadataMatchType, MatchIfTrue[Literal['"', "'", '"""', "'''"]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedStringExpression(BaseFormattedStringContent, BaseMatcherNode):
    expression: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    conversion: Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]], DoNotCareSentinel, OneOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]], AllOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]]] = DoNotCare()
    format_spec: Union[Optional[Sequence["BaseFormattedStringContent"]], MetadataMatchType, MatchIfTrue[Optional[Sequence[cst.BaseFormattedStringContent]]], DoNotCareSentinel, OneOf[Union[Optional[Sequence["BaseFormattedStringContent"]], MetadataMatchType, MatchIfTrue[Optional[Sequence[cst.BaseFormattedStringContent]]]]], AllOf[Union[Optional[Sequence["BaseFormattedStringContent"]], MetadataMatchType, MatchIfTrue[Optional[Sequence[cst.BaseFormattedStringContent]]]]]] = DoNotCare()
    whitespace_before_expression: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_expression: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    equal: Union[Optional["AssignEqual"], MetadataMatchType, MatchIfTrue[Optional[cst.AssignEqual]], DoNotCareSentinel, OneOf[Union[Optional["AssignEqual"], MetadataMatchType, MatchIfTrue[Optional[cst.AssignEqual]]]], AllOf[Union[Optional["AssignEqual"], MetadataMatchType, MatchIfTrue[Optional[cst.AssignEqual]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FormattedStringText(BaseFormattedStringContent, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class From(BaseMatcherNode):
    item: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    whitespace_before_from: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_from: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ParametersMatchType = Union['Parameters', MetadataMatchType, MatchIfTrue[cst.Parameters]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class FunctionDef(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    name: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    params: Union[ParametersMatchType, DoNotCareSentinel, OneOf[ParametersMatchType], AllOf[ParametersMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    decorators: Union[Sequence[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, DoNotCareSentinel, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Decorator]], OneOf[Union[Sequence[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], MatchIfTrue[Sequence[cst.Decorator]]]], AllOf[Union[Sequence[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType], AtLeastN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]], AtMostN[Union[DecoratorMatchType, OneOf[DecoratorMatchType], AllOf[DecoratorMatchType]]]]], MatchIfTrue[Sequence[cst.Decorator]]]]] = DoNotCare()
    returns: Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]], DoNotCareSentinel, OneOf[Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]]]], AllOf[Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]]]]] = DoNotCare()
    asynchronous: Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]], DoNotCareSentinel, OneOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]], AllOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    lines_after_decorators: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_def: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_name: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_params: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GeneratorExp(BaseComp, BaseExpression, BaseSimpleComp, BaseMatcherNode):
    elt: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    for_in: Union[CompForMatchType, DoNotCareSentinel, OneOf[CompForMatchType], AllOf[CompForMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


NameItemMatchType = Union['NameItem', MetadataMatchType, MatchIfTrue[cst.NameItem]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Global(BaseSmallStatement, BaseMatcherNode):
    names: Union[Sequence[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.NameItem]], OneOf[Union[Sequence[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], MatchIfTrue[Sequence[cst.NameItem]]]], AllOf[Union[Sequence[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], MatchIfTrue[Sequence[cst.NameItem]]]]] = DoNotCare()
    whitespace_after_global: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GreaterThan(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class GreaterThanEqual(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


IfOrElseOrNoneMatchType = Union['If', 'Else', None, MetadataMatchType, MatchIfTrue[Union[cst.If, cst.Else, None]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class If(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    test: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    orelse: Union[IfOrElseOrNoneMatchType, DoNotCareSentinel, OneOf[IfOrElseOrNoneMatchType], AllOf[IfOrElseOrNoneMatchType]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_before_test: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_test: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IfExp(BaseExpression, BaseMatcherNode):
    test: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    body: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    orelse: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_before_if: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_if: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_else: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_else: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Imaginary(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ImportAliasMatchType = Union['ImportAlias', MetadataMatchType, MatchIfTrue[cst.ImportAlias]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Import(BaseSmallStatement, BaseMatcherNode):
    names: Union[Sequence[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.ImportAlias]], OneOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]], AllOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    whitespace_after_import: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


AttributeOrNameMatchType = Union['Attribute', 'Name', MetadataMatchType, MatchIfTrue[Union[cst.Attribute, cst.Name]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportAlias(BaseMatcherNode):
    name: Union[AttributeOrNameMatchType, DoNotCareSentinel, OneOf[AttributeOrNameMatchType], AllOf[AttributeOrNameMatchType]] = DoNotCare()
    asname: Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]], DoNotCareSentinel, OneOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]], AllOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


AttributeOrNameOrNoneMatchType = Union['Attribute', 'Name', None, MetadataMatchType, MatchIfTrue[Union[cst.Attribute, cst.Name, None]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportFrom(BaseSmallStatement, BaseMatcherNode):
    module: Union[AttributeOrNameOrNoneMatchType, DoNotCareSentinel, OneOf[AttributeOrNameOrNoneMatchType], AllOf[AttributeOrNameOrNoneMatchType]] = DoNotCare()
    names: Union[Union[Sequence[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, DoNotCareSentinel, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.ImportAlias]], OneOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]], AllOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]]], "ImportStar", MetadataMatchType, MatchIfTrue[Union[Sequence[cst.ImportAlias], cst.ImportStar, OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]], AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]]]], DoNotCareSentinel, OneOf[Union[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]], OneOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]], AllOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]]], "ImportStar", MetadataMatchType, MatchIfTrue[Union[Sequence[cst.ImportAlias], cst.ImportStar, OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]], AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]]]]]], AllOf[Union[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]], OneOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]], AllOf[Union[Sequence[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType], AtLeastN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]], AtMostN[Union[ImportAliasMatchType, OneOf[ImportAliasMatchType], AllOf[ImportAliasMatchType]]]]], MatchIfTrue[Sequence[cst.ImportAlias]]]]], "ImportStar", MetadataMatchType, MatchIfTrue[Union[Sequence[cst.ImportAlias], cst.ImportStar, OneOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]], AllOf[Union[Sequence[cst.ImportAlias], cst.ImportStar]]]]]]] = DoNotCare()
    relative: Union[Sequence[Union[DotMatchType, DoNotCareSentinel, OneOf[DotMatchType], AllOf[DotMatchType], AtLeastN[Union[DotMatchType, DoNotCareSentinel, OneOf[DotMatchType], AllOf[DotMatchType]]], AtMostN[Union[DotMatchType, DoNotCareSentinel, OneOf[DotMatchType], AllOf[DotMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Dot]], OneOf[Union[Sequence[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType], AtLeastN[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]]], AtMostN[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]]]]], MatchIfTrue[Sequence[cst.Dot]]]], AllOf[Union[Sequence[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType], AtLeastN[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]]], AtMostN[Union[DotMatchType, OneOf[DotMatchType], AllOf[DotMatchType]]]]], MatchIfTrue[Sequence[cst.Dot]]]]] = DoNotCare()
    lpar: Union[Optional["LeftParen"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftParen]], DoNotCareSentinel, OneOf[Union[Optional["LeftParen"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftParen]]]], AllOf[Union[Optional["LeftParen"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Optional["RightParen"], MetadataMatchType, MatchIfTrue[Optional[cst.RightParen]], DoNotCareSentinel, OneOf[Union[Optional["RightParen"], MetadataMatchType, MatchIfTrue[Optional[cst.RightParen]]]], AllOf[Union[Optional["RightParen"], MetadataMatchType, MatchIfTrue[Optional[cst.RightParen]]]]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    whitespace_after_from: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_import: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_import: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ImportStar(BaseMatcherNode):
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class In(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseStatementMatchType = Union['BaseStatement', MetadataMatchType, MatchIfTrue[cst.BaseStatement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IndentedBlock(BaseSuite, BaseMatcherNode):
    body: Union[Sequence[Union[BaseStatementMatchType, DoNotCareSentinel, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType], AtLeastN[Union[BaseStatementMatchType, DoNotCareSentinel, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]], AtMostN[Union[BaseStatementMatchType, DoNotCareSentinel, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseStatement]], OneOf[Union[Sequence[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType], AtLeastN[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]], AtMostN[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseStatement]]]], AllOf[Union[Sequence[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType], AtLeastN[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]], AtMostN[Union[BaseStatementMatchType, OneOf[BaseStatementMatchType], AllOf[BaseStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseStatement]]]]] = DoNotCare()
    header: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    indent: Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]], DoNotCareSentinel, OneOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]], AllOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]]] = DoNotCare()
    footer: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Index(BaseSlice, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    star: Union[Optional[Literal["*"]], MetadataMatchType, MatchIfTrue[Optional[Literal["*"]]], DoNotCareSentinel, OneOf[Union[Optional[Literal["*"]], MetadataMatchType, MatchIfTrue[Optional[Literal["*"]]]]], AllOf[Union[Optional[Literal["*"]], MetadataMatchType, MatchIfTrue[Optional[Literal["*"]]]]]] = DoNotCare()
    whitespace_after_star: Union[Optional["BaseParenthesizableWhitespace"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseParenthesizableWhitespace]], DoNotCareSentinel, OneOf[Union[Optional["BaseParenthesizableWhitespace"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseParenthesizableWhitespace]]]], AllOf[Union[Optional["BaseParenthesizableWhitespace"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseParenthesizableWhitespace]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Integer(BaseExpression, BaseNumber, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Is(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class IsNot(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_between: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ColonMatchType = Union['Colon', MetadataMatchType, MatchIfTrue[cst.Colon]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Lambda(BaseExpression, BaseMatcherNode):
    params: Union[ParametersMatchType, DoNotCareSentinel, OneOf[ParametersMatchType], AllOf[ParametersMatchType]] = DoNotCare()
    body: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    colon: Union[ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_after_lambda: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftCurlyBrace(BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftParen(BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftShift(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftShiftAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LeftSquareBracket(BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LessThan(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class LessThanEqual(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseElementMatchType = Union['BaseElement', MetadataMatchType, MatchIfTrue[cst.BaseElement]]
LeftSquareBracketMatchType = Union['LeftSquareBracket', MetadataMatchType, MatchIfTrue[cst.LeftSquareBracket]]
RightSquareBracketMatchType = Union['RightSquareBracket', MetadataMatchType, MatchIfTrue[cst.RightSquareBracket]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class List(BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseList, BaseMatcherNode):
    elements: Union[Sequence[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseElement]], OneOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]], AllOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]]] = DoNotCare()
    lbracket: Union[LeftSquareBracketMatchType, DoNotCareSentinel, OneOf[LeftSquareBracketMatchType], AllOf[LeftSquareBracketMatchType]] = DoNotCare()
    rbracket: Union[RightSquareBracketMatchType, DoNotCareSentinel, OneOf[RightSquareBracketMatchType], AllOf[RightSquareBracketMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ListComp(BaseComp, BaseExpression, BaseList, BaseSimpleComp, BaseMatcherNode):
    elt: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    for_in: Union[CompForMatchType, DoNotCareSentinel, OneOf[CompForMatchType], AllOf[CompForMatchType]] = DoNotCare()
    lbracket: Union[LeftSquareBracketMatchType, DoNotCareSentinel, OneOf[LeftSquareBracketMatchType], AllOf[LeftSquareBracketMatchType]] = DoNotCare()
    rbracket: Union[RightSquareBracketMatchType, DoNotCareSentinel, OneOf[RightSquareBracketMatchType], AllOf[RightSquareBracketMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchCaseMatchType = Union['MatchCase', MetadataMatchType, MatchIfTrue[cst.MatchCase]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Match(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    subject: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    cases: Union[Sequence[Union[MatchCaseMatchType, DoNotCareSentinel, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType], AtLeastN[Union[MatchCaseMatchType, DoNotCareSentinel, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]], AtMostN[Union[MatchCaseMatchType, DoNotCareSentinel, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.MatchCase]], OneOf[Union[Sequence[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType], AtLeastN[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]], AtMostN[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]]]], MatchIfTrue[Sequence[cst.MatchCase]]]], AllOf[Union[Sequence[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType], AtLeastN[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]], AtMostN[Union[MatchCaseMatchType, OneOf[MatchCaseMatchType], AllOf[MatchCaseMatchType]]]]], MatchIfTrue[Sequence[cst.MatchCase]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_match: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_colon: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    indent: Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]], DoNotCareSentinel, OneOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]], AllOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]]] = DoNotCare()
    footer: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchAs(BaseMatcherNode):
    pattern: Union[Optional["MatchPattern"], MetadataMatchType, MatchIfTrue[Optional[cst.MatchPattern]], DoNotCareSentinel, OneOf[Union[Optional["MatchPattern"], MetadataMatchType, MatchIfTrue[Optional[cst.MatchPattern]]]], AllOf[Union[Optional["MatchPattern"], MetadataMatchType, MatchIfTrue[Optional[cst.MatchPattern]]]]] = DoNotCare()
    name: Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]], DoNotCareSentinel, OneOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]], AllOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]]] = DoNotCare()
    whitespace_before_as: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_as: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchPatternMatchType = Union['MatchPattern', MetadataMatchType, MatchIfTrue[cst.MatchPattern]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchCase(BaseMatcherNode):
    pattern: Union[MatchPatternMatchType, DoNotCareSentinel, OneOf[MatchPatternMatchType], AllOf[MatchPatternMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    guard: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_case: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_if: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_after_if: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchSequenceElementMatchType = Union['MatchSequenceElement', MetadataMatchType, MatchIfTrue[cst.MatchSequenceElement]]
MatchKeywordElementMatchType = Union['MatchKeywordElement', MetadataMatchType, MatchIfTrue[cst.MatchKeywordElement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchClass(BaseMatcherNode):
    cls: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    patterns: Union[Sequence[Union[MatchSequenceElementMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType], AtLeastN[Union[MatchSequenceElementMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]], AtMostN[Union[MatchSequenceElementMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.MatchSequenceElement]], OneOf[Union[Sequence[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType], AtLeastN[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]], AtMostN[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchSequenceElement]]]], AllOf[Union[Sequence[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType], AtLeastN[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]], AtMostN[Union[MatchSequenceElementMatchType, OneOf[MatchSequenceElementMatchType], AllOf[MatchSequenceElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchSequenceElement]]]]] = DoNotCare()
    kwds: Union[Sequence[Union[MatchKeywordElementMatchType, DoNotCareSentinel, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType], AtLeastN[Union[MatchKeywordElementMatchType, DoNotCareSentinel, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]], AtMostN[Union[MatchKeywordElementMatchType, DoNotCareSentinel, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.MatchKeywordElement]], OneOf[Union[Sequence[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType], AtLeastN[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]], AtMostN[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchKeywordElement]]]], AllOf[Union[Sequence[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType], AtLeastN[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]], AtMostN[Union[MatchKeywordElementMatchType, OneOf[MatchKeywordElementMatchType], AllOf[MatchKeywordElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchKeywordElement]]]]] = DoNotCare()
    whitespace_after_cls: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_before_patterns: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_kwds: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchKeywordElement(BaseMatcherNode):
    key: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    pattern: Union[MatchPatternMatchType, DoNotCareSentinel, OneOf[MatchPatternMatchType], AllOf[MatchPatternMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_before_equal: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_equal: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchSequenceElementOrMatchStarMatchType = Union['MatchSequenceElement', 'MatchStar', MetadataMatchType, MatchIfTrue[Union[cst.MatchSequenceElement, cst.MatchStar]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchList(BaseMatcherNode):
    patterns: Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]], OneOf[Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]]]], AllOf[Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]]]]] = DoNotCare()
    lbracket: Union[Optional["LeftSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftSquareBracket]], DoNotCareSentinel, OneOf[Union[Optional["LeftSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftSquareBracket]]]], AllOf[Union[Optional["LeftSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.LeftSquareBracket]]]]] = DoNotCare()
    rbracket: Union[Optional["RightSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.RightSquareBracket]], DoNotCareSentinel, OneOf[Union[Optional["RightSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.RightSquareBracket]]]], AllOf[Union[Optional["RightSquareBracket"], MetadataMatchType, MatchIfTrue[Optional[cst.RightSquareBracket]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchMappingElementMatchType = Union['MatchMappingElement', MetadataMatchType, MatchIfTrue[cst.MatchMappingElement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchMapping(BaseMatcherNode):
    elements: Union[Sequence[Union[MatchMappingElementMatchType, DoNotCareSentinel, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType], AtLeastN[Union[MatchMappingElementMatchType, DoNotCareSentinel, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]], AtMostN[Union[MatchMappingElementMatchType, DoNotCareSentinel, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.MatchMappingElement]], OneOf[Union[Sequence[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType], AtLeastN[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]], AtMostN[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchMappingElement]]]], AllOf[Union[Sequence[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType], AtLeastN[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]], AtMostN[Union[MatchMappingElementMatchType, OneOf[MatchMappingElementMatchType], AllOf[MatchMappingElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchMappingElement]]]]] = DoNotCare()
    lbrace: Union[LeftCurlyBraceMatchType, DoNotCareSentinel, OneOf[LeftCurlyBraceMatchType], AllOf[LeftCurlyBraceMatchType]] = DoNotCare()
    rbrace: Union[RightCurlyBraceMatchType, DoNotCareSentinel, OneOf[RightCurlyBraceMatchType], AllOf[RightCurlyBraceMatchType]] = DoNotCare()
    rest: Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]], DoNotCareSentinel, OneOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]], AllOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]]] = DoNotCare()
    whitespace_before_rest: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    trailing_comma: Union[Optional["Comma"], MetadataMatchType, MatchIfTrue[Optional[cst.Comma]], DoNotCareSentinel, OneOf[Union[Optional["Comma"], MetadataMatchType, MatchIfTrue[Optional[cst.Comma]]]], AllOf[Union[Optional["Comma"], MetadataMatchType, MatchIfTrue[Optional[cst.Comma]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchMappingElement(BaseMatcherNode):
    key: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    pattern: Union[MatchPatternMatchType, DoNotCareSentinel, OneOf[MatchPatternMatchType], AllOf[MatchPatternMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_before_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_colon: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


MatchOrElementMatchType = Union['MatchOrElement', MetadataMatchType, MatchIfTrue[cst.MatchOrElement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchOr(BaseMatcherNode):
    patterns: Union[Sequence[Union[MatchOrElementMatchType, DoNotCareSentinel, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType], AtLeastN[Union[MatchOrElementMatchType, DoNotCareSentinel, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]], AtMostN[Union[MatchOrElementMatchType, DoNotCareSentinel, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.MatchOrElement]], OneOf[Union[Sequence[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType], AtLeastN[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]], AtMostN[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchOrElement]]]], AllOf[Union[Sequence[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType], AtLeastN[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]], AtMostN[Union[MatchOrElementMatchType, OneOf[MatchOrElementMatchType], AllOf[MatchOrElementMatchType]]]]], MatchIfTrue[Sequence[cst.MatchOrElement]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BitOrMatchType = Union['BitOr', MetadataMatchType, MatchIfTrue[cst.BitOr]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchOrElement(BaseMatcherNode):
    pattern: Union[MatchPatternMatchType, DoNotCareSentinel, OneOf[MatchPatternMatchType], AllOf[MatchPatternMatchType]] = DoNotCare()
    separator: Union[BitOrMatchType, DoNotCareSentinel, OneOf[BitOrMatchType], AllOf[BitOrMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchPattern(BaseMatcherNode):
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchSequence(BaseMatcherNode):
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchSequenceElement(BaseMatcherNode):
    value: Union[MatchPatternMatchType, DoNotCareSentinel, OneOf[MatchPatternMatchType], AllOf[MatchPatternMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchSingleton(BaseMatcherNode):
    value: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchStar(BaseMatcherNode):
    name: Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]], DoNotCareSentinel, OneOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]], AllOf[Union[Optional["Name"], MetadataMatchType, MatchIfTrue[Optional[cst.Name]]]]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_before_name: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchTuple(BaseMatcherNode):
    patterns: Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, DoNotCareSentinel, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]], OneOf[Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]]]], AllOf[Union[Sequence[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType], AtLeastN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]], AtMostN[Union[MatchSequenceElementOrMatchStarMatchType, OneOf[MatchSequenceElementOrMatchStarMatchType], AllOf[MatchSequenceElementOrMatchStarMatchType]]]]], MatchIfTrue[Sequence[Union[cst.MatchSequenceElement, cst.MatchStar, OneOf[Union[cst.MatchSequenceElement, cst.MatchStar]], AllOf[Union[cst.MatchSequenceElement, cst.MatchStar]]]]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatchValue(BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatrixMultiply(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MatrixMultiplyAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Minus(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


SimpleStatementLineOrBaseCompoundStatementMatchType = Union['SimpleStatementLine', 'BaseCompoundStatement', MetadataMatchType, MatchIfTrue[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Module(BaseMatcherNode):
    body: Union[Sequence[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, DoNotCareSentinel, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AtLeastN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, DoNotCareSentinel, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]], AtMostN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, DoNotCareSentinel, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement, OneOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]], AllOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]]]]], OneOf[Union[Sequence[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AtLeastN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]], AtMostN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]]]], MatchIfTrue[Sequence[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement, OneOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]], AllOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]]]]]]], AllOf[Union[Sequence[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AtLeastN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]], AtMostN[Union[SimpleStatementLineOrBaseCompoundStatementMatchType, OneOf[SimpleStatementLineOrBaseCompoundStatementMatchType], AllOf[SimpleStatementLineOrBaseCompoundStatementMatchType]]]]], MatchIfTrue[Sequence[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement, OneOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]], AllOf[Union[cst.SimpleStatementLine, cst.BaseCompoundStatement]]]]]]]] = DoNotCare()
    header: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    footer: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    encoding: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    default_indent: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    default_newline: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    has_trailing_newline: Union[boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Modulo(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ModuloAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Multiply(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class MultiplyAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Name(BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NameItem(BaseMatcherNode):
    name: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NamedExpr(BaseExpression, BaseMatcherNode):
    target: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_before_walrus: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_walrus: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Newline(BaseMatcherNode):
    value: Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]], DoNotCareSentinel, OneOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]], AllOf[Union[Optional[str], MetadataMatchType, MatchIfTrue[Optional[str]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Nonlocal(BaseSmallStatement, BaseMatcherNode):
    names: Union[Sequence[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, DoNotCareSentinel, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.NameItem]], OneOf[Union[Sequence[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], MatchIfTrue[Sequence[cst.NameItem]]]], AllOf[Union[Sequence[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType], AtLeastN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]], AtMostN[Union[NameItemMatchType, OneOf[NameItemMatchType], AllOf[NameItemMatchType]]]]], MatchIfTrue[Sequence[cst.NameItem]]]]] = DoNotCare()
    whitespace_after_nonlocal: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Not(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NotEqual(BaseCompOp, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class NotIn(BaseCompOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_between: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Or(BaseBooleanOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Param(BaseMatcherNode):
    name: Union[NameMatchType, DoNotCareSentinel, OneOf[NameMatchType], AllOf[NameMatchType]] = DoNotCare()
    annotation: Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]], DoNotCareSentinel, OneOf[Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]]]], AllOf[Union[Optional["Annotation"], MetadataMatchType, MatchIfTrue[Optional[cst.Annotation]]]]] = DoNotCare()
    equal: Union[AssignEqualMatchType, DoNotCareSentinel, OneOf[AssignEqualMatchType], AllOf[AssignEqualMatchType]] = DoNotCare()
    default: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    star: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    whitespace_after_star: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after_param: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParamSlash(BaseMatcherNode):
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParamStar(BaseMatcherNode):
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ParamMatchType = Union['Param', MetadataMatchType, MatchIfTrue[cst.Param]]
ParamOrParamStarMatchType = Union['Param', 'ParamStar', MetadataMatchType, MatchIfTrue[Union[cst.Param, cst.ParamStar]]]
ParamSlashMatchType = Union['ParamSlash', MetadataMatchType, MatchIfTrue[cst.ParamSlash]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Parameters(BaseMatcherNode):
    params: Union[Sequence[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Param]], OneOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]], AllOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]]] = DoNotCare()
    star_arg: Union[ParamOrParamStarMatchType, DoNotCareSentinel, OneOf[ParamOrParamStarMatchType], AllOf[ParamOrParamStarMatchType]] = DoNotCare()
    kwonly_params: Union[Sequence[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Param]], OneOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]], AllOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]]] = DoNotCare()
    star_kwarg: Union[Optional["Param"], MetadataMatchType, MatchIfTrue[Optional[cst.Param]], DoNotCareSentinel, OneOf[Union[Optional["Param"], MetadataMatchType, MatchIfTrue[Optional[cst.Param]]]], AllOf[Union[Optional["Param"], MetadataMatchType, MatchIfTrue[Optional[cst.Param]]]]] = DoNotCare()
    posonly_params: Union[Sequence[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, DoNotCareSentinel, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.Param]], OneOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]], AllOf[Union[Sequence[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType], AtLeastN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]], AtMostN[Union[ParamMatchType, OneOf[ParamMatchType], AllOf[ParamMatchType]]]]], MatchIfTrue[Sequence[cst.Param]]]]] = DoNotCare()
    posonly_ind: Union[ParamSlashMatchType, DoNotCareSentinel, OneOf[ParamSlashMatchType], AllOf[ParamSlashMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class ParenthesizedWhitespace(BaseParenthesizableWhitespace, BaseMatcherNode):
    first_line: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    empty_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    indent: Union[boolMatchType, DoNotCareSentinel, OneOf[boolMatchType], AllOf[boolMatchType]] = DoNotCare()
    last_line: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Pass(BaseSmallStatement, BaseMatcherNode):
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Plus(BaseUnaryOp, BaseMatcherNode):
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Power(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class PowerAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Raise(BaseSmallStatement, BaseMatcherNode):
    exc: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    cause: Union[Optional["From"], MetadataMatchType, MatchIfTrue[Optional[cst.From]], DoNotCareSentinel, OneOf[Union[Optional["From"], MetadataMatchType, MatchIfTrue[Optional[cst.From]]]], AllOf[Union[Optional["From"], MetadataMatchType, MatchIfTrue[Optional[cst.From]]]]] = DoNotCare()
    whitespace_after_raise: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Return(BaseSmallStatement, BaseMatcherNode):
    value: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    whitespace_after_return: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    semicolon: Union[SemicolonMatchType, DoNotCareSentinel, OneOf[SemicolonMatchType], AllOf[SemicolonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightCurlyBrace(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightParen(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightShift(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightShiftAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class RightSquareBracket(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Semicolon(BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Set(BaseExpression, BaseSet, BaseMatcherNode):
    elements: Union[Sequence[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseElement]], OneOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]], AllOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]]] = DoNotCare()
    lbrace: Union[LeftCurlyBraceMatchType, DoNotCareSentinel, OneOf[LeftCurlyBraceMatchType], AllOf[LeftCurlyBraceMatchType]] = DoNotCare()
    rbrace: Union[RightCurlyBraceMatchType, DoNotCareSentinel, OneOf[RightCurlyBraceMatchType], AllOf[RightCurlyBraceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SetComp(BaseComp, BaseExpression, BaseSet, BaseSimpleComp, BaseMatcherNode):
    elt: Union[BaseAssignTargetExpressionMatchType, DoNotCareSentinel, OneOf[BaseAssignTargetExpressionMatchType], AllOf[BaseAssignTargetExpressionMatchType]] = DoNotCare()
    for_in: Union[CompForMatchType, DoNotCareSentinel, OneOf[CompForMatchType], AllOf[CompForMatchType]] = DoNotCare()
    lbrace: Union[LeftCurlyBraceMatchType, DoNotCareSentinel, OneOf[LeftCurlyBraceMatchType], AllOf[LeftCurlyBraceMatchType]] = DoNotCare()
    rbrace: Union[RightCurlyBraceMatchType, DoNotCareSentinel, OneOf[RightCurlyBraceMatchType], AllOf[RightCurlyBraceMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseSmallStatementMatchType = Union['BaseSmallStatement', MetadataMatchType, MatchIfTrue[cst.BaseSmallStatement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleStatementLine(BaseStatement, BaseMatcherNode):
    body: Union[Sequence[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseSmallStatement]], OneOf[Union[Sequence[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseSmallStatement]]]], AllOf[Union[Sequence[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseSmallStatement]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    trailing_whitespace: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleStatementSuite(BaseSuite, BaseMatcherNode):
    body: Union[Sequence[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, DoNotCareSentinel, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseSmallStatement]], OneOf[Union[Sequence[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseSmallStatement]]]], AllOf[Union[Sequence[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType], AtLeastN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]], AtMostN[Union[BaseSmallStatementMatchType, OneOf[BaseSmallStatementMatchType], AllOf[BaseSmallStatementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseSmallStatement]]]]] = DoNotCare()
    leading_whitespace: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    trailing_whitespace: Union[TrailingWhitespaceMatchType, DoNotCareSentinel, OneOf[TrailingWhitespaceMatchType], AllOf[TrailingWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleString(BaseExpression, BaseString, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SimpleWhitespace(BaseParenthesizableWhitespace, BaseMatcherNode):
    value: Union[strMatchType, DoNotCareSentinel, OneOf[strMatchType], AllOf[strMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Slice(BaseSlice, BaseMatcherNode):
    lower: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    upper: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    step: Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]], DoNotCareSentinel, OneOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]], AllOf[Union[Optional["BaseExpression"], MetadataMatchType, MatchIfTrue[Optional[cst.BaseExpression]]]]] = DoNotCare()
    first_colon: Union[ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]] = DoNotCare()
    second_colon: Union[ColonMatchType, DoNotCareSentinel, OneOf[ColonMatchType], AllOf[ColonMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class StarredDictElement(BaseDictElement, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    whitespace_before_value: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class StarredElement(BaseElement, BaseExpression, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_before_value: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


SubscriptElementMatchType = Union['SubscriptElement', MetadataMatchType, MatchIfTrue[cst.SubscriptElement]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Subscript(BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode):
    value: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    slice: Union[Sequence[Union[SubscriptElementMatchType, DoNotCareSentinel, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType], AtLeastN[Union[SubscriptElementMatchType, DoNotCareSentinel, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]], AtMostN[Union[SubscriptElementMatchType, DoNotCareSentinel, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.SubscriptElement]], OneOf[Union[Sequence[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType], AtLeastN[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]], AtMostN[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]]]], MatchIfTrue[Sequence[cst.SubscriptElement]]]], AllOf[Union[Sequence[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType], AtLeastN[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]], AtMostN[Union[SubscriptElementMatchType, OneOf[SubscriptElementMatchType], AllOf[SubscriptElementMatchType]]]]], MatchIfTrue[Sequence[cst.SubscriptElement]]]]] = DoNotCare()
    lbracket: Union[LeftSquareBracketMatchType, DoNotCareSentinel, OneOf[LeftSquareBracketMatchType], AllOf[LeftSquareBracketMatchType]] = DoNotCare()
    rbracket: Union[RightSquareBracketMatchType, DoNotCareSentinel, OneOf[RightSquareBracketMatchType], AllOf[RightSquareBracketMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_after_value: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseSliceMatchType = Union['BaseSlice', MetadataMatchType, MatchIfTrue[cst.BaseSlice]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SubscriptElement(BaseMatcherNode):
    slice: Union[BaseSliceMatchType, DoNotCareSentinel, OneOf[BaseSliceMatchType], AllOf[BaseSliceMatchType]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Subtract(BaseBinaryOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class SubtractAssign(BaseAugOp, BaseMatcherNode):
    whitespace_before: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    whitespace_after: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class TrailingWhitespace(BaseMatcherNode):
    whitespace: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    comment: Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]], DoNotCareSentinel, OneOf[Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]]]], AllOf[Union[Optional["Comment"], MetadataMatchType, MatchIfTrue[Optional[cst.Comment]]]]] = DoNotCare()
    newline: Union[NewlineMatchType, DoNotCareSentinel, OneOf[NewlineMatchType], AllOf[NewlineMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ExceptHandlerMatchType = Union['ExceptHandler', MetadataMatchType, MatchIfTrue[cst.ExceptHandler]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Try(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    handlers: Union[Sequence[Union[ExceptHandlerMatchType, DoNotCareSentinel, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType], AtLeastN[Union[ExceptHandlerMatchType, DoNotCareSentinel, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]], AtMostN[Union[ExceptHandlerMatchType, DoNotCareSentinel, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.ExceptHandler]], OneOf[Union[Sequence[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType], AtLeastN[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]], AtMostN[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]]]], MatchIfTrue[Sequence[cst.ExceptHandler]]]], AllOf[Union[Sequence[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType], AtLeastN[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]], AtMostN[Union[ExceptHandlerMatchType, OneOf[ExceptHandlerMatchType], AllOf[ExceptHandlerMatchType]]]]], MatchIfTrue[Sequence[cst.ExceptHandler]]]]] = DoNotCare()
    orelse: Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]], DoNotCareSentinel, OneOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]], AllOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]]] = DoNotCare()
    finalbody: Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]], DoNotCareSentinel, OneOf[Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]]]], AllOf[Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


ExceptStarHandlerMatchType = Union['ExceptStarHandler', MetadataMatchType, MatchIfTrue[cst.ExceptStarHandler]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class TryStar(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    handlers: Union[Sequence[Union[ExceptStarHandlerMatchType, DoNotCareSentinel, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType], AtLeastN[Union[ExceptStarHandlerMatchType, DoNotCareSentinel, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]], AtMostN[Union[ExceptStarHandlerMatchType, DoNotCareSentinel, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.ExceptStarHandler]], OneOf[Union[Sequence[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType], AtLeastN[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]], AtMostN[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]]]], MatchIfTrue[Sequence[cst.ExceptStarHandler]]]], AllOf[Union[Sequence[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType], AtLeastN[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]], AtMostN[Union[ExceptStarHandlerMatchType, OneOf[ExceptStarHandlerMatchType], AllOf[ExceptStarHandlerMatchType]]]]], MatchIfTrue[Sequence[cst.ExceptStarHandler]]]]] = DoNotCare()
    orelse: Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]], DoNotCareSentinel, OneOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]], AllOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]]] = DoNotCare()
    finalbody: Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]], DoNotCareSentinel, OneOf[Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]]]], AllOf[Union[Optional["Finally"], MetadataMatchType, MatchIfTrue[Optional[cst.Finally]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Tuple(BaseAssignTargetExpression, BaseDelTargetExpression, BaseExpression, BaseMatcherNode):
    elements: Union[Sequence[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, DoNotCareSentinel, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.BaseElement]], OneOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]], AllOf[Union[Sequence[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType], AtLeastN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]], AtMostN[Union[BaseElementMatchType, OneOf[BaseElementMatchType], AllOf[BaseElementMatchType]]]]], MatchIfTrue[Sequence[cst.BaseElement]]]]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseUnaryOpMatchType = Union['BaseUnaryOp', MetadataMatchType, MatchIfTrue[cst.BaseUnaryOp]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class UnaryOperation(BaseExpression, BaseMatcherNode):
    operator: Union[BaseUnaryOpMatchType, DoNotCareSentinel, OneOf[BaseUnaryOpMatchType], AllOf[BaseUnaryOpMatchType]] = DoNotCare()
    expression: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class While(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    test: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    orelse: Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]], DoNotCareSentinel, OneOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]], AllOf[Union[Optional["Else"], MetadataMatchType, MatchIfTrue[Optional[cst.Else]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    whitespace_after_while: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


WithItemMatchType = Union['WithItem', MetadataMatchType, MatchIfTrue[cst.WithItem]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class With(BaseCompoundStatement, BaseStatement, BaseMatcherNode):
    items: Union[Sequence[Union[WithItemMatchType, DoNotCareSentinel, OneOf[WithItemMatchType], AllOf[WithItemMatchType], AtLeastN[Union[WithItemMatchType, DoNotCareSentinel, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]], AtMostN[Union[WithItemMatchType, DoNotCareSentinel, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.WithItem]], OneOf[Union[Sequence[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType], AtLeastN[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]], AtMostN[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]]]], MatchIfTrue[Sequence[cst.WithItem]]]], AllOf[Union[Sequence[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType], AtLeastN[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]], AtMostN[Union[WithItemMatchType, OneOf[WithItemMatchType], AllOf[WithItemMatchType]]]]], MatchIfTrue[Sequence[cst.WithItem]]]]] = DoNotCare()
    body: Union[BaseSuiteMatchType, DoNotCareSentinel, OneOf[BaseSuiteMatchType], AllOf[BaseSuiteMatchType]] = DoNotCare()
    asynchronous: Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]], DoNotCareSentinel, OneOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]], AllOf[Union[Optional["Asynchronous"], MetadataMatchType, MatchIfTrue[Optional[cst.Asynchronous]]]]] = DoNotCare()
    leading_lines: Union[Sequence[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, DoNotCareSentinel, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.EmptyLine]], OneOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]], AllOf[Union[Sequence[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType], AtLeastN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]], AtMostN[Union[EmptyLineMatchType, OneOf[EmptyLineMatchType], AllOf[EmptyLineMatchType]]]]], MatchIfTrue[Sequence[cst.EmptyLine]]]]] = DoNotCare()
    lpar: Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]] = DoNotCare()
    rpar: Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]] = DoNotCare()
    whitespace_after_with: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    whitespace_before_colon: Union[SimpleWhitespaceMatchType, DoNotCareSentinel, OneOf[SimpleWhitespaceMatchType], AllOf[SimpleWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class WithItem(BaseMatcherNode):
    item: Union[BaseExpressionMatchType, DoNotCareSentinel, OneOf[BaseExpressionMatchType], AllOf[BaseExpressionMatchType]] = DoNotCare()
    asname: Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]], DoNotCareSentinel, OneOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]], AllOf[Union[Optional["AsName"], MetadataMatchType, MatchIfTrue[Optional[cst.AsName]]]]] = DoNotCare()
    comma: Union[CommaMatchType, DoNotCareSentinel, OneOf[CommaMatchType], AllOf[CommaMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()


BaseExpressionOrFromOrNoneMatchType = Union['BaseExpression', 'From', None, MetadataMatchType, MatchIfTrue[Union[cst.BaseExpression, cst.From, None]]]


@dataclass(frozen=True, eq=False, unsafe_hash=False)
class Yield(BaseExpression, BaseMatcherNode):
    value: Union[BaseExpressionOrFromOrNoneMatchType, DoNotCareSentinel, OneOf[BaseExpressionOrFromOrNoneMatchType], AllOf[BaseExpressionOrFromOrNoneMatchType]] = DoNotCare()
    lpar: Union[Sequence[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, DoNotCareSentinel, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.LeftParen]], OneOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]], AllOf[Union[Sequence[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType], AtLeastN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]], AtMostN[Union[LeftParenMatchType, OneOf[LeftParenMatchType], AllOf[LeftParenMatchType]]]]], MatchIfTrue[Sequence[cst.LeftParen]]]]] = DoNotCare()
    rpar: Union[Sequence[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, DoNotCareSentinel, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], DoNotCareSentinel, MatchIfTrue[Sequence[cst.RightParen]], OneOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]], AllOf[Union[Sequence[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType], AtLeastN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]], AtMostN[Union[RightParenMatchType, OneOf[RightParenMatchType], AllOf[RightParenMatchType]]]]], MatchIfTrue[Sequence[cst.RightParen]]]]] = DoNotCare()
    whitespace_after_yield: Union[BaseParenthesizableWhitespaceMatchType, DoNotCareSentinel, OneOf[BaseParenthesizableWhitespaceMatchType], AllOf[BaseParenthesizableWhitespaceMatchType]] = DoNotCare()
    metadata: Union[MetadataMatchType, DoNotCareSentinel, OneOf[MetadataMatchType], AllOf[MetadataMatchType]] = DoNotCare()
__all__ = ['Add', 'AddAssign', 'AllOf', 'And', 'AnnAssign', 'Annotation', 'Arg', 'AsName', 'Assert', 'Assign', 'AssignEqual', 'AssignTarget', 'Asynchronous', 'AtLeastN', 'AtMostN', 'Attribute', 'AugAssign', 'Await', 'BaseAssignTargetExpression', 'BaseAugOp', 'BaseBinaryOp', 'BaseBooleanOp', 'BaseComp', 'BaseCompOp', 'BaseCompoundStatement', 'BaseDelTargetExpression', 'BaseDict', 'BaseDictElement', 'BaseElement', 'BaseExpression', 'BaseFormattedStringContent', 'BaseList', 'BaseMatcherNode', 'BaseMetadataProvider', 'BaseNumber', 'BaseParenthesizableWhitespace', 'BaseSet', 'BaseSimpleComp', 'BaseSlice', 'BaseSmallStatement', 'BaseStatement', 'BaseString', 'BaseSuite', 'BaseUnaryOp', 'BinaryOperation', 'BitAnd', 'BitAndAssign', 'BitInvert', 'BitOr', 'BitOrAssign', 'BitXor', 'BitXorAssign', 'BooleanOperation', 'Break', 'Call', 'ClassDef', 'Colon', 'Comma', 'Comment', 'CompFor', 'CompIf', 'Comparison', 'ComparisonTarget', 'ConcatenatedString', 'Continue', 'Decorator', 'Del', 'Dict', 'DictComp', 'DictElement', 'Divide', 'DivideAssign', 'DoNotCare', 'DoNotCareSentinel', 'DoesNotMatch', 'Dot', 'Element', 'Ellipsis', 'Else', 'EmptyLine', 'Equal', 'ExceptHandler', 'ExceptStarHandler', 'Expr', 'Finally', 'Float', 'FloorDivide', 'FloorDivideAssign', 'For', 'FormattedString', 'FormattedStringExpression', 'FormattedStringText', 'From', 'FunctionDef', 'GeneratorExp', 'Global', 'GreaterThan', 'GreaterThanEqual', 'If', 'IfExp', 'Imaginary', 'Import', 'ImportAlias', 'ImportFrom', 'ImportStar', 'In', 'IndentedBlock', 'Index', 'Integer', 'Is', 'IsNot', 'Lambda', 'LeftCurlyBrace', 'LeftParen', 'LeftShift', 'LeftShiftAssign', 'LeftSquareBracket', 'LessThan', 'LessThanEqual', 'List', 'ListComp', 'Match', 'MatchAs', 'MatchCase', 'MatchClass', 'MatchDecoratorMismatch', 'MatchIfTrue', 'MatchKeywordElement', 'MatchList', 'MatchMapping', 'MatchMappingElement', 'MatchMetadata', 'MatchMetadataIfTrue', 'MatchOr', 'MatchOrElement', 'MatchPattern', 'MatchRegex', 'MatchSequence', 'MatchSequenceElement', 'MatchSingleton', 'MatchStar', 'MatchTuple', 'MatchValue', 'MatcherDecoratableTransformer', 'MatcherDecoratableVisitor', 'MatrixMultiply', 'MatrixMultiplyAssign', 'Minus', 'Module', 'Modulo', 'ModuloAssign', 'Multiply', 'MultiplyAssign', 'Name', 'NameItem', 'NamedExpr', 'Newline', 'Nonlocal', 'Not', 'NotEqual', 'NotIn', 'OneOf', 'Or', 'Param', 'ParamSlash', 'ParamStar', 'Parameters', 'ParenthesizedWhitespace', 'Pass', 'Plus', 'Power', 'PowerAssign', 'Raise', 'Return', 'RightCurlyBrace', 'RightParen', 'RightShift', 'RightShiftAssign', 'RightSquareBracket', 'SaveMatchedNode', 'Semicolon', 'Set', 'SetComp', 'SimpleStatementLine', 'SimpleStatementSuite', 'SimpleString', 'SimpleWhitespace', 'Slice', 'StarredDictElement', 'StarredElement', 'Subscript', 'SubscriptElement', 'Subtract', 'SubtractAssign', 'TrailingWhitespace', 'Try', 'TryStar', 'Tuple', 'TypeOf', 'UnaryOperation', 'While', 'With', 'WithItem', 'Yield', 'ZeroOrMore', 'ZeroOrOne', 'call_if_inside', 'call_if_not_inside', 'extract', 'extractall', 'findall', 'leave', 'matches', 'replace', 'visit']