## String#expand_tab

    require 'facets/string/expand_tab'

We will use this string as a basis for demonstration.

    tabs = <<-EOF.gsub(/^\s+\|/, '')
    |
    |\tOne tab
    | \tOne space and one tab
    |    \t Six spaces, a tab, and a space
    EOF

Expanding tabs 0.

    expected = <<-EOF.gsub(/^\s+\|/, '')
    |
    |One tab
    | One space and one tab
    |     Six spaces, a tab, and a space
    EOF

    tabs.expand_tabs(0).assert == expected

Expanding tabs 1.

    expected = <<-EOF.gsub(/^\s+\|/, '')
    |
    | One tab
    |  One space and one tab
    |      Six spaces, a tab, and a space
    EOF

    tabs.expand_tabs(1).assert == expected

Expanding tabs 4.

    expected = <<-EOF.gsub(/^\s+\|/, '')
    |
    |    One tab
    |    One space and one tab
    |         Six spaces, a tab, and a space
    EOF

    tabs.expand_tabs(4).assert == expected

Expanding tabs 8.

    expected = <<-EOF.gsub(/^\s+\|/, '')
    |
    |        One tab
    |        One space and one tab
    |         Six spaces, a tab, and a space
    EOF

    tabs.expand_tabs.assert == expected
    tabs.expand_tabs(8).assert == expected

Expanding tabs 16.

    expected = <<-EOF.gsub(/^\s+\|/, '')
    |
    |                One tab
    |                One space and one tab
    |                 Six spaces, a tab, and a space
    EOF

    tabs.expand_tabs(16).assert == expected

