3.2 Sample Parameters

# Sample Parameters: Amp and Pan

As we saw with synths, we can easily control our sounds with
parameters. Samples support exactly the same parameterisation
mechanism. Let's revisit our friends `amp:` and `pan:`.

## Amping samples

You can change the amplitude of samples with exactly the same
approach you used for synths:

```
sample :ambi_lunar_land, amp: 0.5
```

## Panning samples

We're also able to use the `pan:` parameter on samples. For example,
here's how we'd play the amen break in the left ear and then half way
through play it again through the right ear:

```
sample :loop_amen, pan: -1
sleep 0.877
sample :loop_amen, pan: 1
```

Note that 0.877 is half the duration of the `:loop_amen` sample in
seconds.

Finally, note that if you set some synth defaults with
`use_synth_defaults` (which we will discuss later), these will be
ignored by `sample`.
