/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.EventObject;
import org.apache.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.NodeKind;

public class DiffSummary
extends EventObject {
    private static final long serialVersionUID = 1L;
    private DiffKind diffKind;
    private boolean propsChanged;
    private int nodeKind;

    DiffSummary(String string, int n, boolean bl, int n2) {
        super(string);
        this.diffKind = DiffKind.getInstance(n);
        this.propsChanged = bl;
        this.nodeKind = n2;
    }

    DiffSummary(org.apache.subversion.javahl.DiffSummary diffSummary) {
        this(diffSummary.getPath(), diffSummary.getDiffKind().ordinal(), diffSummary.propsChanged(), NodeKind.fromApache(diffSummary.getNodeKind()));
    }

    public String getPath() {
        return (String)this.source;
    }

    public DiffKind getDiffKind() {
        return this.diffKind;
    }

    public boolean propsChanged() {
        return this.propsChanged;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public static class DiffKind {
        public static DiffKind NORMAL = new DiffKind(0);
        public static DiffKind ADDED = new DiffKind(1);
        public static DiffKind MODIFIED = new DiffKind(2);
        public static DiffKind DELETED = new DiffKind(3);
        private int kind;

        private DiffKind(int n) {
            this.kind = n;
        }

        public static DiffKind getInstance(int n) throws IllegalArgumentException {
            switch (n) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return MODIFIED;
                }
                case 3: {
                    return DELETED;
                }
            }
            throw new IllegalArgumentException("Diff kind " + n + " not recognized");
        }

        public static DiffKind fromApache(DiffSummary.DiffKind diffKind) {
            return DiffKind.getInstance(diffKind.hashCode());
        }

        public boolean equals(Object object) {
            return ((DiffKind)object).kind == this.kind;
        }

        public int hashCode() {
            return this.kind;
        }

        public String toString() {
            switch (this.kind) {
                case 0: {
                    return "normal";
                }
                case 1: {
                    return "added";
                }
                case 2: {
                    return "modified";
                }
                case 3: {
                    return "deleted";
                }
            }
            return "unknown";
        }
    }
}

