/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.SAXException;

final class PersistentProviderRegistrations {
    private static final Log log = LogFactory.getLog(PersistentProviderRegistrations.class);
    private static final StringManager sm = StringManager.getManager(PersistentProviderRegistrations.class);

    private PersistentProviderRegistrations() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Providers loadProviders(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Digester digester = new Digester();
            try {
                digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXException sAXException) {
                log.warn((Object)sm.getString("persistentProviderRegistrations.xmlFeatureEncoding"), (Throwable)sAXException);
            }
            digester.setValidating(true);
            digester.setNamespaceAware(true);
            Providers providers = new Providers();
            digester.push((Object)providers);
            digester.addObjectCreate("jaspic-providers/provider", Provider.class.getName());
            digester.addSetProperties("jaspic-providers/provider");
            digester.addSetNext("jaspic-providers/provider", "addProvider", Provider.class.getName());
            digester.addObjectCreate("jaspic-providers/provider/property", Property.class.getName());
            digester.addSetProperties("jaspic-providers/provider/property");
            digester.addSetNext("jaspic-providers/provider/property", "addProperty", Property.class.getName());
            digester.parse((InputStream)fileInputStream);
            Providers providers2 = providers;
            return providers2;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new SecurityException(exception);
        }
    }

    static void writeProviders(Providers providers, File file) {
        FileOutputStream fileOutputStream;
        File file2 = new File(file.getAbsolutePath() + ".old");
        File file3 = new File(file.getAbsolutePath() + ".new");
        if (file2.exists() && file2.delete()) {
            throw new SecurityException(sm.getString("persistentProviderRegistrations.existsDeleteFail", new Object[]{file2.getAbsolutePath()}));
        }
        if (file3.exists() && file3.delete()) {
            throw new SecurityException(sm.getString("persistentProviderRegistrations.existsDeleteFail", new Object[]{file3.getAbsolutePath()}));
        }
        try {
            fileOutputStream = new FileOutputStream(file3);
            Throwable throwable = null;
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                outputStreamWriter.write("<?xml version='1.0' encoding='utf-8'?>\n<jaspic-providers\n    xmlns=\"http://tomcat.apache.org/xml\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://tomcat.apache.org/xml jaspic-providers.xsd\"\n    version=\"1.0\">\n");
                for (Provider provider : providers.providers) {
                    outputStreamWriter.write("  <provider");
                    PersistentProviderRegistrations.writeOptional("className", provider.getClassName(), outputStreamWriter);
                    PersistentProviderRegistrations.writeOptional("layer", provider.getLayer(), outputStreamWriter);
                    PersistentProviderRegistrations.writeOptional("appContext", provider.getAppContext(), outputStreamWriter);
                    PersistentProviderRegistrations.writeOptional("description", provider.getDescription(), outputStreamWriter);
                    outputStreamWriter.write(">\n");
                    for (Map.Entry<String, String> entry : provider.getProperties().entrySet()) {
                        outputStreamWriter.write("    <property name=\"");
                        outputStreamWriter.write(entry.getKey());
                        outputStreamWriter.write("\" value=\"");
                        outputStreamWriter.write(entry.getValue());
                        outputStreamWriter.write("\"/>\n");
                    }
                    outputStreamWriter.write("  </provider>\n");
                }
                outputStreamWriter.write("</jaspic-providers>\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOutputStream != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (!file3.delete()) {
                Log log = LogFactory.getLog(PersistentProviderRegistrations.class);
                log.warn((Object)sm.getString("persistentProviderRegistrations.deleteFail", new Object[]{file3.getAbsolutePath()}));
            }
            throw new SecurityException(iOException);
        }
        if (file.isFile() && !file.renameTo(file2)) {
            throw new SecurityException(sm.getString("persistentProviderRegistrations.moveFail", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()}));
        }
        if (!file3.renameTo(file)) {
            throw new SecurityException(sm.getString("persistentProviderRegistrations.moveFail", new Object[]{file3.getAbsolutePath(), file.getAbsolutePath()}));
        }
        if (file2.exists() && !file2.delete()) {
            fileOutputStream = LogFactory.getLog(PersistentProviderRegistrations.class);
            fileOutputStream.warn(sm.getString("persistentProviderRegistrations.deleteFail", new Object[]{file2.getAbsolutePath()}));
        }
    }

    private static void writeOptional(String string, String string2, Writer writer) throws IOException {
        if (string2 != null) {
            writer.write(" " + string + "=\"");
            writer.write(string2);
            writer.write("\"");
        }
    }

    public static class Property {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class Provider {
        private String className;
        private String layer;
        private String appContext;
        private String description;
        private final Map<String, String> properties = new HashMap<String, String>();

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public String getLayer() {
            return this.layer;
        }

        public void setLayer(String string) {
            this.layer = string;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public void setAppContext(String string) {
            this.appContext = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void addProperty(Property property) {
            this.properties.put(property.getName(), property.getValue());
        }

        void addProperty(String string, String string2) {
            this.properties.put(string, string2);
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public static class Providers {
        private final List<Provider> providers = new ArrayList<Provider>();

        public void addProvider(Provider provider) {
            this.providers.add(provider);
        }

        public List<Provider> getProviders() {
            return this.providers;
        }
    }
}

