/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.json;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.tomcat.util.json.JSONParserConstants;
import org.apache.tomcat.util.json.JSONParserTokenManager;
import org.apache.tomcat.util.json.JavaCharStream;
import org.apache.tomcat.util.json.ParseException;
import org.apache.tomcat.util.json.Token;

public class JSONParser
implements JSONParserConstants {
    private boolean nativeNumbers = false;
    public JSONParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_gen;
    private final int[] jj_la1 = new int[13];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int trace_indent = 0;
    private boolean trace_enabled;

    public JSONParser(String string) {
        this(new StringReader(string));
    }

    public LinkedHashMap<String, Object> parseObject() throws ParseException {
        LinkedHashMap<String, Object> linkedHashMap = this.object();
        if (!this.ensureEOF()) {
            throw new IllegalStateException("Expected EOF, but still had content to parse");
        }
        return linkedHashMap;
    }

    public ArrayList<Object> parseArray() throws ParseException {
        ArrayList<Object> arrayList = this.list();
        if (!this.ensureEOF()) {
            throw new IllegalStateException("Expected EOF, but still had content to parse");
        }
        return arrayList;
    }

    public Object parse() throws ParseException {
        Object object = this.anything();
        if (!this.ensureEOF()) {
            throw new IllegalStateException("Expected EOF, but still had content to parse");
        }
        return object;
    }

    private static String substringBefore(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void setNativeNumbers(boolean bl) {
        this.nativeNumbers = bl;
    }

    public boolean getNativeNumbers() {
        return this.nativeNumbers;
    }

    public final boolean ensureEOF() throws ParseException {
        this.jj_consume_token(0);
        if ("" != null) {
            return true;
        }
        throw new Error("Missing return statement in function");
    }

    public final Object anything() throws ParseException {
        Object object;
        switch (this.jj_nt.kind) {
            case 7: {
                object = this.object();
                break;
            }
            case 10: {
                object = this.list();
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                object = this.value();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return object;
        }
        throw new Error("Missing return statement in function");
    }

    public final String objectKey() throws ParseException {
        String string;
        switch (this.jj_nt.kind) {
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                string = this.string();
                break;
            }
            case 28: {
                string = this.symbol();
                break;
            }
            case 19: {
                this.nullValue();
                string = null;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                Serializable serializable;
                switch (this.jj_nt.kind) {
                    case 17: 
                    case 18: {
                        serializable = this.booleanValue();
                        break;
                    }
                    case 15: 
                    case 16: {
                        serializable = this.number();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                string = serializable.toString();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return string;
        }
        throw new Error("Missing return statement in function");
    }

    public final LinkedHashMap<String, Object> object() throws ParseException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        this.jj_consume_token(7);
        block0 : switch (this.jj_nt.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                String string = this.objectKey();
                this.jj_consume_token(9);
                Object object = this.anything();
                linkedHashMap.put(string, object);
                string = null;
                object = null;
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(6);
                    string = this.objectKey();
                    this.jj_consume_token(9);
                    object = this.anything();
                    linkedHashMap.put(string, object);
                    string = null;
                    object = null;
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        if ("" != null) {
            return linkedHashMap;
        }
        throw new Error("Missing return statement in function");
    }

    public final ArrayList<Object> list() throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.jj_consume_token(10);
        block0 : switch (this.jj_nt.kind) {
            case 7: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                Object object = this.anything();
                arrayList.add(object);
                object = null;
                while (true) {
                    switch (this.jj_nt.kind) {
                        case 6: {
                            break;
                        }
                        default: {
                            this.jj_la1[5] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(6);
                    object = this.anything();
                    arrayList.add(object);
                    object = null;
                }
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
        arrayList.trimToSize();
        if ("" != null) {
            return arrayList;
        }
        throw new Error("Missing return statement in function");
    }

    public final Object value() throws ParseException {
        Object object;
        switch (this.jj_nt.kind) {
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                object = this.string();
                break;
            }
            case 15: 
            case 16: {
                object = this.number();
                break;
            }
            case 17: 
            case 18: {
                object = this.booleanValue();
                break;
            }
            case 19: {
                object = this.nullValue();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return object;
        }
        throw new Error("Missing return statement in function");
    }

    public final Object nullValue() throws ParseException {
        this.jj_consume_token(19);
        if ("" != null) {
            return null;
        }
        throw new Error("Missing return statement in function");
    }

    public final Boolean booleanValue() throws ParseException {
        Boolean bl;
        switch (this.jj_nt.kind) {
            case 17: {
                this.jj_consume_token(17);
                bl = Boolean.TRUE;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                bl = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return bl;
        }
        throw new Error("Missing return statement in function");
    }

    public final Number number() throws ParseException {
        switch (this.jj_nt.kind) {
            case 16: {
                Token token = this.jj_consume_token(16);
                if (this.nativeNumbers) {
                    if ("" == null) break;
                    return Long.valueOf(token.image);
                }
                if ("" == null) break;
                return new BigDecimal(token.image);
            }
            case 15: {
                Token token = this.jj_consume_token(15);
                if (this.nativeNumbers) {
                    if ("" == null) break;
                    return Double.valueOf(token.image);
                }
                if ("" == null) break;
                return new BigInteger(JSONParser.substringBefore(token.image, '.'));
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String string() throws ParseException {
        String string;
        switch (this.jj_nt.kind) {
            case 23: 
            case 27: {
                string = this.doubleQuoteString();
                break;
            }
            case 22: 
            case 26: {
                string = this.singleQuoteString();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return string;
        }
        throw new Error("Missing return statement in function");
    }

    public final String doubleQuoteString() throws ParseException {
        switch (this.jj_nt.kind) {
            case 23: {
                this.jj_consume_token(23);
                if ("" == null) break;
                return "";
            }
            case 27: {
                this.jj_consume_token(27);
                String string = this.token.image;
                if ("" == null) break;
                return string.substring(1, string.length() - 1);
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String singleQuoteString() throws ParseException {
        switch (this.jj_nt.kind) {
            case 22: {
                this.jj_consume_token(22);
                if ("" == null) break;
                return "";
            }
            case 26: {
                this.jj_consume_token(26);
                String string = this.token.image;
                if ("" == null) break;
                return string.substring(1, string.length() - 1);
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final String symbol() throws ParseException {
        this.jj_consume_token(28);
        if ("" != null) {
            return this.token.image;
        }
        throw new Error("Missing return statement in function");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{214926464, 491520, 483360768, 64, 483360768, 64, 214926464, 214925312, 393216, 98304, 0xCC00000, 0x8800000, 0x4400000};
    }

    public JSONParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public JSONParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JSONParser(Reader reader) {
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        } else {
            this.jj_input_stream.ReInit(reader, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new JSONParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public JSONParser(JSONParserTokenManager jSONParserTokenManager) {
        this.token_source = jSONParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(JSONParserTokenManager jSONParserTokenManager) {
        this.token_source = jSONParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[29];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 13; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 29; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JSONParser.jj_la1_init_0();
    }
}

