/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.util.prefs.Preferences;
import org.openide.util.NbBundle;

public final class ProfilerPreset {
    private static final String PROP_NAME = "prof_preset_name";
    private static final String PROP_SELECTOR = "prof_preset_selector";
    private static final String PROP_FILTER_MODE_S = "prof_preset_filterMode_s";
    private static final String PROP_FILTER_S = "prof_preset_filter_s";
    private static final String PROP_SAMPLING_RATE_S = "prof_preset_samplingRate_s";
    private static final String PROP_REFRESH_RATE_S = "prof_preset_refreshRate_s";
    private static final String PROP_SAMPLING_REFRESH_RATE_S = "prof_preset_samplingRefreshRate_s";
    private static final String PROP_ROOTS_P = "prof_preset_roots_p";
    private static final String PROP_RUNNABLES_P = "prof_preset_runnables_p";
    private static final String PROP_FILTER_MODE_P = "prof_preset_filterMode_p";
    private static final String PROP_FILTER_P = "prof_preset_filter_p";
    private static final String PROP_MEMORY_MODE_P = "prof_preset_memoryMode_p";
    private static final String PROP_ALLOC_P = "prof_preset_alloc_p";
    private static final String PROP_STACKS_P = "prof_preset_stacks_p";
    private static final String PROP_MEMORY_FILTER_P = "prof_memory_filter_p";
    private static final String PROP_JDBC_FILTER_P = "prof_jdbc_filter_p";
    private boolean valid;
    private String name;
    private String selector;
    private boolean filterModeS;
    private String filterS;
    private int samplingRateS;
    private int refreshRateS;
    private int samplingRefreshRateS;
    private String rootsP;
    private boolean runnablesP;
    private boolean filterModeP;
    private String filterP;
    private boolean memoryModeP;
    private int allocP;
    private boolean stacksP;
    private String memoryFilterP;
    private String jdbcFilterP;

    public ProfilerPreset(String name, String selector) {
        this.valid = true;
        this.name = name;
        this.selector = selector;
        this.filterModeS = true;
        this.filterS = "";
        this.samplingRateS = 100;
        this.refreshRateS = 1000;
        this.samplingRefreshRateS = 1000;
        this.rootsP = "";
        this.runnablesP = true;
        this.filterModeP = true;
        this.filterP = "";
        this.memoryModeP = true;
        this.allocP = 10;
        this.stacksP = true;
        this.memoryFilterP = "";
        this.jdbcFilterP = "";
    }

    public ProfilerPreset(ProfilerPreset preset) {
        this.valid = preset.valid;
        this.name = preset.name;
        this.selector = preset.selector;
        this.filterModeS = preset.filterModeS;
        this.filterS = preset.filterS;
        this.samplingRateS = preset.samplingRateS;
        this.refreshRateS = preset.refreshRateS;
        this.samplingRefreshRateS = preset.samplingRefreshRateS;
        this.rootsP = preset.rootsP;
        this.runnablesP = preset.runnablesP;
        this.filterModeP = preset.filterModeP;
        this.filterP = preset.filterP;
        this.memoryModeP = preset.memoryModeP;
        this.allocP = preset.allocP;
        this.stacksP = preset.stacksP;
        this.memoryFilterP = preset.memoryFilterP;
        this.jdbcFilterP = preset.jdbcFilterP;
    }

    ProfilerPreset(Preferences prefs, String prefix) {
        this.valid = true;
        this.name = prefs.get(prefix + PROP_NAME, NbBundle.getMessage(ProfilerPreset.class, (String)"MSG_Preset"));
        this.selector = prefs.get(prefix + PROP_SELECTOR, "");
        this.filterModeS = prefs.getBoolean(prefix + PROP_FILTER_MODE_S, true);
        this.filterS = prefs.get(prefix + PROP_FILTER_S, "");
        this.samplingRateS = prefs.getInt(prefix + PROP_SAMPLING_RATE_S, 100);
        this.refreshRateS = prefs.getInt(prefix + PROP_REFRESH_RATE_S, 1000);
        this.samplingRefreshRateS = prefs.getInt(prefix + PROP_SAMPLING_REFRESH_RATE_S, 1000);
        this.rootsP = prefs.get(prefix + PROP_ROOTS_P, "");
        this.runnablesP = prefs.getBoolean(prefix + PROP_RUNNABLES_P, true);
        this.filterModeP = prefs.getBoolean(prefix + PROP_FILTER_MODE_P, true);
        this.filterP = prefs.get(prefix + PROP_FILTER_P, "");
        this.memoryModeP = prefs.getBoolean(prefix + PROP_MEMORY_MODE_P, true);
        this.allocP = prefs.getInt(prefix + PROP_ALLOC_P, 10);
        this.stacksP = prefs.getBoolean(prefix + PROP_STACKS_P, true);
        this.memoryFilterP = prefs.get(prefix + PROP_MEMORY_FILTER_P, "");
        this.jdbcFilterP = prefs.get(prefix + PROP_JDBC_FILTER_P, "");
    }

    void toPreferences(Preferences prefs, String prefix) {
        prefs.put(prefix + PROP_NAME, this.name);
        prefs.put(prefix + PROP_SELECTOR, this.selector);
        prefs.putBoolean(prefix + PROP_FILTER_MODE_S, this.filterModeS);
        prefs.put(prefix + PROP_FILTER_S, this.filterS);
        prefs.putInt(prefix + PROP_SAMPLING_RATE_S, this.samplingRateS);
        prefs.putInt(prefix + PROP_REFRESH_RATE_S, this.refreshRateS);
        prefs.putInt(prefix + PROP_SAMPLING_REFRESH_RATE_S, this.samplingRefreshRateS);
        prefs.put(prefix + PROP_ROOTS_P, this.rootsP);
        prefs.putBoolean(prefix + PROP_RUNNABLES_P, this.runnablesP);
        prefs.putBoolean(prefix + PROP_FILTER_MODE_P, this.filterModeP);
        prefs.put(prefix + PROP_FILTER_P, this.filterP);
        prefs.putBoolean(prefix + PROP_MEMORY_MODE_P, this.memoryModeP);
        prefs.putInt(prefix + PROP_ALLOC_P, this.allocP);
        prefs.putBoolean(prefix + PROP_STACKS_P, this.stacksP);
        prefs.put(prefix + PROP_MEMORY_FILTER_P, this.memoryFilterP);
        prefs.put(prefix + PROP_JDBC_FILTER_P, this.jdbcFilterP);
    }

    void setValid(boolean valid) {
        this.valid = valid;
    }

    boolean isValid() {
        return this.valid;
    }

    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setFilterModeS(boolean filterMode) {
        this.filterModeS = filterMode;
    }

    public boolean getFilterModeS() {
        return this.filterModeS;
    }

    public void setFilterS(String filter) {
        this.filterS = filter;
    }

    public String getFilterS() {
        return this.filterS;
    }

    public void setSamplingRateS(int samplingRate) {
        this.samplingRateS = samplingRate;
    }

    public int getSamplingRateS() {
        return this.samplingRateS;
    }

    public void setRefreshRateS(int refreshRate) {
        this.refreshRateS = refreshRate;
    }

    public int getRefreshRateS() {
        return this.refreshRateS;
    }

    public void setSamplingRefreshRateS(int samplingRefreshRateS) {
        this.samplingRefreshRateS = samplingRefreshRateS;
    }

    public int getSamplingRefreshRateS() {
        return this.samplingRefreshRateS;
    }

    public void setRootsP(String roots) {
        this.rootsP = roots;
    }

    public String getRootsP() {
        return this.rootsP;
    }

    public void setRunnablesP(boolean runnables) {
        this.runnablesP = runnables;
    }

    public boolean getRunnablesP() {
        return this.runnablesP;
    }

    public void setFilterModeP(boolean filterMode) {
        this.filterModeP = filterMode;
    }

    public boolean getFilterModeP() {
        return this.filterModeP;
    }

    public void setFilterP(String filter) {
        this.filterP = filter;
    }

    public String getFilterP() {
        return this.filterP;
    }

    public void setMemoryModeP(boolean memoryMode) {
        this.memoryModeP = memoryMode;
    }

    public boolean getMemoryModeP() {
        return this.memoryModeP;
    }

    public void setAllocP(int alloc) {
        this.allocP = alloc;
    }

    public int getAllocP() {
        return this.allocP;
    }

    public void setStacksP(boolean stacks) {
        this.stacksP = stacks;
    }

    public boolean getStacksP() {
        return this.stacksP;
    }

    public void setMemoryFilterP(String filter) {
        this.memoryFilterP = filter;
    }

    public String getMemoryFilterP() {
        return this.memoryFilterP;
    }

    public void setJDBCFilterP(String filter) {
        this.jdbcFilterP = filter;
    }

    public String getJDBCFilterP() {
        return this.jdbcFilterP;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        return o instanceof ProfilerPreset ? this.getName().equals(((ProfilerPreset)o).getName()) : false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

