/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.model.Model;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventChecker;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.openide.util.Lookup;

public abstract class JFRModel
extends Model {
    private static final Logger LOGGER = Logger.getLogger(JFRModel.class.getName());
    private final String id;
    private Instant jvmStartTime;
    private Instant jvmShutdownTime;
    private String jvmShutdownReason;
    private Instant firstEventTime;
    private Instant lastEventTime;
    private long eventsCount = 0L;
    private long experimentalCount = 0L;
    private long firstEventTimeMs;
    private String jvmFlags;
    private String jvmArgs;
    private String javaArgs;
    private Properties sysProps;
    private Map<String, Boolean> checkedEvents;
    private static final String TYPE_JVM_INFORMATION = "jdk.JVMInformation";
    private static final String TYPE_SYSTEM_PROPERTY = "jdk.InitialSystemProperty";
    private static final String TYPE_SHUTDOWN = "jdk.Shutdown";
    static final JFRModel OOME = new JFRModel("OOME"){

        @Override
        public void visitEvents(JFREventVisitor ... visitors) {
        }

        @Override
        public void visitEventTypes(JFREventTypeVisitor ... visitors) {
        }
    };

    protected JFRModel(String id) {
        this.id = id;
    }

    protected String getID() {
        return this.id;
    }

    public abstract void visitEvents(JFREventVisitor ... var1);

    public abstract void visitEventTypes(JFREventTypeVisitor ... var1);

    public boolean containsEvent(Class<? extends JFREventChecker> eventCheckerClass) {
        Boolean contains = this.checkedEvents == null ? null : this.checkedEvents.get(eventCheckerClass.getName());
        return Boolean.TRUE.equals(contains);
    }

    public JFREvent getEvent(final long eventID) {
        final JFREvent[] foundEvent = new JFREvent[]{null};
        this.visitEvents(new JFREventVisitor(){

            @Override
            public boolean visit(String typeName, JFREvent event) {
                boolean found;
                boolean bl = found = eventID == event.getID();
                if (found) {
                    foundEvent[0] = event;
                }
                return found;
            }
        });
        return foundEvent[0];
    }

    public Instant getJvmStartTime() {
        return this.jvmStartTime;
    }

    public Instant getJvmShutdownTime() {
        return this.jvmShutdownTime;
    }

    public String getJvmShutdownReason() {
        return this.jvmShutdownReason;
    }

    public Instant getFirstEventTime() {
        return this.firstEventTime;
    }

    public Instant getLastEventTime() {
        return this.lastEventTime;
    }

    public long getEventsCount() {
        return this.eventsCount;
    }

    public long getExperimentalEventsCount() {
        return this.experimentalCount;
    }

    public Properties getSystemProperties() {
        return this.sysProps;
    }

    public String getJvmFlags() {
        return this.jvmFlags;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public String getJavaCommand() {
        return this.javaArgs;
    }

    public String getVmVersion() {
        return this.findByName("java.vm.version");
    }

    public String getJavaHome() {
        return this.findByName("java.home");
    }

    public String getVmInfo() {
        return this.findByName("java.vm.info");
    }

    public String getVmName() {
        return this.findByName("java.vm.name");
    }

    private String findByName(String key) {
        Properties p = this.getSystemProperties();
        return p == null ? null : p.getProperty(key);
    }

    public Duration toRelativeTime(Instant absoluteTime) {
        return Duration.between(this.firstEventTime, absoluteTime);
    }

    public Instant toAbsoluteTime(Duration relativeTime) {
        return this.firstEventTime.plus(relativeTime);
    }

    public Instant nsToAbsoluteTime(long nanos) {
        return this.firstEventTime.plusNanos(nanos);
    }

    public long nsToAbsoluteMillis(long nanos) {
        return this.firstEventTimeMs + ValuesConverter.nanosToMillis(nanos);
    }

    protected final void initialize() {
        this.sysProps = new Properties();
        final HashSet experimentalTypes = new HashSet();
        this.visitEventTypes(new JFREventTypeVisitor(){

            @Override
            public boolean visitType(String typeName, JFREventType eventType) {
                if (eventType.isExperimental()) {
                    experimentalTypes.add(typeName);
                }
                return false;
            }
        });
        this.visitEvents(new JFREventVisitor(){
            private List<? extends JFREventChecker> checkers;

            @Override
            public void init() {
                JFRModel.this.checkedEvents = new HashMap();
                this.checkers = new ArrayList<JFREventChecker>(Lookup.getDefault().lookupAll(JFREventChecker.class));
            }

            @Override
            public boolean visit(String typeName, JFREvent event) {
                JFRModel.this.eventsCount++;
                if (experimentalTypes.contains(typeName)) {
                    JFRModel.this.experimentalCount++;
                }
                if (!this.checkers.isEmpty()) {
                    Iterator<? extends JFREventChecker> checkersI = this.checkers.iterator();
                    while (checkersI.hasNext()) {
                        JFREventChecker checker = checkersI.next();
                        if (!checker.checksEventType(typeName)) continue;
                        checkersI.remove();
                        JFRModel.this.checkedEvents.put(checker.getClass().getName(), Boolean.TRUE);
                    }
                }
                try {
                    Object eventTime = event.getInstant("eventTime");
                    if (JFRModel.this.firstEventTime == null) {
                        JFRModel.this.firstEventTime = (Instant)eventTime;
                        JFRModel.this.lastEventTime = (Instant)eventTime;
                    } else {
                        if (JFRModel.this.firstEventTime.isAfter((Instant)eventTime)) {
                            JFRModel.this.firstEventTime = (Instant)eventTime;
                        }
                        if (JFRModel.this.lastEventTime.isBefore((Instant)eventTime)) {
                            JFRModel.this.lastEventTime = (Instant)eventTime;
                        }
                    }
                }
                catch (JFRPropertyNotAvailableException eventTime) {
                    // empty catch block
                }
                try {
                    switch (typeName) {
                        case "jdk.JVMInformation": {
                            JFRModel.this.jvmStartTime = event.getInstant("jvmStartTime");
                            JFRModel.this.jvmFlags = event.getString("jvmFlags");
                            JFRModel.this.jvmArgs = event.getString("jvmArguments");
                            JFRModel.this.javaArgs = event.getString("javaArguments");
                            break;
                        }
                        case "jdk.InitialSystemProperty": {
                            JFRModel.this.sysProps.put(event.getString("key"), event.getString("value"));
                            break;
                        }
                        case "jdk.Shutdown": {
                            JFRModel.this.jvmShutdownTime = event.getInstant("eventTime");
                            JFRModel.this.jvmShutdownReason = event.getString("reason");
                        }
                    }
                }
                catch (JFRPropertyNotAvailableException e) {
                    LOGGER.log(Level.INFO, "JFR model initialization info (" + JFRModel.this.getID() + ")", e);
                }
                return false;
            }
        });
        this.firstEventTimeMs = ValuesConverter.instantToMillis(this.firstEventTime);
    }
}

