/// <reference types="node" />
import type { Device as ZHDevice, Endpoint as ZHEndpoint, Group as ZHGroup } from 'zigbee-herdsman/dist/controller/model';
import * as exposes from './exposes';
export interface Logger {
    info: (message: string) => void;
    warn: (message: string) => void;
    error: (message: string) => void;
    debug: (message: string) => void;
}
export type Range = [number, number];
export interface KeyValue {
    [s: string]: unknown;
}
export interface KeyValueString {
    [s: string]: string;
}
export interface KeyValueNumberString {
    [s: number]: string;
}
export interface KeyValueAny {
    [s: string]: any;
}
export type Publish = (payload: KeyValue) => void;
export type OnEventType = 'start' | 'stop' | 'message' | 'deviceJoined' | 'deviceInterview' | 'deviceAnnounce' | 'deviceNetworkAddressChanged' | 'deviceOptionsChanged';
export type Access = 0b001 | 0b010 | 0b100 | 0b011 | 0b101 | 0b111;
export type Expose = exposes.Numeric | exposes.Binary | exposes.Enum | exposes.Composite | exposes.List | exposes.Light | exposes.Switch | exposes.Lock | exposes.Cover | exposes.Climate | exposes.Text;
export type Option = exposes.Numeric | exposes.Binary | exposes.Composite | exposes.Enum | exposes.List;
export interface Fingerprint {
    modelID?: string;
    manufacturerName?: string;
    type?: 'EndDevice' | 'Router';
    manufacturerID?: number;
    applicationVersion?: number;
    powerSource?: 'Battery' | 'Mains (single phase)';
    softwareBuildID?: string;
    ieeeAddr?: RegExp;
    endpoints?: {
        ID?: number;
        profileID?: number;
        deviceID?: number;
        inputClusters?: number[];
        outputClusters?: number[];
    }[];
}
export type WhiteLabel = {
    vendor: string;
    model: string;
    description: string;
    fingerprint: Fingerprint[];
} | {
    vendor: string;
    model: string;
    description?: string;
};
export interface OtaUpdateAvailableResult {
    available: boolean;
    currentFileVersion: number;
    otaFileVersion: number;
}
export interface DefinitionMeta {
    separateWhite?: boolean;
    multiEndpoint?: boolean;
    multiEndpointEnforce?: {
        [s: string]: number;
    };
    publishDuplicateTransaction?: boolean;
    tuyaDatapoints?: Tuya.MetaTuyaDataPoints;
    disableDefaultResponse?: boolean;
    pinCodeCount?: number;
    coverInverted?: boolean;
    timeout?: number;
    multiEndpointSkip?: string[];
    tuyaSendCommand?: 'sendData' | 'dataRequest';
    coverStateFromTilt?: boolean;
    thermostat?: {
        weeklyScheduleMaxTransitions?: number;
        weeklyScheduleSupportedModes?: number[];
        weeklyScheduleFirstDayDpId?: number;
        weeklyScheduleConversion?: string;
        dontMapPIHeatingDemand?: boolean;
    };
    battery?: {
        voltageToPercentage?: string | {
            min: number;
            max: number;
        };
        dontDividePercentage?: boolean;
    };
    applyRedFix?: boolean;
    turnsOffAtBrightness1?: boolean;
    tuyaThermostatPreset?: {
        [s: number]: string;
    };
    tuyaThermostatSystemMode?: {
        [s: number]: string;
    };
    tuyaThermostatPresetToSystemMode?: {
        [s: number]: string;
    };
    supportsEnhancedHue?: boolean | ((entity: Zh.Endpoint) => boolean);
    disableActionGroup?: boolean;
    supportsHueAndSaturation?: boolean;
}
export type Configure = (device: Zh.Device, coordinatorEndpoint: Zh.Endpoint, logger: Logger) => Promise<void>;
export type OnEvent = (type: OnEventType, data: OnEventData, device: Zh.Device, settings: KeyValue, state: KeyValue) => Promise<void>;
export interface Extend {
    fromZigbee: Fz.Converter[];
    toZigbee: Tz.Converter[];
    exposes: Expose[];
    configure?: Configure;
    meta?: DefinitionMeta;
}
export interface OnEventData {
    endpoint?: Zh.Endpoint;
    meta?: {
        zclTransactionSequenceNumber?: number;
    };
    cluster?: string;
    type?: string;
    data?: KeyValueAny;
}
export type Definition = {
    model: string;
    vendor: string;
    description: string;
    whiteLabel?: WhiteLabel[];
    endpoint?: (device: Zh.Device) => {
        [s: string]: number;
    };
    configure?: Configure;
    options?: Option[];
    meta?: DefinitionMeta;
    onEvent?: OnEvent;
    ota?: {
        isUpdateAvailable: (device: Zh.Device, logger: Logger, requestPayload: Ota.ImageInfo) => Promise<OtaUpdateAvailableResult>;
        updateToLatest: (device: Zh.Device, logger: Logger, onProgress: Ota.OnProgress) => Promise<number>;
    };
} & ({
    zigbeeModel: string[];
} | {
    fingerprint: Fingerprint[];
}) & ({
    extend: Extend;
} | {
    fromZigbee: Fz.Converter[];
    toZigbee: Tz.Converter[];
    exposes: (Expose[] | ((device: Zh.Device, options: KeyValue) => Expose[]));
});
export declare namespace Fz {
    interface Message {
        data: any;
        endpoint: Zh.Endpoint;
        device: Zh.Device;
        meta: {
            zclTransactionSequenceNumber: number;
        };
        groupID: number;
        type: string;
        cluster: string;
        linkquality: number;
    }
    interface Meta {
        state: KeyValue;
        logger: Logger;
        device: Zh.Device;
    }
    interface Converter {
        cluster: string | number;
        type: string[] | string;
        options?: Option[] | ((definition: Definition) => Option[]);
        convert: (model: Definition, msg: Message, publish: Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny | void | Promise<void>;
    }
}
export declare namespace Tz {
    interface Meta {
        logger: Logger;
        message: KeyValue;
        device: Zh.Device;
        mapped: Definition;
        options: KeyValue;
        state: KeyValue;
        endpoint_name: string;
    }
    interface Converter {
        key: string[];
        options?: Option[] | ((definition: Definition) => Option[]);
        convertSet?: (entity: Zh.Endpoint | Zh.Group, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state?: KeyValue;
            readAfterWriteTime?: number;
        } | void>;
        convertGet?: (entity: Zh.Endpoint | Zh.Group, key: string, meta: Tz.Meta) => Promise<void>;
    }
}
export declare namespace Zh {
    type Endpoint = ZHEndpoint;
    type Device = ZHDevice;
    type Group = ZHGroup;
}
export declare namespace Tuya {
    interface DpValue {
        dp: number;
        datatype: number;
        data: Buffer | number[];
    }
    interface ValueConverterSingle {
        to?: (value: unknown, meta?: Tz.Meta) => unknown;
        from?: (value: unknown, meta?: Fz.Meta, options?: KeyValue, publish?: Publish) => number | string | boolean | KeyValue;
    }
    interface ValueConverterMulti {
        to?: (value: unknown, meta?: Tz.Meta) => unknown;
        from?: (value: unknown, meta?: Fz.Meta, options?: KeyValue, publish?: Publish) => KeyValue;
    }
    interface MetaTuyaDataPointsMeta {
        skip: (meta: Tz.Meta) => boolean;
        optimistic?: boolean;
    }
    type MetaTuyaDataPointsSingle = [number, string, Tuya.ValueConverterSingle, MetaTuyaDataPointsMeta?];
    type MetaTuyaDataPoints = MetaTuyaDataPointsSingle[];
}
export declare namespace Extend {
    interface options_switch {
        disablePowerOnBehavior?: boolean;
        toZigbee?: Tz.Converter[];
        fromZigbee?: Fz.Converter[];
        exposes?: Expose[];
    }
    interface options_light_onoff_brightness {
        disablePowerOnBehavior?: boolean;
        toZigbee?: Tz.Converter[];
        fromZigbee?: Fz.Converter[];
        exposes?: Expose[];
        disableEffect?: boolean;
        disableMoveStep?: boolean;
        disableTransition?: boolean;
        noConfigure?: boolean;
    }
    interface options_light_onoff_brightness_colortemp {
        disablePowerOnBehavior?: boolean;
        toZigbee?: Tz.Converter[];
        fromZigbee?: Fz.Converter[];
        exposes?: Expose[];
        disableEffect?: boolean;
        disableMoveStep?: boolean;
        disableTransition?: boolean;
        noConfigure?: boolean;
        disableColorTempStartup?: boolean;
        colorTempRange?: Range;
    }
    interface options_light_onoff_brightness_color {
        disablePowerOnBehavior?: boolean;
        toZigbee?: Tz.Converter[];
        fromZigbee?: Fz.Converter[];
        exposes?: Expose[];
        disableEffect?: boolean;
        disableMoveStep?: boolean;
        disableTransition?: boolean;
        noConfigure?: boolean;
        disableColorTempStartup?: boolean;
        colorTempRange?: Range;
        preferHueAndSaturation?: boolean;
        supportsHueAndSaturation?: boolean;
    }
    interface options_light_onoff_brightness_colortemp_color {
        disablePowerOnBehavior?: boolean;
        toZigbee?: Tz.Converter[];
        fromZigbee?: Fz.Converter[];
        exposes?: Expose[];
        disableEffect?: boolean;
        disableMoveStep?: boolean;
        disableTransition?: boolean;
        noConfigure?: boolean;
        disableColorTempStartup?: boolean;
        colorTempRange?: Range;
        preferHueAndSaturation?: boolean;
        supportsHueAndSaturation?: boolean;
    }
}
export declare namespace Ota {
    type OnProgress = (progress: number, remaining: number) => void;
    interface Version {
        imageType: number;
        manufacturerCode: number;
        fileVersion: number;
    }
    interface ImageHeader {
        otaUpgradeFileIdentifier: Buffer;
        otaHeaderVersion: number;
        otaHeaderLength: number;
        otaHeaderFieldControl: number;
        manufacturerCode: number;
        imageType: number;
        fileVersion: number;
        zigbeeStackVersion: number;
        otaHeaderString: string;
        totalImageSize: number;
        securityCredentialVersion?: number;
        upgradeFileDestination?: Buffer;
        minimumHardwareVersion?: number;
        maximumHardwareVersion?: number;
    }
    interface ImageElement {
        tagID: number;
        length: number;
        data: Buffer;
    }
    interface Image {
        header: ImageHeader;
        elements: ImageElement[];
        raw: Buffer;
    }
    interface ImageInfo {
        imageType: number;
        fileVersion: number;
        manufacturerCode: number;
    }
    interface ImageMeta {
        fileVersion: number;
        fileSize?: number;
        url: string;
        sha256?: string;
        force?: boolean;
        sha512?: string;
        hardwareVersionMin?: number;
        hardwareVersionMax?: number;
    }
    type GetImageMeta = (current: ImageInfo, logger: Logger, device: Zh.Device) => Promise<ImageMeta>;
}
export declare namespace Reporting {
    interface Override {
        min?: number;
        max?: number;
        change?: number | [number, number];
    }
}
//# sourceMappingURL=types.d.ts.map