/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries;

import org.opensearch.performanceanalyzer.grpc.AdditionalFields;
import org.opensearch.performanceanalyzer.grpc.MetricEnum;
import org.opensearch.performanceanalyzer.grpc.PANetworking;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;

public class ResourceUtil {
    public static final Resource HEAP_MAX_SIZE = Resource.newBuilder().setResourceEnum(ResourceEnum.HEAP).setMetricEnum(MetricEnum.HEAP_MAX).build();
    public static final Resource OLD_GEN_HEAP_USAGE = Resource.newBuilder().setResourceEnum(ResourceEnum.OLD_GEN).setMetricEnum(MetricEnum.HEAP_USAGE).build();
    public static final Resource YOUNG_GEN_PROMOTION_RATE = Resource.newBuilder().setResourceEnum(ResourceEnum.YOUNG_GEN).setMetricEnum(MetricEnum.PROMOTION_RATE).build();
    public static final Resource FULL_GC_EFFECTIVENESS = Resource.newBuilder().setResourceEnum(ResourceEnum.OLD_GEN).setMetricEnum(MetricEnum.OLD_GEN_USAGE_AFTER_FULL_GC).build();
    public static final Resource FULL_GC_PAUSE_TIME = Resource.newBuilder().setResourceEnum(ResourceEnum.OLD_GEN).setMetricEnum(MetricEnum.FULL_GC).build();
    public static final Resource OLD_GEN_MAX_SIZE = Resource.newBuilder().setResourceEnum(ResourceEnum.OLD_GEN).setMetricEnum(MetricEnum.HEAP_MAX).build();
    public static final Resource YOUNG_GEN_MAX_SIZE = Resource.newBuilder().setResourceEnum(ResourceEnum.YOUNG_GEN).setMetricEnum(MetricEnum.HEAP_MAX).build();
    public static final Resource MINOR_GC_PAUSE_TIME = Resource.newBuilder().setResourceEnum(ResourceEnum.YOUNG_GEN).setMetricEnum(MetricEnum.MINOR_GC).build();
    public static final Resource CPU_USAGE = Resource.newBuilder().setResourceEnum(ResourceEnum.CPU).setMetricEnum(MetricEnum.CPU_USAGE).build();
    public static final Resource IO_TOTAL_THROUGHPUT = Resource.newBuilder().setResourceEnum(ResourceEnum.IO).setMetricEnum(MetricEnum.TOTAL_THROUGHPUT).build();
    public static final Resource IO_TOTAL_SYS_CALLRATE = Resource.newBuilder().setResourceEnum(ResourceEnum.IO).setMetricEnum(MetricEnum.TOTAL_SYS_CALLRATE).build();
    public static final Resource WRITE_QUEUE_REJECTION = Resource.newBuilder().setResourceEnum(ResourceEnum.WRITE_THREADPOOL).setMetricEnum(MetricEnum.QUEUE_REJECTION).build();
    public static final Resource SEARCH_QUEUE_REJECTION = Resource.newBuilder().setResourceEnum(ResourceEnum.SEARCH_THREADPOOL).setMetricEnum(MetricEnum.QUEUE_REJECTION).build();
    public static final Resource WRITE_QUEUE_CAPACITY = Resource.newBuilder().setResourceEnum(ResourceEnum.WRITE_THREADPOOL).setMetricEnum(MetricEnum.QUEUE_CAPACITY).build();
    public static final Resource SEARCH_QUEUE_CAPACITY = Resource.newBuilder().setResourceEnum(ResourceEnum.SEARCH_THREADPOOL).setMetricEnum(MetricEnum.QUEUE_CAPACITY).build();
    public static final Resource FIELD_DATA_CACHE_EVICTION = Resource.newBuilder().setResourceEnum(ResourceEnum.FIELD_DATA_CACHE).setMetricEnum(MetricEnum.CACHE_EVICTION).build();
    public static final Resource FIELD_DATA_CACHE_MAX_SIZE = Resource.newBuilder().setResourceEnum(ResourceEnum.FIELD_DATA_CACHE).setMetricEnum(MetricEnum.CACHE_MAX_SIZE).build();
    public static final Resource SHARD_REQUEST_CACHE_EVICTION = Resource.newBuilder().setResourceEnum(ResourceEnum.SHARD_REQUEST_CACHE).setMetricEnum(MetricEnum.CACHE_EVICTION).build();
    public static final Resource SHARD_REQUEST_CACHE_HIT = Resource.newBuilder().setResourceEnum(ResourceEnum.SHARD_REQUEST_CACHE).setMetricEnum(MetricEnum.CACHE_HIT).build();
    public static final Resource SHARD_REQUEST_CACHE_MAX_SIZE = Resource.newBuilder().setResourceEnum(ResourceEnum.SHARD_REQUEST_CACHE).setMetricEnum(MetricEnum.CACHE_MAX_SIZE).build();

    public static String getResourceTypeName(Resource resource) {
        return ((AdditionalFields)resource.getResourceEnum().getValueDescriptor().getOptions().getExtension(PANetworking.additionalFields)).getName();
    }

    public static String getResourceMetricName(Resource resource) {
        AdditionalFields resourceMetricOptions = (AdditionalFields)resource.getMetricEnum().getValueDescriptor().getOptions().getExtension(PANetworking.additionalFields);
        return resourceMetricOptions.getName() + "(" + resourceMetricOptions.getDescription() + ")";
    }

    public static Resource buildResource(int resourceEnumValue, int metricEnumValue) {
        Resource.Builder builder = Resource.newBuilder();
        builder.setResourceEnumValue(resourceEnumValue);
        builder.setMetricEnumValue(metricEnumValue);
        return builder.build();
    }
}

