/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.hotshard;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.rca.configs.HotShardRcaConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindow;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.ResourceFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotShardSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaVerticesMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.IndexShardKey;

public class HotShardRca
extends Rca<ResourceFlowUnit<HotNodeSummary>> {
    private static final Logger LOG = LogManager.getLogger(HotShardRca.class);
    private static final int SLIDING_WINDOW_IN_SECONDS = 60;
    private double cpuUtilizationThreshold;
    private double ioTotThroughputThreshold;
    private double ioTotSysCallRateThreshold;
    private final Metric cpuUtilization;
    private final Metric ioTotThroughput;
    private final Metric ioTotSyscallRate;
    private final int rcaPeriod;
    private int counter;
    protected Clock clock;
    private HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> cpuUtilizationMap;
    private HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> ioTotThroughputMap;
    private HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> ioTotSyscallRateMap;

    public <M extends Metric> HotShardRca(long evaluationIntervalSeconds, int rcaPeriod, M cpuUtilization, M ioTotThroughput, M ioTotSyscallRate) {
        super(evaluationIntervalSeconds);
        this.cpuUtilization = cpuUtilization;
        this.ioTotThroughput = ioTotThroughput;
        this.ioTotSyscallRate = ioTotSyscallRate;
        this.rcaPeriod = rcaPeriod;
        this.counter = 0;
        this.clock = Clock.systemUTC();
        this.cpuUtilizationMap = new HashMap();
        this.ioTotThroughputMap = new HashMap();
        this.ioTotSyscallRateMap = new HashMap();
        this.cpuUtilizationThreshold = 0.01;
        this.ioTotThroughputThreshold = 250000.0;
        this.ioTotSysCallRateThreshold = 0.01;
    }

    private void consumeFlowUnit(MetricFlowUnit metricFlowUnit, String metricType, HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> metricMap) {
        for (Record record : metricFlowUnit.getData()) {
            try {
                String indexName = (String)record.getValue(AllMetrics.CommonDimension.INDEX_NAME.toString(), String.class);
                Integer shardId = (Integer)record.getValue(AllMetrics.CommonDimension.SHARD_ID.toString(), Integer.class);
                if (indexName == null || shardId == null) continue;
                IndexShardKey indexShardKey = IndexShardKey.buildIndexShardKey(record);
                double usage = (Double)record.getValue("sum", Double.class);
                SlidingWindow<SlidingWindowData> usageDeque = metricMap.get(indexShardKey);
                if (null == usageDeque) {
                    usageDeque = new SlidingWindow(60, TimeUnit.SECONDS);
                    metricMap.put(indexShardKey, usageDeque);
                }
                usageDeque.next(new SlidingWindowData(this.clock.millis(), usage));
            }
            catch (Exception e) {
                PerformanceAnalyzerApp.RCA_VERTICES_METRICS_AGGREGATOR.updateStat(RcaVerticesMetrics.HOT_SHARD_RCA_ERROR, "", 1);
                LOG.error("Failed to parse metric in FlowUnit: {} from {}", (Object)record, (Object)metricType, (Object)e);
            }
        }
    }

    private void consumeMetrics(Metric metric, HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> metricMap) {
        for (MetricFlowUnit metricFlowUnit : metric.getFlowUnits()) {
            if (metricFlowUnit.getData() == null) continue;
            this.consumeFlowUnit(metricFlowUnit, metric.getClass().getName(), metricMap);
        }
    }

    private double fetchUsageValueFromMap(HashMap<IndexShardKey, SlidingWindow<SlidingWindowData>> usageMap, IndexShardKey indexShardKey) {
        double value = 0.0;
        if (usageMap.get(indexShardKey) != null) {
            value = usageMap.get(indexShardKey).readAvg(TimeUnit.SECONDS);
        }
        return value;
    }

    @Override
    public ResourceFlowUnit<HotNodeSummary> operate() {
        ++this.counter;
        this.consumeMetrics(this.cpuUtilization, this.cpuUtilizationMap);
        this.consumeMetrics(this.ioTotThroughput, this.ioTotThroughputMap);
        this.consumeMetrics(this.ioTotSyscallRate, this.ioTotSyscallRateMap);
        if (this.counter == this.rcaPeriod) {
            ResourceContext context = new ResourceContext(Resources.State.HEALTHY);
            InstanceDetails instanceDetails = this.getInstanceDetails();
            HashSet<IndexShardKey> indexShardKeySet = new HashSet<IndexShardKey>(this.cpuUtilizationMap.keySet());
            indexShardKeySet.addAll(this.ioTotThroughputMap.keySet());
            indexShardKeySet.addAll(this.ioTotSyscallRateMap.keySet());
            HotNodeSummary nodeSummary = new HotNodeSummary(instanceDetails.getInstanceId(), instanceDetails.getInstanceIp());
            for (IndexShardKey indexShardKey : indexShardKeySet) {
                double avgCpuUtilization = this.fetchUsageValueFromMap(this.cpuUtilizationMap, indexShardKey);
                double avgIoTotThroughput = this.fetchUsageValueFromMap(this.ioTotThroughputMap, indexShardKey);
                double avgIoTotSyscallRate = this.fetchUsageValueFromMap(this.ioTotSyscallRateMap, indexShardKey);
                if (!(avgCpuUtilization > this.cpuUtilizationThreshold) && !(avgIoTotThroughput > this.ioTotThroughputThreshold) && !(avgIoTotSyscallRate > this.ioTotSysCallRateThreshold)) continue;
                HotShardSummary summary = new HotShardSummary(indexShardKey.getIndexName(), String.valueOf(indexShardKey.getShardId()), instanceDetails.getInstanceId().toString(), 60);
                summary.setcpuUtilization(avgCpuUtilization);
                summary.setCpuUtilizationThreshold(this.cpuUtilizationThreshold);
                summary.setIoThroughput(avgIoTotThroughput);
                summary.setIoThroughputThreshold(this.ioTotThroughputThreshold);
                summary.setIoSysCallrate(avgIoTotSyscallRate);
                summary.setIoSysCallrateThreshold(this.ioTotSysCallRateThreshold);
                nodeSummary.appendNestedSummary(summary);
                context = new ResourceContext(Resources.State.UNHEALTHY);
                LOG.debug("Hot Shard Identified, Shard : {} , avgCpuUtilization = {} , avgIoTotThroughput = {}, avgIoTotSyscallRate = {}", (Object)indexShardKey, (Object)avgCpuUtilization, (Object)avgIoTotThroughput, (Object)avgIoTotSyscallRate);
            }
            this.counter = 0;
            boolean isDataNode = !instanceDetails.getIsClusterManager();
            return new ResourceFlowUnit<HotNodeSummary>(this.clock.millis(), context, nodeSummary, isDataNode);
        }
        LOG.debug("Empty FlowUnit returned for Hot Shard RCA");
        return new ResourceFlowUnit<HotNodeSummary>(this.clock.millis());
    }

    @Override
    public void readRcaConf(RcaConf conf) {
        HotShardRcaConfig configObj = conf.getHotShardRcaConfig();
        this.cpuUtilizationThreshold = configObj.getCpuUtilizationThreshold();
        this.ioTotThroughputThreshold = configObj.getIoTotThroughputThreshold();
        this.ioTotSysCallRateThreshold = configObj.getIoTotSysCallRateThreshold();
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        List<FlowUnitMessage> flowUnitMessages = args.getWireHopper().readFromWire(args.getNode());
        ArrayList flowUnitList = new ArrayList();
        LOG.debug("rca: Executing fromWire: {}", (Object)this.getClass().getSimpleName());
        for (FlowUnitMessage flowUnitMessage : flowUnitMessages) {
            flowUnitList.add(ResourceFlowUnit.buildFlowUnitFromWrapper(flowUnitMessage));
        }
        this.setFlowUnits(flowUnitList);
    }
}

