/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.load;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class LoadModelNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    @Generated
    private static final Logger log = LogManager.getLogger(LoadModelNodeResponse.class);
    private Map<String, String> modelLoadStatus;

    public LoadModelNodeResponse(DiscoveryNode node, Map<String, String> modelLoadStatus) {
        super(node);
        this.modelLoadStatus = modelLoadStatus;
    }

    public LoadModelNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.modelLoadStatus = in.readMap(s -> s.readString(), s -> s.readString());
        }
    }

    public static LoadModelNodeResponse readStats(StreamInput in) throws IOException {
        return new LoadModelNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.modelLoadStatus != null && this.modelLoadStatus.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelLoadStatus, (stream, v) -> stream.writeString(v), (stream, stats) -> stream.writeString(stats));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (this.modelLoadStatus != null && this.modelLoadStatus.size() > 0) {
            for (Map.Entry<String, String> stat : this.modelLoadStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }
}

