"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSuggestItem", {
  enumerable: true,
  get: function get() {
    return _suggest_item.EuiSuggestItem;
  }
});
exports.OuiSuggestItem = exports.DISPLAYS = exports.COLORS = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _common = require("../common");

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _suggest_item = require("../../eui_components/suggest/suggest_item");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var colorToClassNameMap = {
  tint0: 'ouiSuggestItem__type--tint0',
  tint1: 'ouiSuggestItem__type--tint1',
  tint2: 'ouiSuggestItem__type--tint2',
  tint3: 'ouiSuggestItem__type--tint3',
  tint4: 'ouiSuggestItem__type--tint4',
  tint5: 'ouiSuggestItem__type--tint5',
  tint6: 'ouiSuggestItem__type--tint6',
  tint7: 'ouiSuggestItem__type--tint7',
  tint8: 'ouiSuggestItem__type--tint8',
  tint9: 'ouiSuggestItem__type--tint9',
  tint10: 'ouiSuggestItem__type--tint10'
};
var COLORS = (0, _common.keysOf)(colorToClassNameMap);
exports.COLORS = COLORS;
var labelDisplayToClassMap = {
  fixed: 'ouiSuggestItem__labelDisplay--fixed',
  expand: 'ouiSuggestItem__labelDisplay--expand'
};
var descriptionDisplayToClassMap = {
  truncate: 'ouiSuggestItem__description--truncate',
  wrap: 'ouiSuggestItem__description--wrap'
};
var DISPLAYS = (0, _common.keysOf)(labelDisplayToClassMap);
exports.DISPLAYS = DISPLAYS;

var OuiSuggestItem = function OuiSuggestItem(_ref) {
  var className = _ref.className,
      label = _ref.label,
      type = _ref.type,
      _ref$labelDisplay = _ref.labelDisplay,
      labelDisplay = _ref$labelDisplay === void 0 ? 'fixed' : _ref$labelDisplay,
      _ref$labelWidth = _ref.labelWidth,
      labelWidth = _ref$labelWidth === void 0 ? '50' : _ref$labelWidth,
      description = _ref.description,
      _ref$descriptionDispl = _ref.descriptionDisplay,
      descriptionDisplay = _ref$descriptionDispl === void 0 ? 'truncate' : _ref$descriptionDispl,
      onClick = _ref.onClick,
      rest = _objectWithoutProperties(_ref, ["className", "label", "type", "labelDisplay", "labelWidth", "description", "descriptionDisplay", "onClick"]);

  var classes = (0, _classnames.default)('ouiSuggestItem', {
    'ouiSuggestItem-isClickable': onClick
  }, className);
  var colorClass = '';
  var labelDisplayCalculated = !description ? 'expand' : labelDisplay;
  var labelClassNames = (0, _classnames.default)('ouiSuggestItem__label', labelDisplayToClassMap[labelDisplayCalculated], _defineProperty({}, "ouiSuggestItem__label--width".concat(labelWidth), labelDisplay === 'fixed'));
  var descriptionClassNames = (0, _classnames.default)('ouiSuggestItem__description', descriptionDisplayToClassMap[descriptionDisplay]);

  if (type && type.color) {
    if (COLORS.indexOf(type.color) > -1) {
      colorClass = colorToClassNameMap[type.color];
    }
  }

  var innerContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiSuggestItem__type ".concat(colorClass)
  }, /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    type: type.iconType,
    color: "inherit" // forces the icon to inherit its parent color

  })), /*#__PURE__*/_react.default.createElement("span", {
    className: labelClassNames
  }, label), description && /*#__PURE__*/_react.default.createElement("span", {
    className: descriptionClassNames
  }, description));

  if (onClick) {
    return /*#__PURE__*/_react.default.createElement("button", _extends({
      onClick: onClick,
      className: classes
    }, rest), innerContent);
  } else {
    return /*#__PURE__*/_react.default.createElement("div", _extends({
      className: classes
    }, rest), innerContent);
  }
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiSuggestItem = OuiSuggestItem;
OuiSuggestItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Takes 'iconType' for OuiIcon and 'color'. 'color' can be tint1 through tint9.
     */
  type: _propTypes.default.shape({
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "push", "questionInCircle", "quote", "radius", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired,
    color: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.oneOf(["tint0", "tint1", "tint2", "tint3", "tint4", "tint5", "tint6", "tint7", "tint8", "tint9", "tint10"]).isRequired]).isRequired
  }).isRequired,

  /**
     * Label or primary text.
     */
  label: _propTypes.default.string.isRequired,

  /**
     * Description or secondary text (optional).
     */
  description: _propTypes.default.string,

  /**
     * Label display is 'fixed' by default. Label will increase its width beyond 50% if needed with 'expand'.
     */
  labelDisplay: _propTypes.default.oneOf(["fixed", "expand"]),

  /**
     * Width of 'label' when 'labelDisplay' is set to 'fixed'.
     * Accepts multiples of 10, from 20 to 90. Defaults to 50.
     */
  labelWidth: _propTypes.default.oneOf(["20", "30", "40", "50", "60", "70", "80", "90"]),

  /**
     * Set the way in which 'description' is displayed, defaults to 'truncate'.
     */
  descriptionDisplay: _propTypes.default.oneOf(["truncate", "wrap"]),
  onClick: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.oneOf([undefined])])
};