/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.config.setting.handler;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Setting;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverrides;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesHelper;
import org.opensearch.performanceanalyzer.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingListener;
import org.opensearch.performanceanalyzer.config.setting.ClusterSettingsManager;

public class ConfigOverridesClusterSettingHandler
implements ClusterSettingListener<String> {
    private static final Logger LOG = LogManager.getLogger(ConfigOverridesClusterSettingHandler.class);
    private final ClusterSettingsManager clusterSettingsManager;
    private final ConfigOverridesWrapper overridesHolder;
    private final Setting<String> setting;

    public ConfigOverridesClusterSettingHandler(ConfigOverridesWrapper overridesHolder, ClusterSettingsManager clusterSettingsManager, Setting<String> setting) {
        this.clusterSettingsManager = clusterSettingsManager;
        this.overridesHolder = overridesHolder;
        this.setting = setting;
    }

    @Override
    public void onSettingUpdate(String newSettingValue) {
        try {
            if (newSettingValue != null && !newSettingValue.isEmpty()) {
                ConfigOverrides newOverrides = ConfigOverridesHelper.deserialize((String)newSettingValue);
                this.overridesHolder.setCurrentClusterConfigOverrides(newOverrides);
                this.overridesHolder.setLastUpdatedTimestamp(System.currentTimeMillis());
            } else {
                LOG.warn("Config override setting update called with empty string. Ignoring.");
            }
        }
        catch (IOException e) {
            LOG.error("Unable to apply received cluster setting update: " + newSettingValue, (Throwable)e);
        }
    }

    public void updateConfigOverrides(ConfigOverrides newOverrides) throws IOException {
        String newClusterSettingValue = this.buildClusterSettingValue(newOverrides);
        LOG.debug("Updating cluster setting with new overrides string: {}", (Object)newClusterSettingValue);
        this.clusterSettingsManager.updateSetting(this.setting, newClusterSettingValue);
    }

    private String buildClusterSettingValue(ConfigOverrides newOverrides) throws IOException {
        ConfigOverrides mergedConfigOverrides = this.merge(this.overridesHolder.getCurrentClusterConfigOverrides(), newOverrides);
        return ConfigOverridesHelper.serialize((ConfigOverrides)mergedConfigOverrides);
    }

    private ConfigOverrides merge(ConfigOverrides current, ConfigOverrides other) {
        ConfigOverrides merged = new ConfigOverrides();
        ConfigOverrides.Overrides optionalCurrentEnabled = Optional.ofNullable(current.getEnable()).orElseGet(ConfigOverrides.Overrides::new);
        ConfigOverrides.Overrides optionalCurrentDisabled = Optional.ofNullable(current.getDisable()).orElseGet(ConfigOverrides.Overrides::new);
        ConfigOverrides.Overrides optionalNewEnable = Optional.ofNullable(other.getEnable()).orElseGet(ConfigOverrides.Overrides::new);
        ConfigOverrides.Overrides optionalNewDisable = Optional.ofNullable(other.getDisable()).orElseGet(ConfigOverrides.Overrides::new);
        this.mergeRcas(merged, optionalCurrentEnabled, optionalNewEnable, optionalCurrentDisabled, optionalNewDisable);
        this.mergeDeciders(merged, optionalCurrentEnabled, optionalNewEnable, optionalCurrentDisabled, optionalNewDisable);
        this.mergeActions(merged, optionalCurrentEnabled, optionalNewEnable, optionalCurrentDisabled, optionalNewDisable);
        this.mergeCollectors(merged, optionalCurrentEnabled, optionalNewEnable, optionalCurrentDisabled, optionalNewDisable);
        return merged;
    }

    private void mergeRcas(ConfigOverrides merged, ConfigOverrides.Overrides baseEnabled, ConfigOverrides.Overrides newEnabled, ConfigOverrides.Overrides baseDisabled, ConfigOverrides.Overrides newDisabled) {
        List currentRcaEnabled = Optional.ofNullable(baseEnabled.getRcas()).orElseGet(ArrayList::new);
        List currentRcaDisabled = Optional.ofNullable(baseDisabled.getRcas()).orElseGet(ArrayList::new);
        List requestedRcasEnabled = Optional.ofNullable(newEnabled.getRcas()).orElseGet(ArrayList::new);
        List requestedRcasDisabled = Optional.ofNullable(newDisabled.getRcas()).orElseGet(ArrayList::new);
        List<String> mergedRcasEnabled = this.combineLists(currentRcaEnabled, requestedRcasEnabled, requestedRcasDisabled);
        List<String> mergedRcasDisabled = this.combineLists(currentRcaDisabled, requestedRcasDisabled, requestedRcasEnabled);
        merged.getEnable().setRcas(mergedRcasEnabled);
        merged.getDisable().setRcas(mergedRcasDisabled);
    }

    private void mergeDeciders(ConfigOverrides merged, ConfigOverrides.Overrides baseEnabled, ConfigOverrides.Overrides newEnabled, ConfigOverrides.Overrides baseDisabled, ConfigOverrides.Overrides newDisabled) {
        List currentDecidersEnabled = Optional.ofNullable(baseEnabled.getDeciders()).orElseGet(ArrayList::new);
        List currentDecidersDisabled = Optional.ofNullable(baseDisabled.getDeciders()).orElseGet(ArrayList::new);
        List requestedDecidersEnabled = Optional.ofNullable(newEnabled.getDeciders()).orElseGet(ArrayList::new);
        List requestedDecidersDisabled = Optional.ofNullable(newDisabled.getDeciders()).orElseGet(ArrayList::new);
        List<String> mergedDecidersEnabled = this.combineLists(currentDecidersEnabled, requestedDecidersEnabled, requestedDecidersDisabled);
        List<String> mergedDecidersDisabled = this.combineLists(currentDecidersDisabled, requestedDecidersDisabled, requestedDecidersEnabled);
        merged.getEnable().setDeciders(mergedDecidersEnabled);
        merged.getDisable().setDeciders(mergedDecidersDisabled);
    }

    private void mergeActions(ConfigOverrides merged, ConfigOverrides.Overrides baseEnabled, ConfigOverrides.Overrides newEnabled, ConfigOverrides.Overrides baseDisabled, ConfigOverrides.Overrides newDisabled) {
        List currentActionsEnabled = Optional.ofNullable(baseEnabled.getActions()).orElseGet(ArrayList::new);
        List currentActionsDisabled = Optional.ofNullable(baseDisabled.getActions()).orElseGet(ArrayList::new);
        List requestedActionsEnabled = Optional.ofNullable(newEnabled.getActions()).orElseGet(ArrayList::new);
        List requestedActionsDisabled = Optional.ofNullable(newDisabled.getActions()).orElseGet(ArrayList::new);
        List<String> mergedActionsEnabled = this.combineLists(currentActionsEnabled, requestedActionsEnabled, requestedActionsDisabled);
        List<String> mergedActionsDisabled = this.combineLists(currentActionsDisabled, requestedActionsDisabled, requestedActionsEnabled);
        merged.getEnable().setActions(mergedActionsEnabled);
        merged.getDisable().setActions(mergedActionsDisabled);
    }

    private void mergeCollectors(ConfigOverrides merged, ConfigOverrides.Overrides baseEnabled, ConfigOverrides.Overrides newEnabled, ConfigOverrides.Overrides baseDisabled, ConfigOverrides.Overrides newDisabled) {
        List currentCollectorsEnabled = Optional.ofNullable(baseEnabled.getCollectors()).orElseGet(ArrayList::new);
        List currentCollectorsDisabled = Optional.ofNullable(baseDisabled.getCollectors()).orElseGet(ArrayList::new);
        List requestedCollectorsEnabled = Optional.ofNullable(newEnabled.getCollectors()).orElseGet(ArrayList::new);
        List requestedCollectorsDisabled = Optional.ofNullable(newDisabled.getCollectors()).orElseGet(ArrayList::new);
        List<String> mergedCollectorsEnabled = this.combineLists(currentCollectorsEnabled, requestedCollectorsEnabled, requestedCollectorsDisabled);
        List<String> mergedCollectorsDisabled = this.combineLists(currentCollectorsDisabled, requestedCollectorsDisabled, requestedCollectorsEnabled);
        merged.getEnable().setCollectors(mergedCollectorsEnabled);
        merged.getDisable().setCollectors(mergedCollectorsDisabled);
    }

    private List<String> combineLists(List<String> baseList, List<String> addList, List<String> removeList) {
        HashSet<String> combinedEnabled = new HashSet<String>(baseList);
        combinedEnabled.addAll(addList);
        combinedEnabled.removeAll(removeList);
        return ImmutableList.copyOf(combinedEnabled);
    }
}

