/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.AD;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Kmeans;
import org.opensearch.sql.ast.tree.ML;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParser;
import org.opensearch.sql.ppl.antlr.parser.OpenSearchPPLParserBaseVisitor;
import org.opensearch.sql.ppl.parser.AstExpressionBuilder;
import org.opensearch.sql.ppl.utils.ArgumentFactory;
import org.opensearch.sql.utils.SystemIndexUtils;

public class AstBuilder
extends OpenSearchPPLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder;
    private final String query;

    @Override
    public UnresolvedPlan visitQueryStatement(OpenSearchPPLParser.QueryStatementContext ctx) {
        UnresolvedPlan pplCommand = (UnresolvedPlan)this.visit((ParseTree)ctx.pplCommands());
        return ctx.commands().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).reduce(pplCommand, (r, e) -> e.attach(r));
    }

    @Override
    public UnresolvedPlan visitSearchFrom(OpenSearchPPLParser.SearchFromContext ctx) {
        return this.visitFromClause(ctx.fromClause());
    }

    @Override
    public UnresolvedPlan visitSearchFromFilter(OpenSearchPPLParser.SearchFromFilterContext ctx) {
        return new Filter(this.internalVisitExpression((ParseTree)ctx.logicalExpression())).attach((UnresolvedPlan)this.visit((ParseTree)ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitSearchFilterFrom(OpenSearchPPLParser.SearchFilterFromContext ctx) {
        return new Filter(this.internalVisitExpression((ParseTree)ctx.logicalExpression())).attach((UnresolvedPlan)this.visit((ParseTree)ctx.fromClause()));
    }

    @Override
    public UnresolvedPlan visitDescribeCommand(OpenSearchPPLParser.DescribeCommandContext ctx) {
        Relation table = (Relation)this.visitTableSourceClause(ctx.tableSourceClause());
        QualifiedName tableQualifiedName = table.getTableQualifiedName();
        ArrayList<String> parts = new ArrayList<String>(tableQualifiedName.getParts());
        parts.set(parts.size() - 1, SystemIndexUtils.mappingTable((String)((String)parts.get(parts.size() - 1))));
        return new Relation((UnresolvedExpression)new QualifiedName(parts));
    }

    @Override
    public UnresolvedPlan visitShowDataSourcesCommand(OpenSearchPPLParser.ShowDataSourcesCommandContext ctx) {
        return new Relation((UnresolvedExpression)AstDSL.qualifiedName((String[])new String[]{".DATASOURCES"}));
    }

    @Override
    public UnresolvedPlan visitWhereCommand(OpenSearchPPLParser.WhereCommandContext ctx) {
        return new Filter(this.internalVisitExpression((ParseTree)ctx.logicalExpression()));
    }

    @Override
    public UnresolvedPlan visitFieldsCommand(OpenSearchPPLParser.FieldsCommandContext ctx) {
        return new Project(ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList()), ArgumentFactory.getArgumentList(ctx));
    }

    @Override
    public UnresolvedPlan visitRenameCommand(OpenSearchPPLParser.RenameCommandContext ctx) {
        return new Rename(ctx.renameClasue().stream().map(ct -> new Map(this.internalVisitExpression((ParseTree)ct.orignalField), this.internalVisitExpression((ParseTree)ct.renamedField))).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitStatsCommand(OpenSearchPPLParser.StatsCommandContext ctx) {
        ImmutableList.Builder aggListBuilder = new ImmutableList.Builder();
        for (OpenSearchPPLParser.StatsAggTermContext aggCtx : ctx.statsAggTerm()) {
            UnresolvedExpression aggExpression = this.internalVisitExpression((ParseTree)aggCtx.statsFunction());
            String name = aggCtx.alias == null ? this.getTextInQuery(aggCtx) : StringUtils.unquoteIdentifier((String)aggCtx.alias.getText());
            Alias alias = new Alias(name, aggExpression);
            aggListBuilder.add((Object)alias);
        }
        List groupList = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::fieldList).map(expr -> expr.fieldExpression().stream().map(groupCtx -> new Alias(this.getTextInQuery((ParserRuleContext)groupCtx), this.internalVisitExpression((ParseTree)groupCtx))).collect(Collectors.toList())).orElse(Collections.emptyList());
        UnresolvedExpression span = Optional.ofNullable(ctx.statsByClause()).map(OpenSearchPPLParser.StatsByClauseContext::bySpanClause).map(this::internalVisitExpression).orElse(null);
        Aggregation aggregation = new Aggregation((List)aggListBuilder.build(), Collections.emptyList(), groupList, span, ArgumentFactory.getArgumentList(ctx));
        return aggregation;
    }

    @Override
    public UnresolvedPlan visitDedupCommand(OpenSearchPPLParser.DedupCommandContext ctx) {
        return new Dedupe(ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()));
    }

    @Override
    public UnresolvedPlan visitHeadCommand(OpenSearchPPLParser.HeadCommandContext ctx) {
        Integer size = ctx.number != null ? Integer.parseInt(ctx.number.getText()) : 10;
        Integer from = ctx.from != null ? Integer.parseInt(ctx.from.getText()) : 0;
        return new Head(size, from);
    }

    @Override
    public UnresolvedPlan visitSortCommand(OpenSearchPPLParser.SortCommandContext ctx) {
        return new Sort(ctx.sortbyClause().sortField().stream().map(sort -> (Field)this.internalVisitExpression((ParseTree)sort)).collect(Collectors.toList()));
    }

    @Override
    public UnresolvedPlan visitEvalCommand(OpenSearchPPLParser.EvalCommandContext ctx) {
        return new Eval(ctx.evalClause().stream().map(ct -> (Let)this.internalVisitExpression((ParseTree)ct)).collect(Collectors.toList()));
    }

    private List<UnresolvedExpression> getGroupByList(OpenSearchPPLParser.ByClauseContext ctx) {
        return ctx.fieldList().fieldExpression().stream().map(this::internalVisitExpression).collect(Collectors.toList());
    }

    private List<Field> getFieldList(OpenSearchPPLParser.FieldListContext ctx) {
        return ctx.fieldExpression().stream().map(field -> (Field)this.internalVisitExpression((ParseTree)field)).collect(Collectors.toList());
    }

    @Override
    public UnresolvedPlan visitRareCommand(OpenSearchPPLParser.RareCommandContext ctx) {
        List groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.RARE, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitGrokCommand(OpenSearchPPLParser.GrokCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.pattern);
        return new Parse(ParseMethod.GROK, sourceField, pattern, (java.util.Map)ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitParseCommand(OpenSearchPPLParser.ParseCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        Literal pattern = (Literal)this.internalVisitExpression((ParseTree)ctx.pattern);
        return new Parse(ParseMethod.REGEX, sourceField, pattern, (java.util.Map)ImmutableMap.of());
    }

    @Override
    public UnresolvedPlan visitPatternsCommand(OpenSearchPPLParser.PatternsCommandContext ctx) {
        UnresolvedExpression sourceField = this.internalVisitExpression((ParseTree)ctx.source_field);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.patternsParameter().forEach(x -> builder.put((Object)((ParseTree)x.children.get(0)).toString(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.children.get(2)))));
        ImmutableMap arguments = builder.build();
        Literal pattern = arguments.getOrDefault("pattern", AstDSL.stringLiteral((String)""));
        return new Parse(ParseMethod.PATTERNS, sourceField, pattern, (java.util.Map)arguments);
    }

    @Override
    public UnresolvedPlan visitTopCommand(OpenSearchPPLParser.TopCommandContext ctx) {
        List groupList = ctx.byClause() == null ? Collections.emptyList() : this.getGroupByList(ctx.byClause());
        return new RareTopN(RareTopN.CommandType.TOP, ArgumentFactory.getArgumentList(ctx), this.getFieldList(ctx.fieldList()), groupList);
    }

    @Override
    public UnresolvedPlan visitFromClause(OpenSearchPPLParser.FromClauseContext ctx) {
        return this.visitTableSourceClause(ctx.tableSourceClause());
    }

    @Override
    public UnresolvedPlan visitTableSourceClause(OpenSearchPPLParser.TableSourceClauseContext ctx) {
        return new Relation(ctx.tableSource().stream().map(this::internalVisitExpression).collect(Collectors.toList()));
    }

    @Override
    @Generated
    public UnresolvedPlan visitTableFunction(OpenSearchPPLParser.TableFunctionContext ctx) {
        return null;
    }

    private UnresolvedExpression internalVisitExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    @Override
    public UnresolvedPlan visitKmeansCommand(OpenSearchPPLParser.KmeansCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.kmeansParameter().forEach(x -> builder.put((Object)((ParseTree)x.children.get(0)).toString(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.children.get(2)))));
        return new Kmeans((java.util.Map)builder.build());
    }

    @Override
    public UnresolvedPlan visitAdCommand(OpenSearchPPLParser.AdCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.adParameter().forEach(x -> builder.put((Object)((ParseTree)x.children.get(0)).toString(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.children.get(2)))));
        return new AD((java.util.Map)builder.build());
    }

    @Override
    public UnresolvedPlan visitMlCommand(OpenSearchPPLParser.MlCommandContext ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ctx.mlArg().forEach(x -> builder.put((Object)x.argName.getText(), (Object)((Literal)this.internalVisitExpression((ParseTree)x.argValue))));
        return new ML((java.util.Map)builder.build());
    }

    private String getTextInQuery(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        Token stop = ctx.getStop();
        return this.query.substring(start.getStartIndex(), stop.getStopIndex() + 1);
    }

    @Generated
    public AstBuilder(AstExpressionBuilder expressionBuilder, String query) {
        this.expressionBuilder = expressionBuilder;
        this.query = query;
    }
}

