/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.ml.common.dataframe.AbstractDataFrame;
import org.opensearch.ml.common.dataframe.ColumnMeta;
import org.opensearch.ml.common.dataframe.ColumnValueBuilder;
import org.opensearch.ml.common.dataframe.DataFrame;
import org.opensearch.ml.common.dataframe.DataFrameType;
import org.opensearch.ml.common.dataframe.Row;

public class DefaultDataFrame
extends AbstractDataFrame {
    private static final String COLUMN_META_FIELD = "column_metas";
    private static final String ROWS_FIELD = "rows";
    private final List<Row> rows;
    private final ColumnMeta[] columnMetas;

    public DefaultDataFrame(ColumnMeta[] columnMetas) {
        super(DataFrameType.DEFAULT);
        this.columnMetas = columnMetas;
        this.rows = new ArrayList<Row>();
    }

    public DefaultDataFrame(ColumnMeta[] columnMetas, List<Row> rows) {
        super(DataFrameType.DEFAULT);
        this.columnMetas = columnMetas;
        this.rows = rows;
    }

    public DefaultDataFrame(StreamInput streamInput) throws IOException {
        super(DataFrameType.DEFAULT);
        this.columnMetas = (ColumnMeta[])streamInput.readArray(ColumnMeta::new, ColumnMeta[]::new);
        this.rows = streamInput.readList(Row::new);
    }

    @Override
    public void appendRow(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("input values can't be null");
        }
        Row row = new Row(values.length);
        for (int i = 0; i < values.length; ++i) {
            row.setValue(i, ColumnValueBuilder.build(values[i]));
        }
        this.appendRow(row);
    }

    @Override
    public void appendRow(Row row) {
        if (row == null) {
            throw new IllegalArgumentException("input row can't be null");
        }
        if (row.size() != this.columnMetas.length) {
            String message = String.format("the size is different between input row:%d and column size in dataframe:%d", row.size(), this.columnMetas.length);
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < this.columnMetas.length; ++i) {
            if (this.columnMetas[i].getColumnType() == row.getValue(i).columnType()) continue;
            String message = String.format("the column type is different in column meta:%s and input row:%s for index: %d", new Object[]{this.columnMetas[i].getColumnType(), row.getValue(i).columnType(), i});
            throw new IllegalArgumentException(message);
        }
        this.rows.add(row);
    }

    @Override
    public Row getRow(int index) {
        return this.rows.get(index);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public ColumnMeta[] columnMetas() {
        return Arrays.copyOf(this.columnMetas, this.columnMetas.length);
    }

    @Override
    public DataFrame remove(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnMetas.length) {
            throw new IllegalArgumentException("columnIndex can't be negative or bigger than columns length:" + this.columnMetas.length);
        }
        ColumnMeta[] newColumnMetas = new ColumnMeta[this.columnMetas.length - 1];
        int index = 0;
        for (int i = 0; i < this.columnMetas.length && i != columnIndex; ++i) {
            newColumnMetas[index++] = this.columnMetas[i];
        }
        return new DefaultDataFrame(newColumnMetas, this.rows.stream().map(row -> row.remove(columnIndex)).collect(Collectors.toList()));
    }

    @Override
    public DataFrame select(int[] columns) {
        if (columns == null || columns.length == 0) {
            throw new IllegalArgumentException("columns can't be null or empty");
        }
        ColumnMeta[] newColumnMetas = new ColumnMeta[columns.length];
        int index = 0;
        for (int col : columns) {
            if (col < 0 || col >= this.columnMetas.length) {
                throw new IllegalArgumentException("columnIndex can't be negative or bigger than columns length");
            }
            newColumnMetas[index++] = this.columnMetas[col];
        }
        return new DefaultDataFrame(newColumnMetas, this.rows.stream().map(row -> row.select(columns)).collect(Collectors.toList()));
    }

    @Override
    public int getColumnIndex(String target) {
        List columnNames = Arrays.stream(this.columnMetas()).map(ColumnMeta::getName).collect(Collectors.toList());
        int targetIndex = -1;
        for (int i = 0; i < columnNames.size(); ++i) {
            if (!((String)columnNames.get(i)).equals(target)) continue;
            targetIndex = i;
            break;
        }
        if (targetIndex == -1) {
            throw new IllegalArgumentException("No matched target when generating dataset from data frame.");
        }
        return targetIndex;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray((Writeable[])this.columnMetas);
        out.writeList(this.rows);
    }

    public static DefaultDataFrame parse(XContentParser parser) throws IOException {
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        ArrayList<Row> rows = new ArrayList<Row>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "column_metas": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        columnMetas.add(ColumnMeta.parse(parser));
                    }
                    continue block8;
                }
                case "rows": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        rows.add(Row.parse(parser));
                    }
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new DefaultDataFrame(columnMetas.toArray(new ColumnMeta[0]), rows);
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, EMPTY_PARAMS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(COLUMN_META_FIELD);
        for (ColumnMeta columnMeta : this.columnMetas) {
            columnMeta.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray(ROWS_FIELD);
        for (Row row : this.rows) {
            row.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Generated
    public String toString() {
        return "DefaultDataFrame(rows=" + this.rows + ", columnMetas=" + Arrays.deepToString(this.columnMetas) + ")";
    }
}

