13.1 Sound In

# Sound In

One simple (and perhaps familiar) way of accessing sound inputs is using our friend `synth` by specifying the `:sound_in` synth:

```
synth :sound_in
```

This will operate just like any synth such as `synth :dsaw` with the
exception that the audio generated will be read directly from the first
input of your system's sound card. On laptops, this is typically the
built-in microphone, but if you have an external sound card, you can
plug any audio input to the first input.

## Increasing the Duration

One thing you might notice is that just like `synth :dsaw` the
`:sound_in` synth only lasts for 1 beat as it has a standard envelope. If you'd like to keep it open for a little longer, change the ADSR envelope settings. For example the following will keep the synth open for 8 beats before closing the connection:

```
synth :sound_in, sustain: 8
```

## Adding FX

Of course, just like any normal synth, you can easily layer on effects with the FX block:

```
with_fx :reverb do
  with_fx :distortion do
    synth :sound_in, sustain: 8
  end
end
```

If you have plugged in a guitar to your first input, you should be able to hear it with distortion and reverb until the synth terminates as expected.

You are free to use the `:sound_in` synth as many times as you like concurrently (just like you would do with any normal synth). For example, the following will play two `:sound_in` synths at the same time - one through distortion and one through reverb:

```
with_fx :distortion do
  synth :sound_in, sustain: 8
end

with_fx :reverb do  
  synth :sound_in, sustain: 8
end
```

## Multiple Inputs

You can select which audio input you want to play with the `input:`
opt. You can also specify a stereo input (two consecutive inputs) using
the `:sound_in_stereo` synth. For example, if you have a sound card with
at least three inputs, you can treat the first two as a stereo stream
and add distortion and the third as a mono stream and add reverb with
the following code:

```
with_fx :distortion do
  synth :sound_in_stereo, sustain: 8, input: 1
end

with_fx :reverb do  
  synth :sound_in, sustain: 8, input: 3
end
```


## Potential Issues

However, although this is a useful technique, there are a couple of
limitations to this approach. Firstly, it only works for a specific
duration (due to it having an ADSR envelope) and secondly, there's no
way to switch the FX around once the synth has been triggered. Both of
these things are typical requests when working with external audio feeds
such as microphones, guitars and external synthesisers. We'll therefore
take a look at Sonic Pi's solution to the problem of manipulating a
(potentially) infinite stream of live audio input: `live_audio`.
