/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.ISMTemplateServiceKt;
import org.opensearch.indexmanagement.indexstatemanagement.action.ReplicaCountAction;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.model.State;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.indexpolicy.TransportIndexPolicyActionKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001.BG\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00022\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-H\u0014R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "ismIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "awarenessReplicaBalance", "Lorg/opensearch/cluster/routing/allocation/AwarenessReplicaBalance;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/IndexManagementIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;Lorg/opensearch/cluster/routing/allocation/AwarenessReplicaBalance;)V", "getAwarenessReplicaBalance", "()Lorg/opensearch/cluster/routing/allocation/AwarenessReplicaBalance;", "setAwarenessReplicaBalance", "(Lorg/opensearch/cluster/routing/allocation/AwarenessReplicaBalance;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getIsmIndices", "()Lorg/opensearch/indexmanagement/IndexManagementIndices;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "IndexPolicyHandler", "opensearch-index-management"})
public final class TransportIndexPolicyAction
extends HandledTransportAction<IndexPolicyRequest, IndexPolicyResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final IndexManagementIndices ismIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private AwarenessReplicaBalance awarenessReplicaBalance;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexPolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexManagementIndices ismIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull AwarenessReplicaBalance awarenessReplicaBalance) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)ismIndices, (String)"ismIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)awarenessReplicaBalance, (String)"awarenessReplicaBalance");
        super("cluster:admin/opendistro/ism/policy/write", transportService, actionFilters, IndexPolicyRequest::new);
        this.client = client;
        this.ismIndices = ismIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.awarenessReplicaBalance = awarenessReplicaBalance;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportIndexPolicyAction._init_$lambda-0(this, arg_0));
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final IndexManagementIndices getIsmIndices() {
        return this.ismIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final AwarenessReplicaBalance getAwarenessReplicaBalance() {
        return this.awarenessReplicaBalance;
    }

    public final void setAwarenessReplicaBalance(@NotNull AwarenessReplicaBalance awarenessReplicaBalance) {
        Intrinsics.checkNotNullParameter((Object)awarenessReplicaBalance, (String)"<set-?>");
        this.awarenessReplicaBalance = awarenessReplicaBalance;
    }

    protected void doExecute(@NotNull Task task, @NotNull IndexPolicyRequest request, @NotNull ActionListener<IndexPolicyResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new IndexPolicyHandler(this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda-0(TransportIndexPolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction$IndexPolicyHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/TransportIndexPolicyAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/indexpolicy/IndexPolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "onCreateMappingsResponse", "", "Lorg/opensearch/action/support/master/AcknowledgedResponse;", "putPolicy", "start", "validate", "validateISMTemplates", "ismTemplateList", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "opensearch-index-management"})
    public final class IndexPolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<IndexPolicyResponse> actionListener;
        @NotNull
        private final IndexPolicyRequest request;
        @Nullable
        private final User user;

        public IndexPolicyHandler(@NotNull NodeClient client, @NotNull ActionListener<IndexPolicyResponse> actionListener, @Nullable IndexPolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportIndexPolicyAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ IndexPolicyHandler(NodeClient nodeClient, ActionListener actionListener, IndexPolicyRequest indexPolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class IndexPolicyHandler\u2026turn null\n        }\n    }");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(nodeClient, (ActionListener<IndexPolicyResponse>)actionListener, indexPolicyRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            this.validate();
            TransportIndexPolicyActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportIndexPolicyAction transportIndexPolicyAction = TransportIndexPolicyAction.this;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                Boolean bl2 = transportIndexPolicyAction.filterByEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"filterByEnabled");
                if (!SecurityUtils.Companion.validateUserConfiguration(this.user, bl2, this.actionListener)) {
                    return;
                }
                transportIndexPolicyAction.getIsmIndices().checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>(this){
                    final /* synthetic */ IndexPolicyHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexPolicyHandler.access$onCreateMappingsResponse(this.this$0, response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (t instanceof ResourceAlreadyExistsException) {
                            IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchStatusException(((ResourceAlreadyExistsException)((Object)t)).getLocalizedMessage(), RestStatus.CONFLICT, new Object[0]));
                        } else {
                            Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                            if (throwable == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                            }
                            IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                        }
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void validate() {
            void $this$forEach$iv;
            AutoExpandReplicas autoExpandReplica = (AutoExpandReplicas)AutoExpandReplicas.SETTING.get(Settings.EMPTY);
            Iterable iterable = this.request.getPolicy().getStates();
            TransportIndexPolicyAction transportIndexPolicyAction = TransportIndexPolicyAction.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                State state = (State)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = state.getActions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Optional error;
                    Action action = (Action)element$iv2;
                    boolean bl2 = false;
                    if (!(action instanceof ReplicaCountAction) || !(error = transportIndexPolicyAction.getAwarenessReplicaBalance().validate(((ReplicaCountAction)action).getNumOfReplicas(), autoExpandReplica)).isPresent()) continue;
                    ValidationException ex = new ValidationException();
                    ex.addValidationError((String)error.get());
                    this.actionListener.onFailure((Exception)ex);
                }
            }
        }

        private final void onCreateMappingsResponse(AcknowledgedResponse response2) {
            if (response2.isAcknowledged()) {
                TransportIndexPolicyActionKt.access$getLog$p().info("Successfully created or updated .opendistro-ism-config with newest mappings.");
                List<ISMTemplate> reqTemplates = this.request.getPolicy().getIsmTemplate();
                if (reqTemplates != null) {
                    this.validateISMTemplates(reqTemplates);
                } else {
                    this.putPolicy();
                }
            } else {
                TransportIndexPolicyActionKt.access$getLog$p().error("Unable to create or update .opendistro-ism-config with newest mapping.");
                this.actionListener.onFailure((Exception)new OpenSearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void validateISMTemplates(List<ISMTemplate> ismTemplateList) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = (String[])ismTemplateList;
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ISMTemplate iSMTemplate = (ISMTemplate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndexPatterns());
            }
            OpenSearchException possibleEx = ISMTemplateServiceKt.validateFormat(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
            if (possibleEx != null) {
                this.actionListener.onFailure((Exception)((Object)possibleEx));
                return;
            }
            Pair<List<String>, List<String>> selfOverlap = ISMTemplateServiceKt.findSelfConflictingTemplates(ismTemplateList);
            if (selfOverlap != null) {
                String errorMessage = "New policy " + this.request.getPolicyID() + " has an ISM template with index pattern " + selfOverlap.getFirst() + " matching this policy's other ISM templates with index patterns " + selfOverlap.getSecond() + ", please use different priority";
                this.actionListener.onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new IllegalArgumentException(errorMessage))));
                return;
            }
            stringArray = new String[]{".opendistro-ism-config"};
            SearchRequest searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.existsQuery((String)"policy.ism_template")).size(10000)).indices(stringArray);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(TransportIndexPolicyAction.this, ismTemplateList, this){
                final /* synthetic */ TransportIndexPolicyAction this$0;
                final /* synthetic */ List<ISMTemplate> $ismTemplateList;
                final /* synthetic */ IndexPolicyHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.$ismTemplateList = $ismTemplateList;
                    this.this$1 = $receiver2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(@NotNull SearchResponse response2) {
                    void $this$forEach$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    List<T> policies2 = OpenSearchExtensionsKt.parseFromSearchResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                        @NotNull
                        public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                        }
                    });
                    Iterable $this$map$iv = policies2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Policy policy2 = (Policy)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)it.getId(), it.getIsmTemplate()));
                    }
                    Map<K, V> policyToTemplateMap = org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt.filterNotNullValues(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
                    $this$map$iv = this.$ismTemplateList;
                    IndexPolicyHandler indexPolicyHandler = this.this$1;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ISMTemplate it = (ISMTemplate)element$iv;
                        boolean bl = false;
                        Map<String, List<String>> conflictingPolicyTemplates = ISMTemplateServiceKt.findConflictingPolicyTemplates(policyToTemplateMap, IndexPolicyHandler.access$getRequest$p(indexPolicyHandler).getPolicyID(), it.getIndexPatterns(), it.getPriority());
                        if (!(!conflictingPolicyTemplates.isEmpty())) continue;
                        String errorMessage = "New policy " + IndexPolicyHandler.access$getRequest$p(indexPolicyHandler).getPolicyID() + " has an ISM template with index pattern " + it.getIndexPatterns() + " matching existing policy templates, please use a different priority than " + it.getPriority();
                        IndexPolicyHandler.access$getActionListener$p(indexPolicyHandler).onFailure((Exception)((Object)IndexManagementException.Companion.wrap(new IllegalArgumentException(errorMessage))));
                        return;
                    }
                    IndexPolicyHandler.access$putPolicy(this.this$1);
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    IndexPolicyHandler.access$getActionListener$p(this.this$1).onFailure((Exception)throwable);
                }
            });
        }

        private final void putPolicy() {
            Policy policy2 = Policy.copy$default(this.request.getPolicy(), null, 0L, 0L, null, IndexUtils.Companion.getIndexManagementConfigSchemaVersion(), null, null, null, null, null, this.user, 1007, null);
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(".opendistro-ism-config").setRefreshPolicy(this.request.getRefreshPolicy());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
            IndexRequest indexRequest2 = (IndexRequest)indexRequest.source(policy2.toXContent(xContentBuilder)).id(this.request.getPolicyID()).timeout(IndexRequest.DEFAULT_TIMEOUT);
            if (this.request.getSeqNo() == -2L || this.request.getPrimaryTerm() == 0L) {
                indexRequest2.opType(DocWriteRequest.OpType.CREATE);
            } else {
                indexRequest2.setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm());
            }
            this.client.index(indexRequest2, (ActionListener)new ActionListener<IndexResponse>(this){
                final /* synthetic */ IndexPolicyHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(@NotNull IndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    String failureReasons2 = IndexPolicyHandler.access$checkShardsFailure(this.this$0, response2);
                    if (failureReasons2 != null) {
                        IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)new OpenSearchStatusException(failureReasons2.toString(), response2.status(), new Object[0]));
                        return;
                    }
                    ActionListener actionListener = IndexPolicyHandler.access$getActionListener$p(this.this$0);
                    String string = response2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                    String string2 = string;
                    long l = response2.getVersion();
                    long l2 = response2.getPrimaryTerm();
                    long l3 = response2.getSeqNo();
                    Policy policy2 = IndexPolicyHandler.access$getRequest$p(this.this$0).getPolicy();
                    string = response2.status();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.status()");
                    actionListener.onResponse((Object)((Object)new IndexPolicyResponse(string2, l, l2, l3, policy2, (RestStatus)string)));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    IndexPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                }
            });
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons2 = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons2.append(entry.reason());
                }
                return failureReasons2.toString();
            }
            return null;
        }

        public static final /* synthetic */ void access$putPolicy(IndexPolicyHandler $this) {
            $this.putPolicy();
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(IndexPolicyHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ IndexPolicyRequest access$getRequest$p(IndexPolicyHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ String access$checkShardsFailure(IndexPolicyHandler $this, IndexResponse response2) {
            return $this.checkShardsFailure(response2);
        }

        public static final /* synthetic */ void access$onCreateMappingsResponse(IndexPolicyHandler $this, AcknowledgedResponse response2) {
            $this.onCreateMappingsResponse(response2);
        }
    }
}

