/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.arthmetic;

import lombok.Generated;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;

public final class ArithmeticFunction {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(ArithmeticFunction.add());
        repository.register(ArithmeticFunction.subtract());
        repository.register(ArithmeticFunction.multiply());
        repository.register(ArithmeticFunction.divide());
        repository.register(ArithmeticFunction.modules());
    }

    private static DefaultFunctionResolver add() {
        return FunctionDSL.define(BuiltinFunctionName.ADD.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprByteValue(v1.byteValue() + v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprShortValue(v1.shortValue() + v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprIntegerValue(Math.addExact(v1.integerValue(), v2.integerValue()))), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprLongValue(Math.addExact(v1.longValue(), v2.longValue()))), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() + v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(v1.doubleValue() + v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver subtract() {
        return FunctionDSL.define(BuiltinFunctionName.SUBTRACT.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprByteValue(v1.byteValue() - v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprShortValue(v1.shortValue() - v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprIntegerValue(Math.subtractExact(v1.integerValue(), v2.integerValue()))), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprLongValue(Math.subtractExact(v1.longValue(), v2.longValue()))), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() - v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(v1.doubleValue() - v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver multiply() {
        return FunctionDSL.define(BuiltinFunctionName.MULTIPLY.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprByteValue(v1.byteValue() * v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprShortValue(v1.shortValue() * v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprIntegerValue(Math.multiplyExact(v1.integerValue(), (int)v2.integerValue()))), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprLongValue(Math.multiplyExact((long)v1.longValue(), v2.longValue()))), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() * v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprDoubleValue(v1.doubleValue() * v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver divide() {
        return FunctionDSL.define(BuiltinFunctionName.DIVIDE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprByteValue(v1.byteValue() / v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprShortValue(v1.shortValue() / v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.integerValue() == 0 ? ExprNullValue.of() : new ExprIntegerValue(v1.integerValue() / v2.integerValue())), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.longValue() == 0L ? ExprNullValue.of() : new ExprLongValue(v1.longValue() / v2.longValue())), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.floatValue().floatValue() == 0.0f ? ExprNullValue.of() : new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() / v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.doubleValue() == 0.0 ? ExprNullValue.of() : new ExprDoubleValue(v1.doubleValue() / v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    private static DefaultFunctionResolver modules() {
        return FunctionDSL.define(BuiltinFunctionName.MODULES.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> new ExprByteValue(v1.byteValue() % v2.byteValue())), ExprCoreType.BYTE, ExprCoreType.BYTE, ExprCoreType.BYTE), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.shortValue() == 0 ? ExprNullValue.of() : new ExprShortValue(v1.shortValue() % v2.shortValue())), ExprCoreType.SHORT, ExprCoreType.SHORT, ExprCoreType.SHORT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.integerValue() == 0 ? ExprNullValue.of() : new ExprIntegerValue(v1.integerValue() % v2.integerValue())), ExprCoreType.INTEGER, ExprCoreType.INTEGER, ExprCoreType.INTEGER), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.longValue() == 0L ? ExprNullValue.of() : new ExprLongValue(v1.longValue() % v2.longValue())), ExprCoreType.LONG, ExprCoreType.LONG, ExprCoreType.LONG), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.floatValue().floatValue() == 0.0f ? ExprNullValue.of() : new ExprFloatValue(Float.valueOf(v1.floatValue().floatValue() % v2.floatValue().floatValue()))), ExprCoreType.FLOAT, ExprCoreType.FLOAT, ExprCoreType.FLOAT), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> v2.doubleValue() == 0.0 ? ExprNullValue.of() : new ExprDoubleValue(v1.doubleValue() % v2.doubleValue())), ExprCoreType.DOUBLE, ExprCoreType.DOUBLE, ExprCoreType.DOUBLE));
    }

    @Generated
    private ArithmeticFunction() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

